ScriptName OutpostStarstationMenuActivator Extends ObjectReference

outpoststarstationactorscript myVendor
Message Property OutpostStarstationMessage Auto Const mandatory
{ message box listing options }
ActorBase Property OutpostStarstationVendor Auto Const mandatory
{ vendor to create when built }
ObjectReference Property TechVendorChest Auto Const
GlobalVariable Property GV_TechVendorCreditsRefresh Auto Const
MiscObject Property Credits Auto Const
LeveledItem Property CreditsLeveledList Auto Const

Event OnWorkshopObjectPlaced(ObjectReference akReference)
  myVendor = Self.PlaceAtMe(OutpostStarstationVendor as Form, 1, False, True, True, None, None, True) as outpoststarstationactorscript
  myVendor.Initialize(Self.GetLinkedRef(None))
EndEvent

Event OnWorkshopObjectRemoved(ObjectReference akReference)
  If myVendor
    myVendor.Cleanup()
    myVendor.Delete()
    myVendor = None
  EndIf
EndEvent

Event OnActivate(ObjectReference akActionRef)
  If akActionRef == Game.GetPlayer() as ObjectReference
    outpoststarstationactorscript theShipServicesActor = myVendor
    If theShipServicesActor
      Int messageIndex = OutpostStarstationMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
      If messageIndex == 0
        TechVendorCreditsRefresh()
		theShipServicesActor.ModifyStarstation()
      EndIf
    EndIf
  EndIf
EndEvent

Function TechVendorCreditsRefresh()
            
			Int CreditsThreshold = GV_TechVendorCreditsRefresh.GetValue() As Int     
				 
				 If TechVendorChest.GetItemCount(Credits) < CreditsThreshold
					TechVendorChest.Removeitem(Credits, 999999999, True, None)
					TechVendorChest.Additem(CreditsLeveledList, 1, True)
			  EndIf

EndFunction