ScriptName SISA_Survival extends Quest

Quest Property QuestSpaceshipSystems Auto Const
Quest Property MQ101 Auto Const

Actor Property PlayerRef Auto Const

ActorValue Property Hunger Auto Const
ActorValue Property Sleep Auto Const
ActorValue Property Thirst Auto Const
ActorValue Property Oversatiation Auto Const
ActorValue Property Intoxication Auto Const
ActorValue Property SurvivalDamageIncoming Auto Const
ActorValue Property SurvivalDamageOutgoing Auto Const

Armor Property AdrenalineToken Auto Const
Armor Property WellRestedToken Auto Const

MiscObject Property CarryweightRefresh Auto Const

Book Property StarvivalGuide Auto Const

Keyword Property FoodDrinks Auto Const
Keyword Property Chems Auto Const
Keyword Property ChemsVendor Auto Const
Keyword Property OnlyFood Auto Const

Potion Property Blackout Auto Const
Potion Property SatiationChecker Auto Const
Potion Property AffPotionAnalgesicPoultice Auto Const
Potion Property AffPotionAntibioticInjector Auto Const
Potion Property AffPotionAntibioticPaste Auto Const
Potion Property AffPotionAntibioticPasteResearch Auto Const
Potion Property AffPotionAntibiotics Auto Const
Potion Property AffPotionAntibioticsCoctail Auto Const
Potion Property AffPotionBandages Auto Const
Potion Property AffPotionBandagesInfused Auto Const
Potion Property AffPotionBandagesZipper Auto Const
Potion Property AffPotionEmergencyKit Auto Const
Potion Property AffPotionHealGel Auto Const
Potion Property AffPotionHealPaste Auto Const
Potion Property AffPotionImmobilizer Auto Const
Potion Property AffPotionImmobilizerAnchored Auto Const
Potion Property AffPotionImmobilizerRepairing Auto Const
Potion Property AffPotionImmobilizerRepairingResearch Auto Const
Potion Property AffPotionInjector Auto Const
Potion Property AffPotionInjectorBoosted Auto Const
Potion Property AffPotionMedpack Auto Const
Potion Property AffPotionPanacea Auto Const
Potion Property AffPotionPanaceaResearch Auto Const
Potion Property AffPotionPenicillinX Auto Const
Potion Property AffPotionSnakeOil Auto Const
Potion Property AffPotionTraumaPack Auto Const
Potion Property AddPotionCureJunkFlush Auto Const
Potion Property PotionAddictionAlcoholism Auto Const
Potion Property PotionAddictionCaffeinophagia Auto Const
Potion Property PotionAddictionCognitiveDissolution Auto Const
Potion Property PotionAddictionHeartAttack Auto Const
Potion Property PotionAddictionParanoidTreatment Auto Const
Potion Property PotionAddictionStimulantsAddiction Auto Const
Potion Property PotionAddictionWarning Auto Const
Potion Property PotionAddictionFoodPoisoning Auto Const

Perk Property SurvivalStart Auto Const
Perk Property SurvivalLogos Auto Const
Perk Property SurvivalLogosOff Auto Const
Perk Property SurvivalAdrenaline Auto Const
Perk Property SurvivalAdrenalineBuff Auto Const
Perk Property SurvivalAdrenalineAftermath Auto Const
Perk Property OversatiationDebuff Auto Const
Perk Property SurvivalDamage Auto Const
Perk Property Nutrition Auto Const
Perk Property PainTolerance Auto Const
Perk Property AmmoWeight Auto Const
Perk Property NonWeightItemsWeight Auto Const
Perk Property DisableWeightForAidItems Auto Const
Perk Property Overencumbrance Auto Const

GlobalVariable Property HungerTime Auto Const
GlobalVariable Property HungerDMGPoints Auto Const
GlobalVariable Property HungerLowestPoints Auto Const
GlobalVariable Property HungerMaxPoints Auto Const
GlobalVariable Property HungerMaxPointsBonus Auto Const
GlobalVariable Property OversatiationMaxPoints Auto Const
GlobalVariable Property OversatiationMaxPointsBonus Auto Const
GlobalVariable Property OversatiationStarter Auto Const
GlobalVariable Property OversatiationLowestPoints Auto Const
GlobalVariable Property IntoxicationMaxPoints Auto Const
GlobalVariable Property IntoxicationMaxPointsBonus Auto Const
GlobalVariable Property IntoxicationStarter Auto Const
GlobalVariable Property IntoxicationLowestPoints Auto Const
GlobalVariable Property IntoxicationMinDMG Auto Const
GlobalVariable Property IntoxicationMaxDMG Auto Const
GlobalVariable Property FoodPoisoningChance Auto Const
GlobalVariable Property FoodPoisoningToggle Auto Const
GlobalVariable Property SleepTime Auto Const
GlobalVariable Property SleepDMGPoints Auto Const
GlobalVariable Property SleepLowestPoints Auto Const
GlobalVariable Property SleepMaxPoints Auto Const
GlobalVariable Property SleepMaxPointsBonus Auto Const
GlobalVariable Property ThirstTime Auto Const
GlobalVariable Property ThirstDMGPoints Auto Const
GlobalVariable Property ThirstLowestPoints Auto Const
GlobalVariable Property ThirstMaxPoints Auto Const
GlobalVariable Property ThirstMaxPointsBonus Auto Const
GlobalVariable Property FoodPointsLow Auto Const
GlobalVariable Property FoodPointsMedium Auto Const
GlobalVariable Property FoodPointsHigh Auto Const
GlobalVariable Property FoodPointsLegendary Auto Const
GlobalVariable Property FoodPointsLowOversatiation Auto Const
GlobalVariable Property FoodPointsMediumOversatiation Auto Const
GlobalVariable Property FoodPointsHighOversatiation Auto Const
GlobalVariable Property FoodPointsLegendaryOversatiation Auto Const
GlobalVariable Property DrinkPointsLow Auto Const
GlobalVariable Property DrinkPointsMedium Auto Const
GlobalVariable Property DrinkPointsHigh Auto Const
GlobalVariable Property DrinkPointsSpecial Auto Const
GlobalVariable Property DrinkPointsSpecialEnergy Auto Const
GlobalVariable Property DrinkAlcPointsLow Auto Const
GlobalVariable Property DrinkAlcPointsHigh Auto Const
GlobalVariable Property DrinkAlcPointsSpecialThirst Auto Const
GlobalVariable Property DrinkAlcPointsSpecialFatigue Auto Const
GlobalVariable Property ChemsPointsLow Auto Const
GlobalVariable Property ChemsPointsMedium Auto Const
GlobalVariable Property ChemsPointsHigh Auto Const
GlobalVariable Property ChemsPointsVeryHigh Auto Const
GlobalVariable Property BlackoutDuration Auto Const
GlobalVariable Property SurvivalToggler Auto Const
GlobalVariable Property AdrenalineMax Auto Const
GlobalVariable Property AdrenalineTimer Auto Const
GlobalVariable Property AdrenalineCountNotifier Auto Const
GlobalVariable Property AdrenalineToggle Auto Const
GlobalVariable Property AfflictionCureTimer Auto Const
GlobalVariable Property AfflictionCureTimerBandages Auto Const
GlobalVariable Property AddictionCureTimerJunkFlush Auto Const
GlobalVariable Property SleepStartTime Auto
GlobalVariable Property SleepStopTime Auto
GlobalVariable Property SleepTOTALTime Auto
GlobalVariable Property SurvivalDamageToggle Auto Const
GlobalVariable Property AddichroneTimeRestoration Auto Const
GlobalVariable Property AddichroneRestoration Auto Const
GlobalVariable Property AmmoWeightToggle Auto Const
GlobalVariable Property OverencumbranceToggle Auto Const
GlobalVariable Property NeedsCheckerImmersiveMode Auto Const
GlobalVariable Property NeedsCheckerNotificationType Auto Const
GlobalVariable Property NeedsCheckerAfterConsumptionNotifier Auto Const
GlobalVariable Property OversatiationTime Auto Const
GlobalVariable Property OversatiationDMGPoints Auto Const
GlobalVariable Property FoodRestoreHealth Auto Const
GlobalVariable Property StartStarvival Auto Const
GlobalVariable Property AddictionToggleAlcoholism Auto Const
GlobalVariable Property AddictionToggleCaffeinophagia Auto Const
GlobalVariable Property AddictionToggleCognitiveDissolution Auto Const
GlobalVariable Property AddictionToggleHeartAttack Auto Const
GlobalVariable Property AddictionToggleParanoidTreatment Auto Const
GlobalVariable Property AddictionToggleStimulants Auto Const
GlobalVariable Property SpaceshipSystemsToggle Auto Const
GlobalVariable Property NGPlusStarted Auto Const
GlobalVariable Property WeightlessAidsToggle Auto Const 
GlobalVariable Property SurvivalDamageIncomingGlobal Auto Const
GlobalVariable Property SurvivalDamageOutgoingGlobal Auto Const
GlobalVariable Property FuelCost Auto Const

MagicEffect Property FoodLowGrade Auto Const
MagicEffect Property FoodMediumGrade Auto Const
MagicEffect Property FoodHighGrade Auto Const
MagicEffect Property FoodLegendaryGrade Auto Const
MagicEffect Property DrinkLowGrade Auto Const
MagicEffect Property DrinkMediumGrade Auto Const
MagicEffect Property DrinkHighGrade Auto Const
MagicEffect Property DrinkEnergy Auto Const
MagicEffect Property DrinkAlcoholLowGrade Auto Const
MagicEffect Property DrinkAlcoholHighGrade Auto Const
MagicEffect Property DrinkAlcoholSpecial Auto Const
MagicEffect Property ChemsLowGrade Auto Const
MagicEffect Property ChemsMediumGrade Auto Const
MagicEffect Property ChemsHighGrade Auto Const
MagicEffect Property AddictionSuppressantCheck Auto Const
MagicEffect Property CaffeinophagiaCheck Auto Const
MagicEffect Property AffCureAnalgesicPoultice Auto Const
MagicEffect Property AffCureAntibioticInjector Auto Const
MagicEffect Property AffCureAntibioticPaste Auto Const
MagicEffect Property AffCureAntibioticPasteResearch Auto Const
MagicEffect Property AffCureAntibiotics Auto Const
MagicEffect Property AffCureAntibioticsCoctail Auto Const
MagicEffect Property AffCureBandages Auto Const
MagicEffect Property AffCureBandagesInfused Auto Const
MagicEffect Property AffCureBandagesZipper Auto Const
MagicEffect Property AffCureEmergencyKit Auto Const
MagicEffect Property AffCureHealGel Auto Const
MagicEffect Property AffCureHealPaste Auto Const
MagicEffect Property AffCureImmobilizer Auto Const
MagicEffect Property AffCureImmobilizerAnchored Auto Const
MagicEffect Property AffCureImmobilizerRepairing Auto Const
MagicEffect Property AffCureImmobilizerRepairingResearch Auto Const
MagicEffect Property AffCureInjector Auto Const
MagicEffect Property AffCureInjectorBoosted Auto Const
MagicEffect Property AffCureMedpack Auto Const
MagicEffect Property AffCurePanacea Auto Const
MagicEffect Property AffCurePanaceaResearch Auto Const
MagicEffect Property AffCurePenicillinX Auto Const
MagicEffect Property AffCureSnakeOil Auto Const
MagicEffect Property AffCureTraumaPack Auto Const
MagicEffect Property AddictionCureJunkFlush Auto Const
MagicEffect Property AddichroneSuppression Auto Const
MagicEffect Property FoodPoisoningDebuff Auto Const

Message Property InitializeMSG Auto Const
Message Property StarvivalEnabled Auto Const
Message Property StarvivalRemoved Auto Const
Message Property NeedsAllChecker Auto Const
Message Property NeedsAllCheckerBox Auto Const
Message Property AdrenalineCount Auto Const
Message Property UpdateMessage Auto Const
Message Property UninstallMessage Auto Const
Message Property MSGHungerFamished Auto Const
Message Property MSGHungerPeckish Auto Const
Message Property MSGHungerRavenous Auto Const
Message Property MSGHungerStarving Auto Const
Message Property MSGSleepExhausted Auto Const
Message Property MSGSleepIncapacitated Auto Const
Message Property MSGSleepTired Auto Const
Message Property MSGSleepWeary Auto Const
Message Property MSGThirstParched Auto Const
Message Property MSGThirstMildlyDehydrated Auto Const
Message Property MSGThirstDehydrated Auto Const
Message Property MSGThirstSeverelyDehydrated Auto Const

FormList Property AddictionItems_AlcoholismTrigger Auto
FormList Property AddictionItems_CaffeinophagiaTrigger Auto
FormList Property AddictionItems_CognitiveDissolutionTrigger Auto
FormList Property AddictionItems_HeartAttackTrigger Auto
FormList Property AddictionItems_ParanoidTreatmentTrigger Auto
FormList Property AddictionItems_StimulantsAddictionTrigger Auto

Spell Property IntoxicationWarning Auto Const
Spell Property CureAddictions Auto Const 
Spell Property OversatiationPenalty Auto Const 
Spell Property AdrenalineAftermathPenalty Auto Const 
Spell Property AdrenalineRushBuff Auto Const 
Spell Property FoodPoisoning Auto Const 

bool AddichroneOnPlayer = false
bool IntroductionEnabled = false

Int Property StarbornTriggerStage = 2000 auto const 
Int Property SurvivalTriggerStage = 310 auto const 

Float fVersion

Event OnQuestInit()

      RegisterForPlayerSleep()
      RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
      RegisterForRemoteEvent(MQ101 as scriptobject, "OnStageSet")                            

EndEvent

Event Quest.OnStageSet(Quest akSender, int auiStageID, int auiItemID)

    If akSender == MQ101 && auiStageID == StarbornTriggerStage

       NGPlusStarted.SetValue(1)
       IntroductoryMessage()
       StartStarvival.SetValue(1)
	   AddBook()
       IntroductionEnabled = True
       UnregisterForRemoteEvent(MQ101, "OnStageSet")
 
 EndIf

    If akSender == MQ101 && auiStageID == SurvivalTriggerStage
       StartTimer(3, 36) 
 EndIf

EndEvent

Function Update()

          Int Version0 = 0		   
          Int Version1 = 1
          Int Version2 = 2
          Int Version3 = 3
          Int Version4 = 4
          Int Version5 = 5
          Int Version6 = 6		   
          Int Version7 = 7
          Int Version8 = 8
          Int Version9 = 9

	   While fVersion < 5.2

                If fVersion < 3.0
	               PlayerRef.Addperk(DisableWeightForAidItems, False)
	               PlayerRef.Addperk(NonWeightItemsWeight, False)
	               PlayerRef.Addperk(AmmoWeight, False)
	               PlayerRef.Addperk(Overencumbrance, False)

                   FoodPoisoningToggle.SetValue(1)

                   RegisterForRemoteEvent(MQ101 as scriptobject, "OnStageSet")                            

                     If SurvivalToggler.GetValue() == 1
			            (QuestSpaceshipSystems as SISA_SpaceshipFuel).SpaceshipSystemStart()
                  EndIf
                  fVersion = 3.0

           ElseIf fVersion < 3.1	              

		             If SpaceshipSystemsToggle.GetValue() == 1
			            (QuestSpaceshipSystems as SISA_SpaceshipFuel).Update31()
                  EndIf
			      fVersion = 3.1

           ElseIf fVersion < 3.11	              
			      fVersion = 3.11

           ElseIf fVersion < 3.12	              
			      fVersion = 3.12

           ElseIf fVersion < 4.0	              
			      fVersion = 4.0
			
					 If SpaceshipSystemsToggle.GetValue() == 1
			            (QuestSpaceshipSystems as SISA_SpaceshipFuel).Update40()
				  EndIf

           ElseIf fVersion < 4.1	              
			      fVersion = 4.1

					 If SpaceshipSystemsToggle.GetValue() == 1
			            (QuestSpaceshipSystems as SISA_SpaceshipFuel).Update41()
				  EndIf

           ElseIf fVersion < 4.2	              
			      fVersion = 4.2

			      (QuestSpaceshipSystems as SISA_SpaceshipFuel).Update42()

           ElseIf fVersion < 4.3	              
			      fVersion = 4.3

           ElseIf fVersion < 5.0	              
			      fVersion = 5.0

                  (QuestSpaceshipSystems as SISA_SpaceshipFuel).Update50()

           ElseIf fVersion < 5.1	              
			      fVersion = 5.1

           ElseIf fVersion < 5.11	              
			      fVersion = 5.11
           
		   ElseIf fVersion < 5.2	              
			      fVersion = 5.2						
		             
					 If SpaceshipSystemsToggle.GetValue() == 1			
			            (QuestSpaceshipSystems as SISA_SpaceshipFuel).Update52()
			      EndIf
			
			EndIf

            UpdateMessage.show(Version5, Version2, Version0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	EndWhile

EndFunction

Function IntroductoryMessage()

         Utility.Wait(3.0)
		 int button = -1
		 button = InitializeMSG.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

	     If (button == 0)
                
            StartStarvivalSystems()
            AddBook()
			StartStarvival.SetValue(1)
			IntroductionEnabled = True
             
	 ElseIf (button == 1)
            IntroductionEnabled = True
	        AddBook()
	  EndIf

EndFunction

Function AddBook()

	If PlayerRef.GetItemCount(StarvivalGuide) < 1
	   PlayerRef.AddItem(StarvivalGuide, 1, True)
 EndIf

EndFunction

Function MissionExterminatus()

         UnregisterForPlayerSleep()
         UnregisterForPlayerWait()
         UnregisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
         UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnItemEquipped")
         UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")

         UnregisterForMagicEffectApplyEvent(PlayerRef, None, FoodLowGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, FoodMediumGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, FoodHighGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, FoodLegendaryGrade, True)

         UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkLowGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkMediumGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkHighGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkEnergy, True)

         UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholLowGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholHighGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholSpecial, True)

         UnregisterForMagicEffectApplyEvent(PlayerRef, None, ChemsLowGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, ChemsMediumGrade, True)
         UnregisterForMagicEffectApplyEvent(PlayerRef, None, ChemsHighGrade, True)

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)

         NeedsStopLogo()

	     Utility.Wait(1.0)
         CancelTimer(0)
         CancelTimer(1)
         CancelTimer(2)
         CancelTimer(3)
         CancelTimer(4)  
         CancelTimer(35)  
         CancelTimer(40)  

	     Utility.Wait(1.0)
         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         Utility.Wait(1.0)         
	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
	     PlayerRef.RestoreValue(Oversatiation, 999)

      If PlayerRef.GetItemCount(SatiationChecker) > 0
         PlayerRef.Removeitem(SatiationChecker, 9999, True, None)
   EndIf

      If PlayerRef.GetItemCount(AdrenalineToken) > 0
         PlayerRef.RemoveItem(AdrenalineToken, 9999, True, None)
   EndIf

      If PlayerRef.GetItemCount(WellRestedToken) > 0
         PlayerRef.RemoveItem(WellRestedToken, 9999, True, None)
   EndIf

      If PlayerRef.GetItemCount(StarvivalGuide) > 0
         PlayerRef.RemoveItem(StarvivalGuide, 9999, True, None)
   EndIf

         Utility.Wait(1.0)
         PlayerRef.Removeperk(SurvivalLogos) 
         PlayerRef.Removeperk(SurvivalLogosOff) 
         PlayerRef.Removeperk(SurvivalStart) 
         PlayerRef.RemovePerk(SurvivalAdrenaline)
         PlayerRef.Removeperk(SurvivalAdrenalineBuff) 
         PlayerRef.Removeperk(SurvivalAdrenalineAftermath) 
         PlayerRef.Removeperk(OversatiationDebuff) 
         PlayerRef.RemovePerk(SurvivalDamage)
         PlayerRef.Removeperk(AmmoWeight) 
         PlayerRef.RemovePerk(Overencumbrance)

         PlayerRef.DispelSpell(OversatiationPenalty)
         PlayerRef.DispelSpell(AdrenalineAftermathPenalty)
         PlayerRef.DispelSpell(AdrenalineRushBuff)	 
         PlayerRef.DispelSpell(FoodPoisoning)

         CureAddictions.Cast(PlayerRef, PlayerRef)
         RefreshCarryWeight()

         (QuestSpaceshipSystems as SISA_SpaceshipFuel).SpaceshipSystemUninstallExterminatus()

		 Utility.Wait(2.0)
         UninstallMessage.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

EndFunction

Function StartStarvivalSystems()

                  SystemsPoints()
                  NeedsInitializeLogo()
                  SurvivalSystems()
                  StartNeedsTimers()

                  RegisterForPlayerSleep()
                  RegisterForPlayerWait()

                  RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
                  RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnItemEquipped")
                  RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLegendaryGrade, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkEnergy, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholHighGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholSpecial, True)

                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsLowGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsMediumGrade, True)
                  RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsHighGrade, True)
                                   
EndFunction

Function NeedsFullReset()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)
 		 Float IntoxicationLowestPoint = IntoxicationLowestPoints.GetValue()
 		 Float IntoxicationThreshold = - PlayerRef.GetValue(Intoxication)

         PlayerRef.Removeitem(SatiationChecker, 999, True, None)
         PlayerRef.RemovePerk(SurvivalStart) 
         NeedsStopLogo()

	     Utility.Wait(1.0)
         StopNeedsTimers() 

	     Utility.Wait(1.0)

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         If PlayerRef.GetValue(Intoxication) < IntoxicationLowestPoint
            PlayerRef.RestoreValue(Intoxication, IntoxicationThreshold)
      EndIf

         Utility.Wait(1.0)         
	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
	     PlayerRef.RestoreValue(Oversatiation, 999)
	     PlayerRef.RestoreValue(Intoxication, 999)

         Utility.Wait(1.0)
         PlayerRef.DamageValue(Hunger, 57)
         PlayerRef.DamageValue(Sleep, 50)
         PlayerRef.DamageValue(Thirst, 60)
         PlayerRef.DamageValue(Oversatiation, 100)
         PlayerRef.DamageValue(Intoxication, 100)

	     Utility.Wait(1.0)
         PlayerRef.Additem(SatiationChecker, 1, False)
         NeedsInitializeLogo()

         Utility.Wait(1.0)
         PlayerRef.Addperk(SurvivalStart, False) 

	     Utility.Wait(1.0)
         StartNeedsTimers()
         SatiationChecker()

EndFunction

Function NeedsInitializeLogo()

             PlayerRef.Addperk(SurvivalLogos, False) 
             Utility.Wait(1.0)
             PlayerRef.Removeperk(SurvivalLogos) 

EndFunction

Function NeedsStopLogo()

             PlayerRef.Addperk(SurvivalLogosOff, False) 
             Utility.Wait(1.0)
             PlayerRef.Removeperk(SurvivalLogosOff) 

EndFunction

Event Actor.OnPlayerLoadGame(Actor akSender)

      RegisterForPlayerSleep()
      RegisterForPlayerWait()
      RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnItemEquipped")
      RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")
      RefreshCarryWeight()

EndEvent

Function RefreshCarryWeight()

      PlayerRef.Additem(CarryweightRefresh, 1, True)
      PlayerRef.Removeitem(CarryweightRefresh, 1, True, None)

EndFunction

Function SystemsPoints()

		 Float IntoxicationPointsPool = IntoxicationMaxPoints.GetValue()
         Float HungerPointsPool = HungerMaxPoints.GetValue()
		 Float SleepPointsPool = SleepMaxPoints.GetValue()
		 Float ThirstPointsPool = ThirstMaxPoints.GetValue()
		 Float OversatiationPointsPool = OversatiationMaxPoints.GetValue()

	     PlayerRef.SetValue(Hunger, HungerPointsPool)
	     PlayerRef.SetValue(Sleep, SleepPointsPool)
	     PlayerRef.SetValue(Thirst, ThirstPointsPool)
	     PlayerRef.SetValue(Oversatiation, OversatiationPointsPool)
         PlayerRef.SetValue(SurvivalDamageIncoming, 20.0)
         PlayerRef.SetValue(SurvivalDamageOutgoing, 20.0)
	     PlayerRef.SetValue(Intoxication, IntoxicationPointsPool)

         Utility.Wait(0.5)
         PlayerRef.DamageValue(Hunger, 57)
         PlayerRef.DamageValue(Sleep, 50)
         PlayerRef.DamageValue(Thirst, 60)
         PlayerRef.DamageValue(Oversatiation, 100)
         PlayerRef.DamageValue(SurvivalDamageIncoming, 17.5)
         PlayerRef.DamageValue(SurvivalDamageOutgoing, 17.5)
         PlayerRef.DamageValue(Intoxication, 100)

         NeedsThresholdsChecks()

EndFunction

Function SurvivalSystems()

         SurvivalToggler.SetValue(1) 
         SurvivalDamageToggle.SetValue(1) 
         IntoxicationStarter.SetValue(1) 
         OversatiationStarter.SetValue(1) 
         AdrenalineToggle.SetValue(1) 
         AmmoWeightToggle.SetValue(1)
	     OverencumbranceToggle.SetValue(1)
         FoodPoisoningToggle.SetValue(1)
         FoodRestoreHealth.SetValue(0)

         Utility.Wait(1.0)
         PlayerRef.Addperk(SurvivalStart, False) 
         PlayerRef.Addperk(SurvivalAdrenaline, False) 
         PlayerRef.Addperk(SurvivalDamage, False) 
	     PlayerRef.Addperk(AmmoWeight, False)
	     PlayerRef.Addperk(Overencumbrance, False)

         PlayerRef.Additem(SatiationChecker, 1, False)

         RefreshCarryWeight()

         Utility.Wait(1.0)
		 SatiationChecker()
          
		 (QuestSpaceshipSystems as SISA_SpaceshipFuel).SpaceshipSystemStart()

EndFunction

Function StarvivalNeedsBook()

        If SurvivalToggler.GetValue() == 0
           SurvivalToggler.SetValue(1)
           OversatiationStarter.SetValue(1) 
           PlayerRef.AddPerk(SurvivalStart, False)
           PlayerRef.Additem(SatiationChecker, 1, False)
           NeedsInitializeLogo()
           SurvivalPointsRestoreOnActivate()
           StartNeedsTimers()

           RegisterForPlayerSleep()
           RegisterForPlayerWait()
           RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
           RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")

           RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLowGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodMediumGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodHighGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLegendaryGrade, True)

           RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkLowGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkMediumGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkHighGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkEnergy, True)

           RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholLowGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholHighGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholSpecial, True)

           RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsLowGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsMediumGrade, True)
           RegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsHighGrade, True)

    ElseIf SurvivalToggler.GetValue() == 1
           SurvivalToggler.SetValue(0) 
           OversatiationStarter.SetValue(0) 
           PlayerRef.RemovePerk(SurvivalStart)
           PlayerRef.Removeitem(SatiationChecker, 9999, True, None)
           NeedsStopLogo()
           SurvivalPointsRestoreOnDeactivate()
           StopNeedsTimers()

           UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")

           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLowGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, FoodMediumGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, FoodHighGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, FoodLegendaryGrade, True)

           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkLowGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkMediumGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkHighGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkEnergy, True)

           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholLowGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholHighGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholSpecial, True)

           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsLowGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsMediumGrade, True)
           UnRegisterForMagicEffectApplyEvent(PlayerRef, None, ChemsHighGrade, True)

     EndIf

EndFunction

Function SurvivalDamageBook()

         Float IncomingSurvDMG = PlayerRef.GetValue(SurvivalDamageIncoming)
         Float OutgoingSurvDMG = PlayerRef.GetValue(SurvivalDamageOutgoing)

      If SurvivalDamageToggle.GetValue() == 0
         SurvivalDamageToggle.SetValue(1) 
         PlayerRef.RestoreValue(SurvivalDamageIncoming, 2.5)
         PlayerRef.RestoreValue(SurvivalDamageOutgoing, 2.5)
         SurvivalDamageIncomingGlobal.SetValue(250)
         SurvivalDamageOutgoingGlobal.SetValue(250)
         PlayerRef.Addperk(SurvivalDamage, False) 

  ElseIf SurvivalDamageToggle.GetValue() == 1
         SurvivalDamageToggle.SetValue(0) 
         PlayerRef.DamageValue(SurvivalDamageIncoming, IncomingSurvDMG)
         PlayerRef.DamageValue(SurvivalDamageOutgoing, OutgoingSurvDMG)
         SurvivalDamageIncomingGlobal.SetValue(0)
         SurvivalDamageOutgoingGlobal.SetValue(0)
         PlayerRef.Removeperk(SurvivalDamage) 
   EndIf

EndFunction

Function AdrenalineBook()

      If AdrenalineToggle.GetValue() == 0
         AdrenalineToggle.SetValue(1) 
         PlayerRef.Addperk(SurvivalAdrenaline, False) 

  ElseIf AdrenalineToggle.GetValue() == 1
         AdrenalineToggle.SetValue(0)
         PlayerRef.Removeperk(SurvivalAdrenaline) 
         PlayerRef.DispelSpell(AdrenalineAftermathPenalty)
         PlayerRef.DispelSpell(AdrenalineRushBuff)	
         CancelTimer(1)

           If PlayerRef.GetItemCount(AdrenalineToken) > 0 
              PlayerRef.RemoveItem(AdrenalineToken, 9999, True, None)
        EndIf

   EndIf

EndFunction

Function OversatiationBook()

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)
         Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)

      If OversatiationStarter.GetValue() == 0
         OversatiationStarter.SetValue(1) 

  ElseIf OversatiationStarter.GetValue() == 1
         OversatiationStarter.SetValue(0) 

		    If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
               PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
         EndIf

         PlayerRef.DamageValue(Oversatiation, OversatiationCheck)
         PlayerRef.RemovePerk(OversatiationDebuff)
         PlayerRef.DispelSpell(OversatiationPenalty)
         CancelTimer(40)
   EndIf

EndFunction

Function IntoxicationBook()

 		 Float IntoxicationLowestPoint = IntoxicationLowestPoints.GetValue()
 		 Float IntoxicationThreshold = - PlayerRef.GetValue(Intoxication)
         Float IntoxicationCheck = PlayerRef.GetValue(Intoxication)

      If IntoxicationStarter.GetValue() == 0
         IntoxicationStarter.SetValue(1) 
  
  ElseIf IntoxicationStarter.GetValue() == 1
         IntoxicationStarter.SetValue(0)

            If PlayerRef.GetValue(Intoxication) < IntoxicationLowestPoint
               PlayerRef.RestoreValue(Intoxication, IntoxicationThreshold)
         EndIf

         PlayerRef.DamageValue(Intoxication, IntoxicationCheck)
   EndIf

EndFunction

Function AmmoWeightsBook()

      If AmmoWeightToggle.GetValue() == 0
         AmmoWeightToggle.SetValue(1)
         PlayerRef.Addperk(AmmoWeight, False)

         RefreshCarryWeight()

  ElseIf AmmoWeightToggle.GetValue() == 1
         AmmoWeightToggle.SetValue(0)
         PlayerRef.Removeperk(AmmoWeight)
   
         RefreshCarryWeight()
   
   EndIf

EndFunction

Function WeightlessAidsBook()

      If WeightlessAidsToggle.GetValue() == 0
         WeightlessAidsToggle.SetValue(1)
         PlayerRef.Addperk(DisableWeightForAidItems, False)

         RefreshCarryWeight()

  ElseIf WeightlessAidsToggle.GetValue() == 1
         WeightlessAidsToggle.SetValue(0)
         PlayerRef.Removeperk(DisableWeightForAidItems)
   
         RefreshCarryWeight()
   
   EndIf

EndFunction

Function OverencumbranceBook()

      If OverencumbranceToggle.GetValue() == 0
         OverencumbranceToggle.SetValue(1)
         PlayerRef.Addperk(Overencumbrance, False)

         RefreshCarryWeight()

  ElseIf OverencumbranceToggle.GetValue() == 1
         OverencumbranceToggle.SetValue(0)
         PlayerRef.Removeperk(Overencumbrance)
   
         RefreshCarryWeight()
   
   EndIf

EndFunction

Function SurvivalPointsRestoreOnDeactivate()

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)

	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
         PlayerRef.RestoreValue(Oversatiation, 999)

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

EndFunction

Function SurvivalPointsRestoreOnActivate()

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)

         PlayerRef.DamageValue(Hunger, 57)
         PlayerRef.DamageValue(Sleep, 50)
         PlayerRef.DamageValue(Thirst, 60)
         PlayerRef.DamageValue(Oversatiation, 100)

         If PlayerRef.GetValue(Oversatiation) < OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         Utility.Wait(1.0)
         SatiationChecker()

EndFunction

Function SurvivalPointsRestoreAfterJail()

         int HungerDMG = Utility.RandomInt(25, 75)
         int SleepDMG = Utility.RandomInt(25, 75)
		 int ThirstDMG = Utility.RandomInt(25, 75)

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)
         Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)

	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
	     PlayerRef.RestoreValue(Oversatiation, 999)

         PlayerRef.DamageValue(Hunger, HungerDMG)
         PlayerRef.DamageValue(Sleep, SleepDMG)
         PlayerRef.DamageValue(Thirst, ThirstDMG)
         PlayerRef.DamageValue(Oversatiation, 100)

         NeedsThresholdsChecksAfterJail()

EndFunction

Function StartNeedsTimers()

         Float HungerStart = HungerTime.GetValue()
         Float SleepStart = SleepTime.GetValue()
         Float ThirstStart = ThirstTime.GetValue()

         StartTimer(HungerStart, 2)
         StartTimer(SleepStart, 3)
         StartTimer(ThirstStart, 4)

EndFunction

Function StopNeedsTimers()

         CancelTimer(0)
         CancelTimer(2)
         CancelTimer(3)
         CancelTimer(4)
         CancelTimer(40)

EndFunction

Function ResetNeedsTimers()

         Float HungerStart = HungerTime.GetValue()
         Float SleepStart = SleepTime.GetValue()
         Float ThirstStart = ThirstTime.GetValue()
         Float OversatiationStart = OversatiationTime.GetValue()
 
         CancelTimer(2)
         CancelTimer(3)
         CancelTimer(4)
         CancelTimer(40)

         Utility.Wait(0.3)

         StartTimer(HungerStart, 2)
         StartTimer(SleepStart, 3)
         StartTimer(ThirstStart, 4)
         StartTimer(OversatiationStart, 40)
         Debug.Notification("Basic Needs timers have been reset")

EndFunction

Function ResetOversatiationTimer()

         Float OversatiationStart = OversatiationTime.GetValue()
 
         CancelTimer(40)

         Utility.Wait(0.3)

         StartTimer(OversatiationStart, 40)
         Debug.Notification("Oversatiation timer has been reset")

EndFunction

float Function GetCurrentHourOfDay() 
 
	float Time = Utility.GetCurrentRealTime()
	Return Time
 
EndFunction

Event Actor.OnPlayerJail(Actor akSender, ObjectReference akGuard, Form akFaction, Location akLocation, Int aeCrimeGold)

    SurvivalPointsRestoreAfterJail()

EndEvent

Event OnPlayerWaitStart(float afWaitStartTime, float afDesiredWaitEndTime)

	Float StartingSleep = GetCurrentHourOfDay()
	SleepStartTime.SetValue(StartingSleep)

EndEvent

Event OnPlayerWaitStop(bool abInterrupted)

	     Float EndingSleep = GetCurrentHourOfDay()
	     SleepStopTime.SetValue(EndingSleep)

      If SurvivalToggler.GetValue() == 1 
         NeedsAfterWait()
         NeedsThresholdsChecks()
   EndIf
   
EndEvent

Event OnPlayerSleepStart(float afSleepStartTime, float afDesiredSleepEndTime, ObjectReference akBed)

	Float StartingSleep = GetCurrentHourOfDay()
	SleepStartTime.SetValue(StartingSleep)

    If PlayerRef.HasMagicEffect(AddictionSuppressantCheck) == True
       AddichroneOnPlayer = True    
 EndIf

EndEvent

Event OnPlayerSleepStop(bool abInterrupted, ObjectReference akBed)

	          Float HoursYouHaveSlept = (SleepStopTime.GetValue() - SleepStartTime.GetValue())/2.05
	          SleepTOTALTime.SetValue(HoursYouHaveSlept)
	          Float EndingSleep = GetCurrentHourOfDay()
	          SleepStopTime.SetValue(EndingSleep)
	
                 If PlayerRef.HasPerk(SurvivalAdrenalineAftermath) == True
                    PlayerRef.RemovePerk(SurvivalAdrenalineAftermath)
              EndIf

              AddichroneOnPlayer = False 

        If SurvivalToggler.GetValue() == 1 
           NeedsAfterSleep()
           NeedsThresholdsChecks()
     EndIf

        If IntroductionEnabled == False
		   IntroductoryMessage()
     EndIf

EndEvent

Function NeedsAfterSleep()

	    Float HoursYouHaveSlept = (SleepStopTime.GetValue() - SleepStartTime.GetValue())/2.05
	    SleepTOTALTime.SetValue(HoursYouHaveSlept)
       
        Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
        Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst) 
        Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
        Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation) 

		Int HungerDamaged01 = (SleepTOTALTime.GetValue() as Int)*2
        Int HungerDamaged02 = (SleepTOTALTime.GetValue() as Int)*3
        Int HungerDamaged03 = (SleepTOTALTime.GetValue() as Int)*4
        Int HungerDamaged04 = (SleepTOTALTime.GetValue() as Int)*5
		   
             If FoodHungerCheck >= 90

	            PlayerRef.DamageValue(Hunger, HungerDamaged01)

         ElseIf FoodHungerCheck >= 70 && FoodHungerCheck < 90

	            PlayerRef.DamageValue(Hunger, HungerDamaged02)

         ElseIf FoodHungerCheck >= 40 && FoodHungerCheck < 70

                PlayerRef.DamageValue(Hunger, HungerDamaged03)

         ElseIf FoodHungerCheck < 40

                PlayerRef.DamageValue(Hunger, HungerDamaged04)

          EndIf
		
		Int ThirstDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int ThirstDamaged02 = (SleepTOTALTime.GetValue() as Int)*4
		Int ThirstDamaged03 = (SleepTOTALTime.GetValue() as Int)*5
		Int ThirstDamaged04 = (SleepTOTALTime.GetValue() as Int)*6
		
             If DrinkThirstCheck >= 90

	            PlayerRef.DamageValue(Thirst, ThirstDamaged01)

         ElseIf DrinkThirstCheck >= 70 && DrinkThirstCheck < 90

	            PlayerRef.DamageValue(Thirst, ThirstDamaged02)

         ElseIf DrinkThirstCheck >= 40 && DrinkThirstCheck < 70

                PlayerRef.DamageValue(Thirst, ThirstDamaged03)

         ElseIf DrinkThirstCheck < 40

                PlayerRef.DamageValue(Thirst, ThirstDamaged04)

          EndIf

     If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && AddichroneOnPlayer == False

        ;Empty

	 Else
		
		Int SleepRestored01 = (SleepTOTALTime.GetValue() as Int)*6
		Int SleepRestored02 = (SleepTOTALTime.GetValue() as Int)*8
		Int SleepRestored03 = (SleepTOTALTime.GetValue() as Int)*10
		Int SleepRestored04 = (SleepTOTALTime.GetValue() as Int)*14
 
             If SleepFatigueCheck >= 90

	            PlayerRef.RestoreValue(Sleep, SleepRestored01)

         ElseIf SleepFatigueCheck >= 70 && SleepFatigueCheck < 90

	            PlayerRef.RestoreValue(Sleep, SleepRestored02)

         ElseIf SleepFatigueCheck >= 40 && SleepFatigueCheck < 70

                PlayerRef.RestoreValue(Sleep, SleepRestored03)

         ElseIf SleepFatigueCheck < 40

                PlayerRef.RestoreValue(Sleep, SleepRestored04)

          EndIf
	 EndIf

		 Int OversatiationDamaged = (SleepTOTALTime.GetValue() as Int)*20
             If OversatiationStarter.GetValue() == 1
	             PlayerRef.DamageValue(Oversatiation, OversatiationDamaged)
          EndIf

        If HoursYouHaveSlept >= 7
           PlayerRef.Additem(WellRestedToken, 1, True)
     EndIf

EndFunction

Function NeedsAfterWait()
       
	    Float HoursYouHaveSlept = (SleepStopTime.GetValue() - SleepStartTime.GetValue())/2.05
	    SleepTOTALTime.SetValue(HoursYouHaveSlept)
       
        Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
        Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst) 
        Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)

		Int HungerDamaged01 = (SleepTOTALTime.GetValue() as Int)*2
        Int HungerDamaged02 = (SleepTOTALTime.GetValue() as Int)*3
        Int HungerDamaged03 = (SleepTOTALTime.GetValue() as Int)*4
        Int HungerDamaged04 = (SleepTOTALTime.GetValue() as Int)*5
		   
             If FoodHungerCheck >= 90

	            PlayerRef.DamageValue(Hunger, HungerDamaged01)

         ElseIf FoodHungerCheck >= 70 && FoodHungerCheck < 90

	            PlayerRef.DamageValue(Hunger, HungerDamaged02)

         ElseIf FoodHungerCheck >= 40 && FoodHungerCheck < 70

                PlayerRef.DamageValue(Hunger, HungerDamaged03)

         ElseIf FoodHungerCheck < 40

                PlayerRef.DamageValue(Hunger, HungerDamaged04)

          EndIf
		
		Int ThirstDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int ThirstDamaged02 = (SleepTOTALTime.GetValue() as Int)*4
		Int ThirstDamaged03 = (SleepTOTALTime.GetValue() as Int)*5
		Int ThirstDamaged04 = (SleepTOTALTime.GetValue() as Int)*6
		
             If DrinkThirstCheck >= 90

	            PlayerRef.DamageValue(Thirst, ThirstDamaged01)

         ElseIf DrinkThirstCheck >= 70 && DrinkThirstCheck < 90

	            PlayerRef.DamageValue(Thirst, ThirstDamaged02)

         ElseIf DrinkThirstCheck >= 40 && DrinkThirstCheck < 70

                PlayerRef.DamageValue(Thirst, ThirstDamaged03)

         ElseIf DrinkThirstCheck < 40

                PlayerRef.DamageValue(Thirst, ThirstDamaged04)

          EndIf
		
		Int SleepDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int SleepDamaged02 = (SleepTOTALTime.GetValue() as Int)*5
		Int SleepDamaged03 = (SleepTOTALTime.GetValue() as Int)*7
		Int SleepDamaged04 = (SleepTOTALTime.GetValue() as Int)*9
 
             If SleepFatigueCheck >= 90

	            PlayerRef.DamageValue(Sleep, SleepDamaged01)

         ElseIf SleepFatigueCheck >= 70 && SleepFatigueCheck < 90

	            PlayerRef.DamageValue(Sleep, SleepDamaged02)

         ElseIf SleepFatigueCheck >= 40 && SleepFatigueCheck < 70

                PlayerRef.DamageValue(Sleep, SleepDamaged03)

         ElseIf SleepFatigueCheck < 40

                PlayerRef.DamageValue(Sleep, SleepDamaged04)

          EndIf

		 Int OversatiationDamaged = (SleepTOTALTime.GetValue() as Int)*20
             If OversatiationStarter.GetValue() == 1
	             PlayerRef.DamageValue(Oversatiation, OversatiationDamaged)
          EndIf

EndFunction

Function NeedsThresholdsChecksAfterJail()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
   		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation) 

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) < OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

      SatiationChecker()

EndFunction

Function NeedsThresholdsChecksTimered()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
   		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation) 

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) < OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

      NeedsAfterEachCycleChecker()

EndFunction

Function NeedsThresholdsChecksOversatiation()

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
   		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation) 

         If PlayerRef.GetValue(Oversatiation) < OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

EndFunction

Function NeedsThresholdsAfterConsumption()

		 Float OversatiationPool = OversatiationMaxPointsBonus.GetValue()
		 Float IntoxicationPool = IntoxicationMaxPointsBonus.GetValue()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 

		 Float HungerPointsPoolBonus = HungerMaxPointsBonus.GetValue()
		 Float ThirstPointsPoolBonus = ThirstMaxPointsBonus.GetValue()
		 Float SleepPointsPoolBonus = SleepMaxPointsBonus.GetValue()

 		 Float IntoxicationLowestPoint = IntoxicationLowestPoints.GetValue()
 		 Float IntoxicationThreshold = - PlayerRef.GetValue(Intoxication)

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) > SleepPointsPoolBonus
            PlayerRef.SetValue(Sleep, SleepPointsPoolBonus)
      EndIf  

         If PlayerRef.GetValue(Thirst) > ThirstPointsPoolBonus
            PlayerRef.SetValue(Thirst, ThirstPointsPoolBonus)
      EndIf  

         If PlayerRef.GetValue(Hunger) > HungerPointsPoolBonus
            PlayerRef.SetValue(Hunger, HungerPointsPoolBonus)
      EndIf  

         If PlayerRef.GetValue(Oversatiation) >= OversatiationPool
            PlayerRef.SetValue(Oversatiation, OversatiationPool)
      EndIf

         If PlayerRef.GetValue(Intoxication) < IntoxicationLowestPoint
            PlayerRef.RestoreValue(Intoxication, IntoxicationThreshold)
      EndIf

         If PlayerRef.GetValue(Intoxication) >= IntoxicationPool
            PlayerRef.SetValue(Intoxication, IntoxicationPool)
      EndIf

      NeedsAfterConsumptionStatus()

EndFunction

Function NeedsThresholdsChecks()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep)
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)
 		 Float IntoxicationLowestPoint = IntoxicationLowestPoints.GetValue()
 		 Float IntoxicationThreshold = - PlayerRef.GetValue(Intoxication)

         If PlayerRef.GetValue(Hunger) <= HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) <= ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) <= SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

		 If OversatiationStarter.GetValue() == 1
                     If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
                        PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
				  EndIf
      EndIf

		 If IntoxicationStarter.GetValue() == 1
                     If PlayerRef.GetValue(Intoxication) < IntoxicationLowestPoint
                        PlayerRef.RestoreValue(Intoxication, IntoxicationThreshold)
                  EndIf
      EndIf

      NeedsAfterEachCycleChecker()

EndFunction

Event OnMagicEffectApply(ObjectReference akTarget, ObjectReference akCaster, MagicEffect akEffect)

		   Float FoodLow = FoodPointsLow.GetValue()
		   Float FoodLowPoison = FoodPointsLow.GetValue() / 3
		   Float FoodLowWithPerk = FoodPointsLow.GetValue() * 2
		   Float FoodLowWithPerkPoison = FoodPointsLow.GetValue() * 2 / 3
		   Float FoodMedium = FoodPointsMedium.GetValue()
		   Float FoodMediumPoison = FoodPointsMedium.GetValue() / 3
		   Float FoodMediumWithPerk = FoodPointsMedium.GetValue() * 2
		   Float FoodMediumWithPerkPoison = FoodPointsMedium.GetValue() * 2 / 3
		   Float FoodHigh = FoodPointsHigh.GetValue()
		   Float FoodHighPoison = FoodPointsHigh.GetValue() / 3
		   Float FoodHighWithPerk = FoodPointsHigh.GetValue() * 2
		   Float FoodHighWithPerkPoison = FoodPointsHigh.GetValue() * 2 / 3
 		   Float FoodLegendary = FoodPointsLegendary.GetValue()
 		   Float FoodLegendaryPoison = FoodPointsLegendary.GetValue() / 3
 		   Float FoodLegendaryWithPerk = FoodPointsLegendary.GetValue() * 2
 		   Float FoodLegendaryWithPerkPoison = FoodPointsLegendary.GetValue() * 2 / 3

		   Float OversatiationLow = FoodPointsLowOversatiation.GetValue()
		   Float OversatiationLowWithPerk = FoodPointsLowOversatiation.GetValue() / 2
		   Float OversatiationMedium = FoodPointsMediumOversatiation.GetValue()
		   Float OversatiationMediumWithPerk = FoodPointsMediumOversatiation.GetValue() / 2
		   Float OversatiationHigh = FoodPointsHighOversatiation.GetValue()
		   Float OversatiationHighWithPerk = FoodPointsHighOversatiation.GetValue() / 2
 		   Float OversatiationLegendary = FoodPointsLegendaryOversatiation.GetValue()
 		   Float OversatiationLegendaryWithPerk = FoodPointsLegendaryOversatiation.GetValue() / 2
           Float OversatiationStart = OversatiationTime.GetValue()

		   Float DrinkLow = DrinkPointsLow.GetValue()
		   Float DrinkLowWithPerk = DrinkPointsLow.GetValue() * 2
		   Float DrinkMedium = DrinkPointsMedium.GetValue()
		   Float DrinkMediumWithPerk = DrinkPointsMedium.GetValue() * 2
		   Float DrinkHigh = DrinkPointsHigh.GetValue()
		   Float DrinkHighWithPerk = DrinkPointsHigh.GetValue() * 2
		   Float DrinkSpecial = DrinkPointsSpecial.GetValue()
		   Float DrinkSpecialWithPerk = DrinkPointsSpecial.GetValue() * 2
		   Float DrinkSpecialEnergy = DrinkPointsSpecialEnergy.GetValue()
           Float DrinkSpecialEnergyAddict = DrinkPointsSpecialEnergy.GetValue() / 6
		   Float DrinkSpecialEnergyWithPerk = DrinkPointsSpecialEnergy.GetValue() * 2
		   Float DrinkSpecialEnergyWithPerkAddict = DrinkPointsSpecialEnergy.GetValue() * 2 / 6

		   Float DrinkAlcLow = DrinkAlcPointsLow.GetValue()
		   Float DrinkAlcLowWithPerk = DrinkAlcPointsLow.GetValue() / 2
		   Float DrinkAlcHigh = DrinkAlcPointsHigh.GetValue()
		   Float DrinkAlcHighWithPerk = DrinkAlcPointsHigh.GetValue() / 2
		   Float DrinkAlcSpecialThirst = DrinkAlcPointsSpecialThirst.GetValue()
		   Float DrinkAlcSpecialThirstWithPerk = DrinkAlcPointsSpecialThirst.GetValue() / 2
		   Float DrinkAlcSpecialFatigue = DrinkAlcPointsSpecialFatigue.GetValue()
		   Float DrinkAlcSpecialFatigueAddict = DrinkAlcPointsSpecialFatigue.GetValue() / 6
		   Float DrinkAlcSpecialFatigueWithPerk = DrinkAlcPointsSpecialFatigue.GetValue() * 2
		   Float DrinkAlcSpecialFatigueWithPerkAddict = DrinkAlcPointsSpecialFatigue.GetValue() * 2 / 6

		   Float ChemsLow = ChemsPointsLow.GetValue()
		   Float ChemsMedium = ChemsPointsMedium.GetValue()
		   Float ChemsHigh = ChemsPointsHigh.GetValue()

    If SurvivalToggler.GetValue() == 1 
		   If (akTarget == PlayerRef as ObjectReference && akEffect == FoodLowGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, FoodLowGrade, True)
			 				 
					    If PlayerRef.Hasperk(Nutrition) == True
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
						         PlayerRef.RestoreValue(Hunger, FoodLowWithPerkPoison)
                          Else
						         PlayerRef.RestoreValue(Hunger, FoodLowWithPerk)
                           EndIf
					Else
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
					             PlayerRef.RestoreValue(Hunger, FoodLowPoison)
                          Else
								 PlayerRef.RestoreValue(Hunger, FoodLow)
                           EndIf
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationLowWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationLow)

			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == FoodMediumGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, FoodMediumGrade, True)
				 					 
					    If PlayerRef.Hasperk(Nutrition) == True
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
						         PlayerRef.RestoreValue(Hunger, FoodMediumWithPerkPoison)
                          Else
						         PlayerRef.RestoreValue(Hunger, FoodMediumWithPerk)
                           EndIf
					Else
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
					             PlayerRef.RestoreValue(Hunger, FoodMediumPoison)
                          Else
					             PlayerRef.RestoreValue(Hunger, FoodMedium)
                           EndIf
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationMediumWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationMedium)

			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == FoodHighGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, FoodHighGrade, True)
				 				 
					    If PlayerRef.Hasperk(Nutrition) == True
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
						         PlayerRef.RestoreValue(Hunger, FoodHighWithPerkPoison)
                          Else
						         PlayerRef.RestoreValue(Hunger, FoodHighWithPerk)
                           EndIf
					Else
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
					             PlayerRef.RestoreValue(Hunger, FoodHighPoison)
                          Else
					             PlayerRef.RestoreValue(Hunger, FoodHigh)
                           EndIf
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationHighWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationHigh)

			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == FoodLegendaryGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, FoodLegendaryGrade, True)
  					 
					    If PlayerRef.Hasperk(Nutrition) == True
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
						         PlayerRef.RestoreValue(Hunger, FoodLegendaryWithPerkPoison)
                          Else
						         PlayerRef.RestoreValue(Hunger, FoodLegendaryWithPerk)
                           EndIf
					Else
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
					             PlayerRef.RestoreValue(Hunger, FoodLegendaryPoison)
                          Else
					             PlayerRef.RestoreValue(Hunger, FoodLegendary)
                           EndIf
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationLegendaryWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationLegendary)

			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkLowGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkLowGrade, True)
				 			 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, DrinkLowWithPerk)
                    Else
					       PlayerRef.RestoreValue(Thirst, DrinkLow)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationLowWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationLow)

			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkMediumGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkMediumGrade, True)
			 				 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, DrinkMediumWithPerk)
                    Else
					       PlayerRef.RestoreValue(Thirst, DrinkMedium)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationMediumWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationMedium)

			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkHighGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkHighGrade, True)
					 					 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, DrinkHighWithPerk)
                    Else
					       PlayerRef.RestoreValue(Thirst, DrinkHigh)
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationHighWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationHigh)

			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkEnergy)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkEnergy, True)
				 					 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, DrinkSpecialWithPerk)	 

					              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && PlayerRef.HasMagicEffect(AddichroneSuppression) == False

                                     PlayerRef.RestoreValue(Sleep, DrinkSpecialEnergyWithPerkAddict)
	                          Else
						             PlayerRef.RestoreValue(Sleep, DrinkSpecialEnergyWithPerk)
                               EndIf

                    Else
					       PlayerRef.RestoreValue(Thirst, DrinkSpecial)	 

					              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && PlayerRef.HasMagicEffect(AddichroneSuppression) == False

                                     PlayerRef.RestoreValue(Sleep, DrinkSpecialEnergyAddict)
	                          Else
						             PlayerRef.RestoreValue(Sleep, DrinkSpecialEnergy)
                               EndIf
			         EndIf

					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, OversatiationHighWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Oversatiation, OversatiationHigh)

			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkAlcoholLowGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkAlcoholLowGrade, True)
			 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.DamageValue(Thirst, DrinkAlcLowWithPerk)				 
					       PlayerRef.DamageValue(Sleep, DrinkAlcLowWithPerk)
                    Else
					       PlayerRef.DamageValue(Thirst, DrinkAlcLow)				 
					       PlayerRef.DamageValue(Sleep, DrinkAlcLow)
			         EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkAlcoholHighGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkAlcoholHighGrade, True)
			 
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.DamageValue(Thirst, DrinkAlcHighWithPerk)				 
					       PlayerRef.DamageValue(Sleep, DrinkAlcHighWithPerk)
                    Else
					       PlayerRef.DamageValue(Thirst, DrinkAlcHigh)				 
					       PlayerRef.DamageValue(Sleep, DrinkAlcHigh)
			         EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == DrinkAlcoholSpecial)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, DrinkAlcoholSpecial, True)
 			
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.DamageValue(Thirst, DrinkAlcSpecialThirstWithPerk)

					              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && PlayerRef.HasMagicEffect(AddichroneSuppression) == False

                                     PlayerRef.RestoreValue(Sleep, DrinkAlcSpecialFatigueWithPerkAddict)
	                          Else
						             PlayerRef.RestoreValue(Sleep, DrinkAlcSpecialFatigueWithPerk)
                               EndIf	

                    Else
					       PlayerRef.DamageValue(Thirst, DrinkAlcSpecialThirst)
					       
					              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && PlayerRef.HasMagicEffect(AddichroneSuppression) == False

                                     PlayerRef.RestoreValue(Sleep, DrinkAlcSpecialFatigueAddict)
	                          Else
						             PlayerRef.RestoreValue(Sleep, DrinkAlcSpecialFatigue)
                               EndIf						   
						   
			         EndIf

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == ChemsLowGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, ChemsLowGrade, True)
			 
					 PlayerRef.DamageValue(Thirst, ChemsLow)			 
					 PlayerRef.DamageValue(Hunger, ChemsLow)
					 PlayerRef.DamageValue(Sleep, ChemsLow)

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == ChemsMediumGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, ChemsMediumGrade, True)
				 
					 PlayerRef.DamageValue(Thirst, ChemsMedium)			 
					 PlayerRef.DamageValue(Hunger, ChemsMedium) 
					 PlayerRef.DamageValue(Sleep, ChemsMedium)

	   ElseIf (akTarget == PlayerRef as ObjectReference && akEffect == ChemsHighGrade)
	          RegisterForMagicEffectApplyEvent(PlayerRef as ScriptObject, None, ChemsHighGrade, True)
 					 
					 PlayerRef.DamageValue(Thirst, ChemsHigh)			 
					 PlayerRef.DamageValue(Hunger, ChemsHigh)		 
					 PlayerRef.DamageValue(Sleep, ChemsHigh)
        		
	    EndIf

EndIf
EndEvent

Function NeedsAfterConsumptionStatus()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)

        If NeedsCheckerAfterConsumptionNotifier.GetValue() == 1
           NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)	
     EndIf

EndFunction

Function NeedsAfterEachCycleChecker()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)
           Float IntoxicationMaxLevel = IntoxicationMaxPoints.GetValue()

   If NeedsCheckerNotificationType.GetValue() == 1 || NeedsCheckerNotificationType.GetValue() == 2

         If NeedsCheckerImmersiveMode.GetValue() == 0

            Utility.Wait(0.1)
            NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)	

     Else

            NeedsImmersiveStatusMessaging()

      EndIf

EndIf

EndFunction

Function NeedsStatusOnDebuff()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)
           Float IntoxicationMaxLevel = IntoxicationMaxPoints.GetValue()

           Utility.Wait(0.1)
           NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)	

EndFunction

Function NeedsImmersiveStatusMessaging()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)
           Float IntoxicationMaxLevel = IntoxicationMaxPoints.GetValue()

             If DrinkThirstCheck > 50 && DrinkThirstCheck <= 75
                Utility.Wait(0.1)
                MSGThirstParched.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

         ElseIf DrinkThirstCheck > 35 && DrinkThirstCheck <= 50
                Utility.Wait(0.1)
                MSGThirstMildlyDehydrated.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)	

         ElseIf DrinkThirstCheck > 20 && DrinkThirstCheck <= 35
                Utility.Wait(0.1)
                MSGThirstDehydrated.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

         ElseIf DrinkThirstCheck <= 20
                Utility.Wait(0.1)
                MSGThirstSeverelyDehydrated.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
          EndIf

             If FoodHungerCheck > 50 && FoodHungerCheck <= 75
                Utility.Wait(0.1)
                MSGHungerPeckish.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

         ElseIf FoodHungerCheck > 35 && FoodHungerCheck <= 50
                Utility.Wait(0.1)
                MSGHungerFamished.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)	

         ElseIf FoodHungerCheck > 20 && FoodHungerCheck <= 35
                Utility.Wait(0.1)
                MSGHungerRavenous.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

         ElseIf FoodHungerCheck <= 20
                Utility.Wait(0.1)
                MSGHungerStarving.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
          EndIf

             If SleepFatigueCheck > 50 && SleepFatigueCheck <= 75
                Utility.Wait(0.1)
                MSGSleepTired.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

         ElseIf SleepFatigueCheck > 35 && SleepFatigueCheck <= 50
                Utility.Wait(0.1)
                MSGSleepWeary.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)	

         ElseIf SleepFatigueCheck > 20 && SleepFatigueCheck <= 35
                Utility.Wait(0.1)
                MSGSleepExhausted.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

         ElseIf SleepFatigueCheck <= 20
                Utility.Wait(0.1)
                MSGSleepIncapacitated.show(afArg1 = 0.0, afArg2 = 0.0, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)
          EndIf

EndFunction

Event OnTimer(int aiTimerID)
	 
	  	     Float HungerDamage = HungerDMGPoints.GetValue()
 			 Float SleepDamage = SleepDMGPoints.GetValue()
 			 Float ThirstDamage = ThirstDMGPoints.GetValue()
 			 Float OversatiationDamage = OversatiationDMGPoints.GetValue()
	         Float HungerStart = HungerTime.GetValue()
             Float SleepStart = SleepTime.GetValue()
             Float ThirstStart = ThirstTime.GetValue()
             Float OversatiationStart = OversatiationTime.GetValue()
	 
             Float BlackoutTimer = BlackoutDuration.GetValue()
             Float Timer = AdrenalineTimer.GetValue()

             Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
 
     	     If (aiTimerID == 0)       

                   If PlayerRef.GetValue(Sleep) > 35
                      CancelTimer(0)
                Else
				      PlayerRef.EquipItem(Blackout, 1, True)
                      StartTimer(BlackoutTimer, 0)
				EndIf

      	 ElseIf (aiTimerID == 1)       

                   If PlayerRef.GetItemCount(AdrenalineToken) >= 1 
                      PlayerRef.RemoveItem(AdrenalineToken, 1, True, None)
                      StartTimer(Timer, 1)
                      AdrenalineStatusChecker()
                EndIf

      	 ElseIf (aiTimerID == 2)       

                PlayerRef.DamageValue(Hunger, HungerDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(HungerStart, 2)

      	 ElseIf (aiTimerID == 3)       

                PlayerRef.DamageValue(Sleep, SleepDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(SleepStart, 3)

      	 ElseIf (aiTimerID == 4)       

                PlayerRef.DamageValue(Thirst, ThirstDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(ThirstStart, 4)

      	 ElseIf (aiTimerID == 40)       

			     If OversatiationStarter.GetValue() == 1

						 If OversatiationCheck <= 0
                            NeedsThresholdsChecksOversatiation()
                            CancelTimer(40)
                     Else
							PlayerRef.DamageValue(Oversatiation, OversatiationDamage)
                            NeedsThresholdsChecksOversatiation()
                            StartTimer(OversatiationStart, 40)
                      EndIf
              EndIf

      	 ElseIf (aiTimerID == 10)       

                PlayerRef.EquipItem(AffPotionAnalgesicPoultice, 1, True)

      	 ElseIf (aiTimerID == 11)       

                PlayerRef.EquipItem(AffPotionAntibioticInjector, 1, True)

      	 ElseIf (aiTimerID == 12)       

                PlayerRef.EquipItem(AffPotionAntibioticPaste, 1, True)

      	 ElseIf (aiTimerID == 13)       

                PlayerRef.EquipItem(AffPotionAntibioticPasteResearch, 1, True)

      	 ElseIf (aiTimerID == 14)       

                PlayerRef.EquipItem(AffPotionAntibiotics, 1, True)

      	 ElseIf (aiTimerID == 15)       

                PlayerRef.EquipItem(AffPotionAntibioticsCoctail, 1, True)

      	 ElseIf (aiTimerID == 16)       

                PlayerRef.EquipItem(AffPotionBandages, 1, True)

      	 ElseIf (aiTimerID == 17)       

                PlayerRef.EquipItem(AffPotionBandagesInfused, 1, True)

      	 ElseIf (aiTimerID == 18)       

                PlayerRef.EquipItem(AffPotionBandagesZipper, 1, True)

      	 ElseIf (aiTimerID == 19)       

                PlayerRef.EquipItem(AffPotionEmergencyKit, 1, True)

      	 ElseIf (aiTimerID == 20)       

                PlayerRef.EquipItem(AffPotionHealGel, 1, True)

      	 ElseIf (aiTimerID == 21)       

                PlayerRef.EquipItem(AffPotionHealPaste, 1, True)

      	 ElseIf (aiTimerID == 22)       

                PlayerRef.EquipItem(AffPotionImmobilizer, 1, True)

      	 ElseIf (aiTimerID == 23)       

                PlayerRef.EquipItem(AffPotionImmobilizerAnchored, 1, True)

      	 ElseIf (aiTimerID == 24)       

                PlayerRef.EquipItem(AffPotionImmobilizerRepairing, 1, True)

      	 ElseIf (aiTimerID == 25)       

                PlayerRef.EquipItem(AffPotionImmobilizerRepairingResearch, 1, True)

      	 ElseIf (aiTimerID == 26)       

                PlayerRef.EquipItem(AffPotionInjector, 1, True)

      	 ElseIf (aiTimerID == 27)       

                PlayerRef.EquipItem(AffPotionInjectorBoosted, 1, True)

      	 ElseIf (aiTimerID == 28)       

                PlayerRef.EquipItem(AffPotionMedpack, 1, True)

      	 ElseIf (aiTimerID == 29)       

                PlayerRef.EquipItem(AffPotionPanacea, 1, True)

      	 ElseIf (aiTimerID == 30)       

                PlayerRef.EquipItem(AffPotionPanaceaResearch, 1, True)

      	 ElseIf (aiTimerID == 31)       

                PlayerRef.EquipItem(AffPotionPenicillinX, 1, True)

      	 ElseIf (aiTimerID == 32)       

                PlayerRef.EquipItem(AffPotionSnakeOil, 1, True)

      	 ElseIf (aiTimerID == 33)       

                PlayerRef.EquipItem(AffPotionTraumaPack, 1, True)

      	 ElseIf (aiTimerID == 34)       

                PlayerRef.EquipItem(AddPotionCureJunkFlush, 1, True)

      	 ElseIf (aiTimerID == 35)       

                Float ToxicityCheck = PlayerRef.Getvalue(Intoxication)
                Float Duration = AddichroneTimeRestoration.GetValue()
                Float Restore = AddichroneRestoration.GetValue()

                If IntoxicationStarter.GetValue() == 1
                       If ToxicityCheck <= 0
                          NeedsThresholdsAfterConsumption()
                          CancelTimer(35)
				   Else
					      PlayerRef.damagevalue(Intoxication, Restore)
			              StartTimer(Duration, 35)
                    EndIf
			 EndIf

      	 ElseIf (aiTimerID == 36) 
                
				IntroductoryMessage()
	            AddBook()
                IntroductionEnabled = True
          
		  EndIf
	  
EndEvent

Function Adrenaline()

                Float Max = AdrenalineMax.GetValue()
                Float Timer = AdrenalineTimer.GetValue()

                PlayerRef.Additem(AdrenalineToken, 1, True)

                   If PlayerRef.GetItemCount(AdrenalineToken) >= Max
                      PlayerRef.AddPerk(SurvivalAdrenalineBuff, False)
                      PlayerRef.RemoveItem(AdrenalineToken, 9999, True, None)
			    EndIf
                AdrenalineStatusChecker()
                StartTimer(Timer, 1)


EndFunction

Function AdrenalineStatusChecker()

           Float Max = AdrenalineMax.GetValue()
           Float Count = PlayerRef.GetItemCount(AdrenalineToken)

        If AdrenalineCountNotifier.GetValue() == 1

           Utility.Wait(0.1)
           AdrenalineCount.show(Count, Max, afArg3 = 0.0, afArg4 = 0.0, afArg5 = 0.0, afArg6 = 0.0, afArg7 = 0.0, afArg8 = 0.0, afArg9 = 0.0)

     EndIf

EndFunction

Function Blackout()

                StartTimer(0, 0)

EndFunction

Function SatiationChecker()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)

           Utility.Wait(0.1)
           NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)

EndFunction

Function SatiationCheckerBox()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)

           Utility.Wait(0.1)
           NeedsAllCheckerBox.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)	
           PlayerRef.Additem(SatiationChecker, 1, True)

EndFunction

Function AfflictionCure()

        Float CureTimer = AfflictionCureTimer.Getvalue()
        Float CureTimerBandages = AfflictionCureTimerBandages.Getvalue()
        Float CureTimerJunkFlush = AddictionCureTimerJunkFlush.Getvalue()

        If PlayerRef.HasMagicEffect(AffCureAnalgesicPoultice) == True         
	       StartTimer(CureTimer, 10)	 
	 EndIf	 

        If PlayerRef.HasMagicEffect(AffCureAntibioticInjector) == True         
	       StartTimer(CureTimer, 11)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureAntibioticPaste) == True         
	       StartTimer(CureTimer, 12)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureAntibioticPasteResearch) == True         
	       StartTimer(CureTimer, 13)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureAntibiotics) == True         
	       StartTimer(CureTimer, 14)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureAntibioticsCoctail) == True         
	       StartTimer(CureTimer, 15)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureBandages) == True         
	       StartTimer(CureTimerBandages, 16)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureBandagesInfused) == True         
	       StartTimer(CureTimerBandages, 17)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureBandagesZipper) == True         
	       StartTimer(CureTimerBandages, 18)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureEmergencyKit) == True         
	       StartTimer(CureTimer, 19)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureHealGel) == True         
	       StartTimer(CureTimer, 20)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureHealPaste) == True         
	       StartTimer(CureTimer, 21)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureImmobilizer) == True         
	       StartTimer(CureTimer, 22)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureImmobilizerAnchored) == True         
	       StartTimer(CureTimer, 23)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureImmobilizerRepairing) == True         
	       StartTimer(CureTimer, 24)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureImmobilizerRepairingResearch) == True         
	       StartTimer(CureTimer, 25)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureInjector) == True         
	       StartTimer(CureTimer, 26)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureInjectorBoosted) == True         
	       StartTimer(CureTimer, 27)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureMedpack) == True         
	       StartTimer(CureTimer, 28)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCurePanacea) == True         
	       StartTimer(CureTimer, 29)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCurePanaceaResearch) == True         
	       StartTimer(CureTimer, 30)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCurePenicillinX) == True         
	       StartTimer(CureTimer, 31)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureSnakeOil) == True         
	       StartTimer(CureTimer, 32)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AffCureTraumaPack) == True         
	       StartTimer(CureTimer, 33)	 
	 EndIf	

        If PlayerRef.HasMagicEffect(AddictionCureJunkFlush) == True         
	       StartTimer(CureTimerJunkFlush, 34)	 
	 EndIf	

EndFunction

Event Actor.OnItemEquipped(Actor akSender, Form akBaseObject, ObjectReference akReference)

	If IntoxicationStarter.GetValue() == 1
       If PlayerRef.HasMagicEffect(AddichroneSuppression) == False

             int Chance = Utility.RandomInt(1, 100)

                          If AddictionItems_AlcoholismTrigger.Find(akBaseObject) != -1

                             If AddictionToggleAlcoholism.GetValue() == 1
							    IntoxicationDamage()
                                              If PlayerRef.Getvalue(Intoxication) >= 80
                                                     If Chance >= 75
             									       PlayerRef.EquipItem(PotionAddictionAlcoholism, 1, True)
             									 EndIf
             							  EndIf
                          EndIf

                      ElseIf AddictionItems_CaffeinophagiaTrigger.Find(akBaseObject) != -1

                             If AddictionToggleCaffeinophagia.GetValue() == 1
                                IntoxicationDamage()
                                              If PlayerRef.Getvalue(Intoxication) >= 80
                                                     If Chance >= 75
                                                        PlayerRef.EquipItem(PotionAddictionCaffeinophagia, 1, True)
                                                  EndIf
                                           EndIf
                          EndIf

                      ElseIf AddictionItems_CognitiveDissolutionTrigger.Find(akBaseObject) != -1

                             If AddictionToggleCognitiveDissolution.GetValue() == 1
                                IntoxicationDamage()
                                              If PlayerRef.Getvalue(Intoxication) >= 80
                                                     If Chance >= 75
                                                        PlayerRef.EquipItem(PotionAddictionCognitiveDissolution, 1, True)
                                                  EndIf
                                           EndIf
                          EndIf

                      ElseIf AddictionItems_HeartAttackTrigger.Find(akBaseObject) != -1

                             If AddictionToggleHeartAttack.GetValue() == 1
                                IntoxicationDamage()
                                              If PlayerRef.Getvalue(Intoxication) >= 80
                                                     If Chance >= 75
                                                        PlayerRef.EquipItem(PotionAddictionHeartAttack, 1, True)
                                                  EndIf
                                           EndIf
                          EndIf

                      ElseIf AddictionItems_ParanoidTreatmentTrigger.Find(akBaseObject) != -1

                             If AddictionToggleParanoidTreatment.GetValue() == 1
                                IntoxicationDamage()
                                              If PlayerRef.Getvalue(Intoxication) >= 80
                                                     If Chance >= 75
                                                        PlayerRef.EquipItem(PotionAddictionParanoidTreatment, 1, True)
                                                  EndIf
                                           EndIf
                          EndIf

                      ElseIf AddictionItems_StimulantsAddictionTrigger.Find(akBaseObject) != -1

                             If AddictionToggleStimulants.GetValue() == 1
                                IntoxicationDamage()
                                              If PlayerRef.Getvalue(Intoxication) >= 80
                                                     If Chance >= 75
                                                        PlayerRef.EquipItem(PotionAddictionStimulantsAddiction, 1, True)
                                                  EndIf
                                           EndIf
                          EndIf

                       EndIf

    EndIf

EndIf

      If SurvivalToggler.GetValue() == 1 
            If akBaseObject.HasKeyword(FoodDrinks) || akBaseObject.HasKeyword(Chems) || akBaseObject.HasKeyword(ChemsVendor)
               NeedsThresholdsAfterConsumption()
         EndIf

            If FoodPoisoningToggle.GetValue() == 1
                 If akBaseObject.HasKeyword(OnlyFood)
                         If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == False
                            int Chance = Utility.RandomInt(1, 100)
                            Int MaxChance = FoodPoisoningChance.GetValue()as Int
                                 If Chance <= MaxChance
                                    PlayerRef.EquipItem(PotionAddictionFoodPoisoning, 1, True)
                              EndIf
                      EndIf
              EndIf
         EndIf
   EndIf

EndEvent

Function IntoxicationDamage()

                       Int MinDMG = (IntoxicationMinDMG.GetValue()as Int)	
                       Int MaxDMG = (IntoxicationMaxDMG.GetValue()as Int)
                       Int MinDMGWithPerk = (IntoxicationMinDMG.GetValue()as Int / 2)	
                       Int MaxDMGWithPerk = (IntoxicationMaxDMG.GetValue()as Int / 2)
                       int RandomDMG = Utility.RandomInt(MinDMG, MaxDMG)
                       int RandomDMGWithPerk = Utility.RandomInt(MinDMGWithPerk, MaxDMGWithPerk)

					              If PlayerRef.Hasperk(PainTolerance) == True
						             PlayerRef.RestoreValue(Intoxication, RandomDMGWithPerk)

                              Else
			                         PlayerRef.RestoreValue(Intoxication, RandomDMG)

			                   EndIf

                  If PlayerRef.HasSpell(IntoxicationWarning) == False
			         PlayerRef.EquipItem(PotionAddictionWarning, 1, True)
               EndIf

EndFunction

Function AddichroneRestoration()

        StartTimer(0, 35)

EndFunction

Function AddichroneRestorationCancel()

        CancelTimer(35)

EndFunction

Function IntoxicationRestore()

        Float Restore = PlayerRef.GetValue(Intoxication)
        If PlayerRef.Getvalue(Intoxication) > 0
           PlayerRef.Damagevalue(Intoxication, Restore)
     EndIf

EndFunction