ScriptName ImmersiveLandingRampsScript Extends Quest
{ Quest script for ImmersiveLandingRamps.esm }

Actor Property PlayerRef Auto Const mandatory
ReferenceAlias Property PlayerShip Auto mandatory
Keyword Property SpaceshipPreventRampOpenOnLanding Auto Const mandatory
Keyword Property IsLandingBayRemote Auto Const mandatory
Weapon Property RampRemote Auto Const mandatory
FormList Property KeepRampClosedOnLanding_FormIDList_RampRemote Auto
LeveledItem Property LLC_Vendor_City_NA_ApexElectronicsContainer Auto



Event OnInit()
  Self.InjectLists()
EndEvent

Event OnQuestInit()
  Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipFarTravel")
  Self.RegisterForRemoteEvent(PlayerShip as ScriptObject, "OnShipLanding")
  Self.RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnExitShipInterior")
  Self.RegisterForRemoteEvent(PlayerRef, "OnItemEquipped")
  If PlayerRef.getitemcount(RampRemote) <= 0
    PlayerRef.AddItem(RampRemote, 1, True)
  EndIf
EndEvent

Event Actor.OnItemEquipped(Actor akSender, Form akBaseObject, ObjectReference akReference)
  If akSender == PlayerRef
    If akBaseObject.haskeyword(IsLandingBayRemote)
      AutoOpenOrCloseLandingBay()
      akSender.UnequipItem(akBaseObject, False, True)
    EndIf
  EndIf
EndEvent

Event Actor.OnExitShipInterior(Actor akSender, ObjectReference akShip)
  If (akShip == PlayerShip.GetShipRef())
    akShip.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
  EndIf
EndEvent

Event ReferenceAlias.OnShipFarTravel(ReferenceAlias akSender, Location aDepartureLocation, Location aArrivalLocation, Int aState)
	spaceshipreference playerShipRef = PlayerShip.GetShipRef()
	planet thePlanetOrbit = aDepartureLocation.GetCurrentPlanet()
	planet thePlanetSurface = aArrivalLocation.GetCurrentPlanet()
	If ((akSender != PlayerShip) || (aState == 1) || (thePlanetOrbit != thePlanetSurface) || playerShipRef.IsLanded() || !playerShipRef.IsInSpace())
		If PlayerRef.GetParentCell().GetParentRef() == playerShipRef
			playerShipRef.AddKeyword(SpaceshipPreventRampOpenOnLanding)
		Else
			playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
		EndIf
		Return
  EndIf
EndEvent

Event ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)
  spaceshipreference playerShipRef = PlayerShip.GetShipRef()
  If !abComplete
    If playerShipRef != None
      playerShipRef.AddKeyword(SpaceshipPreventRampOpenOnLanding)
    EndIf
  Else
    If (Game.IsPluginInstalled("SpaceShipLandingReloaded.esm") == False)
      If !PlayerRef.GetParentCell().IsInterior()
        ObjectReference[] LandingRamps = Game.GetPlayerHomeSpaceShip().GetLandingRamps()
        If LandingRamps != None
          Int i = 0
          While i < LandingRamps.Length
            LandingRamps[i].SetOpen(true)
            i += 1
          EndWhile
        EndIf
      EndIf
    EndIf  
  EndIf
EndEvent

Function InjectLists()
  Int iIndex = KeepRampClosedOnLanding_FormIDList_RampRemote.GetSize()
  While iIndex > 0
    iIndex -= 1
    Form CurrentForm = KeepRampClosedOnLanding_FormIDList_RampRemote.GetAt(iIndex)
    LLC_Vendor_City_NA_ApexElectronicsContainer.AddForm(CurrentForm, 1, 1)
  EndWhile
EndFunction

Bool Function IsAnyLandingBayOpen(SpaceshipReference akShip)
  ObjectReference[] LandingRamps = akShip.GetLandingRamps()
  If LandingRamps != None
    Int i = 0
    While i < LandingRamps.Length
      If LandingRamps[i].GetOpenState() == 1
        Return true
      EndIf
      i += 1
    EndWhile
  EndIf
  Return false
EndFunction

Function ControlLandingBay(SpaceshipReference akShip, Bool abOpen)
  ObjectReference[] LandingRamps = akShip.GetLandingRamps()
  If LandingRamps != None
    Int i = 0
    While i < LandingRamps.Length
      LandingRamps[i].SetOpen(abOpen)
      i += 1
    EndWhile
  EndIf
EndFunction

Function AutoOpenOrCloseLandingBay()
  If !PlayerShip.GetShipRef().IsInSpace()
    If IsAnyLandingBayOpen(akShip = PlayerShip.GetShipRef())
      ControlLandingBay(akShip = PlayerShip.GetShipRef(), abOpen = false)
    Else
      ControlLandingBay(akShip = PlayerShip.GetShipRef(), abOpen = true)
    EndIf
  EndIf
EndFunction

Function UninstallImmersiveLandingRamps()
  spaceshipreference playerShipRef = PlayerShip.GetShipRef()
  Debug.Notification("Uninstalling Immersive Landing Ramps...")
  playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
  PlayerRef.RemoveItem(RampRemote, 999, True, None)
  ControlLandingBay(akShip = playerShipRef, abOpen = true)
  Self.Stop()
EndFunction