ScriptName AUR:UpgradeMissingPowersScript Extends Quest Hidden

;-- Properties --------------------------------------

Perk[] Property PowerPerks Auto Const Mandatory
Spell[] Property PowerSpells Auto Const Mandatory
Spell[] Property GrantSpells Auto Const Mandatory
ActorValue Property PlayerUnityTimesEntered Auto Const Mandatory
ObjectReference Property PlayerREF Auto Mandatory 
Quest Property MQ401 Auto Const Mandatory

Event OnInit()
  PlayerREF = Game.GetPlayer()
EndEvent

Event OnQuestInit()
  RegisterForRemoteEvent(MQ401, "OnStageSet")
EndEvent

Event Quest.OnStageSet(Quest akSender, int auiStageID, int auiItemID)
  ; After crossing the Unity
  If (akSender == MQ401) && (auiStageID == 10)
    Self.UpgradeMissingPowers()
    Self.UnRegisterForRemoteEvent(MQ401, "OnStageSet")
  EndIf
EndEvent

Function UpgradeMissingPowers()
  ; Powers should be the same rank as the number of times the player has entered the unity
  Int iTargetPowerRank = PlayerREF.GetValue(PlayerUnityTimesEntered) as Int
  ; If the player has entered the Unity more than 10x, then powers are already maxed, so shutdown the quest as we don't need it any more.
  If iTargetPowerRank > 10
    Self.UnRegisterForRemoteEvent(MQ401, "OnStageSet")
    Self.Stop()
    Debug.Notification("Powers maxed. Optional Temples quest shutting down.")
    Return
  ElseIf iTargetPowerRank <= 10
    Int I = 0
    While I < PowerSpells.Length
      Spell currentRankUpSpell = GrantSpells[I]
      Spell currentPowerSpell = PowerSpells[I]
      Perk currentPowerPerk = PowerPerks[I]
      Self.AddPowers(iTargetPowerRank, currentPowerSpell, currentRankUpSpell, currentPowerPerk)
      I += 1
    EndWhile
  EndIf
EndFunction

Function AddPowers(Int iTargetPowerRank, Spell PowerSpell, Spell RankUpSpell, Perk PowerPerk)
  (PlayerREF as Actor).RemoveSpell(PowerSpell)
  (PlayerREF as Actor).RemovePerk(PowerPerk)
  Int I = 0
  While I < iTargetPowerRank
    RankUpSpell.Cast(PlayerREF, PlayerREF)
    I += 1
  EndWhile
EndFunction
