ScriptName ccs_activatedelivery Extends ObjectReference
;-- Variables ---------------------------------------

;-- Properties --------------------------------------
Quest Property questobjective Auto Const mandatory
Form Property Cargo Auto
Int Property CargoAmount Auto Const mandatory
Message Property FailMessage Auto Const mandatory
Message Property SuccessMessage Auto Const mandatory
Message Property StartMessage Auto Const mandatory
;-- Functions ---------------------------------------

Event OnActivate(ObjectReference akActionRef)
  Bool repaired = false
  Actor myPlayer = Game.GetPlayer()
  ccs_missiondelivery kmyQuest = questobjective as ccs_missiondelivery ; #DEBUG_LINE_NO:25

  Cargo = kmyQuest.Cargo

  spaceshipreference myShip = myPlayer.GetCurrentShipRef()
  If myPlayer.GetItemCount(Cargo) >= CargoAmount
    myPlayer.RemoveItem(Cargo, CargoAmount, False, None)
    repaired = true
  ElseIf myShip.GetItemCount(Cargo) >= CargoAmount
    myShip.RemoveItem(Cargo, CargoAmount, False, None)
    repaired = true
  EndIf
  If repaired == true
    Self.BlockActivation(True,True)
    StartMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    Utility.wait(Utility.RandomInt(3, 5))
    questobjective.SetObjectiveCompleted(20, True)
    SuccessMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

    kmyQuest.MissionComplete()
  Else
    FailMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  EndIf
  ;Self.GetOwningQuest().SetStage(AllPowerBackOnStage)
EndEvent