ScriptName SISA_AmmoBackpack extends ObjectReference

GlobalVariable Property AmmoTotalPossibleRifle Auto Const
GlobalVariable Property AmmoTotalPossibleRifleHigh Auto Const
GlobalVariable Property AmmoTotalPossibleRifleHeavy Auto Const
GlobalVariable Property AmmoTotalPossibleExplosive Auto Const
GlobalVariable Property AmmoTotalPossiblePistol Auto Const
GlobalVariable Property AmmoTotalPossiblePistolHigh Auto Const
GlobalVariable Property AmmoTotalPossiblePistolHeavy Auto Const
GlobalVariable Property AmmoTotalPossibleShotgun Auto Const
GlobalVariable Property AmmoTotalPossibleShotgunHigh Auto Const
GlobalVariable Property AmmoTotalPossibleGrenade Auto Const
GlobalVariable Property AmmoTotalPossibleMine Auto Const
GlobalVariable Property AmmoTransferNotifier Auto Const

Keyword Property KeywordAmmoObject Auto Const
Keyword Property KeywordAmmoCaliberExplosive Auto Const
Keyword Property KeywordAmmoCaliberPistol Auto Const
Keyword Property KeywordAmmoCaliberPistolHigh Auto Const
Keyword Property KeywordAmmoCaliberPistolHeavy Auto Const
Keyword Property KeywordAmmoCaliberRifleAssault Auto Const
Keyword Property KeywordAmmoCaliberRifleHeavy Auto Const
Keyword Property KeywordAmmoCaliberRifleSniper Auto Const
Keyword Property KeywordAmmoCaliberRifleShotgun Auto Const
Keyword Property KeywordAmmoCaliberRifleShotgunHigh Auto Const
Keyword Property KeywordAmmoGrenades Auto Const
Keyword Property KeywordAmmoMines Auto Const
Keyword Property KeywordWeaponExplosive Auto Const

Message Property AmmocaseFullSpaceship Auto Const

ReferenceAlias Property PlayerShip Auto

Event OnInit()
	  
	  AddInventoryEventFilter(KeywordAmmoObject)       
      AddInventoryEventFilter(KeywordAmmoCaliberExplosive)
      AddInventoryEventFilter(KeywordAmmoCaliberPistol)
      AddInventoryEventFilter(KeywordAmmoCaliberPistolHigh)
      AddInventoryEventFilter(KeywordAmmoCaliberPistolHeavy)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleAssault)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleHeavy)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleSniper)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleShotgun)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleShotgunHigh)
      AddInventoryEventFilter(KeywordAmmoGrenades)
      AddInventoryEventFilter(KeywordAmmoMines)
      AddInventoryEventFilter(KeywordWeaponExplosive) 

EndEvent

Event OnItemAdded(Form akBaseItem, Int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, Int aiTransferReason)

        SpaceShipReference akShip = PlayerShip.getShipRef()

        Int TotalAmmoPossibleRifle = AmmoTotalPossibleRifle.Getvalue() as Int
        Int TotalAmmoPossibleRifleHigh = AmmoTotalPossibleRifleHigh.Getvalue() as Int
        Int TotalAmmoPossibleRifleHeavy = AmmoTotalPossibleRifleHeavy.Getvalue() as Int
        Int TotalAmmoPossibleExplosive = AmmoTotalPossibleExplosive.Getvalue() as Int
        Int TotalAmmoPossiblePistol = AmmoTotalPossiblePistol.Getvalue() as Int
        Int TotalAmmoPossiblePistolHigh = AmmoTotalPossiblePistolHigh.Getvalue() as Int
        Int TotalAmmoPossiblePistolHeavy = AmmoTotalPossiblePistolHeavy.Getvalue() as Int
        Int TotalAmmoPossibleShotgun = AmmoTotalPossibleShotgun.Getvalue() as Int
        Int TotalAmmoPossibleShotgunHigh = AmmoTotalPossibleShotgunHigh.Getvalue() as Int
        Int TotalAmmoPossibleGrenade = AmmoTotalPossibleGrenade.Getvalue() as Int
        Int TotalAmmoPossibleMine = AmmoTotalPossibleMine.Getvalue() as Int

        Int RifleAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossibleRifle
	    Int ExplosiveAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossibleExplosive
        Int PistolAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossiblePistol
        Int PistolHighAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossiblePistolHigh
        Int PistolHeavyAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossiblePistolHeavy
        Int RifleHighAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossibleRifleHigh
        Int RifleHeavyAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossibleRifleHeavy
        Int ShotgunAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossibleShotgun
        Int ShotgunHighAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossibleShotgunHigh
        Int GrenadeAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossibleGrenade
        Int MineAmmoDropCount = GetitemCount(akBaseItem) - TotalAmmoPossibleMine
	  
	  If akBaseItem.HasKeyword(KeywordAmmoObject)
        
		If akBaseItem.HasKeyword(KeywordAmmoCaliberRifleAssault)
           TransferAmmo(akBaseItem, TotalAmmoPossibleRifle, RifleAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberExplosive)
           TransferAmmo(akBaseItem, TotalAmmoPossibleExplosive, ExplosiveAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberPistol)
           TransferAmmo(akBaseItem, TotalAmmoPossiblePistol, PistolAmmoDropCount)
    ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberPistolHigh)
           TransferAmmo(akBaseItem, TotalAmmoPossiblePistolHigh, PistolHighAmmoDropCount)
    ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberPistolHeavy)
           TransferAmmo(akBaseItem, TotalAmmoPossiblePistolHeavy, PistolHeavyAmmoDropCount)
    ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberRifleSniper)
           TransferAmmo(akBaseItem, TotalAmmoPossibleRifleHigh, RifleHighAmmoDropCount)
    ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberRifleHeavy)
           TransferAmmo(akBaseItem, TotalAmmoPossibleRifleHeavy, RifleHeavyAmmoDropCount)
    ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberRifleShotgun)
           TransferAmmo(akBaseItem, TotalAmmoPossibleShotgun, ShotgunAmmoDropCount)
    ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberRifleShotgunHigh)
           TransferAmmo(akBaseItem, TotalAmmoPossibleShotgunHigh, ShotgunHighAmmoDropCount)
     EndIf
  
 ElseIf akBaseItem.HasKeyword(KeywordWeaponExplosive)    
	    
		If akBaseItem.HasKeyword(KeywordAmmoGrenades)	
           TransferAmmo(akBaseItem, TotalAmmoPossibleGrenade, GrenadeAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoMines)
           TransferAmmo(akBaseItem, TotalAmmoPossibleMine, MineAmmoDropCount)
     EndIf
 EndIf
EndEvent

Function TransferAmmo(Form Item, Int TotalAmount, Int DropAmount)	
          
		  SpaceShipReference akShip = PlayerShip.getShipRef()     
          	  
	      If GetitemCount(Item) > TotalAmount
             RemoveItem(Item, DropAmount, True, akShip)
             TransferMessageMode()
       EndIf
EndFunction

Function TransferMessageMode()	
     
	 If AmmoTransferNotifier.GetValue() == 1
        AmmocaseFullSpaceship.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0) 
  EndIf

EndFunction