ScriptName SISA_AmmoRestricter extends ReferenceAlias

ObjectReference Property AmmoBackpack Auto Const

Actor Property PlayerRef Auto Const

Keyword Property KeywordAmmoObject Auto Const
Keyword Property KeywordAmmoCaliberExplosive Auto Const
Keyword Property KeywordAmmoCaliberPistol Auto Const
Keyword Property KeywordAmmoCaliberPistolHigh Auto Const
Keyword Property KeywordAmmoCaliberPistolHeavy Auto Const
Keyword Property KeywordAmmoCaliberRifleAssault Auto Const
Keyword Property KeywordAmmoCaliberRifleHeavy Auto Const
Keyword Property KeywordAmmoCaliberRifleSniper Auto Const
Keyword Property KeywordAmmoCaliberRifleShotgun Auto Const
Keyword Property KeywordAmmoCaliberRifleShotgunHigh Auto Const
Keyword Property KeywordAmmoGrenades Auto Const
Keyword Property KeywordAmmoMines Auto Const
Keyword Property KeywordSpaceshipAutoDelivery Auto Const
Keyword Property KeywordWeaponExplosive Auto Const

GlobalVariable Property AmmoCountRifle Auto Const
GlobalVariable Property AmmoCountRifleHigh Auto Const
GlobalVariable Property AmmoCountRifleHeavy Auto Const
GlobalVariable Property AmmoCountExplosive Auto Const
GlobalVariable Property AmmoCountPistol Auto Const
GlobalVariable Property AmmoCountPistolHigh Auto Const
GlobalVariable Property AmmoCountPistolHeavy Auto Const
GlobalVariable Property AmmoCountShotgun Auto Const
GlobalVariable Property AmmoCountShotgunHigh Auto Const
GlobalVariable Property AmmoCountGrenade Auto Const
GlobalVariable Property AmmoCountMine Auto Const
GlobalVariable Property AmmunitionRestrictionToggle Auto Const 
GlobalVariable Property AmmunitionStoreMode Auto Const 
GlobalVariable Property AmmoTransferNotifier Auto Const
GlobalVariable Property SpaceshipAutoDeliverer Auto Const

Message Property AmmoSupplyFullPlayer Auto Const
Message Property AmmoSupplyFullSpaceship Auto Const

ReferenceAlias Property PlayerShip Auto
ReferenceAlias Property HomeShip Auto Const mandatory

Event OnAliasInit()	
	Register()
EndEvent

Event OnInit()	
	Register()
EndEvent

Event OnPlayerLoadGame()	
	Register()
EndEvent

Function Register()
 	  
	  AddInventoryEventFilter(KeywordAmmoObject)     
	  AddInventoryEventFilter(KeywordAmmoCaliberExplosive)       
      AddInventoryEventFilter(KeywordAmmoCaliberPistol)
      AddInventoryEventFilter(KeywordAmmoCaliberPistolHigh)
      AddInventoryEventFilter(KeywordAmmoCaliberPistolHeavy)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleAssault)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleHeavy)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleSniper)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleShotgun)
      AddInventoryEventFilter(KeywordAmmoCaliberRifleShotgunHigh)
      AddInventoryEventFilter(KeywordAmmoGrenades)
      AddInventoryEventFilter(KeywordAmmoMines)
      AddInventoryEventFilter(KeywordWeaponExplosive)
      AddInventoryEventFilter(KeywordSpaceshipAutoDelivery)
      
EndFunction

Event OnItemAdded(Form akBaseItem, Int aiItemCount, ObjectReference akItemReference, ObjectReference akSourceContainer, Int aiTransferReason)

    SpaceShipReference akShip = HomeShip.getShipRef()
    
	Int TotalAmmoRifle = AmmoCountRifle.Getvalue() as Int
    Int TotalAmmoRifleHigh = AmmoCountRifleHigh.Getvalue() as Int
    Int TotalAmmoRifleHeavy = AmmoCountRifleHeavy.Getvalue() as Int
    Int TotalAmmoExplosive = AmmoCountExplosive.Getvalue() as Int
    Int TotalAmmoPistol = AmmoCountPistol.Getvalue() as Int
    Int TotalAmmoPistolHigh = AmmoCountPistolHigh.Getvalue() as Int
    Int TotalAmmoPistolHeavy = AmmoCountPistolHeavy.Getvalue() as Int
    Int TotalAmmoShotgun = AmmoCountShotgun.Getvalue() as Int
    Int TotalAmmoShotgunHigh = AmmoCountShotgunHigh.Getvalue() as Int
    Int TotalAmmoGrenade = AmmoCountGrenade.Getvalue() as Int
    Int TotalAmmoMine = AmmoCountMine.Getvalue() as Int

    Int RifleAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoRifle
	Int ExplosiveAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoExplosive
    Int PistolAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoPistol
    Int PistolHighAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoPistolHigh
    Int PistolHeavyAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoPistolHeavy
    Int RifleHighAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoRifleHigh
    Int RifleHeavyAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoRifleHeavy
    Int ShotgunAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoShotgun
    Int ShotgunHighAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoShotgunHigh
    Int GrenadeAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoGrenade	
    Int MineAmmoDropCount = PlayerRef.GetitemCount(akBaseItem) - TotalAmmoMine

   If SpaceshipAutoDeliverer.GetValue() == 1      
             If akBaseItem.HasKeyword(KeywordSpaceshipAutoDelivery)              
			      If PlayerRef.GetItemCount(akBaseItem) > 0
				     PlayerRef.RemoveItem(akBaseItem, 999999, True, akShip)			   
	           EndIf	   
          EndIf
EndIf
   
   If AmmunitionRestrictionToggle.GetValue() == 1     
	  If akBaseItem.HasKeyword(KeywordAmmoObject)       
		
		If akBaseItem.HasKeyword(KeywordAmmoCaliberRifleAssault)
           TransferAmmo(akBaseItem, TotalAmmoRifle, RifleAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberExplosive)
           TransferAmmo(akBaseItem, TotalAmmoExplosive, ExplosiveAmmoDropCount)   		
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberPistol)
           TransferAmmo(akBaseItem, TotalAmmoPistol, PistolAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberPistolHigh)
           TransferAmmo(akBaseItem, TotalAmmoPistolHigh, PistolHighAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberPistolHeavy)
           TransferAmmo(akBaseItem, TotalAmmoPistolHeavy, PistolHeavyAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberRifleSniper)
           TransferAmmo(akBaseItem, TotalAmmoRifleHigh, RifleHighAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberRifleHeavy)
           TransferAmmo(akBaseItem, TotalAmmoRifleHeavy, RifleHeavyAmmoDropCount)
    ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberRifleShotgun)
           TransferAmmo(akBaseItem, TotalAmmoShotgun, ShotgunAmmoDropCount)    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoCaliberRifleShotgunHigh)
           TransferAmmo(akBaseItem, TotalAmmoShotgunHigh, ShotgunHighAmmoDropCount)	   
     EndIf

  ElseIf akBaseItem.HasKeyword(KeywordWeaponExplosive)

        If akBaseItem.HasKeyword(KeywordAmmoGrenades)
		   TransferAmmo(akBaseItem, TotalAmmoGrenade, GrenadeAmmoDropCount)
    
	ElseIf akBaseItem.HasKeyword(KeywordAmmoMines)
		   TransferAmmo(akBaseItem, TotalAmmoMine, MineAmmoDropCount)           
     EndIf  
  EndIf
EndIf

EndEvent

Function TransferAmmo(Form Item, Int TotalAmount, Int DropAmount)	
          
		  SpaceShipReference akShip = HomeShip.getShipRef()     
          	  
	      If PlayerRef.GetitemCount(Item) > TotalAmount
                If AmmunitionStoreMode.GetValue() == 0
                   PlayerRef.RemoveItem(Item, DropAmount, True, AmmoBackpack)
            Else
                   PlayerRef.RemoveItem(Item, DropAmount, True, akShip)
             EndIf
             TransferMessageMode()
       EndIf
EndFunction
	  
Function TransferMessageMode()	
     
	 If AmmoTransferNotifier.GetValue() == 1
                If AmmunitionStoreMode.GetValue() == 0
                   AmmoSupplyFullPlayer.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)                  
            Else
                   AmmoSupplyFullSpaceship.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
             EndIf
  EndIf
EndFunction