ScriptName SISA_SpaceshipFuelPlayerAlias extends ReferenceAlias

Actor Property PlayerRef Auto
ActorValue Property SpaceshipBoostActive Auto
ActorValue Property SpaceshipHealth Auto
ActorValue Property SpaceshipEnginesPower Auto
ActorValue Property SpaceshipGravDrivePower Auto
ActorValue Property SpaceshipGravShieldPower Auto
ActorValue Property SpaceshipWeaponGroup01Power Auto
ActorValue Property SpaceshipWeaponGroup02Power Auto
ActorValue Property SpaceshipWeaponGroup03Power Auto

ActorValue Property SpaceshipWeaponHealth Auto Const
ActorValue Property SpaceshipWeaponHealth02 Auto Const
ActorValue Property SpaceshipWeaponHealth03 Auto Const
ActorValue Property SpaceshipShieldHealth Auto Const
ActorValue Property SpaceshipSystemEngineHealth Auto Const

Quest Property SpaceshipSystemsQuest Auto
LocationRefType Property Ship_PilotSeat_RefType Auto
GlobalVariable Property GV_SpaceshipSystemsToggle Auto Const
GlobalVariable Property GV_SpaceshipOnBoostTime Auto Const
GlobalVariable Property GV_SpaceshipAutoFuel Auto Const
GlobalVariable Property GV_SpaceshipGravityToggle Auto Const
GlobalVariable Property GV_SpaceshipAutoRepairDronesToggle Auto Const
Perk Property SpaceshipBoostBuff01 Auto Const
Perk Property SpaceshipBoostBuff02 Auto Const
Perk Property SpaceshipBoostBuff03 Auto Const
Perk Property SpaceshipBoostBuff04 Auto Const
Perk Property SpaceshipEngineering04 Auto Const
MiscObject Property SpaceshipAutoRepairBotsMisc Auto Const 

Bool Busy = false
Bool Repaired = false

Event OnAliasInit()

	Utility.Wait(0.01)
	PlayerOnPilotSeat(PlayerRef.GetFurnitureUsing())

EndEvent

Event OnPlayerLoadGame()

	Utility.Wait(0.01)
	PlayerOnPilotSeat(PlayerRef.GetFurnitureUsing())

EndEvent

Event OnSit(ObjectReference akFurniture)

      PlayerOnPilotSeat(akFurniture)

EndEvent

Event OnGetUp(ObjectReference akFurniture)
    
          If akFurniture.HasRefType(Ship_PilotSeat_RefType)
		     SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()

		      If akShip
			     (SpaceshipSystemsQuest as SISA_SpaceshipFuel).CheckSystemsAtGetUp()
                 CancelTimer(0)
		   EndIf

       EndIf

EndEvent

Function PlayerOnPilotSeat(ObjectReference akFurniture)

          If akFurniture.HasRefType(Ship_PilotSeat_RefType)
		     SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()

		      If akShip
                 RegisterForRemoteEvent(akShip, "OnShipSystemPowerChange")
                 RegisterForRemoteEvent(akShip, "OnShipSystemDamaged")
                 RegisterForRemoteEvent(akShip, "OnShipSystemRepaired")
                 RegisterForRemoteEvent(akShip, "OnShipUndock")
				 (SpaceshipSystemsQuest as SISA_SpaceshipFuel).CheckSystems()
				 OnBoost()
		   EndIf

       EndIf

EndFunction

Event SpaceShipReference.OnShipUndock(SpaceShipReference akShip, Bool abComplete, SpaceshipReference akUndocking, SpaceshipReference akParent)

	If abComplete
		(SpaceshipSystemsQuest as SISA_SpaceshipFuel).FuelConsumptionStartOnUndock()
 EndIf

EndEvent

Event SpaceShipReference.OnShipSystemPowerChange(SpaceShipReference akShip, ActorValue akSystem, Bool abAddPower, Bool abDamagedRelated)

        If GV_SpaceshipSystemsToggle.GetValue() == 1

			If !abDamagedRelated && !Busy

		          If abAddPower   
		                If akSystem == SpaceshipEnginesPower
					      (SpaceshipSystemsQuest as SISA_SpaceshipFuel).EngineUp()
					 EndIf

		                If akSystem == SpaceshipGravDrivePower
					      (SpaceshipSystemsQuest as SISA_SpaceshipFuel).GravDriveStagesUp()
					 EndIf
		      Else
		                If akSystem == SpaceshipEnginesPower
					      (SpaceshipSystemsQuest as SISA_SpaceshipFuel).EngineDown()
					 EndIf

		                If akSystem == SpaceshipGravDrivePower
					      (SpaceshipSystemsQuest as SISA_SpaceshipFuel).GravDriveStagesDown()
					EndIf
			   EndIf

         EndIf
     EndIf
EndEvent

Event SpaceShipReference.OnShipSystemDamaged(SpaceShipReference akShip, ActorValue akSystem, Int aBlocksLost, Bool aElectromagneticDamage, Bool aFullyDamaged)

     SpaceShipReference InsideShip = PlayerRef.GetCurrentShipRef()

     If GV_SpaceshipSystemsToggle.GetValue() == 1
        If akShip == InsideShip
					 
	         If aBlocksLost
		        DeployAutoRepairBots()
		  EndIf		     
			 
			 If akSystem == SpaceshipGravDrivePower  
				
				(SpaceshipSystemsQuest as SISA_SpaceshipFuel).GravDriveDMGToGravDriveHealth()
					 
					 If aFullyDamaged
						Repaired = False
				        (SpaceshipSystemsQuest as SISA_SpaceshipFuel).SpaceshipZegoGOn()					          
					 EndIf                    		  
		  EndIf

		     If akSystem == SpaceshipEnginesPower
	                 If aFullyDamaged
                        (SpaceshipSystemsQuest as SISA_SpaceshipFuel).SpaceshipFuelConsumptionOff()
                         	
							If PlayerRef.Hasperk(SpaceshipEngineering04)
					           (SpaceshipSystemsQuest as SISA_SpaceshipFuel).EmergencySystemRepair(SpaceshipSystemEngineHealth)
					     EndIf
				  EndIf
          EndIf

		     If akSystem == SpaceshipGravShieldPower
	                 If aFullyDamaged
                         	
							If PlayerRef.Hasperk(SpaceshipEngineering04)
					           (SpaceshipSystemsQuest as SISA_SpaceshipFuel).EmergencySystemRepair(SpaceshipShieldHealth)
					     EndIf
				  EndIf
          EndIf

		     If akSystem == SpaceshipWeaponGroup01Power
	                 If aFullyDamaged
                         	
							If PlayerRef.Hasperk(SpaceshipEngineering04)
					           (SpaceshipSystemsQuest as SISA_SpaceshipFuel).EmergencySystemRepair(SpaceshipWeaponHealth)
					     EndIf
				  EndIf
          EndIf

		     If akSystem == SpaceshipWeaponGroup02Power
	                 If aFullyDamaged
                         	
							If PlayerRef.Hasperk(SpaceshipEngineering04)
					           (SpaceshipSystemsQuest as SISA_SpaceshipFuel).EmergencySystemRepair(SpaceshipWeaponHealth02)
					     EndIf
				  EndIf
          EndIf

		     If akSystem == SpaceshipWeaponGroup03Power
	                 If aFullyDamaged
                         	
							If PlayerRef.Hasperk(SpaceshipEngineering04)
					           (SpaceshipSystemsQuest as SISA_SpaceshipFuel).EmergencySystemRepair(SpaceshipWeaponHealth03)
					     EndIf
				  EndIf
          EndIf
     EndIf
 EndIf

EndEvent

Event SpaceShipReference.OnShipSystemRepaired(SpaceShipReference akShip, ActorValue akSystem, Int aBlocksGained, Bool aElectromagneticDamage)

     SpaceShipReference InsideShip = PlayerRef.GetCurrentShipRef()

     If GV_SpaceshipSystemsToggle.GetValue() == 1
        If akShip == InsideShip

	         If akSystem == SpaceshipGravDrivePower
	               If aBlocksGained && Repaired == False
					          Repaired = True
                      	      If GV_SpaceshipGravityToggle.GetValue() == 1  
				                 (SpaceshipSystemsQuest as SISA_SpaceshipFuel).SpaceshipZegoGOff()
			               EndIf

							  If GV_SpaceshipAutoFuel.GetValue() == 1
                                 (SpaceshipSystemsQuest as SISA_SpaceshipFuel).AutoRefuelingCharge()
		                   EndIf
			    EndIf
          EndIf
     EndIf
 EndIf

EndEvent

Function OnBoost()

	RegisterForCustomEvent(self, "SISA_SpaceshipFuelPlayerAlias_ShipIsBoosting")
    SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()

	If akShip
	   Var[] akArgs = new Var[1]
	   akArgs[0] = akShip
	   SendCustomEvent("SISA_SpaceshipFuelPlayerAlias_ShipIsBoosting", akArgs)
 EndIf

EndFunction

Event SISA_SpaceshipFuelPlayerAlias.ShipIsBoosting(SISA_SpaceshipFuelPlayerAlias akSender, Var[] akArgs)

       Float OnBoostTime = GV_SpaceshipOnBoostTime.GetValue()

       SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()
       If akShip.GetValue(SpaceshipBoostActive) > 0
          (SpaceshipSystemsQuest as SISA_SpaceshipFuel).OnBoost()
	EndIf
    StartTimer(OnBoostTime, 0)
 
EndEvent

Event OnTimer(int aiTimerID)

        Float OnBoostTime = GV_SpaceshipOnBoostTime.GetValue()

             SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()
     	     If (aiTimerID == 0)   
                 If akShip.GetValue(SpaceshipBoostActive) > 0   
			        OnBoost()
			        OnBoostBuff()
			 Else		
				    OnBoostBuffRemover()
              EndIf
		      StartTimer(OnBoostTime, 0)
		  EndIf
	  
EndEvent

Function OnBoostBuff()
                       SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()

                       Int GravDrive = akShip.GetPartPower(3, 0)

                       If GravDrive >= 3

				                If PlayerRef.HasPerk(SpaceshipBoostBuff01) == False
					               PlayerRef.Addperk(SpaceshipBoostBuff01, False)
				             EndIf	
                    EndIf
                       If GravDrive >= 6

				                If PlayerRef.HasPerk(SpaceshipBoostBuff02) == False
					               PlayerRef.Addperk(SpaceshipBoostBuff02, False)
				             EndIf	
                    EndIf
                       If GravDrive >= 9

				                If PlayerRef.HasPerk(SpaceshipBoostBuff03) == False
					               PlayerRef.Addperk(SpaceshipBoostBuff03, False)
				             EndIf	
                    EndIf
                       If GravDrive >= 12

				                If PlayerRef.HasPerk(SpaceshipBoostBuff04) == False
					               PlayerRef.Addperk(SpaceshipBoostBuff04, False)
				             EndIf	
                    EndIf

EndFunction

Function OnBoostBuffRemover()

				                If PlayerRef.HasPerk(SpaceshipBoostBuff01) == True
					               PlayerRef.Removeperk(SpaceshipBoostBuff01)
				             EndIf	

				                If PlayerRef.HasPerk(SpaceshipBoostBuff02) == True
					               PlayerRef.Removeperk(SpaceshipBoostBuff02)
				             EndIf	

				                If PlayerRef.HasPerk(SpaceshipBoostBuff03) == True
					               PlayerRef.Removeperk(SpaceshipBoostBuff03)
				             EndIf	

				                If PlayerRef.HasPerk(SpaceshipBoostBuff04) == True
					               PlayerRef.Removeperk(SpaceshipBoostBuff04)
				             EndIf	

EndFunction

Function DeployAutoRepairBots()
                            
							SpaceShipReference akShip = PlayerRef.GetCurrentShipRef()
				                
								If GV_SpaceshipAutoRepairDronesToggle.GetValue() == 1
					                  If akShip.IsInCombat() == True   
									       If akShip.GetValuePercentage(SpaceshipHealth) < 0.3
										          If akShip.GetItemCount(SpaceshipAutoRepairBotsMisc) > 0
				                                     (SpaceshipSystemsQuest as SISA_SpaceshipFuel).EmergencyRepairBotsAuto()
							                   EndIf
							            EndIf
							       EndIf
							 EndIf	

EndFunction
