ScriptName SISA_Survival extends Quest

Quest Property QuestSpaceshipSystems Auto Const
Quest Property MQ101 Auto Const

Actor Property PlayerRef Auto Const

ActorValue Property Hunger Auto Const
ActorValue Property Sleep Auto Const
ActorValue Property Thirst Auto Const
ActorValue Property Oversatiation Auto Const
ActorValue Property Intoxication Auto Const
ActorValue Property SurvivalDamageIncoming Auto Const
ActorValue Property SurvivalDamageOutgoing Auto Const

ActorValue Property Buy Auto Const
ActorValue Property BuySpaceship Auto Const
ActorValue Property Sell Auto Const
ActorValue Property SellSpaceship Auto Const

Armor Property AdrenalineToken Auto Const
Armor Property WellRestedToken Auto Const

MiscObject Property CarryweightRefresh Auto Const

Book Property StarvivalGuide Auto Const

Keyword Property FoodDrinks Auto Const
Keyword Property Chems Auto Const
Keyword Property ChemsVendor Auto Const
Keyword Property OnlyFood Auto Const

Potion Property Blackout Auto Const
Potion Property SatiationChecker Auto Const
Potion Property AddPotionCureJunkFlush Auto Const
Potion Property PotionAddictionAlcoholism Auto Const
Potion Property PotionAddictionCaffeinophagia Auto Const
Potion Property PotionAddictionCognitiveDissolution Auto Const
Potion Property PotionAddictionHeartAttack Auto Const
Potion Property PotionAddictionParanoidTreatment Auto Const
Potion Property PotionAddictionStimulantsAddiction Auto Const
Potion Property PotionAddictionWarning Auto Const
Potion Property PotionAddictionFoodPoisoning Auto Const

Perk Property SurvivalStart Auto Const
Perk Property SurvivalLogos Auto Const
Perk Property SurvivalLogosOff Auto Const
Perk Property SurvivalAdrenaline Auto Const
Perk Property SurvivalAdrenalineBuff Auto Const
Perk Property SurvivalAdrenalineAftermath Auto Const
Perk Property OversatiationDebuff Auto Const
Perk Property SurvivalDamage Auto Const
Perk Property Nutrition Auto Const
Perk Property PainTolerance Auto Const
Perk Property AmmoWeight Auto Const
Perk Property NonWeightItemsWeight Auto Const
Perk Property DisableWeightForAidItems Auto Const
Perk Property Overencumbrance Auto Const
Perk Property EconomyPerk Auto Const

Perk Property ServiceDiscountPerk01 Auto Const
Perk Property ServiceDiscountPerk02 Auto Const
Perk Property ServiceDiscountPerk03 Auto Const
Perk Property ServiceDiscountPerk04 Auto Const

GlobalVariable Property HungerTime Auto Const
GlobalVariable Property HungerDMGPoints Auto Const
GlobalVariable Property HungerLowestPoints Auto Const
GlobalVariable Property HungerMaxPoints Auto Const
GlobalVariable Property HungerMaxPointsBonus Auto Const
GlobalVariable Property OversatiationMaxPoints Auto Const
GlobalVariable Property OversatiationMaxPointsBonus Auto Const
GlobalVariable Property OversatiationStarter Auto Const
GlobalVariable Property OversatiationLowestPoints Auto Const
GlobalVariable Property IntoxicationMaxPoints Auto Const
GlobalVariable Property IntoxicationMaxPointsBonus Auto Const
GlobalVariable Property IntoxicationStarter Auto Const
GlobalVariable Property IntoxicationLowestPoints Auto Const
GlobalVariable Property IntoxicationMinDMG Auto Const
GlobalVariable Property IntoxicationMaxDMG Auto Const
GlobalVariable Property FoodPoisoningChance Auto Const
GlobalVariable Property FoodPoisoningToggle Auto Const
GlobalVariable Property SleepTime Auto Const
GlobalVariable Property SleepDMGPoints Auto Const
GlobalVariable Property SleepLowestPoints Auto Const
GlobalVariable Property SleepMaxPoints Auto Const
GlobalVariable Property SleepMaxPointsBonus Auto Const
GlobalVariable Property ThirstTime Auto Const
GlobalVariable Property ThirstDMGPoints Auto Const
GlobalVariable Property ThirstLowestPoints Auto Const
GlobalVariable Property ThirstMaxPoints Auto Const
GlobalVariable Property ThirstMaxPointsBonus Auto Const
GlobalVariable Property FoodPointsLow Auto Const
GlobalVariable Property FoodPointsMedium Auto Const
GlobalVariable Property FoodPointsHigh Auto Const
GlobalVariable Property FoodPointsLegendary Auto Const
GlobalVariable Property FoodPointsLowOversatiation Auto Const
GlobalVariable Property FoodPointsMediumOversatiation Auto Const
GlobalVariable Property FoodPointsHighOversatiation Auto Const
GlobalVariable Property FoodPointsLegendaryOversatiation Auto Const
GlobalVariable Property FoodPointsLowOversatiationDrinks Auto Const
GlobalVariable Property FoodPointsMediumOversatiationDrinks Auto Const
GlobalVariable Property FoodPointsHighOversatiationDrinks Auto Const
GlobalVariable Property DrinkPointsLow Auto Const
GlobalVariable Property DrinkPointsMedium Auto Const
GlobalVariable Property DrinkPointsHigh Auto Const
GlobalVariable Property DrinkPointsSpecial Auto Const
GlobalVariable Property DrinkPointsSpecialEnergy Auto Const
GlobalVariable Property DrinkAlcPointsLow Auto Const
GlobalVariable Property DrinkAlcPointsHigh Auto Const
GlobalVariable Property DrinkAlcPointsSpecialThirst Auto Const
GlobalVariable Property DrinkAlcPointsSpecialFatigue Auto Const
GlobalVariable Property ChemsPointsLow Auto Const
GlobalVariable Property ChemsPointsMedium Auto Const
GlobalVariable Property ChemsPointsHigh Auto Const
GlobalVariable Property ChemsPointsVeryHigh Auto Const
GlobalVariable Property BlackoutDuration Auto Const
GlobalVariable Property SurvivalToggler Auto Const
GlobalVariable Property AdrenalineMax Auto Const
GlobalVariable Property AdrenalineTimer Auto Const
GlobalVariable Property AdrenalineCountNotifier Auto Const
GlobalVariable Property AdrenalineToggle Auto Const
GlobalVariable Property AfflictionCureTimer Auto Const
GlobalVariable Property AfflictionCureTimerBandages Auto Const
GlobalVariable Property AddictionCureTimerJunkFlush Auto Const
GlobalVariable Property SleepStartTime Auto
GlobalVariable Property SleepStopTime Auto
GlobalVariable Property SleepTOTALTime Auto
GlobalVariable Property SurvivalDamageToggle Auto Const
GlobalVariable Property AddichroneTimeRestoration Auto Const
GlobalVariable Property AddichroneRestoration Auto Const
GlobalVariable Property AmmoWeightToggle Auto Const
GlobalVariable Property OverencumbranceToggle Auto Const
GlobalVariable Property NeedsCheckerImmersiveMode Auto Const
GlobalVariable Property NeedsCheckerNotificationType Auto Const
GlobalVariable Property NeedsCheckerAfterConsumptionNotifier Auto Const
GlobalVariable Property OversatiationTime Auto Const
GlobalVariable Property OversatiationDMGPoints Auto Const
GlobalVariable Property FoodRestoreHealth Auto Const
GlobalVariable Property StartStarvival Auto Const
GlobalVariable Property AddictionToggleAlcoholism Auto Const
GlobalVariable Property AddictionToggleCaffeinophagia Auto Const
GlobalVariable Property AddictionToggleCognitiveDissolution Auto Const
GlobalVariable Property AddictionToggleHeartAttack Auto Const
GlobalVariable Property AddictionToggleParanoidTreatment Auto Const
GlobalVariable Property AddictionToggleStimulants Auto Const
GlobalVariable Property SpaceshipSystemsToggle Auto Const
GlobalVariable Property NGPlusStarted Auto Const
GlobalVariable Property WeightlessAidsToggle Auto Const 
GlobalVariable Property SurvivalDamageIncomingGlobal Auto Const
GlobalVariable Property SurvivalDamageOutgoingGlobal Auto Const
GlobalVariable Property FuelCost Auto Const
GlobalVariable Property EconomyToggle Auto Const
GlobalVariable Property EconomyBuyGlobal Auto Const
GlobalVariable Property EconomySellGlobal Auto Const
GlobalVariable Property EconomyBuyShipGlobal Auto Const
GlobalVariable Property EconomySellShipGlobal Auto Const
GlobalVariable Property BlockFatigueStopBonus Auto Const

MagicEffect Property FoodLowGrade Auto Const
MagicEffect Property FoodMediumGrade Auto Const
MagicEffect Property FoodHighGrade Auto Const
MagicEffect Property FoodLegendaryGrade Auto Const
MagicEffect Property DrinkLowGrade Auto Const
MagicEffect Property DrinkMediumGrade Auto Const
MagicEffect Property DrinkHighGrade Auto Const
MagicEffect Property DrinkEnergy Auto Const
MagicEffect Property DrinkAlcoholLowGrade Auto Const
MagicEffect Property DrinkAlcoholHighGrade Auto Const
MagicEffect Property DrinkAlcoholSpecial Auto Const
MagicEffect Property ChemsLowGrade Auto Const
MagicEffect Property ChemsMediumGrade Auto Const
MagicEffect Property ChemsHighGrade Auto Const
MagicEffect Property AddictionSuppressantCheck Auto Const
MagicEffect Property CaffeinophagiaCheck Auto Const
MagicEffect Property AddictionCureJunkFlush Auto Const
MagicEffect Property AddichroneSuppression Auto Const
MagicEffect Property FoodPoisoningDebuff Auto Const

Message Property InitializeMSG Auto Const
Message Property StarvivalEnabled Auto Const
Message Property StarvivalRemoved Auto Const
Message Property NeedsAllChecker Auto Const
Message Property NeedsAllCheckerBox Auto Const
Message Property AdrenalineCount Auto Const
Message Property UpdateMessage Auto Const
Message Property UninstallMessage Auto Const
Message Property MSGHungerFamished Auto Const
Message Property MSGHungerPeckish Auto Const
Message Property MSGHungerRavenous Auto Const
Message Property MSGHungerStarving Auto Const
Message Property MSGSleepExhausted Auto Const
Message Property MSGSleepIncapacitated Auto Const
Message Property MSGSleepTired Auto Const
Message Property MSGSleepWeary Auto Const
Message Property MSGThirstParched Auto Const
Message Property MSGThirstMildlyDehydrated Auto Const
Message Property MSGThirstDehydrated Auto Const
Message Property MSGThirstSeverelyDehydrated Auto Const

FormList Property AddictionItems_AlcoholismTrigger Auto
FormList Property AddictionItems_CaffeinophagiaTrigger Auto
FormList Property AddictionItems_CognitiveDissolutionTrigger Auto
FormList Property AddictionItems_HeartAttackTrigger Auto
FormList Property AddictionItems_ParanoidTreatmentTrigger Auto
FormList Property AddictionItems_StimulantsAddictionTrigger Auto

FormList Property FoodItems_LowGrade Auto
FormList Property FoodItems_MediumGrade Auto
FormList Property FoodItems_HighGrade Auto
FormList Property FoodItems_LegendaryGrade Auto

FormList Property DrinkItems_LowGrade Auto
FormList Property DrinkItems_MediumGrade Auto
FormList Property DrinkItems_HighGrade Auto
FormList Property DrinkItems_EnergyGrade Auto

FormList Property AlcoholItems_LowGrade Auto
FormList Property AlcoholItems_HighGrade Auto
FormList Property AlcoholItems_EnergyGrade Auto

FormList Property ChemItems_LowGrade Auto
FormList Property ChemItems_MediumGrade Auto
FormList Property ChemItems_HighGrade Auto

FormList Property ComboItems_LowGrade Auto
FormList Property ComboItems_MediumGrade Auto
FormList Property ComboItems_HighGrade Auto

Spell Property IntoxicationWarning Auto Const
Spell Property CureAddictions Auto Const 
Spell Property OversatiationPenalty Auto Const 
Spell Property AdrenalineAftermathPenalty Auto Const 
Spell Property AdrenalineRushBuff Auto Const 
Spell Property FoodPoisoning Auto Const 

bool AddichroneOnPlayer = false

Int Property StarbornTriggerStage = 2000 auto const 
Int Property SurvivalTriggerStage = 310 auto const 
Int FatigueBlock = 0

Float fVersion

Event OnQuestInit()

      RegisterForPlayerSleep()
      RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
      RegisterForRemoteEvent(MQ101 as scriptobject, "OnStageSet")                            

EndEvent

Event Quest.OnStageSet(Quest akSender, int auiStageID, int auiItemID)

    If akSender == MQ101 && auiStageID == StarbornTriggerStage

       NGPlusStarted.SetValue(1)
       IntroductoryMessage()
       StartStarvival.SetValue(1)
	   AddBook()
       UnregisterForRemoteEvent(MQ101, "OnStageSet")
 
 EndIf

    If akSender == MQ101 && auiStageID == SurvivalTriggerStage
       StartTimer(3, 36) 
 EndIf

EndEvent

Function Update()

          Int Version0 = 0		   
          Int Version1 = 1
          Int Version2 = 2
          Int Version3 = 3
          Int Version4 = 4
          Int Version5 = 5
          Int Version6 = 6		   
          Int Version7 = 7
          Int Version8 = 8
          Int Version9 = 9

	   While fVersion < 5.43
			
		       If fVersion < 5.3	              
			      fVersion = 5.3	
                 
				  UnregisterForMagicEffectApplyEvent(PlayerRef, None, FoodLowGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, FoodMediumGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, FoodHighGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, FoodLegendaryGrade, True)

                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkLowGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkMediumGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkHighGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkEnergy, True)

                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholLowGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholHighGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, DrinkAlcoholSpecial, True)

                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, ChemsLowGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, ChemsMediumGrade, True)
                  UnregisterForMagicEffectApplyEvent(PlayerRef, None, ChemsHighGrade, True)			
			      SurvivalDamageDebugReset()
				  EconomyDebugReset()
			      (QuestSpaceshipSystems as SISA_SpaceshipFuel).CalculateRepairCost()
			      (QuestSpaceshipSystems as SISA_SpaceshipFuel).CalculateFuelCost()

		   ElseIf fVersion < 5.31	              
			      fVersion = 5.31	
		   ElseIf fVersion < 5.40	              
			      fVersion = 5.40
		   ElseIf fVersion < 5.41	              
			      fVersion = 5.41
		   ElseIf fVersion < 5.42	              
			      fVersion = 5.42
			      FatigueBlock = 0
				  BlockFatigueStopBonus.Setvalue(0)
		   ElseIf fVersion < 5.43	              
			      fVersion = 5.43
			EndIf

            UpdateMessage.show(Version5, Version4, Version3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	EndWhile

EndFunction

Function IntroductoryMessage()

         Utility.Wait(3.0)
		 int button = -1
		 button = InitializeMSG.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	     If (button == 0)                
            StartStarvivalSystems()
            AddBook()
			StartStarvival.SetValue(1)
             
	 ElseIf (button == 1)
	        AddBook()
            StartStarvival.SetValue(0)
	  EndIf

EndFunction

Function AddBook()

	If PlayerRef.GetItemCount(StarvivalGuide) < 1
	   PlayerRef.AddItem(StarvivalGuide, 1, True)
 EndIf

EndFunction

Function MissionExterminatus()

         UnregisterForPlayerSleep()
         UnregisterForPlayerWait()
         UnregisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
         UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnItemEquipped")
         UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)

         NeedsStopLogo()

	     Utility.Wait(1.0)
         CancelTimer(0)
         CancelTimer(1)
         CancelTimer(2)
         CancelTimer(3)
         CancelTimer(4)  
         CancelTimer(35)  
         CancelTimer(40)  

	     Utility.Wait(1.0)
         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         Utility.Wait(1.0)         
	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
	     PlayerRef.RestoreValue(Oversatiation, 999)

      If PlayerRef.GetItemCount(SatiationChecker) > 0
         PlayerRef.Removeitem(SatiationChecker, 9999, True, None)
   EndIf

      If PlayerRef.GetItemCount(AdrenalineToken) > 0
         PlayerRef.RemoveItem(AdrenalineToken, 9999, True, None)
   EndIf

      If PlayerRef.GetItemCount(WellRestedToken) > 0
         PlayerRef.RemoveItem(WellRestedToken, 9999, True, None)
   EndIf

      If PlayerRef.GetItemCount(StarvivalGuide) > 0
         PlayerRef.RemoveItem(StarvivalGuide, 9999, True, None)
   EndIf

         Utility.Wait(1.0)
         PlayerRef.Removeperk(SurvivalLogos) 
         PlayerRef.Removeperk(SurvivalLogosOff) 
         PlayerRef.Removeperk(SurvivalStart) 
         PlayerRef.RemovePerk(SurvivalAdrenaline)
         PlayerRef.Removeperk(SurvivalAdrenalineBuff) 
         PlayerRef.Removeperk(SurvivalAdrenalineAftermath) 
         PlayerRef.Removeperk(OversatiationDebuff) 
         PlayerRef.RemovePerk(SurvivalDamage)
         PlayerRef.Removeperk(AmmoWeight) 
         PlayerRef.RemovePerk(Overencumbrance)

         PlayerRef.DispelSpell(OversatiationPenalty)
         PlayerRef.DispelSpell(AdrenalineAftermathPenalty)
         PlayerRef.DispelSpell(AdrenalineRushBuff)	 
         PlayerRef.DispelSpell(FoodPoisoning)

         CureAddictions.Cast(PlayerRef, PlayerRef)
         RefreshCarryWeight()

         (QuestSpaceshipSystems as SISA_SpaceshipFuel).SpaceshipSystemUninstallExterminatus()

		 Utility.Wait(2.0)
         UninstallMessage.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

EndFunction

Function StartStarvivalSystems()

                  SystemsPoints()
                  NeedsInitializeLogo()
                  SurvivalSystems()
                  StartNeedsTimers()

                  RegisterForPlayerSleep()
                  RegisterForPlayerWait()

                  RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
                  RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnItemEquipped")
                  RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")
                                   
EndFunction

Function NeedsFullReset()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)
 		 Float IntoxicationLowestPoint = IntoxicationLowestPoints.GetValue()
 		 Float IntoxicationThreshold = - PlayerRef.GetValue(Intoxication)

         PlayerRef.Removeitem(SatiationChecker, 999, True, None)
         PlayerRef.RemovePerk(SurvivalStart) 
         NeedsStopLogo()

	     Utility.Wait(1.0)
         StopNeedsTimers() 

	     Utility.Wait(1.0)

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         If PlayerRef.GetValue(Intoxication) < IntoxicationLowestPoint
            PlayerRef.RestoreValue(Intoxication, IntoxicationThreshold)
      EndIf

         Utility.Wait(1.0)         
	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
	     PlayerRef.RestoreValue(Oversatiation, 999)
	     PlayerRef.RestoreValue(Intoxication, 999)

         Utility.Wait(1.0)
         PlayerRef.DamageValue(Hunger, 57)
         PlayerRef.DamageValue(Sleep, 50)
         PlayerRef.DamageValue(Thirst, 60)
         PlayerRef.DamageValue(Oversatiation, 100)
         PlayerRef.DamageValue(Intoxication, 100)

	     Utility.Wait(1.0)
         PlayerRef.Additem(SatiationChecker, 1, False)
         NeedsInitializeLogo()

         Utility.Wait(1.0)
         PlayerRef.Addperk(SurvivalStart, False) 

	     Utility.Wait(1.0)
         StartNeedsTimers()
         SatiationChecker()

EndFunction

Function NeedsInitializeLogo()

             PlayerRef.Addperk(SurvivalLogos, False) 
             Utility.Wait(1.0)
             PlayerRef.Removeperk(SurvivalLogos) 

EndFunction

Function NeedsStopLogo()

             PlayerRef.Addperk(SurvivalLogosOff, False) 
             Utility.Wait(1.0)
             PlayerRef.Removeperk(SurvivalLogosOff) 

EndFunction

Event Actor.OnPlayerLoadGame(Actor akSender)

      RegisterForPlayerSleep()
      RegisterForPlayerWait()
      RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnItemEquipped")
      RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")
      RefreshCarryWeight()

EndEvent

Function RefreshCarryWeight()

      PlayerRef.Additem(CarryweightRefresh, 1, True)
      PlayerRef.Removeitem(CarryweightRefresh, 1, True, None)

EndFunction

Function SystemsPoints()

		 Float IntoxicationPointsPool = IntoxicationMaxPoints.GetValue()
         Float HungerPointsPool = HungerMaxPoints.GetValue()
		 Float SleepPointsPool = SleepMaxPoints.GetValue()
		 Float ThirstPointsPool = ThirstMaxPoints.GetValue()
		 Float OversatiationPointsPool = OversatiationMaxPoints.GetValue()

	     PlayerRef.SetValue(Hunger, HungerPointsPool)
	     PlayerRef.SetValue(Sleep, SleepPointsPool)
	     PlayerRef.SetValue(Thirst, ThirstPointsPool)
	     PlayerRef.SetValue(Oversatiation, OversatiationPointsPool)
         PlayerRef.SetValue(SurvivalDamageIncoming, 20.0)
         PlayerRef.SetValue(SurvivalDamageOutgoing, 20.0)
	     PlayerRef.SetValue(Intoxication, IntoxicationPointsPool)

         Utility.Wait(0.5)
         PlayerRef.DamageValue(Hunger, 57)
         PlayerRef.DamageValue(Sleep, 50)
         PlayerRef.DamageValue(Thirst, 60)
         PlayerRef.DamageValue(Oversatiation, 100)
         PlayerRef.DamageValue(SurvivalDamageIncoming, 17.5)
         PlayerRef.DamageValue(SurvivalDamageOutgoing, 17.5)
         PlayerRef.DamageValue(Intoxication, 100)
                  
		 NeedsThresholdsChecks()

EndFunction

Function SurvivalSystems()

         SurvivalToggler.SetValue(1) 
         SurvivalDamageToggle.SetValue(1) 
         IntoxicationStarter.SetValue(1) 
         OversatiationStarter.SetValue(1) 
         AdrenalineToggle.SetValue(1) 
         AmmoWeightToggle.SetValue(1)
	     OverencumbranceToggle.SetValue(1)
         FoodPoisoningToggle.SetValue(1)
         FoodRestoreHealth.SetValue(0)
		 SurvivalDamageIncomingGlobal.SetValue(2.50)
         SurvivalDamageOutgoingGlobal.SetValue(2.50)
         
		 Utility.Wait(1.0)
         PlayerRef.Addperk(SurvivalStart, False) 
         PlayerRef.Addperk(SurvivalAdrenaline, False) 
         PlayerRef.Addperk(SurvivalDamage, False) 
	     PlayerRef.Addperk(AmmoWeight, False)
	     PlayerRef.Addperk(NonWeightItemsWeight, False)
		 PlayerRef.Addperk(Overencumbrance, False)

         PlayerRef.Additem(SatiationChecker, 1, False)

         RefreshCarryWeight()

         Utility.Wait(1.0)
		 SatiationChecker()
          
		 (QuestSpaceshipSystems as SISA_SpaceshipFuel).SpaceshipSystemStart()

EndFunction

Function StarvivalNeedsBook()

        If SurvivalToggler.GetValue() == 0
           SurvivalToggler.SetValue(1)
           OversatiationStarter.SetValue(1) 
           PlayerRef.AddPerk(SurvivalStart, False)
           PlayerRef.Additem(SatiationChecker, 1, False)
           NeedsInitializeLogo()
           SurvivalPointsRestoreOnActivate()
           StartNeedsTimers()

           RegisterForPlayerSleep()
           RegisterForPlayerWait()
           RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
           RegisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")

    ElseIf SurvivalToggler.GetValue() == 1
           SurvivalToggler.SetValue(0) 
           OversatiationStarter.SetValue(0) 
           PlayerRef.RemovePerk(SurvivalStart)
           PlayerRef.Removeitem(SatiationChecker, 9999, True, None)
           NeedsStopLogo()
           SurvivalPointsRestoreOnDeactivate()
           StopNeedsTimers()

           UnregisterForRemoteEvent(PlayerRef as ScriptObject, "OnPlayerJail")

     EndIf

EndFunction

Function SurvivalDamageBook()
         
		 Float IncomingSurvDMG = PlayerRef.GetValue(SurvivalDamageIncoming)
         Float OutgoingSurvDMG = PlayerRef.GetValue(SurvivalDamageOutgoing)
         Float IncomingSurvDMGIfNegative = - PlayerRef.GetValue(SurvivalDamageIncoming)
         Float OutgoingSurvDMGIfNegative = - PlayerRef.GetValue(SurvivalDamageOutgoing)

      If SurvivalDamageToggle.GetValue() == 0
         SurvivalDamageToggle.SetValue(1) 
         PlayerRef.RestoreValue(SurvivalDamageIncoming, 2.5)
         PlayerRef.RestoreValue(SurvivalDamageOutgoing, 2.5)
         SurvivalDamageIncomingGlobal.SetValue(2.50)
         SurvivalDamageOutgoingGlobal.SetValue(2.50)
         PlayerRef.Addperk(SurvivalDamage, False) 

  ElseIf SurvivalDamageToggle.GetValue() == 1
         SurvivalDamageToggle.SetValue(0) 
              
			  If IncomingSurvDMG < 0
		         PlayerRef.RestoreValue(SurvivalDamageIncoming, IncomingSurvDMGIfNegative)		 
          ElseIf IncomingSurvDMG >= 0
		         PlayerRef.DamageValue(SurvivalDamageIncoming, IncomingSurvDMG)
		   EndIf
              
			  If OutgoingSurvDMG < 0
                 PlayerRef.RestoreValue(SurvivalDamageOutgoing, OutgoingSurvDMGIfNegative)
          ElseIf OutgoingSurvDMG >= 0
		         PlayerRef.DamageValue(SurvivalDamageOutgoing, OutgoingSurvDMG)
           EndIf        
		 
		 SurvivalDamageIncomingGlobal.SetValue(0)
         SurvivalDamageOutgoingGlobal.SetValue(0)
         PlayerRef.Removeperk(SurvivalDamage) 
   EndIf

EndFunction

Function SurvivalDamageDebugReset()
         
		 Float IncomingSurvDMG = PlayerRef.GetValue(SurvivalDamageIncoming)
         Float OutgoingSurvDMG = PlayerRef.GetValue(SurvivalDamageOutgoing)
         Float IncomingSurvDMGIfNegative = - PlayerRef.GetValue(SurvivalDamageIncoming)
         Float OutgoingSurvDMGIfNegative = - PlayerRef.GetValue(SurvivalDamageOutgoing)
  
      If IncomingSurvDMG < 0 || OutgoingSurvDMG < 0   			  
			  
			  If IncomingSurvDMG < 0
		         PlayerRef.RestoreValue(SurvivalDamageIncoming, IncomingSurvDMGIfNegative)		 
		   EndIf
              
			  If OutgoingSurvDMG < 0
                 PlayerRef.RestoreValue(SurvivalDamageOutgoing, OutgoingSurvDMGIfNegative)
           EndIf   

         PlayerRef.RestoreValue(SurvivalDamageIncoming, 2.5)
         PlayerRef.RestoreValue(SurvivalDamageOutgoing, 2.5)
         
		 SurvivalDamageIncomingGlobal.SetValue(2.50)
         SurvivalDamageOutgoingGlobal.SetValue(2.50)
		 PlayerRef.Removeperk(SurvivalDamage)          
		 PlayerRef.Addperk(SurvivalDamage, False)                  		 
         SurvivalDamageToggle.SetValue(1)
		 Debug.Notification("SURVIVAL DAMAGE HAS BEEN RESET")
   EndIf
EndFunction

Function EconomyBook()
         
		 Float BuyMult = PlayerRef.GetValue(Buy)
         Float SellMult = PlayerRef.GetValue(Sell)
		 Float BuyShipPartsMult = PlayerRef.GetValue(BuySpaceship)
         Float SellShipPartsMult = PlayerRef.GetValue(SellSpaceship)
		 
		 Float BuyMultIfNegative = - PlayerRef.GetValue(Buy)
         Float SellMultIfNegative = - PlayerRef.GetValue(Sell)         
		 Float BuyMultShipPartsIfNegative = - PlayerRef.GetValue(BuySpaceship)
         Float SellMultShipPartsIfNegative = - PlayerRef.GetValue(SellSpaceship)

      If EconomyToggle.GetValue() == 0
         EconomyToggle.SetValue(1) 
         PlayerRef.RestoreValue(Buy, 1.35)
         PlayerRef.RestoreValue(Sell, 0.75)
         PlayerRef.RestoreValue(BuySpaceship, 1.75)
         PlayerRef.RestoreValue(SellSpaceship, 2.25)
         EconomyBuyGlobal.SetValue(35)
         EconomySellGlobal.SetValue(-25)
         EconomyBuyShipGlobal.SetValue(75)
         EconomySellShipGlobal.SetValue(225)
         PlayerRef.Addperk(EconomyPerk, False) 

  ElseIf EconomyToggle.GetValue() == 1
         EconomyToggle.SetValue(0) 
              
			  If BuyMult < 0
		         PlayerRef.RestoreValue(Buy, BuyMultIfNegative)		 
          ElseIf BuyMult >= 0
		         PlayerRef.DamageValue(Buy, BuyMult)
		   EndIf
              
			  If SellMult < 0
                 PlayerRef.RestoreValue(Sell, SellMultIfNegative)
          ElseIf SellMult >= 0
		         PlayerRef.DamageValue(Sell, SellMult)
           EndIf        

			  If BuyShipPartsMult < 0
		         PlayerRef.RestoreValue(BuySpaceship, BuyMultShipPartsIfNegative)		 
          ElseIf BuyShipPartsMult >= 0
		         PlayerRef.DamageValue(BuySpaceship, BuyShipPartsMult)
		   EndIf
              
			  If SellShipPartsMult < 0
                 PlayerRef.RestoreValue(SellSpaceship, SellMultShipPartsIfNegative)
          ElseIf SellShipPartsMult >= 0
		         PlayerRef.DamageValue(SellSpaceship, SellShipPartsMult)
           EndIf
		 
         EconomyBuyGlobal.SetValue(0)
         EconomySellGlobal.SetValue(0)
         EconomyBuyShipGlobal.SetValue(0)
         EconomySellShipGlobal.SetValue(0)
         PlayerRef.Removeperk(EconomyPerk) 
   EndIf

EndFunction

Function EconomyDebugReset()
         
		 Float BuyMult = PlayerRef.GetValue(Buy)
         Float SellMult = PlayerRef.GetValue(Sell)
		 Float BuyShipPartsMult = PlayerRef.GetValue(BuySpaceship)
         Float SellShipPartsMult = PlayerRef.GetValue(SellSpaceship)
		 
		 Float BuyMultIfNegative = - PlayerRef.GetValue(Buy)
         Float SellMultIfNegative = - PlayerRef.GetValue(Sell)         
		 Float BuyMultShipPartsIfNegative = - PlayerRef.GetValue(BuySpaceship)
         Float SellMultShipPartsIfNegative = - PlayerRef.GetValue(SellSpaceship)
  
  If Game.IsPluginInstalled("Starvival - ModuleEconomy.esm")         
		If BuyMult < 0 || SellMult < 0 || BuyShipPartsMult < 0 || SellShipPartsMult < 0       
			  
			  If BuyMult < 0
		         PlayerRef.RestoreValue(Buy, BuyMultIfNegative)		 
		   EndIf
              
			  If SellMult < 0
                 PlayerRef.RestoreValue(Sell, SellMultIfNegative)
           EndIf        

			  If BuyShipPartsMult < 0
		         PlayerRef.RestoreValue(BuySpaceship, BuyMultShipPartsIfNegative)		 
		   EndIf
              
			  If SellShipPartsMult < 0
                 PlayerRef.RestoreValue(SellSpaceship, SellMultShipPartsIfNegative)
           EndIf

         PlayerRef.RestoreValue(Buy, 1.35)
         PlayerRef.RestoreValue(Sell, 0.75)
         PlayerRef.RestoreValue(BuySpaceship, 1.75)
         PlayerRef.RestoreValue(SellSpaceship, 2.25)
		 
         EconomyBuyGlobal.SetValue(35)
         EconomySellGlobal.SetValue(-25)
         EconomyBuyShipGlobal.SetValue(75)
         EconomySellShipGlobal.SetValue(225)
         PlayerRef.Removeperk(EconomyPerk) 
         PlayerRef.Addperk(EconomyPerk, False) 
         EconomyToggle.SetValue(1)
         Debug.Notification("ECONOMY MODULE HAS BEEN RESET")
	 EndIf
 EndIf
EndFunction

Function AdrenalineBook()

      If AdrenalineToggle.GetValue() == 0
         AdrenalineToggle.SetValue(1) 
         PlayerRef.Addperk(SurvivalAdrenaline, False) 

  ElseIf AdrenalineToggle.GetValue() == 1
         AdrenalineToggle.SetValue(0)
         PlayerRef.Removeperk(SurvivalAdrenaline) 
         PlayerRef.DispelSpell(AdrenalineAftermathPenalty)
         PlayerRef.DispelSpell(AdrenalineRushBuff)	
         CancelTimer(1)

           If PlayerRef.GetItemCount(AdrenalineToken) > 0 
              PlayerRef.RemoveItem(AdrenalineToken, 9999, True, None)
        EndIf

   EndIf

EndFunction

Function OversatiationBook()

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)
         Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)

      If OversatiationStarter.GetValue() == 0
         OversatiationStarter.SetValue(1) 

  ElseIf OversatiationStarter.GetValue() == 1
         OversatiationStarter.SetValue(0) 

		    If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
               PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
         EndIf

         PlayerRef.DamageValue(Oversatiation, OversatiationCheck)
         PlayerRef.RemovePerk(OversatiationDebuff)
         PlayerRef.DispelSpell(OversatiationPenalty)
         CancelTimer(40)
   EndIf

EndFunction

Function IntoxicationBook()

 		 Float IntoxicationLowestPoint = IntoxicationLowestPoints.GetValue()
 		 Float IntoxicationThreshold = - PlayerRef.GetValue(Intoxication)
         Float IntoxicationCheck = PlayerRef.GetValue(Intoxication)

      If IntoxicationStarter.GetValue() == 0
         IntoxicationStarter.SetValue(1) 
  
  ElseIf IntoxicationStarter.GetValue() == 1
         IntoxicationStarter.SetValue(0)

            If PlayerRef.GetValue(Intoxication) < IntoxicationLowestPoint
               PlayerRef.RestoreValue(Intoxication, IntoxicationThreshold)
         EndIf

         PlayerRef.DamageValue(Intoxication, IntoxicationCheck)
   EndIf

EndFunction

Function AmmoWeightsBook()

      If AmmoWeightToggle.GetValue() == 0
         AmmoWeightToggle.SetValue(1)
         PlayerRef.Addperk(AmmoWeight, False)

         RefreshCarryWeight()

  ElseIf AmmoWeightToggle.GetValue() == 1
         AmmoWeightToggle.SetValue(0)
         PlayerRef.Removeperk(AmmoWeight)
   
         RefreshCarryWeight()
   
   EndIf

EndFunction

Function WeightlessAidsBook()

      If WeightlessAidsToggle.GetValue() == 0
         WeightlessAidsToggle.SetValue(1)
         PlayerRef.Addperk(DisableWeightForAidItems, False)

         RefreshCarryWeight()

  ElseIf WeightlessAidsToggle.GetValue() == 1
         WeightlessAidsToggle.SetValue(0)
         PlayerRef.Removeperk(DisableWeightForAidItems)
   
         RefreshCarryWeight()
   
   EndIf

EndFunction

Function OverencumbranceBook()

      If OverencumbranceToggle.GetValue() == 0
         OverencumbranceToggle.SetValue(1)
         PlayerRef.Addperk(Overencumbrance, False)

         RefreshCarryWeight()

  ElseIf OverencumbranceToggle.GetValue() == 1
         OverencumbranceToggle.SetValue(0)
         PlayerRef.Removeperk(Overencumbrance)
   
         RefreshCarryWeight()
   
   EndIf

EndFunction

Function SurvivalPointsRestoreOnDeactivate()

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)

	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
         PlayerRef.RestoreValue(Oversatiation, 999)

         If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

EndFunction

Function SurvivalPointsRestoreOnActivate()

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)

         PlayerRef.DamageValue(Hunger, 57)
         PlayerRef.DamageValue(Sleep, 50)
         PlayerRef.DamageValue(Thirst, 60)
         PlayerRef.DamageValue(Oversatiation, 100)

         If PlayerRef.GetValue(Oversatiation) < OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

         Utility.Wait(1.0)
         SatiationChecker()

EndFunction

Function SurvivalPointsRestoreAfterJail()

         int HungerDMG = Utility.RandomInt(25, 75)
         int SleepDMG = Utility.RandomInt(25, 75)
		 int ThirstDMG = Utility.RandomInt(25, 75)

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)
         Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)

	     PlayerRef.RestoreValue(Hunger, 999)
	     PlayerRef.RestoreValue(Sleep, 999)
	     PlayerRef.RestoreValue(Thirst, 999)
	     PlayerRef.RestoreValue(Oversatiation, 999)

         PlayerRef.DamageValue(Hunger, HungerDMG)
         PlayerRef.DamageValue(Sleep, SleepDMG)
         PlayerRef.DamageValue(Thirst, ThirstDMG)
         PlayerRef.DamageValue(Oversatiation, 100)
         
		 FatigueBlock = 0
         BlockFatigueStopBonus.SetValue(0)
		 
		 NeedsThresholdsChecksAfterJail()

EndFunction

Function StartNeedsTimers()

         Float HungerStart = HungerTime.GetValue()
         Float SleepStart = SleepTime.GetValue()
         Float ThirstStart = ThirstTime.GetValue()

         StartTimer(HungerStart, 2)
         StartTimer(SleepStart, 3)
         StartTimer(ThirstStart, 4)

EndFunction

Function StopNeedsTimers()

         CancelTimer(0)
         CancelTimer(2)
         CancelTimer(3)
         CancelTimer(4)
         CancelTimer(40)

EndFunction

Function ResetNeedsTimers()

         Float HungerStart = HungerTime.GetValue()
         Float SleepStart = SleepTime.GetValue()
         Float ThirstStart = ThirstTime.GetValue()
         Float OversatiationStart = OversatiationTime.GetValue()
 
         CancelTimer(2)
         CancelTimer(3)
         CancelTimer(4)
         CancelTimer(40)

         StartTimer(HungerStart, 2)
         StartTimer(SleepStart, 3)
         StartTimer(ThirstStart, 4)
         StartTimer(OversatiationStart, 40)
         Debug.Notification("NEEDs timers have been reset")

EndFunction

Function ResetOversatiationTimer()

         Float OversatiationStart = OversatiationTime.GetValue()
 
         CancelTimer(40)
         StartTimer(OversatiationStart, 40)
         Debug.Notification("Oversatiation timer has been reset")

EndFunction

Float Function ServiceDiscountCost()
     
	 Float DiscountPercent00 = 1.00
     Float DiscountPercent01 = 1.15 	 
     Float DiscountPercent02 = 1.25 
     Float DiscountPercent03 = 1.35 
     Float DiscountPercent04 = 1.50 	 
		
		If PlayerRef.Hasperk(ServiceDiscountPerk04)     
		   Return DiscountPercent04 
	ElseIf PlayerRef.Hasperk(ServiceDiscountPerk03)  
	       Return DiscountPercent03
	ElseIf PlayerRef.Hasperk(ServiceDiscountPerk02) 	 
           Return DiscountPercent02
	ElseIf PlayerRef.Hasperk(ServiceDiscountPerk01)
           Return DiscountPercent01 
Else	
           Return DiscountPercent00
     EndIf

EndFunction

float Function GetCurrentHourOfDay() 
 
	float Time = Utility.GetCurrentRealTime()
	Return Time
 
EndFunction

Event Actor.OnPlayerJail(Actor akSender, ObjectReference akGuard, Form akFaction, Location akLocation, Int aeCrimeGold)

    SurvivalPointsRestoreAfterJail()

EndEvent

Event OnPlayerWaitStart(float afWaitStartTime, float afDesiredWaitEndTime)

	Float StartingSleep = GetCurrentHourOfDay()
	SleepStartTime.SetValue(StartingSleep)

EndEvent

Event OnPlayerWaitStop(bool abInterrupted)

	     Float EndingSleep = GetCurrentHourOfDay()
	     SleepStopTime.SetValue(EndingSleep)

      If SurvivalToggler.GetValue() == 1 
         NeedsAfterWait()
         NeedsThresholdsChecks()
   EndIf
   
EndEvent

Event OnPlayerSleepStart(float afSleepStartTime, float afDesiredSleepEndTime, ObjectReference akBed)

	Float StartingSleep = GetCurrentHourOfDay()
	SleepStartTime.SetValue(StartingSleep)

    If PlayerRef.HasMagicEffect(AddictionSuppressantCheck) == True
       AddichroneOnPlayer = True    
 EndIf

EndEvent

Event OnPlayerSleepStop(bool abInterrupted, ObjectReference akBed)

	     Float HoursYouHaveSlept = (SleepStopTime.GetValue() - SleepStartTime.GetValue())/2.05
	     SleepTOTALTime.SetValue(HoursYouHaveSlept)
	     Float EndingSleep = GetCurrentHourOfDay()
	     SleepStopTime.SetValue(EndingSleep)
	
        If PlayerRef.HasPerk(SurvivalAdrenalineAftermath) == True
           PlayerRef.RemovePerk(SurvivalAdrenalineAftermath)
     EndIf
                       
		If SurvivalToggler.GetValue() == 1 
           NeedsAfterSleep()
           NeedsThresholdsChecks()
		   AddichroneOnPlayer = False
     EndIf
                
		If StartStarvival.GetValue() == 0
		   IntroductoryMessage()
     EndIf

EndEvent

Function NeedsAfterSleep()

	    Float HoursYouHaveSlept = (SleepStopTime.GetValue() - SleepStartTime.GetValue())/2.05
	    SleepTOTALTime.SetValue(HoursYouHaveSlept)
       
        Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
        Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst) 
        Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
        Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation) 

		Int HungerDamaged01 = (SleepTOTALTime.GetValue() as Int)*2
        Int HungerDamaged02 = (SleepTOTALTime.GetValue() as Int)*3
        Int HungerDamaged03 = (SleepTOTALTime.GetValue() as Int)*4
        Int HungerDamaged04 = (SleepTOTALTime.GetValue() as Int)*5
		   
             If FoodHungerCheck >= 90
	            PlayerRef.DamageValue(Hunger, HungerDamaged01)
         ElseIf FoodHungerCheck >= 70 && FoodHungerCheck < 90
	            PlayerRef.DamageValue(Hunger, HungerDamaged02)
         ElseIf FoodHungerCheck >= 40 && FoodHungerCheck < 70
                PlayerRef.DamageValue(Hunger, HungerDamaged03)
         ElseIf FoodHungerCheck < 40
                PlayerRef.DamageValue(Hunger, HungerDamaged04)
          EndIf
		
		Int ThirstDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int ThirstDamaged02 = (SleepTOTALTime.GetValue() as Int)*4
		Int ThirstDamaged03 = (SleepTOTALTime.GetValue() as Int)*5
		Int ThirstDamaged04 = (SleepTOTALTime.GetValue() as Int)*6
		
             If DrinkThirstCheck >= 90
	            PlayerRef.DamageValue(Thirst, ThirstDamaged01)
         ElseIf DrinkThirstCheck >= 70 && DrinkThirstCheck < 90
	            PlayerRef.DamageValue(Thirst, ThirstDamaged02)
         ElseIf DrinkThirstCheck >= 40 && DrinkThirstCheck < 70
                PlayerRef.DamageValue(Thirst, ThirstDamaged03)
         ElseIf DrinkThirstCheck < 40
                PlayerRef.DamageValue(Thirst, ThirstDamaged04)
          EndIf
		
		Int SleepDamaged = (SleepTOTALTime.GetValue() as Int)*3
     
	 If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && AddichroneOnPlayer == False
        PlayerRef.DamageValue(Sleep, SleepDamaged)
	 Else		
		
		Int SleepRestored01 = (SleepTOTALTime.GetValue() as Int)*6
		Int SleepRestored02 = (SleepTOTALTime.GetValue() as Int)*8
		Int SleepRestored03 = (SleepTOTALTime.GetValue() as Int)*10
		Int SleepRestored04 = (SleepTOTALTime.GetValue() as Int)*14
 
             If SleepFatigueCheck >= 90
	            PlayerRef.RestoreValue(Sleep, SleepRestored01)
         ElseIf SleepFatigueCheck >= 70 && SleepFatigueCheck < 90
	            PlayerRef.RestoreValue(Sleep, SleepRestored02)
         ElseIf SleepFatigueCheck >= 40 && SleepFatigueCheck < 70
                PlayerRef.RestoreValue(Sleep, SleepRestored03)
         ElseIf SleepFatigueCheck < 40
                PlayerRef.RestoreValue(Sleep, SleepRestored04)
          EndIf
	 EndIf

		 Int OversatiationDamaged = (SleepTOTALTime.GetValue() as Int)*20
             If OversatiationStarter.GetValue() == 1
	             PlayerRef.DamageValue(Oversatiation, OversatiationDamaged)
          EndIf

        If HoursYouHaveSlept >= 7
              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && AddichroneOnPlayer == False
		         ; Empty
           Else
		         PlayerRef.Additem(WellRestedToken, 1, True)
		         FatigueBlock = 0
				 BlockFatigueStopBonus.SetValue(0)
		   EndIf		   
	 EndIf
EndFunction

Function NeedsAfterWait()
       
	    Float HoursYouHaveSlept = (SleepStopTime.GetValue() - SleepStartTime.GetValue())/2.05
	    SleepTOTALTime.SetValue(HoursYouHaveSlept)
       
        Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
        Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst) 
        Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)

		Int HungerDamaged01 = (SleepTOTALTime.GetValue() as Int)*2
        Int HungerDamaged02 = (SleepTOTALTime.GetValue() as Int)*3
        Int HungerDamaged03 = (SleepTOTALTime.GetValue() as Int)*4
        Int HungerDamaged04 = (SleepTOTALTime.GetValue() as Int)*5
		   
             If FoodHungerCheck >= 90
	            PlayerRef.DamageValue(Hunger, HungerDamaged01)
         ElseIf FoodHungerCheck >= 70 && FoodHungerCheck < 90
	            PlayerRef.DamageValue(Hunger, HungerDamaged02)
         ElseIf FoodHungerCheck >= 40 && FoodHungerCheck < 70
                PlayerRef.DamageValue(Hunger, HungerDamaged03)
         ElseIf FoodHungerCheck < 40
                PlayerRef.DamageValue(Hunger, HungerDamaged04)
          EndIf
		
		Int ThirstDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int ThirstDamaged02 = (SleepTOTALTime.GetValue() as Int)*4
		Int ThirstDamaged03 = (SleepTOTALTime.GetValue() as Int)*5
		Int ThirstDamaged04 = (SleepTOTALTime.GetValue() as Int)*6
		
             If DrinkThirstCheck >= 90
	            PlayerRef.DamageValue(Thirst, ThirstDamaged01)
         ElseIf DrinkThirstCheck >= 70 && DrinkThirstCheck < 90
	            PlayerRef.DamageValue(Thirst, ThirstDamaged02)
         ElseIf DrinkThirstCheck >= 40 && DrinkThirstCheck < 70
                PlayerRef.DamageValue(Thirst, ThirstDamaged03)
         ElseIf DrinkThirstCheck < 40
                PlayerRef.DamageValue(Thirst, ThirstDamaged04)
          EndIf
		
		Int SleepDamaged01 = (SleepTOTALTime.GetValue() as Int)*3
		Int SleepDamaged02 = (SleepTOTALTime.GetValue() as Int)*5
		Int SleepDamaged03 = (SleepTOTALTime.GetValue() as Int)*7
		Int SleepDamaged04 = (SleepTOTALTime.GetValue() as Int)*9
 
             If SleepFatigueCheck >= 90
	            PlayerRef.DamageValue(Sleep, SleepDamaged01)
         ElseIf SleepFatigueCheck >= 70 && SleepFatigueCheck < 90
	            PlayerRef.DamageValue(Sleep, SleepDamaged02)
         ElseIf SleepFatigueCheck >= 40 && SleepFatigueCheck < 70
                PlayerRef.DamageValue(Sleep, SleepDamaged03)
         ElseIf SleepFatigueCheck < 40
                PlayerRef.DamageValue(Sleep, SleepDamaged04)
          EndIf

		 Int OversatiationDamaged = (SleepTOTALTime.GetValue() as Int)*20
             If OversatiationStarter.GetValue() == 1
	             PlayerRef.DamageValue(Oversatiation, OversatiationDamaged)
          EndIf

EndFunction

Function NeedsThresholdsChecksAfterJail()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
   		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation) 

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) < OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

      SatiationChecker()

EndFunction

Function NeedsThresholdsChecksTimered()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 
   		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation) 

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Oversatiation) < OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

      NeedsAfterEachCycleChecker()

EndFunction

Function NeedsThresholdsChecksOversatiation()

 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
   		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation) 

         If PlayerRef.GetValue(Oversatiation) < OversatiationLowestPoint
            PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
      EndIf

EndFunction

Function NeedsThresholdsAfterConsumption()

		 Float OversatiationPool = OversatiationMaxPointsBonus.GetValue()
		 Float IntoxicationPool = IntoxicationMaxPointsBonus.GetValue()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep) 

		 Float HungerPointsPoolBonus = HungerMaxPointsBonus.GetValue()
		 Float ThirstPointsPoolBonus = ThirstMaxPointsBonus.GetValue()
		 Float SleepPointsPoolBonus = SleepMaxPointsBonus.GetValue()

 		 Float IntoxicationLowestPoint = IntoxicationLowestPoints.GetValue()
 		 Float IntoxicationThreshold = - PlayerRef.GetValue(Intoxication)

         If PlayerRef.GetValue(Hunger) < HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) < ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) < SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

         If PlayerRef.GetValue(Intoxication) < IntoxicationLowestPoint
            PlayerRef.RestoreValue(Intoxication, IntoxicationThreshold)
      EndIf

      NeedsAfterConsumptionStatus()

EndFunction

Function NeedsThresholdsChecks()

 		 Float HungerLowestPoint = HungerLowestPoints.GetValue()
 		 Float ThirstLowestPoint = ThirstLowestPoints.GetValue()
 		 Float SleepLowestPoint = SleepLowestPoints.GetValue()
   		 Float ThirstThreshold = - PlayerRef.GetValue(Thirst)     
   		 Float HungerThreshold = - PlayerRef.GetValue(Hunger)  
   		 Float SleepThreshold = - PlayerRef.GetValue(Sleep)
 		 Float OversatiationLowestPoint = OversatiationLowestPoints.GetValue()
 		 Float OversatiationThreshold = - PlayerRef.GetValue(Oversatiation)
 		 Float IntoxicationLowestPoint = IntoxicationLowestPoints.GetValue()
 		 Float IntoxicationThreshold = - PlayerRef.GetValue(Intoxication)

         If PlayerRef.GetValue(Hunger) <= HungerLowestPoint
            PlayerRef.RestoreValue(Hunger, HungerThreshold)
      EndIf

         If PlayerRef.GetValue(Thirst) <= ThirstLowestPoint
            PlayerRef.RestoreValue(Thirst, ThirstThreshold)
      EndIf

         If PlayerRef.GetValue(Sleep) <= SleepLowestPoint
            PlayerRef.RestoreValue(Sleep, SleepThreshold)
      EndIf

		 If OversatiationStarter.GetValue() == 1
                     If PlayerRef.GetValue(Oversatiation) <= OversatiationLowestPoint
                        PlayerRef.RestoreValue(Oversatiation, OversatiationThreshold)
				  EndIf
      EndIf

		 If IntoxicationStarter.GetValue() == 1
                     If PlayerRef.GetValue(Intoxication) < IntoxicationLowestPoint
                        PlayerRef.RestoreValue(Intoxication, IntoxicationThreshold)
                  EndIf
      EndIf

      NeedsAfterEachCycleChecker()

EndFunction

Function NeedsAfterConsumptionStatus()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)

        If NeedsCheckerAfterConsumptionNotifier.GetValue() == 1
           NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)	
     EndIf

EndFunction

Function NeedsAfterEachCycleChecker()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)
           Float IntoxicationMaxLevel = IntoxicationMaxPoints.GetValue()

   If NeedsCheckerNotificationType.GetValue() == 1 || NeedsCheckerNotificationType.GetValue() == 2

         If NeedsCheckerImmersiveMode.GetValue() == 0
            Utility.Wait(0.1)
            NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)	
     Else
            NeedsImmersiveStatusMessaging()
      EndIf
EndIf

EndFunction

Function NeedsStatusOnDebuff()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)
           Float IntoxicationMaxLevel = IntoxicationMaxPoints.GetValue()

           Utility.Wait(0.1)
           NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)	

EndFunction

Function NeedsImmersiveStatusMessaging()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)
           Float IntoxicationMaxLevel = IntoxicationMaxPoints.GetValue()

             If DrinkThirstCheck > 50 && DrinkThirstCheck <= 75
                Utility.Wait(0.1)
                MSGThirstParched.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
         ElseIf DrinkThirstCheck > 35 && DrinkThirstCheck <= 50
                Utility.Wait(0.1)
                MSGThirstMildlyDehydrated.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)	
         ElseIf DrinkThirstCheck > 20 && DrinkThirstCheck <= 35
                Utility.Wait(0.1)
                MSGThirstDehydrated.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
         ElseIf DrinkThirstCheck <= 20
                Utility.Wait(0.1)
                MSGThirstSeverelyDehydrated.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
          EndIf

             If FoodHungerCheck > 50 && FoodHungerCheck <= 75
                Utility.Wait(0.1)
                MSGHungerPeckish.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
         ElseIf FoodHungerCheck > 35 && FoodHungerCheck <= 50
                Utility.Wait(0.1)
                MSGHungerFamished.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)	
         ElseIf FoodHungerCheck > 20 && FoodHungerCheck <= 35
                Utility.Wait(0.1)
                MSGHungerRavenous.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
         ElseIf FoodHungerCheck <= 20
                Utility.Wait(0.1)
                MSGHungerStarving.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
          EndIf

             If SleepFatigueCheck > 50 && SleepFatigueCheck <= 75
                Utility.Wait(0.1)
                MSGSleepTired.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
         ElseIf SleepFatigueCheck > 35 && SleepFatigueCheck <= 50
                Utility.Wait(0.1)
                MSGSleepWeary.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)	
         ElseIf SleepFatigueCheck > 20 && SleepFatigueCheck <= 35
                Utility.Wait(0.1)
                MSGSleepExhausted.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
         ElseIf SleepFatigueCheck <= 20
                Utility.Wait(0.1)
                MSGSleepIncapacitated.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
          EndIf

EndFunction

Event OnTimer(int aiTimerID)
	 
	  	     Float HungerDamage = HungerDMGPoints.GetValue()
 			 Float SleepDamage = SleepDMGPoints.GetValue()
 			 Float ThirstDamage = ThirstDMGPoints.GetValue()
 			 Float OversatiationDamage = OversatiationDMGPoints.GetValue()
	         Float HungerStart = HungerTime.GetValue()
             Float SleepStart = SleepTime.GetValue()
             Float ThirstStart = ThirstTime.GetValue()
             Float OversatiationStart = OversatiationTime.GetValue()
	 
             Float BlackoutTimer = BlackoutDuration.GetValue()
             Float Timer = AdrenalineTimer.GetValue()

             Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
 
     	     If (aiTimerID == 0)       

                   If PlayerRef.GetValue(Sleep) > 35
                      CancelTimer(0)
                Else
				      PlayerRef.EquipItem(Blackout, 1, True)
                      StartTimer(BlackoutTimer, 0)
				EndIf

      	 ElseIf (aiTimerID == 1)       

                   If PlayerRef.GetItemCount(AdrenalineToken) >= 1 
                      PlayerRef.RemoveItem(AdrenalineToken, 1, True, None)
                      StartTimer(Timer, 1)
                      AdrenalineStatusChecker()
                EndIf

      	 ElseIf (aiTimerID == 2)       

                PlayerRef.DamageValue(Hunger, HungerDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(HungerStart, 2)

      	 ElseIf (aiTimerID == 3)       

                PlayerRef.DamageValue(Sleep, SleepDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(SleepStart, 3)

      	 ElseIf (aiTimerID == 4)       

                PlayerRef.DamageValue(Thirst, ThirstDamage)
                NeedsThresholdsChecksTimered()
                StartTimer(ThirstStart, 4)

      	 ElseIf (aiTimerID == 40)       

			     If OversatiationStarter.GetValue() == 1
						 If OversatiationCheck <= 0
                            NeedsThresholdsChecksOversatiation()
                            CancelTimer(40)
                     Else
							PlayerRef.DamageValue(Oversatiation, OversatiationDamage)
                            NeedsThresholdsChecksOversatiation()
                            StartTimer(OversatiationStart, 40)
                      EndIf
              EndIf

      	 ElseIf (aiTimerID == 34)       
                
				PlayerRef.EquipItem(AddPotionCureJunkFlush, 1, True)
      	 
		 ElseIf (aiTimerID == 35)       

                Float ToxicityCheck = PlayerRef.Getvalue(Intoxication)
                Float Duration = AddichroneTimeRestoration.GetValue()
                Float Restore = AddichroneRestoration.GetValue()

                If IntoxicationStarter.GetValue() == 1
                       If ToxicityCheck <= 0
                          NeedsThresholdsAfterConsumption()
                          CancelTimer(35)
				   Else
					      PlayerRef.damagevalue(Intoxication, Restore)
			              StartTimer(Duration, 35)
                    EndIf
			 EndIf

      	 ElseIf (aiTimerID == 36)                 
				IntroductoryMessage()
	            AddBook()      
		  EndIf
	  
EndEvent

Function Adrenaline()

                Float Max = AdrenalineMax.GetValue()
                Float Timer = AdrenalineTimer.GetValue()

                PlayerRef.Additem(AdrenalineToken, 1, True)
                   If PlayerRef.GetItemCount(AdrenalineToken) >= Max
                      PlayerRef.AddPerk(SurvivalAdrenalineBuff, False)
                      PlayerRef.RemoveItem(AdrenalineToken, 9999, True, None)
			    EndIf
                AdrenalineStatusChecker()
                StartTimer(Timer, 1)
EndFunction

Function AdrenalineStatusChecker()

           Float Max = AdrenalineMax.GetValue()
           Float Count = PlayerRef.GetItemCount(AdrenalineToken)

        If AdrenalineCountNotifier.GetValue() == 1
           Utility.Wait(0.1)
           AdrenalineCount.show(Count, Max, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
     EndIf

EndFunction

Function Blackout()
         StartTimer(0, 0)
EndFunction

Function SatiationChecker()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)

           Utility.Wait(0.1)
           NeedsAllChecker.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)

EndFunction

Function SatiationCheckerBox()

           Float DrinkThirstCheck = PlayerRef.Getvalue(Thirst)
           Float ThirstMaxLevel = ThirstMaxPoints.GetValue()	       
           Float FoodHungerCheck = PlayerRef.Getvalue(Hunger)
           Float HungerMaxLevel = HungerMaxPoints.GetValue()
           Float SleepFatigueCheck = PlayerRef.Getvalue(Sleep)
           Float SleepMaxLevel = SleepMaxPoints.GetValue()
           Float OversatiationCheck = PlayerRef.Getvalue(Oversatiation)
           Float OversatiationMaxLevel = OversatiationMaxPoints.GetValue()
           Float IntoxicationCheck = PlayerRef.Getvalue(Intoxication)

           Utility.Wait(0.1)
           NeedsAllCheckerBox.show(FoodHungerCheck, HungerMaxLevel, DrinkThirstCheck, ThirstMaxLevel, SleepFatigueCheck, SleepMaxLevel, OversatiationCheck, OversatiationMaxLevel, IntoxicationCheck)	
           PlayerRef.Additem(SatiationChecker, 1, True)

EndFunction

Function AddictionCure()

        Float CureTimerJunkFlush = AddictionCureTimerJunkFlush.Getvalue()

        If PlayerRef.HasMagicEffect(AddictionCureJunkFlush) == True         
	       StartTimer(CureTimerJunkFlush, 34)	 
	 EndIf	

EndFunction

Event Actor.OnItemEquipped(Actor akSender, Form akBaseObject, ObjectReference akReference)

		   Float FoodLow = FoodPointsLow.GetValue()
		   Float FoodLowPoison = FoodPointsLow.GetValue() / 3
		   Float FoodLowWithPerk = FoodPointsLow.GetValue() * 2
		   Float FoodLowWithPerkPoison = FoodPointsLow.GetValue() * 2 / 3
		   Float FoodMedium = FoodPointsMedium.GetValue()
		   Float FoodMediumPoison = FoodPointsMedium.GetValue() / 3
		   Float FoodMediumWithPerk = FoodPointsMedium.GetValue() * 2
		   Float FoodMediumWithPerkPoison = FoodPointsMedium.GetValue() * 2 / 3
		   Float FoodHigh = FoodPointsHigh.GetValue()
		   Float FoodHighPoison = FoodPointsHigh.GetValue() / 3
		   Float FoodHighWithPerk = FoodPointsHigh.GetValue() * 2
		   Float FoodHighWithPerkPoison = FoodPointsHigh.GetValue() * 2 / 3
 		   Float FoodLegendary = FoodPointsLegendary.GetValue()
 		   Float FoodLegendaryPoison = FoodPointsLegendary.GetValue() / 3
 		   Float FoodLegendaryWithPerk = FoodPointsLegendary.GetValue() * 2
 		   Float FoodLegendaryWithPerkPoison = FoodPointsLegendary.GetValue() * 2 / 3

		   Float OversatiationLow = FoodPointsLowOversatiation.GetValue()
		   Float OversatiationLowWithPerk = FoodPointsLowOversatiation.GetValue() / 2
		   Float OversatiationMedium = FoodPointsMediumOversatiation.GetValue()
		   Float OversatiationMediumWithPerk = FoodPointsMediumOversatiation.GetValue() / 2
		   Float OversatiationHigh = FoodPointsHighOversatiation.GetValue()
		   Float OversatiationHighWithPerk = FoodPointsHighOversatiation.GetValue() / 2
 		   Float OversatiationLegendary = FoodPointsLegendaryOversatiation.GetValue()
 		   Float OversatiationLegendaryWithPerk = FoodPointsLegendaryOversatiation.GetValue() / 2
           Float OversatiationStart = OversatiationTime.GetValue()          
		   Float OversatiationLowDrinks = FoodPointsLowOversatiationDrinks.GetValue()
		   Float OversatiationLowWithPerkDrinks = FoodPointsLowOversatiationDrinks.GetValue() / 2
		   Float OversatiationMediumDrinks = FoodPointsMediumOversatiationDrinks.GetValue()
		   Float OversatiationMediumWithPerkDrinks = FoodPointsMediumOversatiationDrinks.GetValue() / 2
		   Float OversatiationHighDrinks = FoodPointsHighOversatiationDrinks.GetValue()
		   Float OversatiationHighWithPerkDrinks = FoodPointsHighOversatiationDrinks.GetValue() / 2

		   Float DrinkLow = DrinkPointsLow.GetValue()
		   Float DrinkLowWithPerk = DrinkPointsLow.GetValue() * 2
		   Float DrinkMedium = DrinkPointsMedium.GetValue()
		   Float DrinkMediumWithPerk = DrinkPointsMedium.GetValue() * 2
		   Float DrinkHigh = DrinkPointsHigh.GetValue()
		   Float DrinkHighWithPerk = DrinkPointsHigh.GetValue() * 2
		   Float DrinkSpecial = DrinkPointsSpecial.GetValue()
		   Float DrinkSpecialWithPerk = DrinkPointsSpecial.GetValue() * 2
		   Float DrinkSpecialEnergy = DrinkPointsSpecialEnergy.GetValue()
           Float DrinkSpecialEnergyAddict = DrinkPointsSpecialEnergy.GetValue() / 6
		   Float DrinkSpecialEnergyWithPerk = DrinkPointsSpecialEnergy.GetValue() * 2
		   Float DrinkSpecialEnergyWithPerkAddict = DrinkPointsSpecialEnergy.GetValue() * 2 / 6

		   Float DrinkAlcLow = DrinkAlcPointsLow.GetValue()
		   Float DrinkAlcLowWithPerk = DrinkAlcPointsLow.GetValue() / 2
		   Float DrinkAlcHigh = DrinkAlcPointsHigh.GetValue()
		   Float DrinkAlcHighWithPerk = DrinkAlcPointsHigh.GetValue() / 2
		   Float DrinkAlcSpecialThirst = DrinkAlcPointsSpecialThirst.GetValue()
		   Float DrinkAlcSpecialThirstWithPerk = DrinkAlcPointsSpecialThirst.GetValue() / 2
		   Float DrinkAlcSpecialFatigue = DrinkAlcPointsSpecialFatigue.GetValue()
		   Float DrinkAlcSpecialFatigueAddict = DrinkAlcPointsSpecialFatigue.GetValue() / 6
		   Float DrinkAlcSpecialFatigueWithPerk = DrinkAlcPointsSpecialFatigue.GetValue() * 2
		   Float DrinkAlcSpecialFatigueWithPerkAddict = DrinkAlcPointsSpecialFatigue.GetValue() * 2 / 6

		   Float ChemsLow = ChemsPointsLow.GetValue()
		   Float ChemsMedium = ChemsPointsMedium.GetValue()
		   Float ChemsHigh = ChemsPointsHigh.GetValue()

		   Float Zero = 0

	If IntoxicationStarter.GetValue() == 1
       If PlayerRef.HasMagicEffect(AddichroneSuppression) == False
                        If AddictionItems_AlcoholismTrigger.Find(akBaseObject) != -1
                             If AddictionToggleAlcoholism.GetValue() == 1
							    IntoxicationPoints(PotionAddictionAlcoholism)
                          EndIf
                    ElseIf AddictionItems_CaffeinophagiaTrigger.Find(akBaseObject) != -1
                             If AddictionToggleCaffeinophagia.GetValue() == 1
                                IntoxicationPoints(PotionAddictionCaffeinophagia)
                                PlayerRef.RestoreValue(Intoxication, 5)
						  EndIf
                    ElseIf AddictionItems_CognitiveDissolutionTrigger.Find(akBaseObject) != -1
                             If AddictionToggleCognitiveDissolution.GetValue() == 1
                                IntoxicationPoints(PotionAddictionCognitiveDissolution)
                          EndIf
                    ElseIf AddictionItems_HeartAttackTrigger.Find(akBaseObject) != -1
                             If AddictionToggleHeartAttack.GetValue() == 1
                                IntoxicationPoints(PotionAddictionHeartAttack)
                          EndIf
                    ElseIf AddictionItems_ParanoidTreatmentTrigger.Find(akBaseObject) != -1
                             If AddictionToggleParanoidTreatment.GetValue() == 1
                                IntoxicationPoints(PotionAddictionParanoidTreatment)
                          EndIf
                    ElseIf AddictionItems_StimulantsAddictionTrigger.Find(akBaseObject) != -1
                             If AddictionToggleStimulants.GetValue() == 1
                                IntoxicationPoints(PotionAddictionStimulantsAddiction)
                          EndIf
                     EndIf
    EndIf
EndIf

    If SurvivalToggler.GetValue() == 1 
		   If FoodItems_LowGrade.Find(akBaseObject) != -1		 				 
              FoodPoints(FoodLow, FoodLowPoison, FoodLowWithPerk, FoodLowWithPerkPoison)
              OversatiationPoints(OversatiationLow, OversatiationLowWithPerk)	   
	   ElseIf FoodItems_MediumGrade.Find(akBaseObject) != -1	
              FoodPoints(FoodMedium, FoodMediumPoison, FoodMediumWithPerk, FoodMediumWithPerkPoison) 
              OversatiationPoints(OversatiationMedium, OversatiationMediumWithPerk)	   
	   ElseIf FoodItems_HighGrade.Find(akBaseObject) != -1
              FoodPoints(FoodHigh, FoodHighPoison, FoodHighWithPerk, FoodHighWithPerkPoison)
              OversatiationPoints(OversatiationHigh, OversatiationHighWithPerk)	   
	   ElseIf FoodItems_LegendaryGrade.Find(akBaseObject) != -1
              FoodPoints(FoodLegendary, FoodLegendaryPoison, FoodLegendaryWithPerk, FoodLegendaryWithPerkPoison)
              OversatiationPoints(OversatiationLegendary, OversatiationLegendaryWithPerk)	   
	   ElseIf DrinkItems_LowGrade.Find(akBaseObject) != -1
              DrinkPoints(DrinkLow, DrinkLowWithPerk, Zero, Zero, Zero, Zero)				 			 
              OversatiationPoints(OversatiationLowDrinks, OversatiationLowWithPerkDrinks)	   
	   ElseIf DrinkItems_MediumGrade.Find(akBaseObject) != -1
              DrinkPoints(DrinkMedium, DrinkMediumWithPerk, Zero, Zero, Zero, Zero)	
              OversatiationPoints(OversatiationMediumDrinks, OversatiationMediumWithPerkDrinks)	   
	   ElseIf DrinkItems_HighGrade.Find(akBaseObject) != -1
              DrinkPoints(DrinkHigh, DrinkHighWithPerk, Zero, Zero, Zero, Zero)	
              OversatiationPoints(OversatiationHighDrinks, OversatiationHighWithPerkDrinks)	   
	   ElseIf DrinkItems_EnergyGrade.Find(akBaseObject) != -1
              DrinkPoints(DrinkSpecial, DrinkSpecialWithPerk, DrinkSpecialEnergy, DrinkSpecialEnergyAddict, DrinkSpecialEnergyWithPerk, DrinkSpecialEnergyWithPerkAddict)				 					 
              OversatiationPoints(OversatiationHighDrinks, OversatiationHighWithPerkDrinks)	   
              BlockFatigue()
	   ElseIf ComboItems_LowGrade.Find(akBaseObject) != -1
              FoodPoints(FoodLow, FoodLowPoison, FoodLowWithPerk, FoodLowWithPerkPoison)
			  DrinkPoints(DrinkLow, DrinkLowWithPerk, Zero, Zero, Zero, Zero)	
              OversatiationPoints(OversatiationLow, OversatiationLowWithPerk)	   
	   ElseIf ComboItems_MediumGrade.Find(akBaseObject) != -1
              FoodPoints(FoodMedium, FoodMediumPoison, FoodMediumWithPerk, FoodMediumWithPerkPoison) 	
              DrinkPoints(DrinkLow, DrinkLowWithPerk, Zero, Zero, Zero, Zero)
              OversatiationPoints(OversatiationMedium, OversatiationMediumWithPerk)	   	   
	   ElseIf ComboItems_HighGrade.Find(akBaseObject) != -1
              FoodPoints(FoodHigh, FoodHighPoison, FoodHighWithPerk, FoodHighWithPerkPoison)
              DrinkPoints(DrinkMedium, DrinkMediumWithPerk, Zero, Zero, Zero, Zero)
              OversatiationPoints(OversatiationHigh, OversatiationHighWithPerk)		   	   
	   ElseIf AlcoholItems_LowGrade.Find(akBaseObject) != -1
              AlcoholPoints(DrinkAlcLow, DrinkAlcLowWithPerk, DrinkAlcLow, DrinkAlcLowWithPerk, Zero, Zero, Zero, Zero)
	   ElseIf AlcoholItems_HighGrade.Find(akBaseObject) != -1
              AlcoholPoints(DrinkAlcHigh, DrinkAlcHighWithPerk, DrinkAlcHigh, DrinkAlcHighWithPerk, Zero, Zero, Zero, Zero)
	   ElseIf AlcoholItems_EnergyGrade.Find(akBaseObject) != -1
              AlcoholPoints(DrinkAlcSpecialThirst, DrinkAlcSpecialThirstWithPerk, Zero, Zero, DrinkAlcSpecialFatigue, DrinkAlcSpecialFatigueAddict, DrinkAlcSpecialFatigueWithPerk, DrinkAlcSpecialFatigueWithPerkAddict)
              BlockFatigue()
	   ElseIf ChemItems_LowGrade.Find(akBaseObject) != -1
              ChemPoints(ChemsLow)
	   ElseIf ChemItems_MediumGrade.Find(akBaseObject) != -1
              ChemPoints(ChemsMedium)
	   ElseIf ChemItems_HighGrade.Find(akBaseObject) != -1
              ChemPoints(ChemsHigh)        		
	    EndIf

           If akBaseObject.HasKeyword(FoodDrinks) || akBaseObject.HasKeyword(Chems) || akBaseObject.HasKeyword(ChemsVendor)
              NeedsThresholdsAfterConsumption()
        EndIf
 EndIf
EndEvent

Function BlockFatigue()

                    If FatigueBlock < 3
	                   FatigueBlock += 1
					      If FatigueBlock >= 3
                             BlockFatigueStopBonus.SetValue(1)
                       EndIf
	             EndIf

EndFunction

Function FoodPoints(Float RestoreAmount, Float RestoreAmountPoisoned, Float RestoreAmountPerk, Float RestoreAmountPerkPoisoned)
                        
						Float OversatiationStart = OversatiationTime.GetValue()
					    
						If PlayerRef.Hasperk(Nutrition) == True
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
						         PlayerRef.RestoreValue(Hunger, RestoreAmountPerkPoisoned)
                          Else
						         PlayerRef.RestoreValue(Hunger, RestoreAmountPerk)
                           EndIf
					Else
					          If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == True
					             PlayerRef.RestoreValue(Hunger, RestoreAmountPoisoned)
                          Else
								 PlayerRef.RestoreValue(Hunger, RestoreAmount)
                           EndIf
			         EndIf

                        If FoodPoisoningToggle.GetValue() == 1
                                            If PlayerRef.HasMagicEffect(FoodPoisoningDebuff) == False
                                                  int Chance = Utility.RandomInt(1, 100)
                                                  Int MaxChance = FoodPoisoningChance.GetValue()as Int
                                                  If Chance <= MaxChance
                                                     PlayerRef.EquipItem(PotionAddictionFoodPoisoning, 1, True)
                                               EndIf
                                         EndIf
                     EndIf

EndFunction

Function DrinkPoints(Float RestoreAmount, Float RestoreAmountPerk, Float SleepRestoreAmount, Float SleepRestoreAmountAddict, Float SleepRestoreAmountPerk, Float SleepRestoreAmountAddictPerk)
                        
						Float OversatiationStart = OversatiationTime.GetValue()
					    
						If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.RestoreValue(Thirst, RestoreAmountPerk)

					              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && PlayerRef.HasMagicEffect(AddichroneSuppression) == False
									 PlayerRef.RestoreValue(Sleep, SleepRestoreAmountAddictPerk)
							  Else
									 PlayerRef.RestoreValue(Sleep, SleepRestoreAmountPerk)
							   EndIf                                  
                    Else
					       PlayerRef.RestoreValue(Thirst, RestoreAmount)
                           If BlockFatigueStopBonus.Getvalue() == 0
					              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && PlayerRef.HasMagicEffect(AddichroneSuppression) == False
                                     PlayerRef.RestoreValue(Sleep, SleepRestoreAmountAddict)
	                          Else
						             PlayerRef.RestoreValue(Sleep, SleepRestoreAmount)
							   EndIf
			            EndIf
					 EndIf
EndFunction

Function AlcoholPoints(Float ThirstDamageAmount, Float ThirstDamageAmountPerk, Float SleepDamage, Float SleepDamagePerk, Float SleepRestore, Float SleepRestoreAddict, Float SleepRestorePerk, Float SleepRestorePerkAddict)
                        
					    If PlayerRef.Hasperk(Nutrition) == True
					       PlayerRef.DamageValue(Thirst, ThirstDamageAmountPerk)				 
					       PlayerRef.DamageValue(Sleep, SleepDamagePerk)

					              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && PlayerRef.HasMagicEffect(AddichroneSuppression) == False
									 PlayerRef.RestoreValue(Sleep, SleepRestorePerkAddict)
							  Else
									 PlayerRef.RestoreValue(Sleep, SleepRestorePerk)
							   EndIf	
                    Else
					       PlayerRef.DamageValue(Thirst, ThirstDamageAmount)				 
					       PlayerRef.DamageValue(Sleep, SleepDamage)
                           If BlockFatigueStopBonus.Getvalue() == 0
					              If PlayerRef.HasMagicEffect(CaffeinophagiaCheck) == True && PlayerRef.HasMagicEffect(AddichroneSuppression) == False
                                     PlayerRef.RestoreValue(Sleep, SleepRestoreAddict)
							  Else
						             PlayerRef.RestoreValue(Sleep, SleepRestore)
                               EndIf
			            EndIf
					 EndIf
EndFunction

Function ChemPoints(Float DamageAmount)                        
		 PlayerRef.DamageValue(Thirst, DamageAmount)			 
		 PlayerRef.DamageValue(Hunger, DamageAmount)
		 PlayerRef.DamageValue(Sleep, DamageAmount)
EndFunction

Function OversatiationPoints(Float DamageAmount, Float DamageAmountPerk)
                        
						Float OversatiationStart = OversatiationTime.GetValue()
					    
					    If OversatiationStarter.GetValue() == 1
					              If PlayerRef.Hasperk(Nutrition) == True
						             PlayerRef.RestoreValue(Oversatiation, DamageAmountPerk)
                              Else
			                         PlayerRef.RestoreValue(Oversatiation, DamageAmount)
			                   EndIf

                               If PlayerRef.HasPerk(OversatiationDebuff) == False
                                  PlayerRef.Addperk(OversatiationDebuff, False)
                            EndIf
                            StartTimer(OversatiationStart, 40)
                     EndIf

EndFunction

Function IntoxicationPoints(Potion Addiction)
			           
			      Int Chance = Utility.RandomInt(1, 100)
                  Int MinDMG = (IntoxicationMinDMG.GetValue()as Int)	
                  Int MaxDMG = (IntoxicationMaxDMG.GetValue()as Int)
                  Int MinDMGWithPerk = (IntoxicationMinDMG.GetValue()as Int / 2)	
                  Int MaxDMGWithPerk = (IntoxicationMaxDMG.GetValue()as Int / 2)
                  Int RandomDMG = Utility.RandomInt(MinDMG, MaxDMG)
                  Int RandomDMGWithPerk = Utility.RandomInt(MinDMGWithPerk, MaxDMGWithPerk)

				  If PlayerRef.Hasperk(PainTolerance) == True
					 PlayerRef.RestoreValue(Intoxication, RandomDMGWithPerk)
             Else
			         PlayerRef.RestoreValue(Intoxication, RandomDMG)
			   EndIf

                  If PlayerRef.HasSpell(IntoxicationWarning) == False
			         PlayerRef.EquipItem(PotionAddictionWarning, 1, True)
               EndIf

			     If PlayerRef.Getvalue(Intoxication) >= 80
                       If Chance >= 75
             		      PlayerRef.EquipItem(Addiction, 1, True)
             	    EndIf
              EndIf

EndFunction

Function AddichroneRestoration()
         StartTimer(0, 35)
EndFunction

Function AddichroneRestorationCancel()
         CancelTimer(35)
EndFunction

Function FatigueTimerStart()
         Float SleepStart = SleepTime.GetValue()         
		 StartTimer(SleepStart, 3)
EndFunction

Function FatigueTimerCancel()
         CancelTimer(3)
EndFunction

Function IntoxicationRestore()

        Float Restore = PlayerRef.GetValue(Intoxication)
        If PlayerRef.Getvalue(Intoxication) > 0
           PlayerRef.Damagevalue(Intoxication, Restore)
     EndIf

EndFunction