ScriptName SISA_Overencumbrance extends ActiveMagicEffect

Spell Property SpellToCast const auto mandatory
Float Property CastTimerInterval = 45.0 const auto

bool Property DisableSprinting const auto
bool Property DisableRunning const auto

InputEnableLayer inputLayer

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)

    StartTimer(CastTimerInterval, 0)

	inputLayer = InputEnableLayer.Create()

	if DisableRunning
		inputLayer.EnableRunning(false)
	elseif DisableSprinting
		inputLayer.EnableSprinting(false)
	endif

EndEvent

Event OnEffectFinish(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
	inputLayer.EnableRunning(true)
	inputLayer.EnableSprinting(true)
    CancelTimer(0)
EndEvent

Function CastSpellAndStartTimer()

	      If IsBoundGameObjectAvailable()
		     actor actorRef = GetTargetActor()
		     SpellToCast.cast(actorRef, actorRef)	
		     StartTimer(CastTimerInterval, 0)
	   EndIf

EndFunction

Event OnTimer(int aiTimerID)

      	 If (aiTimerID == 0) 
	        CastSpellAndStartTimer()
      EndIf

EndEvent