ScriptName Starvegas_Killcam extends Quest

String Property Root = "COM" Auto conditional
String Property CameraTarget = "CameraTarget" Auto conditional
String Property Tracker = "Tracker" Auto conditional

Quest Property RestartTranslation Auto Const
Quest Property MQ101 Auto Const

Actor Property PlayerRef Auto Const
ActorBase Property StarvegasKillcam_Camera Auto

ActorValue Property StarvegasKillcam_AV_SlowmotionSpeed Auto Const
ActorValue Property StarvegasKillcam_AV_SlowmotionDur Auto Const
ActorValue Property StarvegasKillcam_AV_AnimationSpeed Auto Const

Action Property StarvegasKillcam_ActionSightedRelease Auto

Spell Property StarvegasKillcam_SlowmoEffect Auto
Spell Property StarvegasKillcam_SlowmoEffect_Spaceship Auto

Perk Property StarvegasKillcam_SlowmotionMode_Always Auto Const
Perk Property StarvegasKillcam_SlowmotionMode_Combat Auto Const
Perk Property StarvegasKillcam_SlowmotionMode_LastHostile Auto Const
Perk Property StarvegasKillcam_SlowmotionMode_Oneshot Auto Const
Perk Property StarvegasKillcam_SlowmotionMode_OneshotLastHostile Auto Const
Perk Property StarvegasKillcam_SlowmoPower Auto Const
Perk Property StarvegasKillcam_SmartPerspective Auto Const

Message Property MSG_StarvegasConfBookMain Auto Const
Message Property MSG_StarvegasConfBookMainCooldown Auto Const
Message Property MSG_StarvegasConfBookMainProperties Auto Const
Message Property MSG_StarvegasConfBookMainDebug Auto Const
Message Property MSG_StarvegasConfBookMainModes Auto Const
Message Property MSG_StarvegasConfBookMainEnabledRaces Auto Const
Message Property MSG_StarvegasConfBookMainTriggerChance Auto Const
Message Property MSG_StarvegasConfBookMainSpecialFX Auto Const
Message Property MSG_StarvegasConfBookMainCamera Auto Const
Message Property MSG_StarvegasConfBookMainCameraPlayer Auto Const
Message Property MSG_StarvegasConfBookMainCameraKillcam Auto Const
Message Property MSG_StarvegasConfBookMainCameraKillcamFOV Auto Const
Message Property MSG_StarvegasConfBookMainCameraKillcamFOVBasic Auto Const
Message Property MSG_StarvegasConfBookMainCameraKillcamFOVCinematic Auto Const
Message Property MSG_StarvegasConfBookMainCameraKillcamDistance Auto Const
Message Property MSG_StarvegasConfBookNotificationReset Auto Const
Message Property MSG_StarvegasConfBookNotificationUninstall Auto Const
Message Property MSG_Starvegas_UpdateMessage Auto Const

GlobalVariable Property StarvegasKillcam_SlowmoChanceLastHostile Auto Const
GlobalVariable Property StarvegasKillcam_SlowmoChanceLastHostileOneshot Auto Const
GlobalVariable Property StarvegasKillcam_SlowmoChanceOneshot Auto Const
GlobalVariable Property StarvegasKillcam_SlowmoChanceCombat Auto Const
GlobalVariable Property StarvegasKillcam_SlowmoChanceAlways Auto Const
GlobalVariable Property StarvegasKillcam_Modes Auto Const
GlobalVariable Property StarvegasKillcam_CinematicChance Auto Const
GlobalVariable Property StarvegasKillcam_PlayerVsTargetChance Auto Const
GlobalVariable Property StarvegasKillcam_IMADs_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_IMADs_SS_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_SoundsFX_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_RecoilFX_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_MusicMute_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_UI_Toggle Auto Const
GlobalVariable Property StarvegasKillcam_Invincibility_Toggle Auto Const

GlobalVariable Property StarvegasKillcam_KillcamInAction Auto Const

GlobalVariable Property StarvegasKillcam_ActiveRaceHuman Auto Const
GlobalVariable Property StarvegasKillcam_ActiveRaceCreature Auto Const
GlobalVariable Property StarvegasKillcam_ActiveRaceRobot Auto Const
GlobalVariable Property StarvegasKillcam_ActiveRaceSpaceship Auto Const

GlobalVariable Property StarvegasKillcam_IsInScope Auto Const

FormList Property StarvegasKillcam_HumanRaces Auto Const
FormList Property StarvegasKillcam_RobotRaces Auto Const
FormList Property StarvegasKillcam_CreatureRaces Auto Const
FormList Property StarvegasKillcam_SpaceshipRaces Auto Const

Static Property StarvegasKillcam_CameraMarker Auto

Keyword Property ExclusionCutter Auto Const

float Property Cooldown = 15.0 Auto

float Property CinematicCameraVeryNearFOV = 70.0 Auto
float Property CinematicCameraShortFOV = 80.0 Auto
float Property CinematicCameraMediumFOV = 60.0 Auto
float Property CinematicCameraLongFOV = 40.0 Auto

float Property CinematicCameraFirstPersonMinFOV = 65.0 Auto
float Property CinematicCameraFirstPersonMaxFOV = 120.0 Auto
float Property CinematicCameraFirstPersonGeometryMinFOV = 65.0 Auto
float Property CinematicCameraFirstPersonGeometryMaxFOV = 120.0 Auto
float Property CinematicCameraThirdPersonFOV = 65.0 Auto

float Property BasicCameraFirstPersonFOV5 = 70.0 Auto
float Property BasicCameraFirstPersonGeometryFOV5 = 70.0 Auto
float Property BasicCameraThirdPersonFOV5 = 60.0 Auto

float Property BasicCameraFirstPersonFOV25 = 60.0 Auto
float Property BasicCameraFirstPersonGeometryFOV25 = 60.0 Auto
float Property BasicCameraThirdPersonFOV25 = 50.0 Auto

float Property DefaultCameraFirstPersonFOV = 94.0 Auto
float Property DefaultCameraFirstPersonGeometryFOV = 94.0 Auto
float Property DefaultCameraThirdPersonFOV = 94.0 Auto

float Property CinematicCameraTriggerDistanceMelee = 0.0 Auto
float Property CinematicCameraTriggerDistanceVeryShort = 3.0 Auto
float Property CinematicCameraTriggerDistanceShort = 12.0 Auto
float Property CinematicCameraTriggerDistanceMedium = 24.0 Auto
float Property CinematicCameraTriggerDistanceLong = 64.0 Auto

float Property SlowmotionSpeedMult = 0.1 Auto
float Property SlowmotionSpeedDur = 4.0 Auto
float Property AnimationSpeedMult = 20.0 Auto

float Property CinematicZoomOutMin = 0.19 Auto
float Property CinematicZoomOutMax = 0.21 Auto

float Property CinematicHeightFromTarget = 30.0 Auto

float Property CameraSpeedVeryShort = 3.75 Auto
float Property CameraSpeedShort = 3.50 Auto
float Property CameraSpeedMedium = 3.25 Auto
float Property CameraSpeedLong = 3.00 Auto

float Property CameraMagnitudeVeryShort = 1.0 Auto
float Property CameraMagnitudeShort = -3.0 Auto
float Property CameraMagnitudeMedium = -2.0 Auto
float Property CameraMagnitudeLong = 1.0 Auto

float Property CameraSpeed = 0.0 Auto
float Property CameraAngle = 0.0 Auto

float fVersion

Int Property StarbornTriggerStage = 2000 auto const 
Int Property BarretGivesWatchTriggerStage = 310 auto const 

bool KillcamCooldown = False
bool NearTarget = False
bool RememberFirst = False
bool RememberThird = False

Actor View
ObjectReference CameraTracker

Event OnQuestInit()
      
	  RegisterForRemoteEvent(MQ101 as scriptobject, "OnStageSet")
      Register()	  

EndEvent

Event Quest.OnStageSet(Quest akSender, int auiStageID, int auiItemID)

    If akSender == MQ101 && auiStageID == StarbornTriggerStage
       Register() 
       UnregisterForRemoteEvent(MQ101, "OnStageSet") 
 EndIf

    If akSender == MQ101 && auiStageID == BarretGivesWatchTriggerStage
       Register() 
 EndIf

EndEvent

Event OnAnimationEvent(ObjectReference akSource, string asEventName)
     
     If(asEventName == "weaponFire")
         If StarvegasKillcam_RecoilFX_Toggle.GetValue() == 1
		    If PlayerRef.WornHaskeyword(ExclusionCutter) == False
			   Game.ShakeCamera(PlayerRef, 0.5, 0.2)
         EndIf
	  EndIf
  EndIf

EndEvent

Event OnTimer(int aiTimerID)

	If (aiTimerID == 0)
	   Cooler()       
 EndIf

EndEvent

Event Actor.OnPlayerLoadGame(Actor akSender)

    CinematicFOVReturn()
	KillcamReset()
    SlowmotionAVUpdate()

	If PlayerRef.Hasperk(StarvegasKillcam_SlowmoPower) == False
       PlayerRef.Addperk(StarvegasKillcam_SlowmoPower, False)
 EndIf
	
	If PlayerRef.Hasperk(StarvegasKillcam_SmartPerspective) == False
       PlayerRef.Addperk(StarvegasKillcam_SmartPerspective, False)
 EndIf
	
	Utility.SetINIFloat("fActorFadeOutBoundMax:Camera", 0)

EndEvent

Function Update()

          Int Version0 = 0		   
          Int Version1 = 1
          Int Version2 = 2
          Int Version3 = 3
          Int Version4 = 4
          Int Version5 = 5
          Int Version6 = 6		   
          Int Version7 = 7
          Int Version8 = 8
          Int Version9 = 9
       
	   While fVersion < 1.12
		       If fVersion < 1.12	              
			      fVersion = 1.12      	              
                  CinematicFOVReturn()
	              RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
                  If StarvegasKillcam_RecoilFX_Toggle.GetValue() == 1
			         UnregisterForAnimationEvent(PlayerRef, "weaponFire")
					 Utility.Wait(0.5)
					 RegisterForAnimationEvent(PlayerRef, "weaponFire")
			   EndIf
			EndIf
            MSG_Starvegas_UpdateMessage.show(Version1, Version1, Version2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    EndWhile

EndFunction

Function Register()
      
	  SlowmotionAVUpdate()	  	  
	  RegisterForAnimationEvent(PlayerRef, "weaponFire")
      RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")	  
	  PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile, False)
	  PlayerRef.Addperk(StarvegasKillcam_SlowmoPower, False)
      PlayerRef.Addperk(StarvegasKillcam_SmartPerspective, False)      
	  StarvegasKillcam_Modes.SetValue(2)
      Utility.SetINIFloat("fActorFadeOutBoundMax:Camera", 0)

EndFunction

Function Unregister()
	   
	  UnregisterForAnimationEvent(PlayerRef, "weaponFire")
      UnregisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
	  PlayerRef.DispelSpell(StarvegasKillcam_SlowmoEffect) 	  
      PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Always)	
	  PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Combat)
	  PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_LastHostile)
	  PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Oneshot)
	  PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile)      
	  PlayerRef.Removeperk(StarvegasKillcam_SlowmoPower)	
	  PlayerRef.Removeperk(StarvegasKillcam_SmartPerspective)       
	  Utility.SetINIFloat("fActorFadeOutBoundMax:Camera", 1.429)	

EndFunction

Function FullyReset()
 
		 Unregister()         
		 Utility.Wait(0.5)		 
		 Register()
		 Utility.Wait(0.5)		 
		 KillcamReset()         
		 Utility.Wait(0.5)		 
		 CinematicFOVReturn()		 		 
		 Utility.Wait(0.5)                 
	     Utility.SetINIFloat("fActorFadeOutBoundMax:Camera", 0)		 
		 RestartTranslation.Stop()
		 RestartTranslation.Start()		 
		 MSG_StarvegasConfBookNotificationReset.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

EndFunction

Function EmergencyFallout()
	 
		 Unregister()         
		 Utility.Wait(0.5)		 
		 KillcamReset()         
		 Utility.Wait(0.5)		 
		 CinematicFOVReturn()		 
		 Utility.Wait(0.5)		 				 	 
		 RestartTranslation.Stop()		 
		 MSG_StarvegasConfBookNotificationUninstall.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

EndFunction

Function SlowmotionAVUpdate()

	     PlayerRef.SetValue(StarvegasKillcam_AV_SlowmotionSpeed, SlowmotionSpeedMult)
	     PlayerRef.SetValue(StarvegasKillcam_AV_SlowmotionDur, SlowmotionSpeedDur)
         PlayerRef.SetValue(StarvegasKillcam_AV_AnimationSpeed, AnimationSpeedMult)

EndFunction

Function KillcamReset()
        
		If KillcamCooldown == True
           KillcamCooldown = False
     EndIf

		If NearTarget == True
           NearTarget = False
     EndIf
     
	 StarvegasKillcam_KillcamInAction.SetValue(0)

EndFunction

Function SmartPerspectiveChanger()

        Game.SetCameraTarget(PlayerRef)

             If RememberFirst == True
                Game.ForceFirstPerson()

         ElseIf RememberThird == True
                Game.ForceThirdPerson()

          EndIf

EndFunction

Function SmartPerspective1stPerson()
      
	  Utility.Wait(1.0)
	  If StarvegasKillcam_IsInScope.GetValue() == 0
         RememberFirst = True
         RememberThird = False
   EndIf

EndFunction

Function SmartPerspective3rdPerson()
      
	  Utility.Wait(1.0)	  
	  If StarvegasKillcam_IsInScope.GetValue() == 0
         RememberFirst = False
         RememberThird = True
   EndIf

EndFunction

Function StartCooler()

    StartTimer(Cooldown, 0)

EndFunction

Function Cooler()

	    KillcamCooldown()

EndFunction

Function KillcamCooldown()

        If  KillcamCooldown == True
			KillcamCooldown = False
      EndIf

EndFunction

Function Killcam(ObjectReference akNewContainer)

         Actor Target = akNewContainer as Actor
         Race TargetRace = Target.GetRace()      
	  
	  If KillcamCooldown == False
         KillcamCooldown = True   	 		 
		 
		 If StarvegasKillcam_ActiveRaceHuman.Getvalue() == 1
		        If StarvegasKillcam_HumanRaces.Find(TargetRace) != -1
			       StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
				   PrepareCinematicValues(Target)    
             EndIf
      EndIf

         If StarvegasKillcam_ActiveRaceCreature.Getvalue() == 1
                If StarvegasKillcam_CreatureRaces.Find(TargetRace) != -1
			       StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
				   PrepareCinematicValues(Target)          
             EndIf		 
      EndIf

		 If StarvegasKillcam_ActiveRaceRobot.Getvalue() == 1
                If StarvegasKillcam_RobotRaces.Find(TargetRace) != -1
			       StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
				   PrepareCinematicValues(Target)          
             EndIf		 
      EndIf

		 If StarvegasKillcam_ActiveRaceSpaceship.Getvalue() == 1
                If StarvegasKillcam_SpaceshipRaces.Find(TargetRace) != -1
			       StarvegasKillcam_SlowmoEffect_Spaceship.Cast(PlayerRef, None)
             EndIf 
      EndIf
 EndIf

EndFunction

Function RaceChecker(ObjectReference akNewContainer)

         Actor Target = akNewContainer as Actor
         Race TargetRace = Target.GetRace()      
	   	 				 
		 If StarvegasKillcam_ActiveRaceHuman.Getvalue() == 1
		        If StarvegasKillcam_HumanRaces.Find(TargetRace) != -1
				   PrepareCinematicValues(Target)    
             EndIf
      EndIf

         If StarvegasKillcam_ActiveRaceCreature.Getvalue() == 1
                If StarvegasKillcam_CreatureRaces.Find(TargetRace) != -1
				   PrepareCinematicValues(Target)          
             EndIf		 
      EndIf

		 If StarvegasKillcam_ActiveRaceRobot.Getvalue() == 1
                If StarvegasKillcam_RobotRaces.Find(TargetRace) != -1
				   PrepareCinematicValues(Target)          
             EndIf		 
      EndIf

		 If StarvegasKillcam_ActiveRaceSpaceship.Getvalue() == 1
                If StarvegasKillcam_SpaceshipRaces.Find(TargetRace) != -1
			       StarvegasKillcam_SlowmoEffect_Spaceship.Cast(PlayerRef, None)
             EndIf 
      EndIf

EndFunction

Function CameraShake()

         Game.ShakeCamera(View, 5.0, 0.4)

EndFunction

Function CameraShakePlayer()

         Game.ShakeCamera(PlayerRef, 5.0, 0.4)

EndFunction

Function PrepareCinematicValues(ObjectReference akNewContainer)

                           Actor Target = akNewContainer as Actor
                           
						   Float RandomZoom = Utility.RandomFloat(CinematicCameraFirstPersonMinFOV, CinematicCameraFirstPersonMaxFOV)						   						   						   						   
                           Float RandomGeometryZoom = Utility.RandomFloat(CinematicCameraFirstPersonGeometryMinFOV, CinematicCameraFirstPersonGeometryMaxFOV)						   
						   
						   StarvegasKillcam_KillcamInAction.SetValue(1)
						   
						   If PlayerRef.GetDistance(Target) >= CinematicCameraTriggerDistanceLong
							  CameraSpeed = (Target.GetDistance(PlayerRef) * CameraSpeedLong)
							  CameraAngle = (View.GetAngleZ() + View.GetHeadingAngle(Target))
							  CinematicKillcam(Target, CameraMagnitudeLong, CinematicCameraLongFOV, CameraSpeed, CameraAngle) 
                       
					   ElseIf PlayerRef.GetDistance(Target) >= CinematicCameraTriggerDistanceMedium 
						      CameraSpeed = (Target.GetDistance(PlayerRef) * CameraSpeedMedium)
							  CameraAngle = (View.GetAngleZ() + View.GetHeadingAngle(Target))
							  CinematicKillcam(Target, CameraMagnitudeMedium, CinematicCameraMediumFOV, CameraSpeed, CameraAngle)
					   
					   ElseIf PlayerRef.GetDistance(Target) >= CinematicCameraTriggerDistanceShort						      
							  CameraSpeed = (Target.GetDistance(PlayerRef) * CameraSpeedShort)
							  CameraAngle = (View.GetAngleZ() + View.GetHeadingAngle(Target))
							  CinematicKillcam(Target, CameraMagnitudeShort, CinematicCameraShortFOV, CameraSpeed, CameraAngle)
						
					   ElseIf PlayerRef.GetDistance(Target) >= CinematicCameraTriggerDistanceVeryShort						      
							  NearTarget = True
							  CameraSpeed = (Target.GetDistance(PlayerRef) * CameraSpeedVeryShort)
							  CameraAngle = (View.GetAngleZ() + View.GetHeadingAngle(Target))
							  CinematicKillcam(Target, CameraMagnitudeVeryShort, CinematicCameraVeryNearFOV, CameraSpeed, CameraAngle)

					   ElseIf PlayerRef.GetDistance(Target) >= CinematicCameraTriggerDistanceMelee					      
                              CameraShakePlayer()
							  CinematicFOVCalculation(RandomZoom, CinematicCameraThirdPersonFOV, RandomGeometryZoom)
						
						EndIf

EndFunction

Function CinematicKillcam(ObjectReference akNewContainer, Float Magnitude, Float FOV, Float Speed, Float Angle)
	 	 		 
		     Actor Target = akNewContainer as Actor 		           

			 Float Zoom = Utility.RandomFloat(CinematicZoomOutMin, CinematicZoomOutMax)			  	  	  
			 Float Seconds = SlowmotionSpeedDur * SlowmotionSpeedDur             
	 		     			 
			 Int Max = 0
		     Int Chance = Utility.RandomInt(1, 100)		   	      			 
	         PlayerRef.PlayIdleAction(StarvegasKillcam_ActionSightedRelease, PlayerRef)
             
 If NearTarget == False
	
	     If Chance >= 50 	 
			 
			 Game.ForceThirdPerson()
			 View = PlayerRef.PlaceActorAtMe(StarvegasKillcam_Camera, 4, None, False, False, True, None, True)
			 View.killsilent(Target)  
			 View.moveto(PlayerRef, 0.0, 0.0, 0.60, false, false)			 			 			 
			 View.SetAngle(0.0, 0.0, Angle)			 
			 Game.SetCameraTarget(View)	              
			 View.SplineTranslateToRefNode(Target, Root, Magnitude, Speed, 0.0001)				 			 		 			 
			 CinematicFOVCalculation(FOV, FOV, FOV)
			 CameraShake()  
			 
			 While (Max < Seconds)																			  
				   CameraTracker = Target.PlaceAtNode(Root, StarvegasKillcam_CameraMarker, 1, False, False, True, False)
				   Speed = (View.GetDistance(CameraTracker) / 0.2)				    
				   PlayerRef.SetLookAt(View, true)			   
				   CameraTracker.moveto(Target, 0.0, 0.0, CinematicHeightFromTarget, false, false)				   													          																			  
		           Max += 1
		  EndWhile
		   
		   PlayerRef.Clearlookat()
		   CameraTracker.Delete()
		   CameraTracker = None
		   View.Delete()
		   View = None 
           CameraSpeed = 0.0
           CameraAngle = 0.0

      Else 	     

		   Game.ForceThirdPerson()
		   View = Target.PlaceActorAtMe(StarvegasKillcam_Camera, 4, None, False, False, True, None, True)
		   View.killsilent(Target)
		   View.moveto(Target, 0, 0, 0.6, True, False)
		   View.SplineTranslateToRefNode(PlayerRef, Root, 1.0, 0.0, 0.0001)
		   Game.SetCameraTarget(View)
		   PlayerRef.SetLookAt(Target, True)			 
           CameraShake()      
		   Utility.Wait(Zoom)
 		   View.StopTranslation()																													
		   View.Delete()	
	       View = None
		   RestartTranslation.Stop()
		   RestartTranslation.Start()

      EndIf

Else
		   Game.ForceThirdPerson()
		   View = Target.PlaceActorAtMe(StarvegasKillcam_Camera, 4, None, False, False, True, None, True)
		   View.killsilent(Target)
		   View.moveto(Target, 0, 0, 0.2, True, False)
		   View.SetAngle(0.0, 0.0, Angle)	
		   Game.SetCameraTarget(View)
		   View.SplineTranslateToRefNode(PlayerRef, CameraTarget, Magnitude, Speed, 0.0001)
		   CinematicFOVCalculation(FOV, FOV, FOV)
		   CameraShake()  
		   
		   While (Max < Seconds)																			  				
				  CameraTracker = Target.PlaceAtNode(CameraTarget, StarvegasKillcam_CameraMarker, 1, False, False, True, False)
				  Speed = (View.GetDistance(CameraTracker) / 0.2)				    
				  PlayerRef.SetLookAt(View, true)			   
				  CameraTracker.moveto(Target, 0.0, 0.0, CinematicHeightFromTarget, false, false)				   													          																			  		          	
		          Max += 1		  
		EndWhile
			
			PlayerRef.Clearlookat()
		    CameraTracker.Delete()
		    CameraTracker = None
   		  	View.Delete()
		    View = None 
            CameraSpeed = 0.0
            CameraAngle = 0.0    
            NearTarget = False
EndIf

EndFunction                                                          

Function KillcamBasic(ObjectReference akNewContainer)

         Actor Target = akNewContainer as Actor
         Race TargetRace = Target.GetRace()
	  
	  If KillcamCooldown == False
         KillcamCooldown = True           		 	 
		 	   
			   If StarvegasKillcam_ActiveRaceHuman.Getvalue() == 1
				     If StarvegasKillcam_HumanRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						PrepareCinematicBasicValues(Target)
                  EndIf
            EndIf		       

			   If StarvegasKillcam_ActiveRaceCreature.Getvalue() == 1        
				     If StarvegasKillcam_CreatureRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						PrepareCinematicBasicValues(Target)
                  EndIf
            EndIf	 		       
			   
			   If StarvegasKillcam_ActiveRaceRobot.Getvalue() == 1    
				     If StarvegasKillcam_RobotRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect.Cast(PlayerRef, None)
						PrepareCinematicBasicValues(Target)
                  EndIf
            EndIf	 		      

			  If StarvegasKillcam_ActiveRaceSpaceship.Getvalue() == 1    
				     If StarvegasKillcam_SpaceshipRaces.Find(TargetRace) != -1
		                StarvegasKillcam_SlowmoEffect_Spaceship.Cast(PlayerRef, None)
                  EndIf
            EndIf
		 
   EndIf

EndFunction

Function PrepareCinematicBasicValues(ObjectReference akNewContainer)
						   
         Actor Target = akNewContainer as Actor		  
	  	 
		 CameraShakePlayer() 	 		  
		  
		  If PlayerRef.GetDistance(Target) <= CinematicCameraTriggerDistanceShort		     
			 CinematicFOVCalculation(BasicCameraFirstPersonFOV5, BasicCameraThirdPersonFOV5, BasicCameraFirstPersonGeometryFOV5)
      ElseIf PlayerRef.GetDistance(Target) > CinematicCameraTriggerDistanceShort
			 CinematicFOVCalculation(BasicCameraFirstPersonFOV25, BasicCameraThirdPersonFOV25, BasicCameraFirstPersonGeometryFOV25)		 										
	   EndIf

EndFunction

 Function CinematicFOVCalculation(Float Default1stPFOV, Float Default3rdPFOV, Float Default1stPGeometryFOV)
  
	      Utility.SetINIFloat("fDefault1stPersonFOV:Camera", Default1stPFOV) 
	      Utility.SetINIFloat("fFPWorldFOV:Camera", Default1stPFOV) 
	      Utility.SetINIFloat("fTPWorldFOV:Camera", Default3rdPFOV)  
	      Utility.SetINIFloat("fFPGeometryFOV:Camera", Default1stPGeometryFOV) 

EndFunction

Function CinematicFOVReturn()
		  
		  Utility.SetINIFloat("fDefault1stPersonFOV:Camera", DefaultCameraFirstPersonFOV) 
	      Utility.SetINIFloat("fFPWorldFOV:Camera", DefaultCameraFirstPersonFOV) 
	      Utility.SetINIFloat("fTPWorldFOV:Camera", DefaultCameraThirdPersonFOV) 
	      Utility.SetINIFloat("fFPGeometryFOV:Camera", DefaultCameraFirstPersonGeometryFOV)
          StarvegasKillcam_KillcamInAction.SetValue(0)

EndFunction

Function HUDTurnOn()
		  
	  If StarvegasKillcam_UI_Toggle.GetValue() == 1		 
		 Debug.EnableMenus(True)
         Game.SetCharGenHUDMode(0)
   EndIf	

EndFunction

Function Main(Int Message = 0, Int Button = 0, Bool MenuOpened = True)

  While MenuOpened

	 If Button == -1

 ElseIf Message == 0
		button = MSG_StarvegasConfBookMain.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                            Message = 1

	                                ElseIf (button == 1)
            
		                                    Message = 2

	                                ElseIf (button == 2)

 		                                    Message = 3                                           

	                                ElseIf (button == 3)

		                                    Message = 4
              
	                                ElseIf (button == 4)

		                                    Message = 5

	                                ElseIf (button == 5)

		                                    Message = 7

	                                ElseIf (button == 6)

		                                    Message = 8

	                                ElseIf (button == 7)

		                                    Message = 6

	                                ElseIf (button == 8)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 1
		button = MSG_StarvegasConfBookMainModes.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                            StarvegasKillcam_Modes.SetValue(1)
                                            PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_LastHostile)
											PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_Oneshot, False)
	                                
									ElseIf (button == 1)
            
		                                    StarvegasKillcam_Modes.SetValue(2)
                                            PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Oneshot)
											PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile, False)
	                                
									ElseIf (button == 2)

 		                                    StarvegasKillcam_Modes.SetValue(3)                                           
                                            PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile)
											PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_Combat, False)

	                                ElseIf (button == 3)

		                                    StarvegasKillcam_Modes.SetValue(4)
                                            PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Combat)
											PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_Always, False)              
	                                
									ElseIf (button == 4)

		                                    StarvegasKillcam_Modes.SetValue(5)
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Always)	
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Combat)
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_LastHostile)
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_Oneshot)
		                                    PlayerRef.Removeperk(StarvegasKillcam_SlowmotionMode_OneshotLastHostile)
	                                
									ElseIf (button == 5)

		                                    StarvegasKillcam_Modes.SetValue(0)
                                            PlayerRef.Addperk(StarvegasKillcam_SlowmotionMode_LastHostile, False)	
	                                
									ElseIf (button == 6)

		                                    Message = 0

	                                ElseIf (button == 7)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 2
		button = MSG_StarvegasConfBookMainCamera.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                            Message = 22

	                                ElseIf (button == 1)
            
		                                    Message = 222
              
	                                ElseIf (button == 2)

		                                    Message = 0

	                                ElseIf (button == 3)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 22
		button = MSG_StarvegasConfBookMainCameraPlayer.show(DefaultCameraFirstPersonFOV, DefaultCameraThirdPersonFOV, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)

 		                                    DefaultCameraFirstPersonFOV += 2                                          
                                            DefaultCameraFirstPersonGeometryFOV += 2
	                                
									ElseIf (button == 1)

                                               If DefaultCameraFirstPersonFOV == 2
											      DefaultCameraFirstPersonFOV = 2
                                                  DefaultCameraFirstPersonGeometryFOV = 2
											Else
		                                          DefaultCameraFirstPersonFOV -= 2
											      DefaultCameraFirstPersonGeometryFOV -= 2
											EndIf
              
	                                ElseIf (button == 2)

		                                    DefaultCameraThirdPersonFOV += 2

	                                ElseIf (button == 3)

                                               If DefaultCameraThirdPersonFOV == 2
											      DefaultCameraThirdPersonFOV = 2
                                            Else
		                                          DefaultCameraThirdPersonFOV -= 2
											EndIf
              
	                                ElseIf (button == 4)

		                                    Message = 2
                                            CinematicFOVReturn()
	                                
									ElseIf (button == 5)

                                           ; Exit
                                           MenuOpened = False
                                           CinematicFOVReturn()
									 EndIf

 ElseIf Message == 222
		button = MSG_StarvegasConfBookMainCameraKillcam.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                            Message = 2222
											
	                                ElseIf (button == 1)
            		                                  
                                            Message = 22222		                                    
											
	                                ElseIf (button == 2)

		                                    Message = 2

	                                ElseIf (button == 3)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 2222
		button = MSG_StarvegasConfBookMainCameraKillcamFOV.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)

		                                    Message = 2223
									
									ElseIf (button == 1)

                                            Message = 2224                            
																						                                									
									ElseIf (button == 2)
            		                                  
	                                       Message = 222
											
	                                ElseIf (button == 3)
                                           
										   ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 2223
		button = MSG_StarvegasConfBookMainCameraKillcamFOVBasic.show(BasicCameraFirstPersonFOV5, BasicCameraThirdPersonFOV5, BasicCameraFirstPersonFOV25, BasicCameraThirdPersonFOV25, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)

		                                    BasicCameraFirstPersonFOV5 += 2
	                                        BasicCameraFirstPersonGeometryFOV5 += 2
									
									ElseIf (button == 1)

                                               If BasicCameraFirstPersonFOV5 == 2
											      BasicCameraFirstPersonFOV5 = 2
                                                  BasicCameraFirstPersonGeometryFOV5 = 2
											Else
		                                          BasicCameraFirstPersonFOV5 -= 2
											      BasicCameraFirstPersonGeometryFOV5 -= 2
											EndIf                            
											
	                                ElseIf (button == 2)

		                                    BasicCameraThirdPersonFOV5 += 2

	                                ElseIf (button == 3)

                                               If BasicCameraThirdPersonFOV5 == 2
											      BasicCameraThirdPersonFOV5 = 2
                                            Else
		                                          BasicCameraThirdPersonFOV5 -= 2
											EndIf 
	                                
									ElseIf (button == 4)
            		                                  
                                            BasicCameraFirstPersonFOV25 += 2		                                    
											BasicCameraFirstPersonGeometryFOV25 += 2
	                                
									ElseIf (button == 5)

                                               If BasicCameraFirstPersonFOV25 == 2
											      BasicCameraFirstPersonFOV25 = 2
                                                  BasicCameraFirstPersonGeometryFOV25 = 2
											Else
		                                          BasicCameraFirstPersonFOV25 -= 2
											      BasicCameraFirstPersonGeometryFOV25 -= 2
											EndIf   		                                    

	                                ElseIf (button == 6)

                                            BasicCameraThirdPersonFOV25 += 2
	                                
									ElseIf (button == 7)
            		                                  
                                               If BasicCameraThirdPersonFOV25 == 2
											      BasicCameraThirdPersonFOV25 = 2
                                            Else
		                                          BasicCameraThirdPersonFOV25 -= 2
											EndIf                                              		                                    
											                                									
									ElseIf (button == 8)
            		                                  
	                                       Message = 2222
											
	                                ElseIf (button == 9)
                                           
										   ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 2224
		button = MSG_StarvegasConfBookMainCameraKillcamFOVCinematic.show(CinematicCameraVeryNearFOV, CinematicCameraShortFOV, CinematicCameraMediumFOV, CinematicCameraLongFOV, CinematicZoomOutMin, CinematicZoomOutMax, 0.0, 0.0, 0.0)

	                                    If (button == 0)

		                                    CinematicCameraVeryNearFOV += 2
									
									ElseIf (button == 1)

                                               If CinematicCameraVeryNearFOV == 2
											      CinematicCameraVeryNearFOV = 2
											Else
		                                          CinematicCameraVeryNearFOV -= 2
											EndIf                            
											
	                                ElseIf (button == 2)

		                                    CinematicCameraShortFOV += 2

	                                ElseIf (button == 3)

                                               If CinematicCameraShortFOV == 2
											      CinematicCameraShortFOV = 2
                                            Else
		                                          CinematicCameraShortFOV -= 2
											EndIf 
	                                
									ElseIf (button == 4)
            		                                  
                                            CinematicCameraMediumFOV += 2		                                    
	                                
									ElseIf (button == 5)

                                               If CinematicCameraMediumFOV == 2
											      CinematicCameraMediumFOV = 2
											Else
		                                          CinematicCameraMediumFOV -= 2
											EndIf   		                                    

	                                ElseIf (button == 6)

                                            CinematicCameraLongFOV += 2
	                                
									ElseIf (button == 7)
            		                                  
                                               If CinematicCameraLongFOV == 2
											      CinematicCameraLongFOV = 2
                                            Else
		                                          CinematicCameraLongFOV -= 2
											EndIf                                              		                                    

	                                ElseIf (button == 8)

                                               If CinematicZoomOutMin == 0.30
											      CinematicZoomOutMin = 0.30
                                            Else
		                                          CinematicZoomOutMin += 0.01
											EndIf 
	                                
									ElseIf (button == 9)
            		                                  
                                               If CinematicZoomOutMin == 0.15
											      CinematicZoomOutMin = 0.15
                                            Else
		                                          CinematicZoomOutMin -= 0.01
											EndIf 

	                                ElseIf (button == 10)

                                               If CinematicZoomOutMax == 0.30
											      CinematicZoomOutMax = 0.30
                                            Else
		                                          CinematicZoomOutMax += 0.01
											EndIf 
	                                
									ElseIf (button == 11)
            		                                  
                                               If CinematicZoomOutMax == 0.15
											      CinematicZoomOutMax = 0.15
                                            Else
		                                          CinematicZoomOutMax -= 0.01
											EndIf 
											                                									
									ElseIf (button == 12)
            		                                  
	                                       Message = 222
											
	                                ElseIf (button == 13)
                                           
										   ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 22222
		button = MSG_StarvegasConfBookMainCameraKillcamDistance.show(CinematicCameraTriggerDistanceVeryShort, CinematicCameraTriggerDistanceShort, CinematicCameraTriggerDistanceMedium, CinematicCameraTriggerDistanceLong, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                            CinematicCameraTriggerDistanceVeryShort += 1
											
	                                ElseIf (button == 1)
            		                                  
                                               If CinematicCameraTriggerDistanceVeryShort == 2
											      CinematicCameraTriggerDistanceVeryShort = 2
                                            Else
		                                          CinematicCameraTriggerDistanceVeryShort -= 1
											EndIf 

	                                ElseIf (button == 2)
            
                                            CinematicCameraTriggerDistanceShort += 2
											
	                                ElseIf (button == 3)
            		                                  
                                               If CinematicCameraTriggerDistanceShort == 2
											      CinematicCameraTriggerDistanceShort = 2
                                            Else
		                                          CinematicCameraTriggerDistanceShort -= 2
											EndIf 	                                    
											
	                                ElseIf (button == 4)

		                                    CinematicCameraTriggerDistanceMedium += 2

	                                ElseIf (button == 5)
            		                                 
                                               If CinematicCameraTriggerDistanceMedium == 2
											      CinematicCameraTriggerDistanceMedium = 2
                                            Else
		                                          CinematicCameraTriggerDistanceMedium -= 2
											EndIf                                     
											
	                                ElseIf (button == 6)

		                                    CinematicCameraTriggerDistanceLong += 2

	                                ElseIf (button == 7)
            		                                  
                                               If CinematicCameraTriggerDistanceLong == 2
											      CinematicCameraTriggerDistanceLong = 2
                                            Else
		                                          CinematicCameraTriggerDistanceLong -= 2
											EndIf  	                                    
											                                   										
	                                ElseIf (button == 8)

		                                    Message = 222

	                                ElseIf (button == 9)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 3

                               Float AlwaysTriggerChance = StarvegasKillcam_SlowmoChanceAlways.Getvalue()
                               Float CombatTriggerChance = StarvegasKillcam_SlowmoChanceCombat.Getvalue()
                               Float LastHostileTriggerChance = StarvegasKillcam_SlowmoChanceLastHostile.Getvalue()
                               Float OneshotTriggerChance = StarvegasKillcam_SlowmoChanceOneshot.Getvalue()
                               Float OneshotAndLastHostileTriggerChance = StarvegasKillcam_SlowmoChanceLastHostileOneshot.Getvalue()
                               Float CinematicCameraTriggerChance = StarvegasKillcam_CinematicChance.Getvalue()

                               Float AlwaysTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceAlways.Getvalue() + 2
                               Float AlwaysTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceAlways.Getvalue() - 2
                               Float CombatTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceCombat.Getvalue() + 2
                               Float CombatTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceCombat.Getvalue() - 2
                               Float LastHostileTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceLastHostile.Getvalue() + 2
                               Float LastHostileTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceLastHostile.Getvalue() - 2
                               Float OneshotTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceOneshot.Getvalue() + 2
                               Float OneshotTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceOneshot.Getvalue() - 2
                               Float OneshotAndLastHostileTriggerChanceIncrease = StarvegasKillcam_SlowmoChanceLastHostileOneshot.Getvalue() + 2
                               Float OneshotAndLastHostileTriggerChanceDecrease = StarvegasKillcam_SlowmoChanceLastHostileOneshot.Getvalue() - 2
                               Float CinematicCameraTriggerChanceIncrease = StarvegasKillcam_CinematicChance.Getvalue() + 5
                               Float CinematicCameraTriggerChanceDecrease = StarvegasKillcam_CinematicChance.Getvalue() - 5

		button = MSG_StarvegasConfBookMainTriggerChance.show(AlwaysTriggerChance, CombatTriggerChance, LastHostileTriggerChance, OneshotTriggerChance, OneshotAndLastHostileTriggerChance, CinematicCameraTriggerChance, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                               If AlwaysTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceAlways.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceAlways.SetValue(AlwaysTriggerChanceIncrease)
											EndIf 
											
	                                ElseIf (button == 1)
            		                                  
                                               If AlwaysTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceAlways.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceAlways.SetValue(AlwaysTriggerChanceDecrease)
											EndIf                                    
											
	                                ElseIf (button == 2)

                                               If CombatTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceCombat.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceCombat.SetValue(CombatTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 3)
            		                                  
                                               If CombatTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceCombat.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceCombat.SetValue(CombatTriggerChanceDecrease)
											EndIf                                      
											
	                                ElseIf (button == 4)

                                               If LastHostileTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceLastHostile.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceLastHostile.SetValue(LastHostileTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 5)
            		                                  
                                               If LastHostileTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceLastHostile.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceLastHostile.SetValue(LastHostileTriggerChanceDecrease)
											EndIf  	                                    
											
	                                ElseIf (button == 6)

                                               If OneshotTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceOneshot.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceOneshot.SetValue(OneshotTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 7)
            		                                  
                                               If OneshotTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceOneshot.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceOneshot.SetValue(OneshotTriggerChanceDecrease)
											EndIf   	                                    

	                                ElseIf (button == 8)

                                               If OneshotAndLastHostileTriggerChance == 100
											      StarvegasKillcam_SlowmoChanceLastHostileOneshot.SetValue(100)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceLastHostileOneshot.SetValue(OneshotAndLastHostileTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 9)
            		                                  
                                               If OneshotAndLastHostileTriggerChance == 2
											      StarvegasKillcam_SlowmoChanceLastHostileOneshot.SetValue(2)
                                            Else
		                                          StarvegasKillcam_SlowmoChanceLastHostileOneshot.SetValue(OneshotAndLastHostileTriggerChanceDecrease)
											EndIf

	                                ElseIf (button == 10)

                                               If CinematicCameraTriggerChance == 100
											      StarvegasKillcam_CinematicChance.SetValue(100)
                                            Else
		                                          StarvegasKillcam_CinematicChance.SetValue(CinematicCameraTriggerChanceIncrease)
											EndIf 

	                                ElseIf (button == 11)
            		                                  
                                               If CinematicCameraTriggerChance == 0
											      StarvegasKillcam_CinematicChance.SetValue(0)
                                            Else
		                                          StarvegasKillcam_CinematicChance.SetValue(CinematicCameraTriggerChanceDecrease)
											EndIf
											
	                                ElseIf (button == 12)

		                                    Message = 0

	                                ElseIf (button == 13)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 4
		button = MSG_StarvegasConfBookMainCooldown.show(Cooldown, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                           Cooldown += 1
											
	                                ElseIf (button == 1)
            		                                  
                                               If Cooldown == 1
											      Cooldown = 1
                                            Else
		                                          Cooldown -= 1
											EndIf  	                              										
											
	                                ElseIf (button == 2)

		                                    Message = 0

	                                ElseIf (button == 3)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 5
		button = MSG_StarvegasConfBookMainSpecialFX.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                            StarvegasKillcam_SoundsFX_Toggle.SetValue(0) 
											
	                                ElseIf (button == 1)
            		                                  
                                            StarvegasKillcam_SoundsFX_Toggle.SetValue(1)                                   
											
	                                ElseIf (button == 2)

                                            StarvegasKillcam_IMADs_Toggle.SetValue(0) 

	                                ElseIf (button == 3)
            		                                  
                                            StarvegasKillcam_IMADs_Toggle.SetValue(1)                                     

	                                ElseIf (button == 4)

                                            StarvegasKillcam_IMADs_SS_Toggle.SetValue(0) 

	                                ElseIf (button == 5)
            		                                  
                                            StarvegasKillcam_IMADs_SS_Toggle.SetValue(1)       
											
	                                ElseIf (button == 6)

                                            StarvegasKillcam_RecoilFX_Toggle.SetValue(0) 
                                            UnregisterForAnimationEvent(PlayerRef, "weaponFire")
	                                
									ElseIf (button == 7)
            		                                  
                                            StarvegasKillcam_RecoilFX_Toggle.SetValue(1) 	                                    
											RegisterForAnimationEvent(PlayerRef, "weaponFire")
	                                
									ElseIf (button == 8)

                                            StarvegasKillcam_MusicMute_Toggle.SetValue(0)  

	                                ElseIf (button == 9)
            		                                  
                                            StarvegasKillcam_MusicMute_Toggle.SetValue(1)   	                                    

	                                ElseIf (button == 10)

                                            StarvegasKillcam_UI_Toggle.SetValue(0) 

	                                ElseIf (button == 11)
            		                                  
                                            StarvegasKillcam_UI_Toggle.SetValue(1) 

	                                ElseIf (button == 12)

                                            StarvegasKillcam_Invincibility_Toggle.SetValue(0) 

	                                ElseIf (button == 13)
            		                                  
                                            StarvegasKillcam_Invincibility_Toggle.SetValue(1) 
											
	                                ElseIf (button == 14)

		                                    Message = 0

	                                ElseIf (button == 15)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 6
		button = MSG_StarvegasConfBookMainDebug.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                           FullyReset()
											
	                                ElseIf (button == 1)
            		                                  
                                           EmergencyFallout()  	                              										
											
	                                ElseIf (button == 2)

		                                    Message = 0

	                                ElseIf (button == 3)

                                           ; Exit
                                           MenuOpened = False
                                           
									 EndIf

 ElseIf Message == 7
		button = MSG_StarvegasConfBookMainProperties.show(SlowmotionSpeedMult, AnimationSpeedMult, SlowmotionSpeedDur, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                           If SlowmotionSpeedMult == 0.40
											  SlowmotionSpeedMult = 0.40
	                                   Else
									          SlowmotionSpeedMult += 0.01
									    EndIf
									
									ElseIf (button == 1)
            		                                  
                                           If SlowmotionSpeedMult == 0.01
											  SlowmotionSpeedMult = 0.01
	                                   Else
									          SlowmotionSpeedMult -= 0.01
									    EndIf 	                              										

	                                ElseIf (button == 2)

                                           If AnimationSpeedMult == 100
											  AnimationSpeedMult = 100
	                                   Else
									          AnimationSpeedMult += 5.0
									    EndIf

	                                ElseIf (button == 3)
											
                                           If AnimationSpeedMult == 5.0
											  AnimationSpeedMult = 5.0
	                                   Else
									          AnimationSpeedMult -= 5.0
									    EndIf 

	                                ElseIf (button == 4)

									       SlowmotionSpeedDur += 1

	                                ElseIf (button == 5)
											
                                           If SlowmotionSpeedDur == 1
											  SlowmotionSpeedDur = 1
	                                   Else
									          SlowmotionSpeedDur -= 1
									    EndIf 											
																						
	                                ElseIf (button == 6)

		                                    Message = 0
                                            SlowmotionAVUpdate()
	                                
									ElseIf (button == 7)

                                           ; Exit
                                           MenuOpened = False
                                           SlowmotionAVUpdate()                                          
									 
									 EndIf

 ElseIf Message == 8
		button = MSG_StarvegasConfBookMainEnabledRaces.show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)

	                                    If (button == 0)
            
                                           StarvegasKillcam_ActiveRaceHuman.SetValue(0)
									
									ElseIf (button == 1)
            		                                  
                                           StarvegasKillcam_ActiveRaceHuman.SetValue(1)	                              										

	                                ElseIf (button == 2)

                                           StarvegasKillcam_ActiveRaceCreature.SetValue(0)

	                                ElseIf (button == 3)
											
                                           StarvegasKillcam_ActiveRaceCreature.SetValue(1)	 											

	                                ElseIf (button == 4)

                                           StarvegasKillcam_ActiveRaceRobot.SetValue(0)

	                                ElseIf (button == 5)
											
                                           StarvegasKillcam_ActiveRaceRobot.SetValue(1)										

	                                ElseIf (button == 6)

                                           StarvegasKillcam_ActiveRaceSpaceship.SetValue(0)

	                                ElseIf (button == 7)
											
                                           StarvegasKillcam_ActiveRaceSpaceship.SetValue(1)	
											
	                                ElseIf (button == 8)

		                                    Message = 0
	                               
									ElseIf (button == 9)

                                           ; Exit
                                           MenuOpened = False                                          
									 
									 EndIf

  EndIf
EndWhile
EndFunction