Scriptname ShipDecoration_CrewPassengerSlots_TerminalMenu_Script Extends TerminalMenu


;-- Variables ---------------------------------------

;-- Properties --------------------------------------
TerminalMenu Property CrewPassengerSlots_TerminalMenu Auto Const mandatory
ReferenceAlias Property PlayerShip Auto mandatory

ActorValue Property CrewPassengerSlot_CrewAV Auto  mandatory
ActorValue Property CrewPassengerSlot_PassengerAV Auto  mandatory

Keyword Property CrewPassengerSlots_isCrewSlot Auto Const mandatory
Keyword Property CrewPassengerSlots_isCrewSlotDouble Auto Const mandatory
Keyword Property CrewPassengerSlots_isCrewSlotHalf Auto Const mandatory

Keyword Property CrewPassengerSlots_isPassengerSlot Auto Const mandatory
Keyword Property CrewPassengerSlots_isPassengerSlotDouble Auto Const mandatory
Keyword Property CrewPassengerSlots_isPassengerSlotTriple Auto Const mandatory



Event OnTerminalMenuEnter(TerminalMenu akTerminalBase, ObjectReference akTerminalRef)

	If akTerminalBase == CrewPassengerSlots_TerminalMenu 
		akTerminalRef.AddTextReplacementValue("CrewSlots",  PlayerShip.GetShipRef().GetValue(CrewPassengerSlot_CrewAV) as int) 
		akTerminalRef.AddTextReplacementValue("PassengerSlots",  PlayerShip.GetShipRef().GetValue(CrewPassengerSlot_PassengerAV) as int) 
	endif
EndEvent




Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)

	If akTerminalBase == CrewPassengerSlots_TerminalMenu 
		if auiMenuItemID == 1 
            ObjectReference[] singleCrewSlots = Game.GetPlayer().FindAllReferencesWithKeyword(CrewPassengerSlots_isCrewSlot, 100.0)	
		    ObjectReference[] doubleCrewSlots = Game.GetPlayer().FindAllReferencesWithKeyword(CrewPassengerSlots_isCrewSlotDouble, 100.0)	
		    ObjectReference[] halfCrewSlots = Game.GetPlayer().FindAllReferencesWithKeyword(CrewPassengerSlots_isCrewSlotHalf, 100.0)	
		    PlayerShip.GetShipRef().SetValue(CrewPassengerSlot_CrewAV, (singleCrewSlots.Length + (2 * doubleCrewSlots.Length) + Math.Floor(0.5 * halfCrewSlots.Length)) as float)
            Debug.Trace("Crew " + singleCrewSlots.Length + " " + doubleCrewSlots.Length,0)
        elseif auiMenuItemID == 2
            ObjectReference[] singlePassengerSlots = Game.GetPlayer().FindAllReferencesWithKeyword(CrewPassengerSlots_isPassengerSlot, 100.0)	
		    ObjectReference[] doublePassengerSlots = Game.GetPlayer().FindAllReferencesWithKeyword(CrewPassengerSlots_isPassengerSlotDouble, 100.0)	
		    ObjectReference[] triplePassengerSlots = Game.GetPlayer().FindAllReferencesWithKeyword(CrewPassengerSlots_isPassengerSlotTriple, 100.0)	
            PlayerShip.GetShipRef().SetValue(CrewPassengerSlot_PassengerAV, (singlePassengerSlots.Length + (2 * doublePassengerSlots.Length) + ( 3 * triplePassengerSlots.Length)) as float)
            Debug.Trace("Passenger " + singlePassengerSlots.Length + " " + doublePassengerSlots.Length,0)
        endif
		akTerminalRef.AddTextReplacementValue("CrewSlots",  PlayerShip.GetShipRef().GetValue(CrewPassengerSlot_CrewAV) as int) 
		akTerminalRef.AddTextReplacementValue("PassengerSlots",  PlayerShip.GetShipRef().GetValue(CrewPassengerSlot_PassengerAV) as int) 
	endif
EndEvent

