ScriptName WakeUpDateMessageScript Extends Quest
{ Quest script for WakeUpDateMessage.esm }

GlobalVariable Property GameYear auto mandatory
GlobalVariable Property GameMonth auto mandatory
GlobalVariable Property GameDay auto mandatory
GlobalVariable Property GameHour auto mandatory
; GlobalVariable Property GameDaysPassed auto mandatory


Event OnQuestInit()
  Self.RegisterForPlayerSleep()
EndEvent

Event OnPlayerSleepStop(Bool abInterrupted, ObjectReference akBed)
  ; Debug.Notification(Utility.GameTimeToString(Utility.GetCurrentGameTime()))
  Debug.Notification(FormatDate(GameYear, GameMonth, GameDay, GameHour))
EndEvent

String Function FormatDate(GlobalVariable gameYear, GlobalVariable gameMonth, GlobalVariable gameDay, GlobalVariable gameHour)
  Return (GetMonth(gameMonth) + " " + (gameDay.GetValue() as Int) + ", " + GetYear(gameYear) + " " + GetTime(gameHour))
EndFunction

Int Function GetYear(GlobalVariable gameYear)
  Return (gameYear.GetValue() as Int) + 2000
EndFunction

String Function GetMonth(GlobalVariable gameMonth)
  If gameMonth.GetValue() == 1.0
    Return "January"
  elseif gameMonth.GetValue() == 2.0
    Return "February"
  elseif gameMonth.GetValue() == 3.0
    Return "March"
  elseif gameMonth.GetValue() == 4.0
    Return "April"
  elseif gameMonth.GetValue() == 5.0
    Return "May"
  elseif gameMonth.GetValue() == 6.0
    Return "June"
  elseif gameMonth.GetValue() == 7.0
    Return "July"
  elseif gameMonth.GetValue() == 8.0
    Return "August"
  elseif gameMonth.GetValue() == 9.0
    Return "September"
  elseif gameMonth.GetValue() == 10.0
    Return "October"
  elseif gameMonth.GetValue() == 11.0
    Return "November"
  elseif gameMonth.GetValue() == 12.0
    Return "December"
  EndIf
  Return "Error"
EndFunction

; String Function GetWeekDay(GlobalVariable gameDaysPassed)
;   Int daysAfterWednesday = ((Math.Floor(gameDaysPassed.GetValue()) as Int) % 7)
;   If daysAfterWednesday == 0
;     Return "Wednesday"
;   elseif daysAfterWednesday == 1
;     Return "Thursday"
;   elseif daysAfterWednesday == 2
;     Return "Friday"
;   elseif daysAfterWednesday == 3
;     Return "Saturday"
;   elseif daysAfterWednesday == 4
;     Return "Sunday"
;   elseif daysAfterWednesday == 5
;     Return "Monday"
;   elseif daysAfterWednesday == 6
;     Return "Tuesday"
;   EndIf
;   Return "Error"
; EndFunction

String Function GetTime(GlobalVariable gameHour)
  String currentHour = (Math.Floor(gameHour.GetValue()) as Int) as String
  String currentMinute = (Math.Floor((gameHour.GetValue() - (currentHour as Float)) * 60.0) as Int) as String
  If (((currentHour as Int) < 10) && (((currentHour as Int) % 10) as Bool)) || ((currentHour as Int) == 0)
    currentHour = "0" + currentHour
  EndIf
  If (((currentMinute as Int) < 10) && (((currentMinute as Int) % 10) as Bool)) || ((currentMinute as Int) == 0)
    currentMinute = "0" + currentMinute
  EndIf
  Return (currentHour + ":" + currentMinute + " UT")
EndFunction