ScriptName WakeUpDateMessageScript Extends Quest
{ Quest script for WakeUpDateMessage.esm }

GlobalVariable Property GameYear auto mandatory
GlobalVariable Property GameMonth auto mandatory
GlobalVariable Property GameDay auto mandatory


Event OnQuestInit()
  Self.RegisterForPlayerSleep()
EndEvent

Event OnPlayerSleepStop(Bool abInterrupted, ObjectReference akBed)
  ; Debug.Notification(Utility.GameTimeToString(Utility.GetCurrentGameTime()))
  Debug.Notification(FormatDate(GameYear, GameMonth, GameDay))
EndEvent

String Function FormatDate(GlobalVariable gameYear, GlobalVariable gameMonth, GlobalVariable gameDay)
  Return (GetMonth(gameMonth) + " " + (gameDay.GetValue() as Int) + ", " + GetYear(gameYear))
EndFunction

Int Function GetYear(GlobalVariable gameYear)
  Return (gameYear.GetValue() as Int) + 2000
EndFunction

String Function GetMonth(GlobalVariable gameMonth)
  If gameMonth.GetValue() == 1.0
    Return "January"
  elseif gameMonth.GetValue() == 2.0
    Return "February"
  elseif gameMonth.GetValue() == 3.0
    Return "March"
  elseif gameMonth.GetValue() == 4.0
    Return "April"
  elseif gameMonth.GetValue() == 5.0
    Return "May"
  elseif gameMonth.GetValue() == 6.0
    Return "June"
  elseif gameMonth.GetValue() == 7.0
    Return "July"
  elseif gameMonth.GetValue() == 8.0
    Return "August"
  elseif gameMonth.GetValue() == 9.0
    Return "September"
  elseif gameMonth.GetValue() == 10.0
    Return "October"
  elseif gameMonth.GetValue() == 11.0
    Return "November"
  elseif gameMonth.GetValue() == 12.0
    Return "December"
  EndIf
  Return "Error"
EndFunction