ScriptName Aurie:SkipCompanionQuestsScript Extends Quest Hidden

;-- Properties --------------------------------------

Group CompanionQuests_AutoFill
  Quest Property COM_Quest_Andreja_Q01 Auto Const Mandatory
  Quest Property COM_Quest_Barrett_Q01 Auto Const Mandatory
  Quest Property COM_Quest_SamCoe_Q01 Auto Const Mandatory
  Quest Property COM_Quest_SarahMorgan_Q01 Auto Const Mandatory
EndGroup

Group Messages_AutoFill
  Message Property Andreja_MSG_SkipChoice Auto Const Mandatory
  Message Property Barrett_MSG_SkipChoice Auto Const Mandatory
  Message Property Sam_MSG_SkipChoice Auto Const Mandatory
  Message Property Sarah_MSG_SkipChoice Auto Const Mandatory
  Message Property Andreja_MSG_AggieChoice Auto Const Mandatory
  Message Property Andreja_MSG_JaedaInfo Auto Const Mandatory
  Message Property Andreja_MSG_TomisarFate Auto Const Mandatory
  Message Property Sam_MSG_LillianChoice Auto Const Mandatory
EndGroup

GlobalVariable Property COM_PlayerMet_LilianHart Auto
sq_companionsscript Property SQ_Companions Auto Const mandatory
ReferenceAlias Property Alias_Barrett Auto Const mandatory
Activator Property COM_PQ_TxtReplace_QuestName_Barret Auto Const mandatory
MiscObject Property Credits Auto Const mandatory
GlobalVariable Property PlayerPaycheck Auto Const mandatory
GlobalVariable Property BQ01_Global_DetectivePoints Auto Const mandatory

;-- Functions ---------------------------------------

Event OnQuestInit()
  Self.RegisterForRemoteEvent(COM_Quest_Andreja_Q01 as ScriptObject, "OnStageSet")
  Self.RegisterForRemoteEvent(COM_Quest_Barrett_Q01 as ScriptObject, "OnStageSet")
  Self.RegisterForRemoteEvent(COM_Quest_SamCoe_Q01 as ScriptObject, "OnStageSet")
  Self.RegisterForRemoteEvent(COM_Quest_SarahMorgan_Q01 as ScriptObject, "OnStageSet")
EndEvent

Event Quest.OnStageSet(Quest akSender, Int auiStageID, Int auiItemID)
  If akSender == COM_Quest_Andreja_Q01 && auiStageID == 10
    Int AndrejaSkipChoice = Andreja_MSG_SkipChoice.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    If AndrejaSkipChoice == 1
      SkipAndrejaQuest(akSender)
    EndIf
    Self.UnRegisterForRemoteEvent(COM_Quest_Andreja_Q01 as ScriptObject, "OnStageSet")
  ElseIf akSender == COM_Quest_Barrett_Q01 && auiStageID == 200
    Int BarrettSkipChoice = Barrett_MSG_SkipChoice.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    If BarrettSkipChoice == 1
      SkipBarrettQuest(akSender)
    EndIf
    Self.UnRegisterForRemoteEvent(COM_Quest_Barrett_Q01 as ScriptObject, "OnStageSet")
  ElseIf akSender == COM_Quest_SamCoe_Q01 && auiStageID == 1
    Int SamSkipChoice = Sam_MSG_SkipChoice.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    If SamSkipChoice == 1
      SkipSamQuest(akSender)
    EndIf
    Self.UnRegisterForRemoteEvent(COM_Quest_SamCoe_Q01 as ScriptObject, "OnStageSet")
  ElseIf akSender == COM_Quest_SarahMorgan_Q01 && auiStageID == 10
    Int SarahSkipChoice = Sarah_MSG_SkipChoice.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
    If SarahSkipChoice == 1
      SkipSarahQuest(akSender)
    EndIf
    Self.UnRegisterForRemoteEvent(COM_Quest_SarahMorgan_Q01 as ScriptObject, "OnStageSet")
  EndIf
EndEvent

Function SkipSarahQuest(Quest akSender)
  ;Speak to Admiral Logan
  akSender.SetStage(20)
  ;--Proximity Trigger Fire Scene
  akSender.SetStage(23)
  ;--Intro Logan/Sarah Scene Done - Enable Regular Scene
  akSender.SetStage(25)
  ;Proceed to Cassiopeia I
  akSender.SetStage(30)
  ;Land Near Sarah's Campsite
  akSender.SetStage(40)
  ;Speak to Sarah
  akSender.SetStage(50)
  ;Proceed to Sarah's Campsite
  akSender.SetStage(60)
  ;Speak to Sarah
  akSender.SetStage(70)
  ;Locate an Emergency Power Cell
  akSender.SetStage(80)
  ;Picked up Power Cell
  ;akSender.SetStage(85)
  ;Install the Emergency Power Cell
  akSender.SetStage(90)
  ;Analyze the telemetry data
  akSender.SetStage(100)
  ;Speak to Sarah
  akSender.SetStage(110)
  ;Investigate the shuttle crash site
  akSender.SetStage(120)
  ;Campsite Proximity Trigger
  akSender.SetStage(130)
  ;Speak to the mysterious girl (trigger preamble)
  akSender.SetStage(140)
  ;--Preamble done - trigger main scene
  akSender.SetStage(145)
  ;Speak to Sarah
  akSender.SetStage(150)
  ;Retrieve genetags from the crew's gravesite
  akSender.SetStage(160)
  ;Spawn Boss Creature
  akSender.SetStage(165)
  ;Return to Sarah
  akSender.SetStage(170)
  ;--Trigger Greeting Scene
  akSender.SetStage(175)
  ;--Speak to Sarah
  akSender.SetStage(178)
  ;Allow Sona to Stay or Convince Sona to Leave
  akSender.SetStage(180)
  ;--Sona is Staying
  ;akSender.SetStage(185)
  ;--Sona is Leaving
  akSender.SetStage(190)
  ;Sarah Quick Sona Ship WrapUp
  akSender.SetStage(195)
  ;Proceed to the overlook
  akSender.SetStage(198)
  ;Arrived at Overlook for Scene
  akSender.SetStage(200)
  ;Speak to Sarah
  akSender.SetStage(205)
  ;Return to New Atlantis
  akSender.SetStage(210)
  ;Speak to Admiral Logan
  akSender.SetStage(220)
  ;Passenger Arrival Stage
  akSender.SetStage(221)
  ;Passenger Destination Stage
  akSender.SetStage(222)
  ;Remove Genetags
  akSender.SetStage(225)
  ;Speak to Sona
  akSender.SetStage(226)
  ;Speak to Sarah at the Colony War Memorial
  akSender.SetStage(230)
  ;--Memorial Arrival
  akSender.SetStage(232)
  ;--Memorial Talk
  akSender.SetStage(235)
  ;Speak to Sarah at the Waterfall in New Atlantis
  akSender.SetStage(240)
EndFunction

Function SkipAndrejaQuest(Quest akSender)
  Int AggieChoice = Andreja_MSG_AggieChoice.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  Utility.Wait(0.100000001)

  Int JadeaInfo = Andreja_MSG_JaedaInfo.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  Utility.Wait(0.100000001)

  Int TomisarFate = Andreja_MSG_TomisarFate.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  Utility.Wait(0.100000001)

  ; arrived in Akila, pointed to Aggie's
  akSender.SetStage(20)
  ; arrived in Aggie's, Trigger Andreja's forcegreet
  akSender.SetStage(25)
  ; Andreja force-greet at Aggie's done, EVP so she'll stop running it
  akSender.SetStage(29)
  ; Andreja forcegreet done, directed to Aggie
  akSender.SetStage(30)
  If AggieChoice == 0 || AggieChoice == 1
    ; Player Choice - told Aggie they care about Eren
    akSender.SetStage(31)
  ElseIf AggieChoice == 2
    ; Player Choice - told Aggie to skip the sob story
    akSender.SetStage(32)
  EndIf
  ; done with Aggie, directed to talk to Andreja
  akSender.SetStage(40)
  ; done talking to Andreja, directed to Hyla II
  akSender.SetStage(45)
  ; arrived on planet with Eren's camp, directed to talk to Andreja
  akSender.SetStage(50)
  ; done talking to Andreja, directed to camp
  akSender.SetStage(55)
  ; arrived at camp, attacked by zealots
  akSender.SetStage(60)
  ; enemies defeated, directed to talk to Andreja
  akSender.SetStage(70)
  ; done talking to Andreja, directed to search camp
  akSender.SetStage(75)
  ; note from Jaeda found, directed to Andreja
  akSender.SetStage(80)
  ; Done talking to Andreja about Jaeda, cue up scene about Tomisar
  akSender.SetStage(81)
  ; done talking to Andreja, directed to Den
  akSender.SetStage(85)
  ; arrived at Den, directed to ask around
  akSender.SetStage(90)
  If JadeaInfo == 0
    ; Rayna Speech Challenge Won
    akSender.SetStage(91)
  ElseIf JadeaInfo == 1
    ; Orval has offered to sell information about Jadea
    akSender.SetStage(94)
    ; Player bought information from Orval
    akSender.SetStage(95)
  EndIf
  ; pointed to Jaeda's location
  akSender.SetStage(100)
  ; arrived at location - Doesn't seem to be used so commenting out
  ; akSender.SetStage(110)
  ; Jaeda jumps in
  akSender.SetStage(120)
  ; initial hail done, zealots arrive
  akSender.SetStage(130)
  ; Zealot Ship 1 defeated
  akSender.SetStage(131)
  ; Zealot Ship 2 defeated
  akSender.SetStage(132)
  ; Zealot Ship 3 defeated
  akSender.SetStage(133)
  ; zealots defeated, 2nd hailing
  akSender.SetStage(140)
  ; 2nd Hail done, directed to board Jaeda's ship
  akSender.SetStage(150)
  ; boarded Jaeda's ship. Scene betweenJaeda and Andreja starts
  akSender.SetStage(160)
  ; Jaeda and Andreja done talking, directed to talk to Jaeda
  akSender.SetStage(170)
  ; Jaeda Scene done - Zealot Captain Jumps in
  akSender.SetStage(175)
  ; directed to player's ship
  akSender.SetStage(200)
  ; player back in ship, directed to kill captain
  akSender.SetStage(210)
  ; hailing scene done, directed to attack captain - Doesn't seem to be used so commenting out
  ;akSender.SetStage(220)
  ; Zealot captain destroyed, directed to pick up cargo - Doesn't seem to be used so commenting out
  ;akSender.SetStage(230)
  ; done with captain, directed to talk to Andreja
  akSender.SetStage(300)
  ; done talking to Andreja, directed to station
  akSender.SetStage(305)
  ; arrived at station, directed to follow Andreja
  akSender.SetStage(310)
  ; arrived at panel, directed to talk to Andreja
  akSender.SetStage(320)
  ; done talking to Andreja, waiting for her to open panel
  akSender.SetStage(330)
  ; Andreja has entered furniture for secret panel, call function to register
  akSender.SetStage(331)
  ; follow Andreja to Tomisar
  akSender.SetStage(340)
  ; Andreja hits 1st checkpoint for scene update
  akSender.SetStage(341)
  ; mid-scene checkpoint to update Tomisar's package
  akSender.SetStage(342)
  ; arrived at Tomisar, he starts his thing - Doesn't seem to be used so commenting out
  ; akSender.SetStage(350)
  ; scene with Tomisar and player
  akSender.SetStage(360)
  ; done talking to Tomisar, directed to talk to Andreja
  akSender.SetStage(370)
  If TomisarFate == 0
    ; player asked if there's some other way - opens option to turn over Tomisar
    akSender.SetStage(371)
    ; Player told Andreja to turn over Tomisar
    akSender.SetStage(385)
  ElseIf TomisarFate == 1
    ; player told Andreja to let Tomisar live
    akSender.SetStage(380)
    ; Final scene finished, Tomisar left alive. Andreja asks to return to Lodge
    akSender.SetStage(381)
  ElseIf TomisarFate == 2
    ; Player has offered to kill Tomisar
    akSender.SetStage(375)
  ElseIf TomisarFate == 3
    ; player convinced Andreja to kill Tomisar
    akSender.SetStage(390)
    ; Andreja has killed Tomisar
    akSender.SetStage(395)
  ElseIf TomisarFate == 4
    ; Player killed Tomisar after some other conclusion had been reached
    akSender.SetStage(399)
  EndIf
  ; Done with Tomisar, final conversation with Andreja
  akSender.SetStage(400)
  ; Done with Station, directed back to Lodge
  akSender.SetStage(500)
EndFunction

Function SkipBarrettQuest(Quest akSender)
  ; Stage 1 is debug mode. We do not want this so removed it
  ; Stage 305 - *DEBUG: Skip to Gagarin.
  ; * Checkpoint: Regular Path Selected. (Go to Gagarin)
  Self.SetStage(235)
  SQ_Companions.LockInCompanion(Alias_Barrett.GetActorReference() as companionactorscript, True, None, COM_PQ_TxtReplace_QuestName_Barret)
  ; Stage 1005 - *DEBUG: Skip to Ervin's Apartment Section.
  ; LOCATED: Law Office Exterior - This only starts a scene, so skip it
  ;Self.SetStage(405)
  ; FIND Ervin's Apartment. (QO) 
  Self.SetStage(1000)
  ; Stage 1205 - *DEBUG: Skip to Search Ervin's Apartment Section.
  ; SEARCH Ervin's Apartment (QO)
  Self.SetStage(1200)
  ; FOUND: All Evidence in Apartment. (QO)
  Self.SetStage(1201)
  BQ01_Global_DetectivePoints.Mod(4.0)
  ; FOUND Copy of License Application on Terminal. 
  Self.SetStage(1238)
  ; TALK to Barrett. (QO) - This is started in Self.SetStage(1201)
  ; Self.SetStage(1300)
  ; TALK to Ellie about Hunting License. (QO) 
  Self.SetStage(1600)
  ; Stage 1505 - *DEBUG: Skip to Town Hall section.
  ; TALKED to Barrett. (QO)
  Self.SetStage(1301)
  ; FIND Town Hall
  Self.SetStage(1500)
  ; Stage 2112 - CREDITS Player claimed their own paycheck.
  Game.GetPlayer().AddItem(Credits as Form, PlayerPaycheck.GetValue() as Int, False)
  ; Stage 6405 - *DEBUG: Skip to Talk to Dr. Keala
  ; *DEBUG: Skip to Find Helgi section.
  Self.SetStage(6305)
  ; TALKED to Dr. Keala "Where's Helgi" (QO)
  Self.SetStage(6400)
  ; Stage 6700 - TALK to Clint (QO)
  Self.SetObjectiveDisplayed(6700, True, False)
  ; HELGI
  ; TALK to Helgi (QO) 
  akSender.SetStage(7000)
  ; Helgi dialogue check
  akSender.SetStage(7002)
  ; Helgi dialogue check 2
  akSender.SetStage(7003)
  ; Helgi dialogue check 3
  akSender.SetStage(7004)
  ; SPEECH CHALLENGE WIN
  akSender.SetStage(7009)
  ; TALKED to Helgi. (QO) 
  akSender.SetStage(7101)
  ; TALK to Ellie. (QO) - Set by 7101
  ; akSender.SetStage(7300)
  ; TALKED to Ellie. (QO)
  akSender.SetStage(7301)
EndFunction

Function SkipBarrettQuestOLD(Quest akSender)
  ; TALKED to Barrett. (QO)
  akSender.SetStage(231)
  akSender.SetStage(251)
  ; TALK to Barrett on Gagarin. (QO)
  akSender.SetStage(300)
  ; TALKED to Barrett. "Gagarin" (QO)
  akSender.SetStage(301)
  ; * Checkpoint: Gagarin
  akSender.SetStage(310)
  ; * Checkpoint: Talk to Lawyer
  akSender.SetStage(315)
  ; TALK to Ellie Yankton. (QO)
  akSender.SetStage(400)
  ; TALKED to Ellie. (QO) 
  akSender.SetStage(401)
  ;akSender.SetStage(404)
  ;akSender.SetStage(405)
  ;akSender.SetStage(407)
  ; Stage 409
  akSender.SetStage(215)
  ; No Fragments, so skip them
  ;akSender.SetStage(410)
  ;akSender.SetStage(411)
  ;akSender.SetStage(412)
  ;akSender.SetStage(420)
  ;akSender.SetStage(430)
  ;akSender.SetStage(432)
  ;akSender.SetStage(1000)
  akSender.SetStage(1001)
  akSender.SetStage(1010)
  ; Sets 1025
  akSender.SetStage(1015)
  akSender.SetStage(1016)
  akSender.SetStage(1020)
  ; Set in stage 1015
  ;akSender.SetStage(1025)
  akSender.SetStage(1100)
  akSender.SetStage(1101)
  akSender.SetStage(1101)
  akSender.SetStage(1105)
  akSender.SetStage(1107)
  akSender.SetStage(1108)
  akSender.SetStage(1200)
  akSender.SetStage(1201)
  akSender.SetStage(1220)
  akSender.SetStage(1221)
  akSender.SetStage(1225)
  akSender.SetStage(1226)
  akSender.SetStage(1228)
  akSender.SetStage(1229)
  akSender.SetStage(1230)
  akSender.SetStage(1231)
  akSender.SetStage(1238)
  akSender.SetStage(1239)
  akSender.SetStage(1300)
  akSender.SetStage(1301)
  akSender.SetStage(1500)
  akSender.SetStage(1501)
  akSender.SetStage(1502)
  akSender.SetStage(1510)
  akSender.SetStage(1515)
  akSender.SetStage(1520)
  akSender.SetStage(1600)
  akSender.SetStage(1601)
  akSender.SetStage(1620)
  akSender.SetStage(2000)
  akSender.SetStage(2001)
  akSender.SetStage(2002)
  akSender.SetStage(2100)
  akSender.SetStage(2101)
  akSender.SetStage(2111)
  akSender.SetStage(2112)
  akSender.SetStage(2120)
  akSender.SetStage(2125)
  akSender.SetStage(2133)
  akSender.SetStage(2134)
  akSender.SetStage(2300)
  akSender.SetStage(2302)
  akSender.SetStage(2401)
  akSender.SetStage(2501)
  akSender.SetStage(2800)
  akSender.SetStage(2801)
  akSender.SetStage(5000)
  akSender.SetStage(5001)
  akSender.SetStage(5010)
  akSender.SetStage(5011)
  akSender.SetStage(5012)
  akSender.SetStage(5013)
  akSender.SetStage(5014)
  akSender.SetStage(5031)
  akSender.SetStage(5032)
  akSender.SetStage(5033)
  akSender.SetStage(5034)
  akSender.SetStage(5035)
  akSender.SetStage(5200)
  akSender.SetStage(5201)
  akSender.SetStage(5205)
  akSender.SetStage(5210)
  akSender.SetStage(5211)
  akSender.SetStage(5212)
  akSender.SetStage(5220)
  akSender.SetStage(5225)
  akSender.SetStage(5230)
  akSender.SetStage(5235)
  akSender.SetStage(6000)
  akSender.SetStage(6001)
  akSender.SetStage(6010)
  akSender.SetStage(6015)
  akSender.SetStage(6020)
  akSender.SetStage(6100)
  akSender.SetStage(6106)
  akSender.SetStage(6111)
  akSender.SetStage(6112)
  akSender.SetStage(6300)
  akSender.SetStage(6301)
  akSender.SetStage(6315)
  akSender.SetStage(6400)
  akSender.SetStage(6401)
  akSender.SetStage(6410)
  akSender.SetStage(6420)
  akSender.SetStage(6422)
  akSender.SetStage(6425)
  akSender.SetStage(6430)
  akSender.SetStage(6500)
  akSender.SetStage(6502)
  akSender.SetStage(6520)
  akSender.SetStage(7000)
  akSender.SetStage(7002)
  akSender.SetStage(7003)
  akSender.SetStage(7004)
  akSender.SetStage(7009)
  akSender.SetStage(7101)
  akSender.SetStage(7300)
  akSender.SetStage(7301)
EndFunction

Function SkipSamQuest(Quest akSender)
  Int LillianChoice = Sam_MSG_LillianChoice.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
  Utility.Wait(0.100000001)
  ; Stage 150 Arrived at Neon
  akSender.SetObjectiveCompleted(75, True)
  akSender.SetObjectiveDisplayed(100, True, False)
  ; Stage 300 Looking for Lillian Clue now
  akSender.SetObjectiveCompleted(100, True)
  akSender.SetObjectiveCompleted(200, True)
  akSender.SetObjectiveDisplayed(300, True, False)
  ; Stage_0350 CI Clue has been picked up
  akSender.SetObjectiveCompleted(300, True)
  akSender.SetObjectiveDisplayed(350, True, False)
  ;CI Clue has been read
  akSender.SetStage(400)
  ;Found out about CI Addy w/Sam
  akSender.SetStage(500)
  ;Arrived at CI Stage 510 - Skip it
  ;Arrival scene ends Stage 520 - Skip it
  ;Door Opened Scene Ends Stage 530 - Skip it
  ;Stage 600 - Entered the room
  akSender.SetObjectiveCompleted(500, True)
  akSender.SetObjectiveDisplayed(600, True, False)
  ;Found the papers
  akSender.SetStage(650)
  ;Stage 700 - Ready to go to Victor Compound
  akSender.SetObjectiveCompleted(650, True)
  akSender.SetObjectiveDisplayed(700, True, False)
  ;Stage 750 - Landed near Victor Compound
  akSender.SetObjectiveCompleted(700, True)
  akSender.SetObjectiveDisplayed(750, True, False)
  ;Stage 775 - Listened to Sam contacting Lillian
  akSender.SetStage(775)
  ;Stage 800 - Contacted Lillian - ready for extraction
  akSender.SetObjectiveCompleted(775, True)
  akSender.SetObjectiveDisplayed(800, True, False)
  ;Stage 825 - Near Lillian - Skip it
  ;Stage 850 - Lillian found
  akSender.SetObjectiveCompleted(800, True)
  akSender.SetObjectiveDisplayed(850, True, False)
  COM_PlayerMet_LilianHart.SetValue(1.0)
  ;Stage 860 - Left Victor Compound - Skip it
  ;Stage 875 - Lillian & Cora Reunion - Skip it
  ;Stage 890 - Reunion over - Skip it
  ;Stage 900 - Lillian debriefs about Valerie and Seokga
  akSender.SetStage(900)
  ;Stage 920 - Arrived at Dumas - Skip it
  ;Stage 930 - Dumas goes hostile - Skip it
  ;Stage 1000 - Dumas' Manifest Looted
  akSender.SetObjectiveCompleted(900, True)
  akSender.SetObjectiveDisplayed(1000, True, False)
  ;Stage 1100 - Lillian briefed about Cache
  akSender.SetStage(1100)
  ;Stage 1150 - Landed at Cache - Skip it
  ;Stage 1200 - Alarm triggered - fight starts
  akSender.SetStage(1200)
  ;Stage 1250 - Valerie Killed
  akSender.SetStage(1250)
  ;Stage 1300 - Combat Completed
  akSender.SetStage(1300)
  ;Stage 1400 - Finished Valerie talk
  akSender.SetStage(1400)
  If LillianChoice == 0
    ;Lillian will get vacations
    akSender.SetStage(1410)
  ElseIf LillianChoice == 1
    ;Lillian keeps the Cora status quo
    akSender.SetStage(1420)
  EndIf
  ;Stage 1500 - Finished talk with Sam at Cache
  akSender.SetStage(1500)
EndFunction
