ScriptName SRCBookAliasScript Extends ReferenceAlias

;-- Variables ---------------------------------------
inputEnableLayer disableFastTravelLayer

;-- Guards ------------------------------------------
Guard GravityGuard

;-- Properties --------------------------------------
sQ_PlayerShipScript Property SQ_PlayerShip Auto
Keyword Property SpaceshipLinkedInterior Auto
Keyword Property SpaceshipEnabledLandingLink Auto
FormList Property SRCLandingMarkers Auto
Furniture Property SRCLandingMarker Auto
Quest Property SRCSLandingQuest Auto
ReferenceAlias Property SRCSLandingQuestAlias Auto
Static Property XMarker Auto
Message Property SRCLandingMessage Auto
Message Property SRCLandingSuccessMessage Auto
Message Property SRCLandingFailedMessage Auto
Message Property SRCTakeOffMessage Auto
Message Property SRCGravityOffMessage Auto
Message Property SRCGravityOnMessage Auto
wwiseevent Property SRCGravitySound Auto Const mandatory

;-- Functions ---------------------------------------

Event OnEquipped(Actor akActor)
	spaceshipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	If akShip != None
		If (akShip.IsLanded() == True)
			SRCTakeOffMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
			akShip.TakeOff()
		ElseIf (akActor.IsInInterior() == False) && (akActor.IsInSpace() == False) && (akShip.IsLanded() == False)
			Land()
		ElseIf (akShip.IsInSpace() == True) && (akActor.GetParentCell() == akShip.GetLinkedCell(SpaceshipLinkedInterior))
			If (akActor.GetGravityScale() > 0.0)
				SRCGravityOffMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
				SetGravity(0.0 as Float)
			ElseIf (akActor.GetGravityScale() < 1.0)
				SRCGravityOnMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
				SetGravity(1.0 as Float)
			EndIf
		EndIf
	EndIf
	akActor.UnequipItem(Self.GetReference().GetBaseObject(), False, True)
EndEvent

Function SetGravity(Float gravity)
	Self.RegisterForCustomEvent(Self as ScriptObject, "SRCBookAliasScript_GravityChangeRequested")
	Var[] akArgs = new Var[1]
	akArgs[0] = gravity as Var
	Self.SendCustomEvent("SRCBookAliasScript_GravityChangeRequested", akArgs)
EndFunction

Event SRCBookAliasScript.GravityChangeRequested(SRCBookAliasScript akSender, Var[] akArgs)
	Guard GravityGuard
		Utility.Wait(0.01)
		spaceshipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
		Cell shipInterior = akShip.GetLinkedCell(SpaceshipLinkedInterior)
		Float gravity = akArgs[0] as Float
		SRCGravitySound.Play(akShip, None, None)
		Utility.Wait(1.0)
		shipInterior.SetGravityScale(gravity)
	EndGuard
EndEvent

Function TakeOff()
	spaceshipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	akShip.TakeOff()
EndFunction

Function Land()
	Self.RegisterForCustomEvent(Self as ScriptObject, "SRCBookAliasScript_LandingRequested")
	ObjectReference landingMarker = Self.FindLandingMarker()
	If landingMarker as Bool
		SRCLandingSuccessMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
		Var[] akArgs = new Var[1]
		akArgs[0] = landingMarker as Var
		Self.SendCustomEvent("SRCBookAliasScript_LandingRequested", akArgs)
	Else
		SRCLandingFailedMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	EndIf
EndFunction

Event SRCBookAliasScript.LandingRequested(SRCBookAliasScript akSender, Var[] akArgs)
	ObjectReference landingMarker = akArgs[0] as ObjectReference
	spaceshipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	SRCSLandingQuest.Stop()
	SRCSLandingQuest.Reset()
	disableFastTravelLayer = inputEnableLayer.Create()
	disableFastTravelLayer.EnableFastTravel(False)
	akShip.Disable(False)
	akShip.MoveTo(landingMarker, 0.0, 0.0, 0.0, True, False)
	akShip.SetLinkedRef(landingMarker, SpaceshipEnabledLandingLink, True)
	Self.RegisterForRemoteEvent(Game.GetPlayer() as ScriptObject, "OnLocationChange")
	SRCSLandingQuest.Start()
	SRCSLandingQuestAlias.ForceRefTo(landingMarker)
	SRCSLandingQuest.SetActive(True)
	SRCSLandingQuest.SetObjectiveDisplayed(100, True, False)
	akShip.Enable(False)
	akShip.EnableWithLanding()
	While SRCSLandingQuest.IsRunning() && !akShip.IsLanded()
		Utility.Wait(1.0)
	EndWhile
	Self.ShutDownLandingQuest()
EndEvent

Event Actor.OnLocationChange(Actor akSource, Location akOldLoc, Location akNewLoc)
	WorldSpace ws1 = Game.GetPlayer().GetWorldSpace()
	WorldSpace ws2 = SRCSLandingQuestAlias.GetRef().GetWorldSpace()
	If !ws1 || ws1 != ws2
		Self.ShutDownLandingQuest()
	EndIf
EndEvent

Function ShutDownLandingQuest()
	SRCSLandingQuest.CompleteAllObjectives()
	SRCSLandingQuest.CompleteQuest()
	SRCSLandingQuest.Stop()
	SRCSLandingQuest.Reset()
	If disableFastTravelLayer as Bool
		disableFastTravelLayer.EnableFastTravel(True)
		disableFastTravelLayer.Delete()
	EndIf
EndFunction

ObjectReference Function FindLandingMarker()
	Actor playerRef = Game.GetPlayer()
	spaceshipReference akShip = SQ_PlayerShip.PlayerShip.GetShipRef()
	ObjectReference landingMarker200 = Game.FindClosestReferenceOfAnyTypeInListFromRef(SRCLandingMarkers, playerRef as ObjectReference, 200.0)
	If landingMarker200 as Bool && akShip.CanLandAtMarker(landingMarker200) && !landingMarker200.IsFurnitureInUse(False)
		Return landingMarker200
	EndIf
	;SRCLandingMessage.Show(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)
	Float[] offsets = new Float[6]
	offsets[1] = 10.0
	offsets[5] = 180.0
	ObjectReference landingMarkerCustom = playerRef.PlaceAtMe(SRCLandingMarker as Form, 1, False, False, True, offsets, None, True)
	If Self.CheckLandingSpace(landingMarkerCustom) && akShip.CanLandAtMarker(landingMarkerCustom) && !landingMarker200.IsFurnitureInUse(False)
		Return landingMarkerCustom
	EndIf
	Return None
EndFunction

Bool Function CheckLandingSpace(ObjectReference markerRef)
	Int i = -30
	Int j = -30
	While i < 30
		While j < 30
			Float[] offsets = new Float[6]
			offsets[0] = i as Float
			offsets[1] = j as Float
			offsets[2] = 0.0
			offsets[3] = 0.0
			offsets[4] = 0.0
			offsets[5] = 0.0
			ObjectReference test1 = markerRef.PlaceAtMe(XMarker as Form, 1, False, False, True, offsets, None, False)
			ObjectReference test2 = markerRef.PlaceAtMe(XMarker as Form, 1, False, False, True, offsets, None, True)
			Float distance = test1.getDistance(test2)
			test1.Delete()
			test2.Delete()
			If distance > 2.0
				Return False
			EndIf
			j += 1
		EndWhile
		i += 1
	EndWhile
	Return True
EndFunction
