ScriptName qf_spawnships_derelict Extends Quest Const hidden

;-- Variables ---------------------------------------

;-- Properties --------------------------------------
ReferenceAlias Property Alias_Enemy01 Auto Const mandatory
ReferenceAlias Property Alias_Enemy02 Auto Const mandatory
ReferenceAlias Property Alias_Enemy03 Auto Const mandatory
ReferenceAlias Property Alias_Enemy04 Auto Const mandatory
ActorValue Property Aggression Auto Const mandatory
Form Property ShipToSpawn Auto Const mandatory


;-- Functions ---------------------------------------

Function Fragment_Stage_0005_Item_00()
  Alias_Enemy01.GetShipRef().SetValue(Aggression, 0.0) ; #DEBUG_LINE_NO:7
  Alias_Enemy02.GetShipRef().SetValue(Aggression, 1.0) ; #DEBUG_LINE_NO:8
  Alias_Enemy03.GetShipRef().SetValue(Aggression, 1.0) ; #DEBUG_LINE_NO:9
  Alias_Enemy04.GetShipRef().SetValue(Aggression, 1.0) ; #DEBUG_LINE_NO:10
EndFunction

Function DisableShip(spaceshipreference ship)
  ; #SetupDamagedShip
  ship.SetValue(Aggression, 0.0)
 
  ActorValue ShipSystemEngineHealth = Game.GetFormFromFile(2027725, "Starfield.esm") as ActorValue
  ActorValue ShipSystemWeaponGroup1Health = Game.GetFormFromFile(931, "Starfield.esm") as ActorValue
  ActorValue ShipSystemWeaponGroup2Health = Game.GetFormFromFile(932, "Starfield.esm") as ActorValue
  ActorValue ShipSystemWeaponGroup3Health = Game.GetFormFromFile(933, "Starfield.esm") as ActorValue
  ActorValue ShipSystemShieldsHealth = Game.GetFormFromFile(2025673, "Starfield.esm") as ActorValue
  ActorValue ShipSystemGravDriveHealth = Game.GetFormFromFile(2027723, "Starfield.esm") as ActorValue
  
  ship.DamageValue(ShipSystemEngineHealth, ship.GetValue(ShipSystemEngineHealth))
  ship.EnablePartRepair(ShipSystemEngineHealth, False)

  ship.DamageValue(ShipSystemWeaponGroup1Health, ship.GetValue(ShipSystemWeaponGroup1Health))
  ship.EnablePartRepair(ShipSystemWeaponGroup1Health, False)

  ship.DamageValue(ShipSystemWeaponGroup2Health, ship.GetValue(ShipSystemWeaponGroup2Health))
  ship.EnablePartRepair(ShipSystemWeaponGroup2Health, False)

  ship.DamageValue(ShipSystemWeaponGroup3Health, ship.GetValue(ShipSystemWeaponGroup3Health))
  ship.EnablePartRepair(ShipSystemWeaponGroup3Health, False)

  ship.DamageValue(ShipSystemShieldsHealth, ship.GetValue(ShipSystemShieldsHealth))
  ship.EnablePartRepair(ShipSystemShieldsHealth, False)

  ship.DamageValue(ShipSystemGravDriveHealth, ship.GetValue(ShipSystemGravDriveHealth))
  ship.EnablePartRepair(ShipSystemGravDriveHealth, False)

  ship.RemoveFromAllFactions()
  Faction CrimeFactionCrimsonFleet = Game.GetFormFromFile(68400, "Starfield.esm") as Faction
  ship.AddToFaction(CrimeFactionCrimsonFleet)

  ; Note that this does remove the crew, however it breaks the cockpit/takeover stuff
  ;ActorValue SpaceshipCrew = Game.GetFormFromFile(265440, "Starfield.esm") as ActorValue
  ;ship.SetValue(SpaceshipCrew, 0)
  ;Keyword BEDerelict = Game.GetFormFromFile(1305684, "Starfield.esm") as Keyword
 ; FormList BEHazardKeywordList = Game.GetFormFromFile(1576408, "Starfield.esm") as FormList
 ; Keyword[] hazardKeywords = BEHazardKeywordList.GetArray(False) as Keyword[]
 ; Int hazard = Utility.RandomInt(0, 24)
  ;ship.AddKeyword(hazardKeywords[hazard])
  ;ship.AddKeyword(BEDerelict)

EndFunction

Function Fragment_Stage_0007_Item_00()
  Self.DisableShip(Alias_Enemy01.GetShipRef())
  Utility.wait(1.0) ; #DEBUG_LINE_NO:18
  Self.setstage(10) ; #DEBUG_LINE_NO:19
EndFunction

Function Fragment_Stage_0010_Item_00()
  Alias_Enemy01.GetShipRef().SetValue(Aggression, 0.0) ; #DEBUG_LINE_NO:27
  Self.SetStage(1000)
  Self.Stop()
EndFunction