ScriptName qf_spawnships_underfire Extends Quest Const hidden

;-- Variables ---------------------------------------

;-- Properties --------------------------------------
ReferenceAlias Property Alias_Enemy01 Auto Const mandatory
ReferenceAlias Property Alias_Enemy02 Auto Const mandatory
ReferenceAlias Property Alias_Enemy03 Auto Const mandatory
ReferenceAlias Property Alias_Enemy04 Auto Const mandatory
ActorValue Property Aggression Auto Const mandatory
Form Property ShipToSpawn Auto Const mandatory


;-- Functions ---------------------------------------

Function Fragment_Stage_0005_Item_00()
  Alias_Enemy01.GetShipRef().SetValue(Aggression, 0.0) ; #DEBUG_LINE_NO:7
  Alias_Enemy02.GetShipRef().SetValue(Aggression, 1.0) ; #DEBUG_LINE_NO:8
  Alias_Enemy03.GetShipRef().SetValue(Aggression, 1.0) ; #DEBUG_LINE_NO:9
  Alias_Enemy04.GetShipRef().SetValue(Aggression, 1.0) ; #DEBUG_LINE_NO:10

EndFunction

Function DisableShip(spaceshipreference ship)
  ; #SetupDamagedShip
  ship.SetValue(Aggression, 0.0)
 
  ActorValue ShipSystemEngineHealth = Game.GetFormFromFile(2027725, "Starfield.esm") as ActorValue
  ActorValue ShipSystemWeaponGroup1Health = Game.GetFormFromFile(931, "Starfield.esm") as ActorValue
  ActorValue ShipSystemWeaponGroup2Health = Game.GetFormFromFile(932, "Starfield.esm") as ActorValue
  ActorValue ShipSystemWeaponGroup3Health = Game.GetFormFromFile(933, "Starfield.esm") as ActorValue
  ActorValue ShipSystemShieldsHealth = Game.GetFormFromFile(2025673, "Starfield.esm") as ActorValue
  ActorValue ShipSystemGravDriveHealth = Game.GetFormFromFile(2027723, "Starfield.esm") as ActorValue
  
  ship.DamageValue(ShipSystemEngineHealth, ship.GetValue(ShipSystemEngineHealth) * 2)
  ship.EnablePartRepair(ShipSystemEngineHealth, True)

  ship.DamageValue(ShipSystemWeaponGroup1Health, ship.GetValue(ShipSystemWeaponGroup1Health)* 2)
  ship.EnablePartRepair(ShipSystemWeaponGroup1Health, True)

  ship.DamageValue(ShipSystemWeaponGroup2Health, ship.GetValue(ShipSystemWeaponGroup2Health)* 2)
  ship.EnablePartRepair(ShipSystemWeaponGroup2Health, True)

  ship.DamageValue(ShipSystemWeaponGroup3Health, ship.GetValue(ShipSystemWeaponGroup3Health)* 2)
  ship.EnablePartRepair(ShipSystemWeaponGroup3Health, True)

  ship.DamageValue(ShipSystemShieldsHealth, ship.GetValue(ShipSystemShieldsHealth)* 2)
  ship.EnablePartRepair(ShipSystemShieldsHealth, True)

  ship.DamageValue(ShipSystemGravDriveHealth, ship.GetValue(ShipSystemGravDriveHealth)* 2)
  ship.EnablePartRepair(ShipSystemGravDriveHealth, True)

  ; Note that this does remove the crew, however it breaks the cockpit/takeover stuff
  ;ActorValue SpaceshipCrew = Game.GetFormFromFile(265440, "Starfield.esm") as ActorValue
  ;ship.SetValue(SpaceshipCrew, 0)
  ;Keyword BEDerelict = Game.GetFormFromFile(1305684, "Starfield.esm") as Keyword
 ; FormList BEHazardKeywordList = Game.GetFormFromFile(1576408, "Starfield.esm") as FormList
 ; Keyword[] hazardKeywords = BEHazardKeywordList.GetArray(False) as Keyword[]
 ; Int hazard = Utility.RandomInt(0, 24)
  ;ship.AddKeyword(hazardKeywords[hazard])
  ;ship.AddKeyword(BEDerelict)

EndFunction

Function Fragment_Stage_0007_Item_00()
  Self.DisableShip(Alias_Enemy01.GetShipRef())
  Float[] placePosition = new Float[6] 
  placePosition[0] = (Utility.RandomFloat(-10, 10) * 50)
  placePosition[1] = (Utility.RandomFloat(-10, 10) * 50)
  placePosition[2] = (Utility.RandomFloat(-10, 10) * 50)
  spaceshipreference myNewShip = Alias_Enemy01.GetShipRef().PlaceShipAtMe(ShipToSpawn, 4, True, False, False, True, placePosition, None, None, True)
  myNewShip.StartCombat(Alias_Enemy01.GetShipRef(),True)
  myNewShip.SetValue(Aggression, 1.0)
  Alias_Enemy02.GetShipRef().StartCombat(Alias_Enemy01.GetShipRef(),False)
  Alias_Enemy03.GetShipRef().StartCombat(Alias_Enemy01.GetShipRef(),False)
  Alias_Enemy04.GetShipRef().StartCombat(Alias_Enemy01.GetShipRef(),False)
  Utility.wait(1.0) ; #DEBUG_LINE_NO:18
  Self.setstage(10) ; #DEBUG_LINE_NO:19
EndFunction

Function Fragment_Stage_0010_Item_00()
  Alias_Enemy01.GetShipRef().SetValue(Aggression, 0.0) ; #DEBUG_LINE_NO:27
  Self.SetStage(1000)
  Self.Stop()
EndFunction