import struct
import os
def calculate_division_factor(desired_in_game_minutes):
    real_minutes = 60.0  
    division_factor = real_minutes / desired_in_game_minutes
    return division_factor
def float_to_bytes(f):
    return struct.pack('<f', f)
def bytes_to_float(b):
    return struct.unpack('<f', b)[0]
tolerance = 1e-6
original_floats = []
with open('changeTimescale.dat', 'rb') as file:
    while True:
        byte_chunk = file.read(4)
        if not byte_chunk:
            break
        float_value = bytes_to_float(byte_chunk)
        original_floats.append(float_value)
while True:
    try:
        desired_in_game_minutes = float(input("Enter desired in-game minutes per real minute: "))
        if desired_in_game_minutes <= 0:
            raise ValueError("Desired in-game minutes must be greater than zero.")
        break
    except ValueError as e:
        print(f"Error: {e}. Please enter a valid number greater than zero.")
division_factor = calculate_division_factor(desired_in_game_minutes)
new_floats = [f / division_factor for f in original_floats]
with open('changeTimescale.dat', 'rb') as file:
    data = file.read()
modified_data = bytearray(data)
for i in range(0, len(data), 4):
    current_bytes = data[i:i+4]
    current_float = bytes_to_float(current_bytes)
    for j, orig in enumerate(original_floats):
        if abs(current_float - orig) < tolerance:
            new_float = new_floats[j]
            new_bytes = float_to_bytes(new_float)
            modified_data[i:i+4] = new_bytes
            break
subfolder_name = f"1 real minute is {desired_in_game_minutes} in-game minutes"
os.makedirs(subfolder_name, exist_ok=True)
output_file_path = os.path.join(subfolder_name, 'timescales.dat')
with open(output_file_path, 'wb') as file:
    file.write(modified_data)
print(f"Modification completed. Output file saved to: {output_file_path}")
