Scriptname CS7_SpaceshipLandingQuestScript extends Quest
{Quest script for SpaceShipLandingReloaded.esm}

sq_playershipscript Property SQ_PlayerShip Auto
sq_followersscript Property SQ_Followers Auto
Keyword Property SpaceshipEnabledLandingLink Auto
Keyword Property CurrentInteractionLinkedRefKeyword Auto
Keyword Property SpaceshipPreventRampOpenOnLanding Auto
Keyword Property LocTypeOutpost Auto
LocationRefType Property Ship_PilotSeat_RefType Auto
Spell Property CS7_BlackImodSpell Auto



spaceshipreference playerShipRef
Actor[] currentFollowers
Actor[] crewMembers
Bool bPlayerInShipPilotSeat
Bool bFollowersArePaused
Bool bCrewIsSilenced
Bool bPlayerInShipInSpace
Int PayerInShipInSpaceTimer = 10


EVENT OnQuestInit()
	Actor PlayerRef = Game.GetPlayer()
	Self.RegisterForRemoteEvent(PlayerRef, "OnSit") 
	Self.RegisterForRemoteEvent(PlayerRef, "OnGetUp")
	Self.RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
	Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ReferenceAlias, "OnShipFarTravel")
	Self.RegisterForMenuOpenCloseEvent("GalaxyStarMapMenu")
ENDEVENT


EVENT Actor.OnPlayerLoadGame(Actor akSender)
	If (Game.IsPluginInstalled("SpaceShipLandingReloaded.esm") == False)
		Self.UnregisterForAllRemoteEvents()
		Self.UnregisterForAllMenuOpenCloseEvents()
		CancelTimer(PayerInShipInSpaceTimer)
		Self.Stop()
		Debug.Notification("Script events unregistered and quest ended.")
	EndIf
ENDEVENT


EVENT OnTimer(Int aiTimerID)
	If aiTimerID == PayerInShipInSpaceTimer
		bPlayerInShipInSpace = False
	Endif
ENDEVENT


EVENT Actor.OnSit(Actor akSender, ObjectReference akFurniture)
	If (akSender == Game.GetPlayer()) && akFurniture.HasRefType(Ship_PilotSeat_RefType)
		bPlayerInShipPilotSeat = True
    EndIf
ENDEVENT


EVENT Actor.OnGetUp(Actor akSender, ObjectReference akFurniture)
	If (akSender == Game.GetPlayer()) && akFurniture.HasRefType(Ship_PilotSeat_RefType)
		bPlayerInShipPilotSeat = False
	EndIf
ENDEVENT


EVENT OnMenuOpenCloseEvent(String asMenuName, Bool abOpening)
	If asMenuName == "GalaxyStarMapMenu"
		if abOpening
			Self.ResetPayerInShipInSpaceBool()
			bPlayerInShipInSpace = Self.GetPayerInShipInSpaceBool()
			; if this is true we are in our ship in space, when using the Star Map
			; if false we won't get a valid fartravel for landing reload
		else
			StartTimer(10.0, PayerInShipInSpaceTimer)	; hold it for max 10 sec for potato PC and XBOX
		endif
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipFarTravel(ReferenceAlias akSender, Location aDepartureLocation, Location aArrivalLocation, Int aState)
	If (akSender == SQ_PlayerShip.PlayerShip) && (aState == 0)
		playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
		planet thePlanetOrbit = aDepartureLocation.GetCurrentPlanet()
		planet thePlanetSurface = aArrivalLocation.GetCurrentPlanet()
		if ((thePlanetOrbit != thePlanetSurface) || playerShipRef.IsLanded() || !playerShipRef.IsInSpace() || !bPlayerInShipInSpace)
			Self.ResetPayerInShipInSpaceBool()
			RETURN
			; we can exclude far travel to other planets/orbits and any travel from planet surface to surface/orbit (same or different planet)
			; and the first time landing at new landing site (player set marker or site marker) - vanilla landing animation
		else
			Actor PlayerRef = Game.GetPlayer()
			PlayerRef.AddSpell(CS7_BlackImodSpell, False)
			if !bFollowersArePaused
				Self.PauseFollowers()
			endif
			playerShipRef.AddKeyword(SpaceshipPreventRampOpenOnLanding)
			Self.RegisterForRemoteEvent(PlayerRef, "OnLocationChange")
			Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ReferenceAlias, "OnLocationChange")
			Self.RegisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ReferenceAlias, "OnShipLanding")
			PlayerRef.SetGhost(True)
			Debug.SetGodMode(True)
			Self.ResetPayerInShipInSpaceBool()

			Utility.Wait(0.01)	; wait for the event to finish loading screen
			Game.FadeOutGame(False, True, 2.0, 0.00015, False)	; need to have min 1 sec here
		endif
	EndIf
ENDEVENT


EVENT Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
	Self.UnregisterForRemoteEvent(Game.GetPlayer() as Actor, "OnLocationChange")
	If !bPlayerInShipPilotSeat	; cannot be true, but just in case
		Game.FadeOutGame(False, True, 4.0, 0.00015, False)	; 3 to max 4 sec black screen
		Game.GetPlayer().AddSpell(CS7_BlackImodSpell, False)
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnLocationChange(ReferenceAlias akSender, Location akOldLoc, Location akNewLoc)
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ReferenceAlias, "OnLocationChange")
	If (akSender != SQ_PlayerShip.PlayerShip) || (akOldLoc == akNewLoc) || bPlayerInShipPilotSeat || Game.GetPlayer().GetParentCell().IsInterior() || (akNewLoc != Game.GetPlayer().GetCurrentLocation())
		; travel from planet orbit to interior cell on same planet (e.g. Neon Core)
		; game is going to handle the landing - no animated landing
		playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
		playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
		Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ReferenceAlias, "OnShipLanding")
		Self.UnregisterForRemoteEvent(Game.GetPlayer() as Actor, "OnLocationChange")
		if playerShipRef.Is3DLoaded()
			Self.OpenOrCloseLandingRamps(playerShipRef, True)
		else
			Self.RegisterForRemoteEvent(playerShipRef as ObjectReference, "OnLoad")
		endif
		Game.GetPlayer().RemoveSpell(CS7_BlackImodSpell)
		if bFollowersArePaused
			if bPlayerInShipPilotSeat
				Self.UnpauseFollowers(False)
			else
				Self.UnpauseFollowers(True)
			endif
		endif
		Debug.SetGodMode(False)
		if Game.GetPlayer().IsGhost()
			Game.GetPlayer().SetGhost(False)
		endif
	Else
		if !bCrewIsSilenced
			Self.DisableCrewAI()
		endif
		if Game.GetPlayer().GetCurrentLocation().HasKeyword(LocTypeOutpost) && akNewLoc.HasKeyword(LocTypeOutpost)
			Game.FadeOutGame(False, True, 5.0, 0.00015, False)
		endif
	EndIf
ENDEVENT


EVENT ReferenceAlias.OnShipLanding(ReferenceAlias akSender, Bool abComplete)
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ReferenceAlias, "OnShipLanding")
	Self.UnregisterForRemoteEvent(SQ_PlayerShip.PlayerShip as ReferenceAlias, "OnLocationChange")
	Self.UnregisterForRemoteEvent(Game.GetPlayer() as Actor, "OnLocationChange")
	If !bPlayerInShipPilotSeat
		playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
		ObjectReference LandingMarker = Self.GetShipLandingMarker(playerShipRef)
		if (LandingMarker as Bool)	; play landing animation
			Game.GetPlayer().AddSpell(CS7_BlackImodSpell, False)
			Game.FadeOutGame(False, True, 5.0, 0.00015, False)
			playerShipRef.MoveTo(LandingMarker, 0.0, 0.0, 155.0, True, False)
			Game.FadeOutGame(False, True, 5.0, 0.00015, False)
			playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
			if playerShipRef.IsRampDown()
				Self.OpenOrCloseLandingRamps(playerShipRef, False)
			endif
			Self.MovePlayerIntoPilotSeat(SQ_PlayerShip.PlayerShipPilotSeat.GetRef())
			Game.FadeOutGame(False, True, 2.0, 0.5, True)	; need to have 2 sec here!
			Game.GetPlayer().RemoveSpell(CS7_BlackImodSpell)
			playerShipRef.SetLinkedRef(LandingMarker, SpaceshipEnabledLandingLink, True)
			playerShipRef.EnableWithLanding()
			Self.EnableCrewAI()
			Utility.Wait(0.01)
			playerShipRef.SetAngle(LandingMarker.GetAngleX(), LandingMarker.GetAngleY(), LandingMarker.GetAngleZ())
		else
			; travel from planet orbit to exterior cell on same planet (e.g. Loge, Mast, etc.)
			; game is going to handle the landing - no landing animation
			playerShipRef.RemoveKeyword(SpaceshipPreventRampOpenOnLanding)
			Game.GetPlayer().RemoveSpell(CS7_BlackImodSpell)
			if playerShipRef.Is3DLoaded()
				Self.OpenOrCloseLandingRamps(playerShipRef, True)
			else
				Self.RegisterForRemoteEvent(playerShipRef as ObjectReference, "OnLoad")
			endif
			Self.EnableCrewAI()
		endif
		if bFollowersArePaused
			Self.UnpauseFollowers(True)
		endif
		Debug.SetGodMode(False)
		if Game.GetPlayer().IsGhost()
			Game.GetPlayer().SetGhost(False)
		endif
	EndIf
	If Game.GetPlayer().HasSpell(CS7_BlackImodSpell)
		Game.GetPlayer().RemoveSpell(CS7_BlackImodSpell)
	Endif
ENDEVENT


EVENT ObjectReference.OnLoad(ObjectReference akSource)
	Self.UnregisterForRemoteEvent(playerShipRef as ObjectReference, "OnLoad")
	If !playerShipRef.IsInSpace()
		Self.OpenOrCloseLandingRamps(playerShipRef, True)
	EndIf
ENDEVENT


Bool Function GetPayerInShipInSpaceBool()
	Bool returnVal = False
	Location playerLocation = Game.GetPlayer().GetCurrentLocation()
	if (playerLocation == SQ_PlayerShip.playerShipInteriorLocation.GetLocation()) && SQ_PlayerShip.PlayerShip.GetShipRef().IsInSpace()
		returnVal = True
	Endif
	Return returnVal
EndFunction


Function ResetPayerInShipInSpaceBool()
	CancelTimer(PayerInShipInSpaceTimer)
	bPlayerInShipInSpace = False
EndFunction


ObjectReference Function GetShipLandingMarker(spaceshipreference akShip)
	ObjectReference theLandingMarker
	ObjectReference MarkerRef = akShip.GetLinkedRef(SQ_PlayerShip.LandingMarkerKeyword)
	If MarkerRef && ((MarkerRef.GetDistance(Game.GetPlayer()) < 200) || MarkerRef.GetCurrentLocation().HasKeyword(LocTypeOutpost))
		theLandingMarker = MarkerRef
	Else
		MarkerRef = akShip.GetLinkedRef(CurrentInteractionLinkedRefKeyword)
		If MarkerRef && (MarkerRef.GetDistance(Game.GetPlayer()) < 150)
			theLandingMarker = MarkerRef
		EndIf
	EndIf
	Return theLandingMarker
EndFunction


Function MovePlayerIntoPilotSeat(ObjectReference akPilotSeat)
	playerShipRef = SQ_PlayerShip.PlayerShip.GetShipRef()
	inputenablelayer myEnableLayer = inputenablelayer.Create()
	myEnableLayer.DisablePlayerControls(True, True, True, False, False, True, True, False, True, True, False)	; default disable + abCamSwitch=True
	Game.FadeOutGame(False, True, 5.0, 0.00015, False)	; need to have min 4 sec here!
	If (Self.PopPlayerIntoPilotSeat(akPilotSeat) == False)
		Game.GetPlayer().MoveToFurniture(akPilotSeat)
	EndIf
	Utility.Wait(0.01)
	myEnableLayer.Delete()
EndFunction


Bool Function PopPlayerIntoPilotSeat(ObjectReference akTargetFurniture)
	Actor PlayerRef = Game.GetPlayer()
	PlayerRef.MoveTo(akTargetFurniture, 0.0, 0.0, 0.0, True, False)
	Game.FadeOutGame(False, True, 2.0, 0.00015, False)	; need to have min 1.5 sec here!
	Return PlayerRef.SnapIntoInteraction(akTargetFurniture)
EndFunction


Function OpenOrCloseLandingRamps(spaceshipreference akShip, Bool bOpen = True)
	ObjectReference[] landingRamps = playerShipRef.GetLandingRamps()
	If (landingRamps != None)
		Int i = 0
		While i < landingRamps.Length
			landingRamps[i].SetOpen(bOpen)
			i += 1
		EndWhile
	EndIf
EndFunction


Function PauseFollowers()
	bFollowersArePaused = True
	currentFollowers = Game.GetPlayerFollowers()
	int i = 0
	While (i < currentFollowers.Length)
		SQ_Followers.SetRoleInactive(currentFollowers[i], False, False, False)
;		currentFollowers[i].DisableNoWait(False)
		i += 1
	EndWhile
EndFunction


Function UnpauseFollowers(Bool bMoveToPlayer = False)
	bFollowersArePaused = False
	Actor PlayerRef = Game.GetPlayer()
	int i = 0
	While (i < currentFollowers.Length)
;		If currentFollowers[i].IsDisabled()
;			currentFollowers[i].Enable(False)
;		EndIf
		SQ_Followers.SetRoleActive(currentFollowers[i], False, True, 0.0, 0.0)
		if bMoveToPlayer
			currentFollowers[i].MoveTo(PlayerRef as ObjectReference, 0.0, 0.0, 0.0, True, False)
		endif
		SQ_Followers.CommandFollow(currentFollowers[i])
		currentFollowers[i].EvaluatePackage(False)
		i += 1
	EndWhile
EndFunction

;/
Function DisableFollowers()
	int i = 0	
	While (i < currentFollowers.Length)
		currentFollowers[i].DisableNoWait(False)
		currentFollowers[i].EnableNoWait(False)
		i += 1
	EndWhile
EndFunction
/;

Function DisableCrewAI()
	bCrewIsSilenced = True
	crewMembers = playerShipRef.GetAllCrewMembers()
	int i = 0
	While (i < crewMembers.Length)
		crewMembers[i].EnableAI(False, True)
		i += 1
	EndWhile
EndFunction


Function EnableCrewAI()
	bCrewIsSilenced = False
	int i = 0
	While (i < crewMembers.Length)
		if !crewMembers[i].IsAIEnabled()
			crewMembers[i].EnableAI(True, False)
		endif
		i += 1
	EndWhile
EndFunction
