Scriptname SPE_SelfRepair extends ReferenceAlias
{When your home ship is hit by fire without shields, detect when the hull damage is at a specified level and automatically use Ship Parts to repair the hull damage.}


Import debug


Bool Property cooldown = false Auto Hidden

ActorValue Property Health Auto
{The actor value that determines health.}

MagicEffect Property RestoreHealthShip Auto
{The magic effect applied to the home ship when hull damage is below the threshold.}

Potion Property ShipRepairKit Auto
{The potion object for Ship Parts used to repair the hull.}

Spell Property SPE_ShipRepairSpell Auto
{The custom spell used to trigger the potion effects.}

GameplayOption Property SPE_GPO_ShipAutoRepair Auto
{The gameplay option that determines whether this feature is enabled and the hull damage threshold is reached.}



Event OnInit()

    GotoState("detectionOn")

EndEvent



State detectionOn

    Event OnShipSystemDamaged(ActorValue akSystem, int aBlocksLost, bool aElectromagneticDamage, bool aFullyDamaged)

        GotoState("detectionOff")

        SpaceshipReference myShip = self.GetShipRef()
        Float shipHealth = myShip.GetValuePercentage(Health)

        If SPE_GPO_ShipAutoRepair.GetValue() > 0

            If !myShip.HasMagicEffect(RestoreHealthShip)

                Float repairThreshold = getRepairMode()

                If shipHealth < repairThreshold

                    Actor thePlayer = game.GetPlayer()

                    If myShip.GetItemCount(ShipRepairKit) > 0
                        SPE_ShipRepairSpell.RemoteCast(myShip, thePlayer)
                        myShip.RemoveItem(ShipRepairKit, 1)
                        Notification("Ship Repairing!")
                    Else
                        Notification("No Ship Parts for Repair!")
                    Endif
                EndIf

            EndIf

        Endif

        utility.Wait(3)
        GotoState("detectionOn")

    EndEvent

EndState



;Check the gameplay option setting and return the ship threshold a float.
Float Function getRepairMode()

    Int repairMode = SPE_GPO_ShipAutoRepair.GetValue() as Int

    If repairMode == 1
        return 0.20
    ElseIf repairMode == 2
        return 0.40
    ElseIf repairMode == 3
        return 0.60
    EndIf

EndFunction