ScriptName AUR:CompanionBioIDHandler extends Quest

Group Lists
{Form Lists for injection}
FormList Property CharGenPresets Auto Mandatory
FormList Property ChargenPresets_Swap Auto Mandatory
EndGroup

Group NPCs
{Arrays of NPCs you want to add to the Form Lists}
ActorBase[] Property CharGenPresetsAdditions Auto Const
ActorBase[] Property ChargenPresets_SwapAdditions Auto Const
EndGroup

Event OnQuestInit()
  Self.UpdateFormLists()
EndEvent

Function UpdateFormLists()
  Self.AddActorsToFormList(CharGenPresets, CharGenPresetsAdditions)
  Self.AddActorsToFormList(ChargenPresets_Swap, ChargenPresets_SwapAdditions)
EndFunction

Function AddActorsToFormList(FormList fl, ActorBase[] ab)
  ;Check how many actors are in the array
  int iPresets = ab.Length
  ;If there is at least 1 actor
  If (iPresets > 0)
    int iCurrentPreset = 0    
    while (iCurrentPreset < iPresets)
      ;Check to make sure it doesn't already exist in the list
      If !fl.HasForm(ab[iCurrentPreset] as Form)
        fl.AddForm(ab[iCurrentPreset] as Form)
      EndIf
      iCurrentPreset += 1
    endWhile
  EndIf
EndFunction