   /*-----------------------------------------------------------.
  /                           Custom                            /
  '-----------------------------------------------------------*/
/*

*/

//>ReinhardLinear settings<\\


float4 CustomPass( float4 colorInput, float2 tex )
{

	float3 x = colorInput.rgb;

  const float W = ReinhardLinearWhitepoint;	        // Linear White Point Value
  const float L = ReinhardLinearPoint;           // Linear point
  const float C = ReinhardLinearSlope;           // Slope of the linear section
  const float K = (1 - L * C) / C; // Scale (fixed so that the derivatives of the Reinhard and linear functions are the same at x = L)
  float3 reinhard = L * C + (1 - L * C) * (1 + K * (x - L) / ((W - L) * (W - L))) * (x - L) / (x - L + K);

  // gamma space or not?
  colorInput.rgb = (x > L) ? reinhard : C * x;
  
	return colorInput;
}