  /*----------------------------------------.
      .-.                   .  .---..   .
     (   )                 _|_ |     \ / 
      `-..  .    ._.-.  .-. |  |---   /  
     (   )\  \  / (.-' (.-' |  |     / \ 
      `-'  `' `'   `--' `--'`-''    '   '
                by CeeJay.dk
  '----------------------------------------*/

#pragma message "SweetFX 2.0 alpha for eFX"

  /*--------------------.
  | :: Load settings :: |
  '--------------------*/

// load preset and settings
#include "SweetFX_preset.txt"

  /*--------------------------.
  | :: Cross API constants :: |
  '--------------------------*/

#ifdef EFX //using eFX?
  #define screen_size float2(BUFFER_WIDTH,BUFFER_HEIGHT) //the screen size in pixels
  #define pixel float2(1.0 / screen_size) //the size of a single pixel

  #define px (pixel.x)
  #define py (pixel.y)
#endif

  /*-----------------------------.
  | :: Load API specific code :: |
  '-----------------------------*/

#ifdef EFX_DIRECT3D9 //Using DX9?
  #include "SweetFX\SweetFX_compatibility_settings.txt" // load compability settings
  #include "SweetFX\Shaders\SweetFX_D3D9.fx" // load DX9 specific code.
#endif

#ifdef EFX_DIRECT3D10 //Using DX10?
  #include "SweetFX\Shaders\SweetFX_D3D10.fx" // load DX10 specific code.
#endif

#ifdef EFX_DIRECT3D11 //Using DX11?
  #include "SweetFX\Shaders\SweetFX_D3D10.fx" // load DX10 specific code. (I'm currently using the DX10 branch for DX11 as well)
#endif

#ifdef EFX_OPENGL //Using OpenGL?
  #include "SweetFX\Shaders\SweetFX_OpenGL.fx" // load OpenGL specific code.
#endif