Texture2D texColor <
	string type = "input";
>;
Texture2D texTarget <
	string type = "output";
>;
SamplerState samplerColor
{
	Filter = MIN_MAG_LINEAR_MIP_POINT;
	AddressU = Clamp; AddressV = Clamp;
};

// --------------------------------------------------------- \\

struct VS_INPUT
{
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};
struct VS_OUTPUT
{
	float4 pos : SV_POSITION;
	float2 tex : TEXCOORD0;
};

// --------------------------------------------------------- \\

VS_OUTPUT PostProcess_VS(VS_INPUT IN)
{
	VS_OUTPUT OUT;
	
	OUT.pos = IN.pos;
	OUT.tex = IN.tex;
	
	return OUT;
}
float4 PostProcess_PS_Target(VS_OUTPUT OUT) : SV_TARGET0
{
	// SV_TARGET0 --> Rendertarget 1
	// SV_TARGET1 --> Rendertarget 2
	// ...
	
	return texColor.Sample(samplerColor, OUT.tex) * float4(OUT.tex, 1.0, 1.0);
}
float4 PostProcess_PS(VS_OUTPUT OUT) : SV_TARGET
{
	float4 color = texTarget.Sample(samplerColor, OUT.tex);
	color.a = 1.0;

	return color;
}

// --------------------------------------------------------- \\

technique11 PostProcess
{
	pass p0 < string output0 = "texTarget"; >
	{
		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS()));
		SetPixelShader(CompileShader(ps_4_0, PostProcess_PS_Target()));
	}
	pass p1
	{
		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS()));
		SetPixelShader(CompileShader(ps_4_0, PostProcess_PS()));
	}
}