Scriptname CassiopeiaPapyrusExtender native hidden

; #### This file is part of the mod "Cassiopeia Papyrus Extender" (SFSE plugin) by LarannKiar ####






   ; ##### Actor #####
   ;
   ; # returns the actors currently visible ( rendered on the screen and have fully enabled anim graph )
Actor[] Function GetVisibleActors() native global
   ;
   ; # turns on/off the spacesuit helmet light
Function SetHelmetLight(Actor akActor, bool abOn) native global
   ;
   ; # returns the actors currently being detected this actor; can be filtered for LOS
Actor[] Function GetActorsDetectedBy(Actor akDetecter, bool abMustHaveLOS = false) native global
   ;
   ; # returns the actors currently detecting this actor; can be filtered for LOS
Actor[] Function GetActorsDetecting(Actor akDetected, bool abMustHaveLOS = false) native global
   ;
   ; # returns the actors currently being process in HighActorProcessLevel
Actor[] Function GetHighActors() native global
   ;
   ; # returns the Spells of this actor
Spell[] Function GetSpells(Actor akActor) native global
   ;
   ; # returns the Factions of this actor
Faction[] Function GetFactions(Actor akActor) native global
   ;
   ; # adds a perk to this array of actors; returns how many actors has the perk on function end
Int Function AddPerkToAll(Actor[] akActors, Perk akPerk) native global
   ;
   ; # removes a perk from this array of actors; returns how many actors does not have the perk on function end
Int Function RemovePerkFromAll(Actor[] akActors, Perk akPerk) native global
   ;
   ; # returns this actor's sex ( 0 = male, 1 = female, -1 = non binary )
Int Function GetSex(Actor akActor) native global
   ;
   ; # evaluates the AI for the specified actors; returns how many actors' AI was evaluated until function end
Int Function EvaluatePackageForAll(Actor[] akActors, bool abResetAI = false) native global
   ;
   ; # returns the MagicEffects of this actor
MagicEffect[] Function GetMagicEffects(Actor akActor) native global
   ;
   ; # returns the base forms of actor's equipped inventory items
Form[] Function GetEquippedInventoryItems(Actor akActor) native global
   ;
Bool Function IsSwimming(Actor akActor) native global
Bool Function IsInWater(Actor akActor) native global
Bool Function IsInCombatSearch(Actor akActor) native global
Bool Function IsMurderAlarmed(Actor akActor) native global
Bool Function IsParalyzed(Actor akActor) native global
Bool Function DoesAffectStealthMeter(Actor akActor) native global
Bool Function IsUnderwater(Actor akActor) native global
Bool Function IsSpacesuitHelmetVisible(Actor akActor) native global
Bool Function IsSpacesuitHelmetLightOn(Actor akActor) native global
Bool Function IsJumping(Actor akActor) native global
Bool Function IsMovingForward(Actor akActor) native global
Bool Function IsMovingBackward(Actor akActor) native global
Bool Function IsMovingLeft(Actor akActor) native global
Bool Function IsMovingRight(Actor akActor) native global
Bool Function IsWalking(Actor akActor) native global
Bool Function IsStaggered(Actor akActor) native global
   ;
   ; # returns the knock state
Float Function GetKnockStateEnum(Actor akActor) native global
   ;
   ; # returns the gun state
Float Function GetActorGunState(Actor akActor) native global
   ;
   ; # updates the full appearance of this actor
Bool Function UpdateAppearance(Actor akActor, int aiUpdateFlags = 0x28, bool abTreatAsRaceChange = false) native global
   ;
   ; # updates the chargen ( facial ) appearance of this actor
Bool Function UpdateChargenAppearance(Actor akActor) native global
   ;
   ; # returns the skin tone index ( 0 - 8 )
Int Function GetSkinTone(Actor akActor) native global
   ;
   ; # changes the skin tone index ( 0 - 8 )
Bool Function SetSkinTone(Actor akActor, int aiSkinToneIndex) native global



   ; ##### ActorBase #####
   ;
   ; # returns the ActorBase that holds the appearance data for this actor
ActorBase Function GetAppearanceSource(Actor akActor) native global



   ; ##### Bitwise #####
   ;
Int Function SetBit(Int aiNumber, Int aiBit) native global
Int Function UnsetBit(Int aiNumber, Int aiBit) native global
Int Function BitwiseAnd(Int aiNumber1, Int aiNumber2) native global
Int Function BitwiseOr(Int aiNumber1, Int aiNumber2) native global
Int Function BitwiseNot(Int aiNumber) native global
Int Function BitwiseXor(Int aiNumber1, Int aiNumber2) native global
Int Function BitwiseLeftShift(Int aiNumber1, Int aiNumber2) native global
Int Function BitwiseRightShift(Int aiNumber1, Int aiNumber2) native global



   ; ##### Camera #####
   ;
Bool Function IsInPhotoMode() native global
Bool Function IsInAutoVanityMode() native global
Bool Function IsInFirstPerson() native global
Bool Function IsInThirdPerson() native global
Bool Function IsInIronSightsCam() native global
Bool Function IsInFlightCam() native global
Bool Function IsInShipTargetingCam() native global
Bool Function IsInShipCombatOrbitCam() native global
Bool Function IsInShipFarTravelCam() native global
Bool Function IsInShipActionCam() native global



   ; ##### Form #####
   ;
   ; # returns this form's FullName ( "TESFullName" )
String Function GetTESFullName(Form akForm) native global
   ;
   ; # alters this base form's FullName
Bool Function SetTESFullName(Form akForm, String asName) native global
   ;
   ; # returns true if the given form flag is set ( e.g. 0x400 is the persistence flag )
Bool Function GetIsFormFlagSet(Form akForm, Int aiFlag) native global
   ;
   ; # returns the form flags as int
Int Function GetFormFlagsAsInt(Form akForm) native global
   ;
   ; # returns the form flags as hex
String Function GetFormFlagsAsHex(Form akForm) native global
   ;
   ; # set/unset a form flag
Bool Function SetFormFlag(Form akForm, Bool abSet, Int aiFlag) native global
   ;
   ; # returns true if the given change flag ( another type of flag ) is set ( e.g. 0x1 is the temporary [T] )
Bool Function GetIsChangeFlagSet(Form akForm, Int aiFlag) native global
   ;
   ; # returns the change flags as int
Int Function GetChangeFlagsAsInt(Form akForm) native global
   ;
   ; # returns the change flags as hex
String Function GetChangeFlagsAsHex(Form akForm) native global
   ;
   ; # set/unset a change flag
Bool Function SetChangeFlag(Form akForm, Bool abSet, Int aiFlag) native global
   ;
   ; # returns all forms in this form list in a form array
Form[] Function GetFormListAllForms(FormList akFormList) native global
   ;
   ; # returns all forms with the given TESFullName; optional form type filter recommended as this operation is quite expensive
Form[] Function GetFormsByTESFullName(String asFullName, Int aiFormType = -1) native global



   ; ##### Game #####
   ;
   ; # returns true if any companion is talking
Bool Function IsAnyCompanionTalking() native global
   ;
   ; # returns the activatable reference in the crosshair
ObjectReference Function GetCrosshairRef() native global
   ;
   ; # returns the actor the SLM command was most recently called with ( e.g. actor with FormID 0x59A9 if "SLM 59A9 2" )
Actor Function GetLastSLMTarget() native global


   ; ##### GameSettings #####
   ;
Float Function GetINISettingFloat(String asSetting) native global
Int Function GetINISettingInt(String asSetting) native global
Bool Function GetINISettingBool(String asSetting) native global
Int Function GetINISettingUInt(String asSetting) native global
String Function GetINISettingString(String asSetting) native global
   ;
Bool Function SetGameSettingFloat(String asSetting, Float afValue) native global
Bool Function SetGameSettingInt(String asSetting, Int aiValue) native global
Bool Function SetGameSettingBool(String asSetting, Bool abValue) native global
Bool Function SetGameSettingUInt(String asSetting, Int auValue) native global
Bool Function SetGameSettingString(String asSetting, String asValue) native global



   ; ##### INI #####
   ;
   ; # returns true if the given file exist ( use like asFilePath = ".\\Data\\SFSE\\"; asFileName="MyFile.txt" )
Bool Function DoesFileExist(String asFilePath, String asFileName) native global
   ;
   ; # returns true if this INI exists ( no need to specify its file extension )
Bool Function DoesIniExist(String asINIPath, String asININame) native global
   ;
   ; # write/Read an INI file ( WriteIni also creates the INI if it doesn't exist )
Bool Function WriteIni(String asINIPath, String asININame, String asSection, String asKey, String asValue) native global
String Function ReadIni(String asINIPath, String asININame, String asSection, String asKey) native global



   ; ##### ObjectReference #####
   ;
   ; # returns this reference name ( prefers OverrideName over TESFullName )
String Function GetReferenceName(ObjectReference akReference) native global
   ;
   ; # sets an OverrideName on this reference
Bool Function SetDisplayName(ObjectReference akReference, String asName) native global
   ;
   ; # returns the OverrideName of a reference, if the reference has any ( if not, returns "" )
String Function GetOverrideName(ObjectReference akReference) native global
   ;
   ; # returns the Quests whose Quest Aliases this reference is filled into
Quest[] Function GetAliasHolderQuests(ObjectReference akReference) native global
   ;
   ; # flags a reference as temporary [T]; which practically marks the ref to be deleted OnUnload
Function SetTemporaryReference(ObjectReference akReference, bool abSet) native global
   ;
   ; # returns true if this reference is temporary [T]
Bool Function IsTemporaryReference(ObjectReference akReference) native global
   ;
   ; # returns the reference handle
Int Function GetReferenceHandle(ObjectReference akReference) native global
   ;
   ; # find the reference with the given handle
ObjectReference Function GetReferenceByHandle(Int aiReferenceHandle) native global
   ;
   ; # returns all references in this Cell
ObjectReference[] Function GetReferencesInCell(Cell akCell) native global
   ;
   ; # returns the Keyword of this rerference
Keyword[] Function GetKeywords(ObjectReference akReference) native global
   ;
   ; # returns the base forms of rerference's inventory items
Form[] Function GetInventoryItems(ObjectReference akReference) native global
   ;
   ; # returns the ObjectsMods attached to this reference
ObjectMod[] Function GetReferenceMods(ObjectReference akReference, bool abExcludeModColls = false) native global



   ; ##### Outfit #####
   ;
   ; # returns the forms in this outfit
Form[] Function GetOutfitForms(Outfit akOutfit) native global
   ;
   ; # adds a form to this outfit
Bool Function AddToOutfitForms(Outfit akOutfit, Form akFormToAdd) native global
   ;
   ; # removes a form from this outfit
Bool Function RemoveOutfitForm(Outfit akOutfit, Form akFormToRemove) native global
   ;
   ; # removes the Nth form from this outfit ( enum starts at 0 )
Bool Function RemoveNthOutfitForm(Outfit akOutfit, Int aiIndex) native global
   ;
   ; # removes all forms from this outfit
Bool Function RemoveAllOutfitForms(Outfit akOutfit) native global



   ; ##### Persistence #####
   ;
   ; # returns true if the reference with the given HexFormID is persistent ( Console [EP] or [PP] flag )
Int Function IsPersistent(String asHexFormID) native global



   ; ##### Plugin #####
   ;
   ; # returns how many active plugin ( ESM ) files the player have
Int Function GetActivePluginCount() native global
   ;
   ; # returns the names of the active plugins
String[] Function GetActivePlugins() native global
   ;
   ; # returns the plugin type ( enum: 1 = Full, 2 = Small, 3 = Medium )
Int Function GetPluginType(String asPluginName) native global
   ;
   ; # returns true if the specified ESM is a Full Master
Bool Function IsFullMaster(String asPluginName) native global
   ;
   ; # returns true if the specified ESM is a Small Master
Bool Function IsSmallMaster(String asPluginName) native global
   ;
   ; # returns true if the specified ESM is a Medium Master
Bool Function IsMediumMaster(String asPluginName) native global
   ;
   ; # returns the author name of this plugin
String Function GetPluginFileAuthorName(String asPluginName) native global
   ;
   ; # returns the Console selected reference
ObjectReference Function GetConsoleRef() native global
   ;
   ; # returns the form type as string ( e.g. "STAT", "FURN", "NPC_" )
String Function GetFormTypeAsString(Form akForm) native global
   ;
   ; # returns the form type as int ( game forms are enumerated from 0 - 217 )
Int Function GetFormTypeAsInt(Form akForm) native global
   ;
   ; # returns all forms with the given form type; optional OverriderPlugin to filter 
Form[] Function GetAllFormsByFormType(Int aiFormType, String asLastOverriderPluginName = "") native global
   ;
   ; # returns the last "OverriderPlugin" ( the one that determines this form's data )
String Function LookupLastOverriderPlugin(Form akForm) native global



   ; ##### UI #####
   ;
   ; # Returns true if the specified menu is open
Bool Function IsMenuOpen(String asMenuName) native global



   ; ##### Utility #####
   ;
   ; # convert int to hex
Int Function HexToInt(String asHexString) native global



   ; ##### Version #####
   ;
   ; # Returns the version of Cassiopeia ( e.g. v1.2 is 12, v2.0 is 20 )
Int Function GetCassiopeiaPapyrusExtenderVersion() native global






