Scriptname ADW_TA_Dropbox_Script extends ObjectReference

ConditionForm property CommerceRank1 auto const mandatory
ConditionForm property CommerceRank2 auto const mandatory
ConditionForm property CommerceRank3 auto const mandatory
ConditionForm property CommerceRank4 auto const mandatory
ADW_TA_Dropbox_Quest_Script property SharedPayoutQuest auto mandatory
ActorBase property Vendor auto const mandatory
Container property VendorContainer auto const mandatory
Keyword property VendorContainerKeyword01 auto const mandatory
Perk property ZeroSellPrice auto const mandatory

float FeeMultCommerce0 = 0.7 const
float FeeMultCommerce1 = 0.75 const
float FeeMultCommerce2 = 0.8 const
float FeeMultCommerce3 = 0.85 const
float FeeMultCommerce4 = 0.9 const

Actor PlayerRef
int CurrentTotal
Actor myVendor ; created vendor
ObjectReference myVendorContainer ; created container

Event OnLoad()
	if myVendor == NONE
		Debug.Trace("ADW T: " + self + " Place invisible vendor and container")
		myVendor = PlaceActorAtMe(Vendor, abInitiallyDisabled=true)
		myVendorContainer = PlaceAtMe(VendorContainer, abInitiallyDisabled=true)
		myVendor.SetLinkedRef(myVendorContainer, VendorContainerKeyword01)
	endif

	PlayerRef = Game.GetPlayer()
EndEvent

Event OnActivate(ObjectReference akActionRef)
	debug.trace("ADW T: " + self + " OnActivate " + akActionRef)
	if akActionRef == PlayerRef
		RegisterForMenuOpenCloseEvent("BarterMenu")
		Debug.Trace("ADW T: " + self + " Registered for BarterMenu OpenClose event")
;		PlayAnimationAndWait("Open", "done")
		PlayerRef.AddPerk(ZeroSellPrice)
		myVendor.ShowBarterMenu()
	endif
EndEvent

Event OnMenuOpenCloseEvent(string asMenuName, bool abOpening)
	float VendorSellPriceMult = Game.GetGameSettingFloat("fVendorSellPriceMult")
	
	if(asMenuName == "BarterMenu" && !abOpening)
		Debug.Trace("ADW T: " + self + " Closed event received")
		CurrentTotal = myVendor.GetInventoryValue()
		Debug.Trace("ADW T: " + self + " Vendor Inventory Value " + CurrentTotal)
		CurrentTotal = (CurrentTotal * VendorSellPriceMult) as int
		Debug.Trace("ADW T: " + self + " Adjusted Value " + CurrentTotal)
		myVendor.RemoveAllItems()
		PlayerRef.RemovePerk(ZeroSellPrice)
		if(CurrentTotal > 0)
			if CommerceRank1.IsTrue(PlayerRef, PlayerRef)
				Debug.Trace("ADW T: " + self + " Player has Commerce rank 1")
				CurrentTotal = (CurrentTotal * FeeMultCommerce1) as int
			elseif CommerceRank2.IsTrue(PlayerRef, PlayerRef)
				Debug.Trace("ADW T: " + self + " Player has Commerce rank 2")
				CurrentTotal = (CurrentTotal * FeeMultCommerce2) as int
			elseif CommerceRank3.IsTrue(PlayerRef, PlayerRef)
				Debug.Trace("ADW T: " + self + " Player has Commerce rank 3")
				CurrentTotal = (CurrentTotal * FeeMultCommerce3) as int
			elseif CommerceRank4.IsTrue(PlayerRef, PlayerRef)
				Debug.Trace("ADW T: " + self + " Player has Commerce rank 4")
				CurrentTotal = (CurrentTotal * FeeMultCommerce4) as int
			else
				Debug.Trace("ADW T: " + self + " Player has no Commerce rank")
				CurrentTotal = (CurrentTotal * FeeMultCommerce0) as int
			endif
			Debug.Trace("ADW T: " + self + " Value in dropbox = " + CurrentTotal)
	
			SharedPayoutQuest.IncreaseRunningTotal(CurrentTotal)
		endIf
		UnregisterForMenuOpenCloseEvent("BarterMenu")
		Debug.Trace("ADW T: " + self + " Unregistered for BarterMenu OpenClose event")
;		PlayAnimation("Close")
	endIf
EndEvent
