Scriptname ADW_TA_DropboxSlateScript extends ObjectReference

Quest property SlateQuest auto mandatory const
Message property ProtectionMessage auto mandatory const
bool property FirstTime = false auto

Auto State WaitingToBeRead

	Event OnRead()
		if FirstTime
			FirstTime = false
			Debug.Trace("ADW S: New slate read, wait for close")
			RegisterForMenuOpenCloseEvent("DataSlateMenu")
			GotoState("WaitingToBeClosed")
		endIf
	endEvent

EndState

State WaitingToBeClosed

	Event OnMenuOpenCloseEvent(string asMenuName, bool abOpening)
		int MessageButton
		bool WasStarted

		Debug.Trace("ADW S: OpenClose event received")
		if (asMenuName == "DataSlateMenu")
			Debug.Trace("ADW S: DataSlateMenu OpenCloseEvent received - " + abOpening)
			
			if !abOpening
				Debug.trace("DataSlateMenu closed")
				UnRegisterForMenuOpenCloseEvent("DataSlateMenu")
				Debug.Trace("ADW S: Slates protected, show message")
				MessageButton = ProtectionMessage.Show()
				if MessageButton == 0
					Debug.Trace("ADW S: Player chose Yes")
					if SlateQuest.IsRunning()
						Debug.Trace("ADW S: Stop SlateQuest")
						SlateQuest.Stop()
					endif
				elseIf MessageButton == 1
					Debug.Trace("ADW S: Player chose No")
					if !SlateQuest.IsRunning()
						WasStarted = SlateQuest.Start()
						Debug.Trace("ADW S: SlateQuest started? = " + WasStarted)
						if WasStarted
							Game.GetPlayer().RemoveItem(Self, abSilent = true)
							FirstTime = true
						endif
					endif
				endIf
				GotoState("WaitingToBeRead")
			endIf
		endIf
	endEvent
	
EndState