Scriptname ADW_TA_Dropbox_Quest_Script extends Quest

MiscObject property Credits auto const mandatory
GlobalVariable Property ADW_TA_Dropbox_BAL Auto
GlobalVariable Property ADW_TA_Dropbox_PAY Auto
GlobalVariable Property ADW_TA_Dropbox_HRS Auto
GlobalVariable Property ADW_TA_Dropbox_MIN Auto
Quest Property SlateQuest auto const mandatory

int RunningTotal = 0
bool AwaitingPayoutTimer = false
bool AwaitingUpdateTimer = false
float PayoutInterval = 24.0 const
float UpdateInterval = 0.333 const
int PaymentTimerID = 10 const
int UpdateTimerID = 20 const
Actor PlayerRef
int DailyPayment = 50000 const
float PaymentDueTime = 0.0
float CurrentTime = 0.0

Event OnInit()
	 PlayerRef = Game.GetPlayer()
EndEvent

function UpdateInstances()
	float TimeRemaining
	
	Debug.Trace("ADW Q: Update instances")
	if !AwaitingPayoutTimer
		Debug.Trace("ADW Q: !AwaitingPayoutTimer")
		ADW_TA_Dropbox_HRS.SetValue(0.0)
		ADW_TA_Dropbox_MIN.SetValue(0.0)
		
		if AwaitingUpdateTimer
			Debug.Trace("ADW Q: AwaitingUpdateTimer, cancel timer")
			AwaitingUpdateTimer = false
			CancelTimerGameTime(UpdateTimerID)
		endif
	else
		TimeRemaining = PaymentDueTime - CurrentTime
		Debug.Trace("ADW Q: AwaitingPayoutTimer. Payment due time = " + PaymentDueTime + ", Time remaining = " + TimeRemaining)
		ADW_TA_Dropbox_HRS.SetValue(TimeRemaining as int)
		ADW_TA_Dropbox_MIN.SetValue((TimeRemaining - (TimeRemaining as int)) * 60.0)

		if (!AwaitingUpdateTimer)
			Debug.Trace("ADW Q: !AwaitingUpdateTimer, start timer")
			AwaitingUpdateTimer = true
			StartTimerGameTime(UpdateInterval, UpdateTimerID)
		endif
	endif
	
	UpdateCurrentInstanceGlobal(ADW_TA_Dropbox_BAL)
	UpdateCurrentInstanceGlobal(ADW_TA_Dropbox_PAY)
	UpdateCurrentInstanceGlobal(ADW_TA_Dropbox_HRS)
	UpdateCurrentInstanceGlobal(ADW_TA_Dropbox_MIN)
	if SlateQuest.IsRunning()
		SlateQuest.UpdateCurrentInstanceGlobal(ADW_TA_Dropbox_BAL)
		SlateQuest.UpdateCurrentInstanceGlobal(ADW_TA_Dropbox_PAY)
		SlateQuest.UpdateCurrentInstanceGlobal(ADW_TA_Dropbox_HRS)
		SlateQuest.UpdateCurrentInstanceGlobal(ADW_TA_Dropbox_MIN)
	endif

endFunction	

function IncreaseRunningTotal(int CurrentTotal)
	CurrentTime = Utility.GetCurrentGameTime() * 24.0
	RunningTotal += CurrentTotal
	Debug.Trace("ADW Q: IncreaseRunningTotal: Total = " + RunningTotal + " @ " + Utility.GameTimeToString(Utility.GetCurrentGameTime()) + " (" + CurrentTime + ")")
	ADW_TA_Dropbox_BAL.SetValue(RunningTotal)

	if (RunningTotal > 0 && !AwaitingPayoutTimer)
		Debug.Trace("ADW Q: !AwaitingPayoutTimer, start timer")
		AwaitingPayoutTimer = true
		PaymentDueTime = CurrentTime + PayoutInterval
		StartTimerGameTime(PayoutInterval, PaymentTimerID)
	endIf

	UpdateInstances()
endFunction

function Payout(int Amount)
	Debug.Trace("ADW Q: Payout " + Amount + " credits @ " + Utility.GameTimeToString(Utility.GetCurrentGameTime()) + " (" + CurrentTime + ")")
	RunningTotal -= Amount
	PlayerRef.AddItem(Credits, Amount)
	Debug.Trace("ADW Q: New runningTotal " + RunningTotal)
	if(RunningTotal > 0)
		Debug.Trace("ADW Q: Start next payout timer")
		AwaitingPayoutTimer = true
		StartTimerGameTime(PayoutInterval, PaymentTimerID)
		PaymentDueTime = CurrentTime + PayoutInterval
	else
		AwaitingPayoutTimer = false
	endif
	ADW_TA_Dropbox_BAL.SetValue(RunningTotal)
	ADW_TA_Dropbox_PAY.Mod(1)
	UpdateInstances()
endFunction

Event OnTimerGameTime(int TimerID)
	CurrentTime = Utility.GetCurrentGameTime() * 24.0
	Debug.Trace("ADW Q: Timer " + TimerID + " elapsed @ " + Utility.GameTimeToString(Utility.GetCurrentGameTime()) + " (" + CurrentTime + ")")
	if (TimerID == PaymentTimerID)
		AwaitingPayoutTimer = false
		if (RunningTotal > 0)
			if (RunningTotal > DailyPayment)
				Payout(DailyPayment)
			else
				Payout(RunningTotal)
			endIf
		endif
	elseif (TimerID == UpdateTimerID)
		AwaitingUpdateTimer = false
		UpdateInstances()
	endIf
EndEvent
