Scriptname CassiopeiaPapyrusExtender native hidden

; #### This file is part of the mod "Cassiopeia Papyrus Extender" (SFSE plugin) by LarannKiar ####





   ; ##### Actor #####
   ;
   ; # turns on/off the spacesuit helmet light
Function SetHelmetLight(Actor akActor, bool abOn) native global
   ;
   ; # returns the actors currently being detected this actor; can be filtered for LOS
Actor[] Function GetActorsDetectedBy(Actor akDetecter, bool abMustHaveLOS = false) native global
   ;
   ; # returns the actors currently detecting this actor; can be filtered for LOS
Actor[] Function GetActorsDetecting(Actor akDetected, bool abMustHaveLOS = false) native global
   ;
   ; # returns the actors currently being processed in HighActorProcessLevel
Actor[] Function GetHighActors() native global
   ;
   ; # returns the Spells of this actor
Spell[] Function GetSpells(Actor akActor) native global
   ;
   ; # returns the Factions of this actor
Faction[] Function GetFactions(Actor akActor) native global
   ;
   ; # adds this Perk to these actors; returns how many actors has the perk on function end
Int Function AddPerkToAll(Actor[] akActors, Perk akPerk) native global
   ;
   ; # removes this Perk from these actors; returns how many actors does not have the perk on function end
Int Function RemovePerkFromAll(Actor[] akActors, Perk akPerk) native global
   ;
   ; # returns this actor's sex ( 0 = male, 1 = female, -1 = non binary )
Int Function GetSex(Actor akActor) native global
   ;
   ; # evaluates the AI of the specified actors; returns how many actors' AI was evaluated until function end
Int Function EvaluatePackageForAll(Actor[] akActors, bool abResetAI = false) native global
   ;
   ; # returns the MagicEffects of this actor
MagicEffect[] Function GetMagicEffects(Actor akActor) native global
   ;
   ; # returns the base forms of actor's equipped inventory items
Form[] Function GetEquippedInventoryItems(Actor akActor) native global
   ;
Bool Function IsSwimming(Actor akActor) native global
Bool Function IsInWater(Actor akActor) native global
Bool Function IsInCombatSearch(Actor akActor) native global
Bool Function IsMurderAlarmed(Actor akActor) native global
Bool Function IsParalyzed(Actor akActor) native global
Bool Function DoesAffectStealthMeter(Actor akActor) native global
Bool Function IsUnderwater(Actor akActor) native global
Bool Function IsSpacesuitHelmetVisible(Actor akActor) native global
Bool Function IsSpacesuitHelmetLightOn(Actor akActor) native global
Bool Function IsJumping(Actor akActor) native global
Bool Function IsMovingForward(Actor akActor) native global
Bool Function IsMovingBackward(Actor akActor) native global
Bool Function IsMovingLeft(Actor akActor) native global
Bool Function IsMovingRight(Actor akActor) native global
Bool Function IsWalking(Actor akActor) native global
Bool Function IsStaggered(Actor akActor) native global
   ;
   ; # returns the knock state
Float Function GetKnockStateEnum(Actor akActor) native global
   ;
   ; # returns the gun state
Float Function GetActorGunState(Actor akActor) native global
   ;
   ; # updates the full appearance of this actor
Bool Function UpdateAppearance(Actor akActor, int aiUpdateFlags = 0x28, bool abTreatAsRaceChange = false) native global
   ;
   ; # updates the chargen ( facial ) appearance of this actor
Bool Function UpdateChargenAppearance(Actor akActor) native global
   ;
   ; # returns the skin tone index ( 0 - 8 )
Int Function GetSkinTone(Actor akActor) native global
   ;
   ; # changes the skin tone index ( 0 - 8 )
Bool Function SetSkinTone(Actor akActor, int aiSkinToneIndex) native global
   ;
   ; # returns the ActorBase that holds this actor's appearance data
ActorBase Function GetAppearanceSource(Actor akActor) native global
   ;
   ; # returns true if this actor is in a Land Vehicle
Bool Function IsInVehicle(Actor akReference) native global
   ;
   ; # returns the Difficulty of this Leveled Actor ( 0 - 4; 4 = "not leveled" )
Int Function GetLeveledCharacterModifier(Actor akLeveledActor) native global
   ;
   ; # returns true if there's at least one hostile ( to this actor ) within the given distance
   ; # ( works only with 3D loaded hostiles and akActor )
Bool Function AreHostileActorsNearCustom(Actor akActor, float afDistance) native global



   ; ##### Bitwise #####
   ;
Int Function SetBit(Int aiNumber, Int aiBit) native global
Int Function UnsetBit(Int aiNumber, Int aiBit) native global
Int Function BitwiseAnd(Int aiNumber1, Int aiNumber2) native global
Int Function BitwiseOr(Int aiNumber1, Int aiNumber2) native global
Int Function BitwiseNot(Int aiNumber) native global
Int Function BitwiseXor(Int aiNumber1, Int aiNumber2) native global
Int Function BitwiseLeftShift(Int aiNumber1, Int aiNumber2) native global
Int Function BitwiseRightShift(Int aiNumber1, Int aiNumber2) native global



   ; ##### Camera #####
   ;
Bool Function IsInPhotoMode() native global
Bool Function IsInAutoVanityMode() native global
Bool Function IsInFirstPerson() native global
Bool Function IsInThirdPerson() native global
Bool Function IsInIronSightsCam() native global
Bool Function IsInFlightCam() native global
Bool Function IsInShipTargetingCam() native global
Bool Function IsInShipCombatOrbitCam() native global
Bool Function IsInShipFarTravelCam() native global
Bool Function IsInShipActionCam() native global



   ; ##### Console #####
   ;
   ; # print this line in the Console log
Bool Function PrintToConsoleLog(String asText) native global
   ;
   ; # clears the Console log
Bool Function ClearConsoleLog() native global



   ; ##### Events #####
   ;
   ; # ( see CassiopieaPapyrusEvents.txt for details )
Bool Function RegisterForNativeEvent(String asScriptName, String asEventName, Form[] akFormFilter = None) native global
Bool Function IsRegisteredForNativeEvent(String asScriptName, String asEventName) native global
Bool Function UnregisterForNativeEvent(String asScriptName, String asEventName) native global
Bool Function UnregisterForAllNativeEvents(String asScriptName) native global
   ;
   ; # debug use only
Int Function RegisterForAllNativeEvents(String asScriptName) native global
   ;
   ; # scripts can be filtered by the event sender forms
Bool Function AddNativeEventFilter(String asScriptName, String asEventName, Form[] akFormFilter) native global
Bool Function RemoveNativeEventFilter(String asScriptName, String asEventName, Form[] akFormFilter) native global
Form[] Function GetNativeEventFilteredForms(String asScriptName, String asEventName) native global



   ; ##### FaceGen #####
   ;
   ; # exports all facial morphs to a txt file (in the EXE folder). You can use this to see all facial morphs names.
Bool Function ExportMorphMap(Actor akActor) native global
   ;
   ; # get / set a single morph value on this actor
Float Function GetMorphValue(Actor akActor, String asMorphName) native global
Bool Function SetMorphValue(Actor akActor, String asMorphName, float afValue) native global
   ;
   ; # get / set multiple morph values ( an actor has 100 expression related facial morphs )
Float[] Function GetMorphValues(Actor akActor) native global
Bool Function SetMorphValues(Actor akActor, String[] asMorphNames, float[] afValues) native global
   ;
   ; # copies the facial expression from an actor to another
Bool Function CopyFacialExpression(Actor akSourceActor, Actor akTargetActor) native global
   ;
   ; # returns the active Anim Face Archetype
Keyword Function GetAnimFaceArchetype(Actor akActor) native global
   ;
   ; # applies the facial expression (all morphs) from a Facial Expression Data form to an actor
Bool Function ApplyFacialExpression(Actor akActor, Form akFacialExpressionData) native global
   ;
   ; # sets everything to 0, i.e. "neutral" face
Bool Function ResetFacialExpression(Actor akActor) native global
   ;
   ; # these two below return the same sized arrays, each morph value has the same index as its morph name
Float[] Function ReadFacialExpressionDataMorphValues(Form akFacialExpressionData) native global
String[] Function ReadFacialExpressionDataMorphNames(Form akFacialExpressionData) native global
   ;
   ; # all facial morphs of this actor will be written to this Facial Expression Data form
Bool Function StoreFacialExpression(Actor akActor, Form akFacialExpressionData) native global
   ;
   ; # writes / reads a single morph to / from this Facial Expression Data form
Bool Function WriteMorphValue(Form akFacialExpressionData, String asMorphName, float afValue) native global
Float Function ReadMorphValue(Form akFacialExpressionData, String asMorphName) native global



   ; ##### Form #####
   ;
   ; # returns this form's FullName ( "TESFullName" )
String Function GetTESFullName(Form akForm) native global
   ;
   ; # alters this form's FullName
Bool Function SetTESFullName(Form akForm, String asName) native global
   ;
   ; # returns true if the given form flag is set ( e.g. 0x400 is the persistence flag )
Bool Function GetIsFormFlagSet(Form akForm, Int aiFlag) native global
   ;
   ; # returns the form flags as int
Int Function GetFormFlagsAsInt(Form akForm) native global
   ;
   ; # returns the form flags as hex
String Function GetFormFlagsAsHex(Form akForm) native global
   ;
   ; # set/unset a form flag
Bool Function SetFormFlag(Form akForm, Bool abSet, Int aiFlag) native global
   ;
   ; # returns true if the given change flag ( another type of flag ) is set ( e.g. 0x1 is the temporary [T] )
Bool Function GetIsChangeFlagSet(Form akForm, Int aiFlag) native global
   ;
   ; # returns the change flags as int
Int Function GetChangeFlagsAsInt(Form akForm) native global
   ;
   ; # returns the change flags as hex
String Function GetChangeFlagsAsHex(Form akForm) native global
   ;
   ; # set/unset a change flag
Bool Function SetChangeFlag(Form akForm, Bool abSet, Int aiFlag) native global
   ;
   ; # returns all forms in this form list in a form array
Form[] Function GetFormListAllForms(FormList akFormList) native global
   ;
   ; # returns all forms with the given TESFullName; optional form type filter recommended as this operation is quite expensive
Form[] Function GetFormsByTESFullName(String asFullName, Int aiFormType = -1) native global
   ;
   ; # returns the form type as string ( e.g. "STAT", "FURN", "NPC_" )
String Function GetFormTypeAsString(Form akForm) native global
   ;
   ; # returns the form type as int ( game forms are enumerated from 0 - 217 )
Int Function GetFormTypeAsInt(Form akForm) native global
   ;
   ; # returns all forms with the given form type; optional OverriderPlugin to filter 
Form[] Function GetAllFormsByFormType(Int aiFormType, String asLastOverriderPluginName = "") native global
   ;
   ; # returns the last "overrider plugin" of this form ( the one that determines this form's data )
String Function LookupLastOverriderPlugin(Form akForm) native global
   ;
   ; # returns the source plugin of this form ( the one this form's record lives in )
String Function LookupSourcePlugin(Form akForm) native global
   ;
   ; # adds a keyword to this base form
Bool Function AddKeywordToForm(Form akForm, Keyword akKeyword) native global
   ;
   ; # removes a keyword from this base form
Bool Function RemoveKeywordFromForm(Form akForm, Keyword akKeyword) native global



   ; ##### Game #####
   ;
   ; # returns the actors currently seen by the player
Actor[] Function GetVisibleActors() native global
   ;
   ; # returns the sorted actors from the HighActorProcessLevel
Actor[] Function GetSortedHighActors() native global
   ;
   ; # returns true if any companion is talking
Bool Function IsAnyCompanionTalking() native global
   ;
   ; # returns the activatable reference in the crosshair
ObjectReference Function GetCrosshairRef() native global
   ;
   ; # returns the actor the SLM command was most recently called with ( e.g. actor with FormID 0x59A9 if "SLM 59A9 2" )
Actor Function GetLastSLMTarget() native global
   ;
   ; # returns the Console selected reference
ObjectReference Function GetConsoleRef() native global
   ;
   ; # returns the current speed of the player's ship
Int Function GetPlayerSpaceshipCurrentSpeed() native global
   ;
   ; # returns true if God Mode ( TGM command ) is on
Bool Function IsInGodMode() native global
   ;
   ; # returns true if AI Detection ( TDetect command ) is on
Bool Function IsGlobalAIDetectionOn() native global
   ;
   ; # returns the weapon charge level of the player's ship
   ; # aiWeaponIndex: 1 = left, 2 = top, 3 = right ( as seen on the Ship HUD )
Int Function GetPlayerSpaceshipWeaponCapacity(int aiWeaponIndex) native global
   ;
   ; # returns the weapon type of the player's ship as string ( e.g. MSL, LAS )
String Function GetPlayerSpaceshipWeaponType(int aiWeaponIndex) native global
   ;
   ; # returns the Grav Jump Range of the player's ship
   ; # only works after a planet or system is selected in the Galaxy menu
Float Function GetPlayerSpaceshipMaxFuelRange() native global
   ;
   ; # returns the most recently calculated Fuel Consumption after the player selected a planet or system in the Galaxy menu
Float Function GetPlayerSpaceshipFuelConsumption() native global
   ;
   ; # returns true is the player's ship is in reverse
Bool Function IsPlayerSpaceshipFlyingBackward() native global
   ;
   ; # returns the actors selectable in Photo Mode if Photo Mode is open
Actor[] Function GetPhotoModeActors() native global
   ;
   ; # returns all loaded Cells
Cell[] Function GetLoadedCells() native global
   ;
   ; # returns all references in the loaded cells
   ; # I used it for testing the SortReferences functions
ObjectReference[] Function GetLoadedReferences() native global
   ;
   ; # returns the current time scale ( 0.0: pause - 1.0: normal )
Float Function GetGlobalTimeMultiplier() native global
   ;
   ; # returns the target time scale ( can be handy after calling SetGlobalTimeMultiplier )
Float Function GetGlobalTimeMultiplierTarget() native global
   ;
   ; # changes the time scale ( first param affects everything and everyone except the player; the second param only affects the player )
Bool Function SetGlobalTimeMultiplier(Float afGlobalTimeMultiplier, Float afPlayerRelativeTimeMultiplier) native global
   ;
   ; # plays an UI menu sound ( e.g. UIMenuGeneralOK, UIMenuGeneralActivateFailure )
Function PlayMenuSound(String asSoundName) native global



   ; ##### GameSettings #####
   ;
Float Function GetINISettingFloat(String asSetting) native global
Int Function GetINISettingInt(String asSetting) native global
Bool Function GetINISettingBool(String asSetting) native global
Int Function GetINISettingUInt(String asSetting) native global
String Function GetINISettingString(String asSetting) native global
   ;
Bool Function SetGameSettingFloat(String asSetting, Float afValue) native global
Bool Function SetGameSettingInt(String asSetting, Int aiValue) native global
Bool Function SetGameSettingBool(String asSetting, Bool abValue) native global
Bool Function SetGameSettingUInt(String asSetting, Int auValue) native global
Bool Function SetGameSettingString(String asSetting, String asValue) native global



   ; ##### INI #####
   ;
   ; # returns true if the given file exist ( use like asFilePath = ".\\Data\\SFSE\\"; asFileName="MyFile.txt" )
Bool Function DoesFileExist(String asFilePath, String asFileName) native global
   ;
   ; # returns true if this INI exists ( no need to specify its file extension )
Bool Function DoesIniExist(String asINIPath, String asININame) native global
   ;
   ; # write/Read an INI file ( WriteIni also creates the INI if it doesn't exist )
Bool Function WriteIni(String asINIPath, String asININame, String asSection, String asKey, String asValue) native global
String Function ReadIni(String asINIPath, String asININame, String asSection, String asKey) native global



   ; ##### MiscObject #####
   ;
   ; # returns true if this misc object is a LooseMod
Bool Function IsLooseMod(MiscObject akMiscObject) native global



   ; ##### ObjectReference #####
   ;
   ; # returns this reference name ( prefers OverrideName over TESFullName )
String Function GetReferenceName(ObjectReference akReference) native global
   ;
   ; # sets an OverrideName on this reference
Bool Function SetDisplayName(ObjectReference akReference, String asName) native global
   ;
   ; # returns the OverrideName of a reference, if the reference has any ( if not, returns "" )
String Function GetOverrideName(ObjectReference akReference) native global
   ;
   ; # returns the Quests whose Quest Aliases this reference is filled into
Quest[] Function GetAliasHolderQuests(ObjectReference akReference) native global
   ;
   ; # flags a reference as temporary [T]; which practically marks the ref to be deleted OnUnload
Function SetTemporaryReference(ObjectReference akReference, bool abSet) native global
   ;
   ; # returns true if this reference is temporary [T]
Bool Function IsTemporaryReference(ObjectReference akReference) native global
   ;
   ; # returns the reference handle
Int Function GetReferenceHandle(ObjectReference akReference) native global
   ;
   ; # find the reference with the given handle
ObjectReference Function GetReferenceByHandle(Int aiReferenceHandle) native global
   ;
   ; # returns all references in this Cell
ObjectReference[] Function GetReferencesInCell(Cell akCell) native global
   ;
   ; # returns the Keywords of this reference
Keyword[] Function GetKeywords(ObjectReference akReference) native global
   ;
   ; # returns the base forms of reference's inventory items
Form[] Function GetInventoryItems(ObjectReference akReference) native global
   ;
   ; # returns the ObjectsMods attached to this reference
ObjectMod[] Function GetReferenceMods(ObjectReference akReference, bool abExcludeModColls = false) native global
   ;
   ; # copies the inventory items of the given form types ( source and target can't be the same reference )
   ; # valid form types: 48 = Weapon, 34 = Armor, 54 = Aid, 40 = Misc, 57 = Note, 35  = Book, 49 = Ammo, 53 = Key
Bool Function CopyInventoryItems(ObjectReference akSourceRef, ObjectReference akTargetRef, Int[] aiFormTypes) native global
   ;
   ; # returns true if it would be consiered as crime to activate the reference in the crosshair
Bool Function IsCrimeToActivate(ObjectReference akReference) native global
   ;
   ; #  changes the visibility ( i.e. rendered ) state of this reference's 3D
Bool Function SetModelVisible(ObjectReference akReference, bool abVisible) native global
   ;
   ; # returns true if this reference is 3D loaded and has fully initialized Anim Graph
Bool Function HasAnimGraphManager(ObjectReference akReference) native global
   ;
   ; # returns the Source Pack-In
PackIn Function GetSourcePackIn(ObjectReference akReference) native global
   ;
   ; # returns the Grouped Pack-In
PackIn Function GetGroupedPackIn(ObjectReference akReference) native global
   ;
   ; # forces the reference to be persistent / removes forced persistence
   ; # optional abSilent to suppress the Console log feedback
Bool Function ForcePersistent(ObjectReference akReference, bool abPersistent, bool abSilent = true) native global
   ;
   ; # returns true if this reference can be picked by the player ( i.e. can be inventory item )
Bool Function IsCarryable(ObjectReference akReference) native global



   ; ##### Outfit #####
   ;
   ; # returns the forms in this outfit
Form[] Function GetOutfitForms(Outfit akOutfit) native global
   ;
   ; # adds a form to this outfit
Bool Function AddToOutfitForms(Outfit akOutfit, Form akFormToAdd) native global
   ;
   ; # removes a form from this outfit
Bool Function RemoveOutfitForm(Outfit akOutfit, Form akFormToRemove) native global
   ;
   ; # removes the Nth form from this outfit ( enum starts at 0 )
Bool Function RemoveNthOutfitForm(Outfit akOutfit, Int aiIndex) native global
   ;
   ; # removes all forms from this outfit
Bool Function RemoveAllOutfitForms(Outfit akOutfit) native global



   ; ##### ObjectMod #####
   ;
   ; # returns true is this object mod is flagged as a ModCollection
Bool Function IsModCollection(ObjectMod akObjectMod) native global



   ; ##### Persistence #####
   ;
   ; # returns true if the reference with the given HexFormID is persistent ( Console [EP] or [PP] flag )
Int Function IsPersistent(String asHexFormID) native global



   ; ##### Plugin #####
   ;
   ; # returns how many active plugin ( ESM ) files the player has
Int Function GetActivePluginCount() native global
   ;
   ; # returns the names of all active plugins
String[] Function GetActivePlugins() native global
   ;
   ; # returns the plugin type ( enum: 1 = Full, 2 = Small, 3 = Medium )
Int Function GetPluginType(String asPluginName) native global
   ;
   ; # returns true if the specified ESM is a Full Master
Bool Function IsFullMaster(String asPluginName) native global
   ;
   ; # returns true if the specified ESM is a Small Master
Bool Function IsSmallMaster(String asPluginName) native global
   ;
   ; # returns true if the specified ESM is a Medium Master
Bool Function IsMediumMaster(String asPluginName) native global
   ;
   ; # returns the author name of this plugin
String Function GetPluginFileAuthorName(String asPluginName) native global



   ; ##### Quest #####
   ;
   ; # clears all Quest Aliases
Bool Function ClearAllAliases(Quest akQuest) native global
   ;
   ; # returns all running quests
Quest[] Function GetAllRunningQuests() native global



   ; ##### Sorter functions #####
   ;
ObjectReference[] Function SortReferencesByDeleted(ObjectReference[] akReferences, bool abRemoveDeleted) native global
ObjectReference[] Function SortReferencesByName(ObjectReference[] akReferences, String asName, bool abExactMatch, bool abReversed) native global
ObjectReference[] Function SortReferencesByKeywords(ObjectReference[] akReferences, Keyword[] akKeywords, bool abMustHaveAll) native global
ObjectReference[] Function SortReferencesByDistance(ObjectReference[] akReferences, float afDistance, bool abCloserThan) native global
   ;
   ; # allows you to sort arrays of references by ConditionForms
   ; # ( internally, Cassiopiea calls native ConditionForm.IsTrue for the refs )
   ; # you can pass None to akTargetReferences if the conditions in your ConditionForms don't need a target ref
   ; # ( most conditions don't need a target ref, an exception could be GetInSameCell )
   ; # however, if you'd like to specify target refs, it is important that the two arrays must have the same size so the code knows which target ref belongs to which subject ref
ObjectReference[] Function SortReferencesByConditions(ObjectReference[] akSubjectReferences, ObjectReference[] akTargetReferences, ConditionForm[] akConditionForms, bool abConjuntive) native global



   ; ##### UI #####
   ;
   ; # returns true if the specified menu is open
Bool Function IsMenuOpen(String asMenuName) native global
   ;
   ; # returns an AS3 variable as string
   ;     examples:
   ;         string menu = "Console"
   ;         string var = "root1.AnimHolder_mc.Menu_mc.CurrentSelection.text"
   ;       the selected Console reference text
   ;         string menu = "PhotoModeMenu"
   ;         string var = "root1.Menu_mc.PanelContainer_mc.SettingsList_mc.EntryHolder_mc.Entry0.Stepper_mc.textField.text"
   ;       the first entry in the Photo Mode menu ( HUD ) ( e.g. "Free" in the Camera Type tab, Photo Mode Actor's name in Character, etc.)
   ;         string menu = "PhotoModeMenu"
   ;         string var = "root1.Menu_mc.PanelContainer_mc.SettingsList_mc.EntryHolder_mc.Entry2.currentFrame"
   ;       the current frame of the third entry ( i.e. 2 = selected entry )
   ;         string menu = "WeaponsCraftingMenu"
   ;         string var = "root1.Menu_mc.ModsDirectory_mc.ModsList_mc.EntryHolder_mc.Entry0.Installed_mc.visible"
   ;       returns whether the MovieClp property visible is true or not ( i.e. whether the mod in the first entry is installed )
String Function GetAS3VariableAsString(String asMenuName, String asVarPath) native global



   ; ##### Utility #####
   ;
   ; # convert hex to int
Int Function HexToInt(String asHexString) native global
   ;
   ; # as it is more convenient than ( IntToHex(akForm.GetFormID()) )
String Function GetHexFormID(Form akForm) native global
   ;
   ; # returns true if the key with the given Virtual Key-Code ( Winuser.h ) is pressed
Bool Function IsKeyDown(Int aiKeyCode) native global



   ; ##### Version #####
   ;
   ; # returns the version of Cassiopeia ( e.g. v1.2 is 12, v2.0 is 20 )
Int Function GetCassiopeiaPapyrusExtenderVersion() native global
   ;
   ; # returns the SFSE version as Int ( e.g. 2120 for v0.2.12.0 )
Int Function GetSFSEVersionAsInt() native global
   ;
   ; # returns the SFSE version as String ( e.g. "0.2.12.0" for v0.2.12.0 )
String Function GetSFSEVersionAsString() native global
   ;
   ; # returns Starfield version as Int ( e.g. 113610 for v1.13.61 )
Int Function GetStarfieldVersionAsInt() native global
   ;
   ; # returns Starfield version as String ( e.g. "1.13.61.0" for v1.13.61 )
String Function GetStarfieldVersionAsString() native global



   ; ##### Dev #####
   ;
   ; # for development only
   ; # reads all lines ( each must contain a memory offset ) from the speficied file
   ; # then converts them to Address Library RelocationIDs
   ; # asFile example: ".\\Data\\SFSE\\Plugins\\events.txt"
Bool Function ConvertAddressFromFileToRelocationID(String asFile) native global
   ;
   ; # enables/disables global logging for Cassiopeia
Function EnableLogging(bool abEnable) native global




