Scriptname EBLNW:SpaceCombatScript extends Quest

ReferenceAlias Property PlayerShip Mandatory Const Auto
ReferenceAlias Property PlayerShipPilotSeat Mandatory Const Auto
ReferenceAlias Property CrimeVictim Const Auto
RefCollectionAlias Property Witnesses Const Auto
Quest Property EBLNW_Scanner Const Auto Mandatory
SQ_ParentScript Property SQ_Parent Const Auto Mandatory

Actor PlayerRef

Faction CrimeFaction
Int CrimeGoldViolent
Int CrimeGoldNonViolent
Int CPEVersion

BEScript BEQuest

Function RegisterForEvents()
	RegisterForRemoteEvent(PlayerRef, "OnPlayerCrimeGold")
	RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
	RegisterForRemoteEvent(PlayerShip, "OnShipLanding")
	RegisterForRemoteEvent(PlayerShip, "OnShipTakeOff")
	RegisterForRemoteEvent(PlayerShip, "OnShipGravJump")
	RegisterForRemoteEvent(PlayerShip, "OnShipFarTravel")
	RegisterForRemoteEvent(PlayerShip, "OnKill")
	RegisterForCustomEvent(SQ_Parent, "SQ_BEStarted")
EndFunction

Event OnQuestStarted()
	PlayerRef = game.GetPlayer()
	RegisterForEvents()
	ResetTracking()
	CPEVersion = CassiopeiaPapyrusExtender.GetCassiopeiaPapyrusExtenderVersion()
	;Debug.Trace("EBLNW_SpaceCombat quest started, CPE version is " + CPEVersion)
EndEvent

Event Actor.OnPlayerLoadGame(Actor akActor)
	CPEVersion = CassiopeiaPapyrusExtender.GetCassiopeiaPapyrusExtenderVersion()
	RegisterForEvents()
	;Debug.Trace("EBLNW_SpaceCombat game loaded, CPE version is " + CPEVersion)
EndEvent

Function ResetTracking()
	CrimeFaction = None
	CrimeGoldNonViolent = 0
	CrimeGoldViolent = 0
	CrimeVictim.Clear()
EndFunction

Event ReferenceAlias.OnShipLanding(ReferenceAlias akSender, bool abComplete)
	ResetTracking()
EndEvent

Event ReferenceAlias.OnShipTakeoff(ReferenceAlias akSender, bool abComplete)
	ResetTracking()
EndEvent

Event ReferenceAlias.OnShipFarTravel(ReferenceAlias shipAlias, Location aDepartureLocation, Location aArrivalLocation, int aState)
	ResetTracking()
EndEvent

; Event received when a ship grav jump event occurs - State { Initiated = 0, AnimStarted = 1, Completed = 2, Failed = 3 }
Event ReferenceAlias.OnShipGravJump(ReferenceAlias shipAlias, Location aDestination, int aState)
	If (aState == 2)
		ResetTracking()
	EndIf
EndEvent

; aeCrimeType 0 == theft, 1 == pickpocket, 2 == lockpick, 3 == assault, 4 == murder, 6 == piracy, 7 == contraband
Event Actor.OnPlayerCrimeGold(Actor akActor, ObjectReference akVictim, Form akFaction, int aeCrimeGold, int aeCrimeType)
	SpaceshipReference ShipVictim = akVictim as SpaceshipReference
	If !ShipVictim
		ShipVictim = akVictim.GetParentCell().GetParentRef() as SpaceshipReference
	EndIf
	;Debug.Trace("OnPlayerCrimeGold: victim " + akVictim + " ship " + ShipVictim + " faction " + akFaction + " gold " + aeCrimeGold + " type " + aeCrimeType)
	
	If ShipVictim
		If (akFaction != CrimeFaction)
			ResetTracking()
			CrimeVictim.ForceRefTo(ShipVictim)
			CrimeFaction = akFaction as Faction
			EBLNW_Scanner.Stop()
			EBLNW_Scanner.Start()	
		EndIf

		If (aeCrimeType == 3 || aeCrimeType == 4)
			CrimeGoldViolent += aeCrimeGold
		Else
			CrimeGoldNonViolent += aeCrimeGold
		EndIf

		CheckWitnesses()
	EndIf
EndEvent

Event ReferenceAlias.OnKill(ReferenceAlias akKiller, ObjectReference akVictim)
	SpaceshipReference ShipVictim = akVictim as SpaceshipReference
	If !ShipVictim
		ShipVictim = akVictim.GetParentCell().GetParentRef() as SpaceshipReference
	EndIf
	;Debug.Trace("OnKill killer " + akKiller + " victim " + akVictim + " ship " + ShipVictim)

	If (CrimeFaction)
		Witnesses.RemoveRef(akVictim)
		Witnesses.RemoveRef(ShipVictim)
		CheckWitnesses()
	EndIf
EndEvent

Event SQ_ParentScript.SQ_BEStarted(SQ_ParentScript akSender, Var[] akArgs)
	If (CrimeFaction)
		SpaceShipREference BEShip = akArgs[0] as SpaceShipReference
		BEQuest = akArgs[1] as BEScript

		If Witnesses.Find(BEShip) > -1
			RegisterForCustomEvent(BEQuest, "BEAllCrewDead")
			RegisterForCustomEvent(SQ_Parent, "SQ_BEForceStop")
		EndIf
	EndIf
EndEvent

Event SQ_ParentScript.SQ_BEForceStop(SQ_ParentScript akSender, Var[] akArgs)
	UnregisterForCustomEvent(BEQuest, "BEAllCrewDead")
EndEvent

Event BEScript.BEAllCrewDead(BEScript akSender, Var[] akArgs)
	UnregisterForCustomEvent(BEQuest, "BEAllCrewDead")
	Utility.Wait(0.5)
	Witnesses.RemoveRef(akSender.EnemyShip.GetReference())
	CheckWitnesses()
EndEvent

Function CheckWitnesses()
	If CrimeFaction != None && Witnesses.GetCount() == 0
		;Debug.Trace("No more witnesses! Total bounty " + (CrimeGoldNonViolent + CrimeGoldViolent))
		If (CrimeGoldNonViolent + CrimeGoldViolent) > 0
			If CPEVersion == 0
				Debug.Notification("Last witness eliminated. " + (CrimeGoldNonViolent + CrimeGoldViolent) + " bounty removed.")
			Else
				Debug.Notification("Last witness eliminated. " + (CrimeGoldNonViolent + CrimeGoldViolent) + " bounty removed from " + CassiopeiaPapyrusExtender.GetTESFullName(CrimeFaction) + ".")
			EndIf
			CrimeFaction.ModCrimeGold(0 - CrimeGoldNonViolent, false)
			CrimeFaction.ModCrimeGold(0 - CrimeGoldViolent, true)
			If CrimeFaction.GetCrimeGoldViolent() == 0
				CrimeFaction.SetPlayerEnemy(False)
			EndIf
		EndIf
		ResetTracking()
	EndIf
EndFunction
