Scriptname Aurie:STAY:DisableHavokOnAliasScript extends RefCollectionAlias

{This is a modified version of defaultDisableHavokOnLoad, with some extra lines to make sure havok is not turned off in Zero G.}

Group Autofill
    GlobalVariable Property STAY_DisableHavokScriptFinished Auto Mandatory
    {Used to determine if while loop is complete. We do not want to reset the quest in the middle of while loop.}
EndGroup

Group Optional_Properties
    bool property HavokOnHit = False Auto Const
    {Start Havok Sim when hit? DEFAULT: False}

    bool property HavokOnActivate = True Auto Const
    {Start Havok Sim when activated? DEFAULT: False Set to True by Stay Put}

    bool property HavokOnZKey = TRUE Auto Const
    {Start Havok Sim when grabbed by player? DEFAULT: False Set to true by Stay Put}

    bool property BeenSimmed = false auto hidden
    {Prevent an object that has been havok'd in-game from going static}

    float property HavokImpulseMagnitude = 0.07 auto const
    {havok impulse to apply when released to havok sim}
EndGroup

bool bHasChangedContainers

Event OnAliasInit()
    ; Debug.Notification("Begin disable havok")
    ; We use this global to determine when the while loop has completed.
    ; This keeps the quest from being reset in the middle of the while loop which can cause suspended stacks.
    STAY_DisableHavokScriptFinished.SetValue(0.0)
    ObjectReference[] theRefArray = new ObjectReference[0]
    theRefArray = GetArray()
    Int I = 0
    While I < theRefArray.Length
        ObjectReference currentRef = theRefArray[I]
        ObjectReference theContainer = currentRef.GetContainer()
        ; Make sure currentRef is not empty and that it is not in a container. No need to disable havok on items inside containers.
        If currentRef && theContainer == None  
            If (BeenSimmed == FALSE && currentRef.Is3DLoaded())
                ; Added to check if gravity is more than 0
                Float fGravity = currentRef.GetGravityScale()
                If fGravity > 0 as Float
                    currentRef.setMotionType(currentRef.Motion_Keyframed, FALSE)
                Else
                    ReleaseToHavok(currentRef)
                EndIf
                If !bHasChangedContainers
                    currentRef.MoveToMyEditorLocation()
                EndIf
                If HavokOnHit
                    RegisterForHitEvent(currentRef)
                EndIf
                ; Reset item position if script loads too late		
                currentRef.MoveToMyEditorLocation()
            EndIf
        EndIf
        I += 1
    EndWhile
    STAY_DisableHavokScriptFinished.SetValue(1.0)
    ; Debug.Notification("End disable havok")
EndEvent

Event OnContainerChanged(ObjectReference akSenderRef, ObjectReference akNewContainer, ObjectReference akOldContainer)
    bHasChangedContainers = TRUE
    BeenSimmed = TRUE
EndEvent

Event OnCellAttach(ObjectReference akSenderRef)
    If (beenSimmed == False && akSenderRef.Is3DLoaded()) 		
        akSenderRef.setMotionType(akSenderRef.Motion_Keyframed, FALSE)
        ; Reset item position if script loads too late		
        akSenderRef.MoveToMyEditorLocation()	
    EndIf	
EndEvent

EVENT OnLoad(ObjectReference akSenderRef)
    If akSenderRef.GetContainer() == None
        ; akSenderRef.MoveToMyEditorLocation() ; Move the item to default position before disabling havok
        If (BeenSimmed == FALSE && akSenderRef.Is3DLoaded())
            ; Added to check if gravity is more than 0
            Float fGravity = akSenderRef.GetGravityScale()
            If fGravity > 0 as Float
                akSenderRef.setMotionType(akSenderRef.Motion_Keyframed, FALSE)
            Else
                ReleaseToHavok(akSenderRef)
            EndIf
            If !bHasChangedContainers
                akSenderRef.MoveToMyEditorLocation()
            EndIf
            If HavokOnHit
                RegisterForHitEvent(akSenderRef)
            EndIf
            ; Reset item position if script loads too late		
            akSenderRef.MoveToMyEditorLocation()
        EndIf
    EndIf
endEVENT

EVENT OnUnload(ObjectReference akSenderRef)
    UnregisterForAllHitEvents(akSenderRef)
endEVENT

EVENT OnActivate(ObjectReference akSenderRef, ObjectReference akActionRef)
    If HavokonActivate == TRUE && BeenSimmed == FALSE
        ReleaseToHavok(akSenderRef)
    EndIf
endEVENT

EVENT onHit(ObjectReference akTarget, ObjectReference var1, Form var2, Projectile var3, bool var4, bool var5, bool var6, bool var7, string asMaterialName)
    If HavokOnHit == TRUE && BeenSimmed == FALSE
        ReleaseToHavok(akTarget)
    EndIf
endEVENT

EVENT OnGrab(ObjectReference akSenderRef)
    If HavokOnZkey == TRUE && BeenSimmed == FALSE
        ReleaseToHavok(akSenderRef)
    EndIf
endEVENT

FUNCTION ReleaseToHavok(ObjectReference akTarget)
    BeenSimmed = TRUE
    akTarget.setMotionType(akTarget.Motion_Dynamic, TRUE)
    akTarget.ApplyHavokImpulse(0, 0, 1, havokImpulseMagnitude)
endFUNCTION
