Scriptname Aurie:STAY:DisableHavokQuestResetScript extends Quest

Group Autofill
    Quest Property STAY_DisableHavokHandlerQuest Auto
    GlobalVariable Property STAY_DisableHavokScriptFinished Auto Mandatory
    {Used to determine if while loop is complete. We do not want to reset the quest in the middle of while loop.}
EndGroup

Function ResetDisableHavokHandlerQuest()
    ; We need to wait until the while loop has finished on the LoadedRefs alias. This is tracked using STAY_DisableHavokScriptFinished global
    ; The while loop waits until this global has been set to 1.0
    Int I = 0
    While STAY_DisableHavokScriptFinished.GetValue() < 1.0 && I < 50
        ; Debug.Notification("Waiting for LoadedRefs alias script to finish")
        Utility.Wait(0.1)
    EndWhile
    STAY_DisableHavokHandlerQuest.Stop()
    ;We must wait until the quest has stopped before restarting the quest. Using Stop() and immediately Start() may fail. 
    I = 0
    While !STAY_DisableHavokHandlerQuest.IsStopped() && I < 50
        Utility.Wait(0.1)
        I += 1
    endWhile
    STAY_DisableHavokHandlerQuest.Start()
EndFunction
