ScriptName _CostofLivingScript Extends Quest

    LocationAlias property PlayerOutpostLocation auto const mandatory
    { filled when player enters an outpost location }

    ReferenceAlias property PlayerOutpostBeacon auto const mandatory
    { filled when player enters an outpost location }

    WwiseEvent Property ITM_Credits_Down_WEF Mandatory Const Auto

Group COLActors
    Actor Property PlayerRef Auto Const
EndGroup

Group COLMisc
	MiscObject Property Credits Auto Const
EndGroup

Group COLKeywords
    Keyword Property LocTypeSettledPlanet Mandatory Const Auto
    Keyword Property LocTypeSettledSystem Mandatory Const Auto
    Keyword Property LocTypePlayerHouse Mandatory Const Auto
    Keyword Property LocTypeMajorOrbital Mandatory Const Auto
    Keyword Property LocTypeOutpost Mandatory Const Auto
    Keyword Property LocTypeStarSystem Mandatory Const Auto
    Keyword Property LocSystemFactionFreestarCollective Mandatory Const Auto
    Keyword Property LocSystemFactionUnitedColonies Mandatory Const Auto
    Keyword Property LocSystemFactionHouseVaruun Mandatory Const Auto
    ;compat work
    Keyword Property _col_PlayerHouseKey Mandatory Const Auto
EndGroup

Group COLKeys
    ;keys to detect ownership
    Key Property CityNewAtlantisWellApartmentKey Mandatory Const Auto
    Key Property CityNewAtlantisPenthouseKey Mandatory Const Auto
    Key Property FCNeon_SleepCratePlayerHomeKey Mandatory Const Auto
    Key Property FCNeon_TradeTowerPlayerHomeKey Mandatory Const Auto
    Key Property CityAkilaCityMidtownHouseKey Mandatory Const Auto
    Key Property CityAkilaCityCoreHouseKey Mandatory Const Auto
EndGroup

Group COLGlobals
    ;vanilla house trackers
    GlobalVariable Property _colNAwellowned Mandatory Const Auto
    GlobalVariable Property _colNApentowned Mandatory Const Auto
    GlobalVariable Property _colACmidowned Mandatory Const Auto
    GlobalVariable Property _colACcoreowned Mandatory Const Auto
    GlobalVariable Property _colNEcrateowned Mandatory Const Auto
    GlobalVariable Property _colNEtradeowned Mandatory Const Auto
    ;times
    GlobalVariable Property _colDaysToPay Mandatory Const Auto
    GlobalVariable Property _colLastWeek Mandatory Const Auto
    ;Outpost costs
    GlobalVariable Property _colUCSystemTax Mandatory Const Auto
    GlobalVariable Property _colFCSystemTax Mandatory Const Auto
    GlobalVariable Property _colUCPlanetTax Mandatory Const Auto
    GlobalVariable Property _colFCPlanetTax Mandatory Const Auto
    ;Home costs
    GlobalVariable Property _colapartmenttax Mandatory Const Auto
    GlobalVariable Property _colhousetax Mandatory Const Auto
    ;systems
    GlobalVariable Property _colPenaltyfee Mandatory Const Auto
    GlobalVariable Property _coltaxinterest Mandatory Const Auto
    ;GlobalVariable Property _colHVSystemTax Mandatory Const Auto
    ;GlobalVariable Property _colGenericPlanetTax Mandatory Const Auto
    GlobalVariable Property _col_enabled Mandatory Const Auto
EndGroup

Group COLLocations
    Location Property SCheyenne_PAkila Mandatory Const Auto
    Location Property SCheyenne_PAkila_MAntharum Mandatory Const Auto
    Location Property SCheyenne_PAkila_MBindi Mandatory Const Auto
    Location Property SCheyenne_PAkila_MCodos Mandatory Const Auto
    Location Property SSol_PMars Mandatory Const Auto
    Location Property SSol_PMars_MPhobos Mandatory Const Auto
    Location Property SAlphaCentauri_PJemison Mandatory Const Auto
    Location Property SAlphaCentauri_PJemison_MKurtz Mandatory Const Auto
EndGroup

Group COLFActions
    Faction Property CrimeFactionUC Mandatory Const Auto
    Faction Property CrimeFactionFreestar Mandatory Const Auto
EndGroup

Group COLMessages
    ;System Messages for Outposts
    Message Property _col_RegSystemClaimMSG Mandatory Const Auto
    Message Property _col_RegWorldClaimMSG Mandatory Const Auto
    Message Property _colRegFailed Mandatory Const Auto
    Message Property _colCancelReg Mandatory Const Auto
    Message Property _colCongrats Mandatory Const Auto
    ;Penalty system messages for Outposts
    Message Property _col_BeaconUpMsg Mandatory Const Auto
    Message Property _col_OutpostBountyMsg Mandatory Const Auto
    ;System Messages for Taxes
    Message Property _col_TaxWarnMsg Mandatory Const Auto
    Message Property _col_TaxSuccessMsg Mandatory Const Auto
    ;registration messages
    ;Message Property _colNAwellownermsg Mandatory Const Auto
    ;Message Property _colNApentownermsg Mandatory Const Auto
    ;Message Property _colACmidownermsg Mandatory Const Auto
    ;Message Property _colACcoreownermsg Mandatory Const Auto
    ;Message Property _colNEcrateownermsg Mandatory Const Auto
    ;Message Property _colNEtradeownermsg Mandatory Const Auto
EndGroup

;/
Group COLCollections
    RefCollectionAlias property CargoLinks auto const mandatory
EndGroup
/;

bool delinquentbeacon = false

;Check home ownership via keys
Function DetectOwnership()
    Actor Player = Game.GetPlayer()
    ;int outposts = BorrowedOutpostCounter()
    ;Key and optional quest stage checks for each
    If Player.GetItemCount(CityNewAtlantisPenthouseKey) > 0
    _colNApentowned.SetValue(1)
    EndIf
    If Player.GetItemCount(CityNewAtlantisWellApartmentKey) > 0
    _colNAwellowned.SetValue(1)
    EndIf
    If Player.GetItemCount(CityAkilaCityCoreHouseKey)
    _colACcoreowned.SetValue(1)
    EndIf
    If Player.GetItemCount(CityAkilaCityMidtownHouseKey)
    _colACmidowned.SetValue(1)
    EndIf
    If Player.GetItemCount(FCNeon_SleepCratePlayerHomeKey)
    _colNEcrateowned.SetValue(1)
    EndIf
    If Player.GetItemCount(FCNeon_TradeTowerPlayerHomeKey)
    _colNEtradeowned.SetValue(1)
    EndIf
    ;If outposts >= 1
    ;Debug.Notification(outposts as int + " Outposts detected.")
    ;EndIf
EndFunction

;Preliminary function for regular deductions
;Currently only for player homes
Function Taxation()
    int taxfee = 0
    int mod = PlayerRef.GetItemCount(_col_PlayerHouseKey)
    int rich = _colACcoreowned.GetValue() as int + _colNEtradeowned.GetValue() as int  + _colNApentowned.GetValue() as int 
    int poor = _colNAwellowned.GetValue() as int + _colACmidowned.GetValue() as int  + _colNEcrateowned.GetValue() as int + mod
    ;Debug.Trace("_COL detected " + rich as string + " high value homes & " + poor as string + " low value homes, " + mod as string + "mod homes")
    int mortgage = Math.Ceiling(Utility.GetCurrentGameTime() as int - _colLastWeek.GetValue() as int)
    if mortgage > _colDaysToPay.GetValue()
    ;Debug.Trace("_COL detected it has been a week")
        taxfee = Math.Floor((poor * _colapartmenttax.GetValue()) + (rich * _colhousetax.GetValue())) + _coltaxinterest.GetValue() as int
        If PlayerRef.GetItemCount(Credits) > taxfee
            Utility.Wait(4)
            PlayerRef.RemoveItem(Credits, taxfee, true)
            _col_TaxSuccessMsg.Show(taxfee)
            Jingle()
            ;No interest even if there was previously
            _coltaxinterest.SetValue(0)
        Else
        _coltaxinterest.SetValue(Math.Round(taxfee * 1.2))
        Utility.Wait(3)
        _col_TaxWarnMsg.Show(rich + poor, taxfee, _colDaysToPay.GetValue())
        EndIf
    _colLastWeek.SetValue(Utility.GetCurrentGameTime())
    Else
    ;Debug.Trace("_COL detected " + mortgage as string + " days")
    EndIf
EndFunction

Function Jingle()
    ;GlobalVariable colmute = Game.GetFormFromFile(0x00000, "costofspacing.esm")
	;If colmute.GetValue() == 0
		ITM_Credits_Down_WEF.PlayAndWait(PlayerRef, None, None)
	;EndIf
EndFunction

;Withdraw registration fees upon outpost establishment
;aiFaction: 1=UC, 2=FC, 3=HV
;WorldMult determined by planet's habitation status
bool Function PayOutpostRegCost(int aiFaction, float afWorldMult, bool abPlanetClaimed)
    int creditfee = 0
    ;Check whose system we are colonizing
    If aiFaction == 1
        creditfee = Math.Round(_colUCSystemTax.GetValue() * Utility.RandomFloat(0.7, 1.3))
    ElseIf aiFaction == 2
        creditfee = Math.Round(_colFCSystemTax.GetValue() * Utility.RandomFloat(0.7, 1.3))
    ;ElseIf aiFaction == 3
        ;creditfee = _colHVSystemTax.GetValue() as int
    EndIf
    ;If the planet is occupied, by whom?
    If abPlanetClaimed == true
        If aiFaction == 1
            creditfee += Math.Round(_colUCPlanetTax.GetValue() * afWorldMult)
        ElseIf aiFaction == 2
            creditfee += Math.Round(_colFCPlanetTax.GetValue() * afWorldMult)
        EndIf
    EndIf
    creditfee = Math.Round((creditfee / 100) * 100)
    _colPenaltyfee.SetValue(creditfee)
    ;Now we want to request payment from the player. This is a big expense so we need a big penalty
    ;Test: pass false as bool and handle in the event for now
    int ButtonPressed = 2
    Utility.Wait(3)
    if abPlanetClaimed == false
    ButtonPressed = _col_RegSystemClaimMSG.Show(creditfee)
    elseif abPlanetClaimed == true
    ButtonPressed = _col_RegWorldClaimMSG.Show(creditfee)
    EndIF
    If ButtonPressed == 0
        If PlayerRef.GetItemCount(Credits) > creditfee
        PlayerRef.RemoveItem(Credits, creditfee)
        return true
        Else
        Utility.Wait(3)
        _colRegFailed.Show()
        return false
        EndIf
    ElseIf ButtonPressed == 1
    return false
    Else
    return false
    EndIf
EndFunction

;Returns 2 for FC 3 for UC 4 for HV
Int Function CheckSystemOwnership(Location akLocation)
    int sys = 1
    Location[] ClaimSystem = akLocation.GetParentLocations(LocTypeStarSystem)
        If ClaimSystem
            ;We are in a settled system. Whose?
            Location system = ClaimSystem[0]
            If system.HasKeyword(LocTypeSettledSystem)
           ; Debug.Trace("_COL detected settled system!")
                If system.HasKeyword(LocSystemFactionFreestarCollective)
                sys = 2
                ElseIf system.HasKeyword(LocSystemFactionUnitedColonies)
                sys = 3
                ElseIf system.HasKeyword(LocSystemFactionHouseVaruun)
                sys = 4
                EndIf
            EndIf
        EndIf
    return sys
EndFunction

Event OnQuestInit()
    DetectOwnership()
    RegisterForRemoteEvent(PlayerRef, "OnOutpostPlaced")
    RegisterForRemoteEvent(PlayerRef, "OnWorkshopMode")
    RegisterForRemoteEvent(PlayerRef, "OnLocationChange")
    Taxation()
    int whenarewe = Utility.GetCurrentGameTime() as int
    if whenarewe > 2
    whenarewe -= 1
    endif
    _colLastWeek.SetValue(whenarewe)
    ;Debug.Trace("_COL initialized on day " + whenarewe as string)
    Debug.Notification("Cost of Living initialized.")
EndEvent

;Charge for initialization of outposts in settled systems
;Taxation system will be checked against cargo links
;Non-cargo equipped outposts are free to run
Event Actor.OnOutpostPlaced(Actor PlayerRef, ObjectReference akOutpostBeacon)
    If _col_enabled.GetValue() == 1
    Location Claim = akOutpostBeacon.GetCurrentLocation()
    ;Debug.Trace("_COL detected outpost placement at" + akOutpostBeacon.GetCurrentLocation() as string)
    ;Debug.Trace("_COL trying to find beacon as" + akOutpostBeacon)
    ;First check if the system is settled at all before triggering logic
    Location[] ClaimSystem = Claim.GetParentLocations(LocTypeStarSystem)
        If ClaimSystem
            int factcheck = 4
            float planetcheck = 1
            bool settled = false
            ;We are in a settled system. Whose?
            Location system = ClaimSystem[0]
            If system.HasKeyword(LocTypeSettledSystem)
            ;Debug.Trace("_COL detected settled system!")
                If system.HasKeyword(LocSystemFactionFreestarCollective)
                factcheck = 1
                ElseIf system.HasKeyword(LocSystemFactionUnitedColonies)
                factcheck = 2
                ;ElseIf system.HasKeyword(LocSystemFactionHouseVaruun)
                ;factcheck = 3
                EndIf
                ;Now check if the planet is settled for extra costs
                Location[] ClaimWorld = Claim.GetParentLocations(LocTypeMajorOrbital)
                If ClaimWorld
                    Location world = ClaimWorld[0]
                    If world.HasKeyword(LocTypeSettledPlanet)
                    settled = true
                    ;Debug.Trace("_COL detected settled planet!")
                        ;Is it a capital world or moon?
                        If world == SCheyenne_PAkila || world == SCheyenne_PAkila_MAntharum || world == SCheyenne_PAkila_MBindi || world == SCheyenne_PAkila_MCodos
                        planetcheck = 1.75
                        ElseIf world == SAlphaCentauri_PJemison || world == SAlphaCentauri_PJemison_MKurtz
                        planetcheck = 4.25
                        ElseIf world == SSol_PMars || world == SSol_PMars_MPhobos
                        planetcheck = 2.25
                        Else
                        planetcheck = 1.75
                        EndIf
                    EndIf
                EndIf
            ;Bring up payment flow
            bool AllowReg = PayOutpostRegCost(factcheck, planetcheck, settled)
                ;Player cancelled or was unable to pay
                If AllowReg == false
                ;Debug.MessageBox("Pick up that beacon before leaving citizen")
                ;Warn the player to remove the outpost before leaving
                Utility.Wait(4)
                _colCancelReg.Show()
                ;Fill aliases to check elsewhere in OnWorkshopObjectRemoved
                PlayerOutpostLocation.ForceLocationTo(PlayerRef.GetCurrentLocation())
                PlayerOutpostLocation.RefillDependentAliases()
                RegisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
                delinquentbeacon = true
                ;Debug.Trace("_COL detected lollygagging re: " + akOutpostBeacon as string + " in " + Claim as string)
                ;Player forked over the starbux. Congratulations!
                Elseif AllowReg == true
                Utility.Wait(6)
                _colCongrats.Show()
                _colPenaltyfee.SetValue(0)
                EndIf
            EndIf
        EndIf
    EndIf
EndEvent

Event Actor.OnLocationChange(Actor PlayerRef, Location akOldLoc, Location akNewLoc)
    If _col_enabled.GetValue() == 1
    ;Debug.Trace(akOldLoc as string + " _COL going on " + akNewLoc as string)
    DetectOwnership()
    Taxation()
    ;Player left an unregistered beacon behind
    if delinquentbeacon == true
        Location BeaconIsIn = PlayerOutpostLocation.GetLocation()
        int fac = CheckSystemOwnership(BeaconIsIn)
        int pen = _colPenaltyfee.GetValue() as int
        if fac > 1
            if fac == 2
            CrimeFactionFreestar.ModCrimeGold(pen)
            elseif fac == 3
            CrimeFactionUC.ModCrimeGold(pen)
            Else
            CrimeFactionUC.ModCrimeGold(pen)
            endif
        EndIf
    Utility.Wait(4)
    _col_OutpostBountyMsg.Show(pen)
    ;Debug.MessageBox("stop right there citizen")
    ;Clean up aliases and reg
    _colPenaltyfee.SetValue(0)
    UnregisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
    delinquentbeacon = false
    PlayerOutpostBeacon.Clear()
    PlayerOutpostLocation.Clear()
    endif
    EndIf
EndEvent

;Watching for citizen to pick up the can
Event ReferenceAlias.OnWorkshopObjectRemoved(ReferenceAlias akSource, ObjectReference akReference)
    If _col_enabled.GetValue() == 1
    ;Debug.Trace("_COL removed object is " + akReference as string)
    ;Debug.Trace("_COL removed source is " + akSource as string)
    ;Player should and did remove the beacon
    if delinquentbeacon == true && akReference == PlayerOutpostBeacon.GetReference()
    Utility.Wait(4)
    _col_BeaconUpMsg.Show()
    ;Clear penalty
    _colPenaltyfee.SetValue(0)
    delinquentbeacon = false
    ;Clean up aliases and reg
    UnregisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
    PlayerOutpostBeacon.Clear()
    PlayerOutpostLocation.Clear()
    endif
    EndIf
EndEvent

;/dynamic player house detection for mods
Event ReferenceAlias.OnWorkshopMode(ReferenceAlias akSenderRef, bool aStart)
    Debug.Trace("_COL detected workshop mode!")
    Location Shop = Game.GetPlayer().GetCurrentLocation()
    If Shop.HasKeyword(LocTypePlayerHouse) || Shop.HasKeyword(LocTypeOutpost)
    Debug.Trace("_COL detected player modifying home location!")
    Location[] ShopWorld = Shop.GetParentLocations(LocTypeMajorOrbital)
        If ShopWorld
        Location HousePlanet = ShopWorld[0]
        Debug.Trace("_COL detected home is on" + HousePlanet as string)
        EndIf
    EndIf
EndEvent
/;

;/
;Duplicates vanilla function that checks number of established cargo links
;This will be used for future regular taxation
int Function BorrowedOutpostCounter()
    CargoLinks.RefillAlias()
    int cargoLinkCount = CargoLinks.GetCount()
    ;debug.trace(self + " cargoLinkCount=" + cargoLinkCount)
    if cargoLinkCount > 0
        ; count how many outposts are linked
        ObjectReference[] linkedOutposts = new ObjectReference[0]
        int i = 0
        while i < cargoLinkCount
            OutpostCargoLinkMarkerScript cargoLinkRef = CargoLinks.GetAt(i) as OutpostCargoLinkMarkerScript
            ;debug.trace(self + " i=" + i + ": cargoLinkRef=" + cargoLinkRef)
            if cargoLinkRef
                ObjectReference myOutpostRef = cargoLinkRef.GetWorkshop()
                ;debug.trace(self + "    islinked=" + cargoLinkRef.isLinked + " myOutpostRef=" + myOutpostRef)
                if myOutpostRef && cargoLinkRef.isLinked
                    ; add outpost to list if it isn't already in it
                    int foundOutpost = linkedOutposts.Find(myOutpostRef)
                    if foundOutpost < 0
                        ;debug.trace(self + " adding linked outpost " + myOutpostRef)
                        linkedOutposts.Add(myOutpostRef)
                    endif
                endif
            endif
            i += 1
        EndWhile
    EndIf
    return cargoLinkCount
EndFunction
/;