Scriptname LJailScript_DoorMenuOpen Extends TerminalMenu

Int Property CloseMenuId Auto Const
Keyword Property DoorLinkKeyword Auto Const
ActorValue Property ClosedDoorsValue Auto Const

Event OnTerminalMenuItemRun(Int auiMenuItemID, TerminalMenu akTerminalBase, ObjectReference akTerminalRef)
    If auiMenuItemID == CloseMenuId
        ObjectReference[] children = akTerminalRef.GetLinkedRefChain(DoorLinkKeyword, 99)
        CloseDoors(akTerminalRef, children)
        CloseDoors(akTerminalRef, akTerminalRef.GetRefsLinkedToMe(DoorLinkKeyword, none))

    EndIf
EndEvent

Function CloseDoors(ObjectReference Terminal, ObjectReference[] doors)
    Int index = 0
    While index < doors.Length
        ObjectReference door = doors[index]
        door.setOpen(false)
        index += 1
    EndWHile
    Terminal.SetValue(ClosedDoorsValue, 1)
EndFunction