Scriptname LJailScript_SceneTurnPrisoners Extends Scene


LJailScript_Quest Property Manager Auto Const

GlobalVariable Property PrisonerCount Auto
GlobalVariable Property TotalPrisonerCost Auto

Event OnPhaseBegin(Int auiPhaseIndex)
    If auiPhaseIndex == 1
        TurnOverPrisoners()
        Game.RequestDialogueExit()
    EndIf
EndEvent  

Event OnBegin()
    Manager.CalculateGlobals()
EndEvent

Function TurnOverPrisoners()
    Manager.CalculateGlobals()

    int prisonerIndex = 0
    While prisonerIndex < Manager.GetArrestedActors().Length
        Actor act = Manager.GetArrestedActors()[prisonerIndex]

        Manager.Release(act, false)
        act.Disable(False)
        act.Kill(none)

        prisonerIndex += 1
    EndWhile

    Game.GetPlayer().AddItem(Game.GetCredits(), TotalPrisonerCost.GetValueInt(), False)
    TotalPrisonerCost.SetValueInt(0)
    PrisonerCount.SetValueInt(0)

    Manager.UpdateCurrentInstanceGlobal(TotalPrisonerCost)
    Manager.UpdateCurrentInstanceGlobal(PrisonerCount)

EndFunction