#include <windows.h>
#include <math.h>

#include "types.h"
#include "natives.h"
#include "enums.h"
#include "main.h"

#include "strauss_enums.h"

#define LERP(a, b, t) ((a) + ((b) - (a)) * (t))
#define RAND_RANGE(min, max) (LERP(min, max, float(rand())/float(RAND_MAX)))

void script_main() {
	srand(GetTickCount());
	while (true) {
		#ifdef _DEBUG
			WAIT(3000);
		#else
			WAIT(RAND_RANGE(60000, 120000));
		#endif

		Ped peds[1024];
		int count = worldGetAllPeds(peds, 1024);
		for (int i = 0; i < count; i++) {
			if (ENTITY::GET_ENTITY_MODEL(peds[i]) == CS_leostrauss) {
				Vector3 position = ENTITY::GET_ENTITY_COORDS(peds[i], TRUE, FALSE);
				float ground_z;
				if (!GAMEPLAY::GET_GROUND_Z_FOR_3D_COORD(position.x, position.y, position.z, &ground_z, false)) {
					ground_z = position.z;
				}
				PED::SET_PED_TO_RAGDOLL(peds[i], 2000, 10000, 0, false, false, false);
				ENTITY::APPLY_FORCE_TO_ENTITY(peds[i], APPLY_TYPE_EXTERNAL_IMPULSE,
					RAND_RANGE(-10.0f, 10.0f), // x
					RAND_RANGE(-10.0f, 10.0f), // y
					25.0f,                     // z
					0.0f, 0.0f, 0.0f, 0, false, true, true, false, true);
				FIRE::ADD_EXPLOSION(position.x, position.y, ground_z, EXP_TAG_DYNAMITE, 1.0f, true, false, 1.0f);
				break;
			}
		}
	}
}

BOOL APIENTRY DllMain(HMODULE hInstance, DWORD reason, LPVOID lpReserved) {
	switch (reason) {
	case DLL_PROCESS_ATTACH:
		scriptRegister(hInstance, script_main);
		break;
	case DLL_PROCESS_DETACH:
		scriptUnregister(hInstance);
		break;
	}
	return TRUE;
}
