scriptname BMOEffect extends ActiveMagicEffect

Actor Property PlayerRef auto Const

ActorValue Property CarbonDioxide auto Const
ActorValue Property Oxygen auto Const

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, Float afMagnitude, Float afDuration)
	
	RegisterForActorValueLessThanEvent(PlayerRef, Oxygen, 5)
	
EndEvent


Event OnActorValueLessThan(ObjectReference akObjRef, ActorValue akActorValue)
	
	If akObjRef == PlayerRef && akActorValue == Oxygen
		StartTimer(0.25, 0)
	EndIf	
	
EndEvent

Event OnTimer(int aiTimerID)
	if aiTimerID == 0
		if PlayerRef.GetValue(Oxygen) <= 5
			PlayerRef.DamageValue(CarbonDioxide, 5)
				StartTimer(0.25, 0)
		else
			return
		EndIf
	EndIf
EndEvent