scriptname BMOmain extends Quest

Import CassiopeiaPapyrusExtender


Actor Property PlayerRef auto Const

Spell Property BM_SprintSpell auto Const
Spell Property BM_SprintSpellStrafe auto Const
Spell Property BM_OxygenSpell auto Const


MagicEffect Property BM_SprintEffect auto Const
MagicEffect Property BM_SprintEffectStrafe auto Const
MagicEffect Property BM_OxygenEffect auto Const


Function RegisterMe()
	Utility.Wait(1.0)
	RegisterForNativeEvent("BMOmain", "BSInputEvent")
	RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
EndFunction

Function AddSpell()
	
	if !PlayerRef.HasSpell(BM_SprintSpell)
		PlayerRef.AddSpell(BM_SprintSpell)
	Endif	
	
	if !PlayerRef.HasSpell(BM_SprintSpellStrafe)
		PlayerRef.AddSpell(BM_SprintSpellStrafe)
	Endif
	
	if !PlayerRef.HasSpell(BM_OxygenSpell)
		PlayerRef.AddSpell(BM_OxygenSpell)
	Endif
	
EndFunction


Event OnQuestInit()
	RegisterMe()
	AddSpell()
EndEvent

Event Actor.OnPlayerLoadGame(Actor akActor)
	RegisterMe()
	AddSpell()
EndEvent



Function Cast0()

	BM_SprintSpell.Cast(PlayerRef)
	BM_OxygenSpell.Cast(PlayerRef)
	StartTimer(0.1, 0)
	
EndFunction


Function Cast1()

	BM_SprintSpellStrafe.Cast(PlayerRef)
	BM_OxygenSpell.Cast(PlayerRef)
	StartTimer(0.1, 1)
	
EndFunction


Function CleanUp()
	PlayerRef.DispelSpell(BM_SprintSpell)
	PlayerRef.DispelSpell(BM_SprintSpellStrafe)
	PlayerRef.DispelSpell(BM_OxygenSpell)
EndFunction

Function BSInputEvent(Int aiKeyCode, String asControlName, String asFriendlyName, bool bPressed, Float afHeldTime) global
	BMOmain QS = (Game.GetFormFromFile(0x80D, "Better Backward Movement.esm") as Quest) as BMOmain
	
	if asControlName == "Sprint" && GetHoldTimeByControlName("Back") > 0 && afHeldtime <= 0.1
		QS.Cast0()
	Endif
	
	if asControlName == "Sprint" && (GetHoldTimeByControlName("StrafeLeft") > 0 || GetHoldTimeByControlName("StrafeRight") > 0) && GetHoldTimeByControlName("Forward") <= 0 && afHeldTime <= 0.1
		QS.Cast1()
	Endif
EndFunction

Event OnTimer(int aiTimerID)
	if aiTimerID == 0
	
		if GetHoldTimeByControlName("Back") <= 0 || GetHoldTimeByControlName("Sprint") <= 0 || GetHoldTimeByControlName("Forward") > 0
			Utility.Wait(0.1)
			CleanUp()
		elseif GetHoldTimeByControlName("StrafeRight") > 0 || GetHoldTimeByControlName("StrafeLeft") > 0
			PlayerRef.DispelSpell(BM_SprintSpell)
			Cast1()
		else
			StartTimer(0.1, 0)
		Endif
	elseif aiTimerID == 1
		
		if (GetHoldTimeByControlName("StrafeRight")<=0 && GetHoldTimeByControlName("StrafeLeft") <= 0) || GetHoldTimeByControlName("Sprint") <=0 || GetHoldTimeByControlName("Forward") > 0
			CleanUp()

		else
			StartTimer(0.1, 1)
		Endif
	Endif		
			
EndEvent
