Scriptname NEG_EnhancerGunEffectScript extends ActiveMagicEffect

PROJECTILE Property NEG_ParticleProjectileEnhancerGun Auto Const
ObjectReference Property NEG_dummyNPC Auto Const
Actor Property PlayerRef Auto Const
MagicEffect Property NEG_EnhancerGunEffect Auto Const

;MESSAGE BOX PROPERTIES
Message Property NEG_MessageBox1 Mandatory Const Auto
Message Property NEG_MessageBoxCmbCert Auto Const
Message Property NEG_MessageBoxCmbSpec Auto Const
Message Property NEG_MessageBoxPhysical Auto Const
Message Property NEG_MessageBoxScience Auto Const
Message Property NEG_MessageBoxSkillGroup Auto Const
Message Property NEG_MessageSkillBoxSkillLevel Auto Const
Message Property NEG_MessageBoxSocial Auto Const
Message Property NEG_MessageBoxTechOther Auto Const
Message Property NEG_MessageBoxTechWpnSys Auto Const

;SKILL PROPERTIES
;Physical 1
Perk Property Crew_Stealth Auto Const
Perk Property Crew_WeightLifting Auto Const
Perk Property Crew_Wellness Auto Const
Perk Property Crew_EnergyWeaponDissipation Auto Const
Perk Property Crew_PainTolerance Auto Const
Perk Property Crew_Concealment Auto Const

;Social 2
Perk Property Crew_Gastronomy Auto Const
Perk Property Crew_Scavenging Auto Const
Perk Property Crew_Theft Auto Const
Perk Property Crew_Leadership Auto Const
Perk Property Crew_Outpost_Management Auto Const
Perk Property Crew_Xenosociology Auto Const

;Combat Certifications 3
Perk Property Crew_PistolCertification Auto Const
Perk Property Crew_ShotgunCertification Auto Const
Perk Property Crew_RifleCertification Auto Const
Perk Property Crew_SniperCertification Auto Const
Perk Property Crew_Demolitions Auto Const

;Combat Specializations 4
Perk Property Crew_Lasers Auto Const
Perk Property Crew_Ballistics Auto Const
Perk Property Crew_ParticleBeams Auto Const
Perk Property Crew_Marksmanship Auto Const
Perk Property Crew_Sharpshooting Auto Const
Perk Property Crew_Incapacitation Auto Const

;Science 5
Perk Property Crew_Ship_Astrodynamics Auto Const
Perk Property Crew_Chemistry Auto Const
Perk Property Crew_Geology Auto Const
Perk Property Crew_Medicine Auto Const
Perk Property Crew_Botany Auto Const
Perk Property Crew_Outpost_Engineering Auto Const
Perk Property Crew_AneutronicFusion Auto Const

;Tech Weapon Systems 6
Perk Property Crew_Ship_Weapons_Ballistic Auto Const
Perk Property Crew_Ship_Weapons_Energy Auto Const
Perk Property Crew_Ship_Weapons_Missile Auto Const
Perk Property Crew_Ship_Weapons_ParticleBeam Auto Const
Perk Property Crew_Ship_Weapons_EM Auto Const

;Tech Other 7
perk Property Crew_Ship_Piloting Const Auto
Perk Property Crew_Ship_Payloads Auto Const
Perk Property Crew_Ship_Shields Auto Const
Perk Property Crew_Ship_StarshipEngineering Auto Const
Perk Property Crew_Robotics Auto Const


;This is the main script when the projectile hits the NPC

Event OnEffectStart(ObjectReference akTarget, Actor akCaster, MagicEffect akBaseEffect, float afMagnitude, float afDuration)
	Actor targetNPC = akTarget as Actor
	Actor dummyNPC = NEG_dummyNPC as Actor
	Int GunChoice = NEG_MessageBox1.Show()
	If GunChoice == 1
		If targetNPC
		;copy Player appearance to dummyNPC
		dummyNPC.CopyAppearance(PlayerREF)
		;Copy Target appearace to Player
		PlayerRef.CopyAppearance(targetNPC)
		;Open the Enhance menu and wait 1 second
		Game.ShowRaceMenu(none, 2, none, none)
		debug.MessageBox("Change the Avatar to whatever you want the NPC to look like. Save with YOUR character's name")
		Utility.Wait(1.0)
		;Copy current player appearance to the target
		targetNPC.CopyAppearance(PlayerREF)
		;Copy AFG_dummyNPC appearace to Player
		PlayerRef.CopyAppearance(dummyNPC)
   		EndIf
	ElseIf GunChoice == 2
	Int SkillGroup = NEG_MessageBoxSkillGroup.Show()
	;debug.MessageBox("Skillgroup: " + SkillGroup)
	Int SkillChoice = WhichChoice(SkillGroup)
	;debug.MessageBox("SkillChoice: " + SkillChoice)
	Int SkillLevel = NEG_MessageSkillBoxSkillLevel.Show()
		If SkillLevel == 1
		; Remove all ranks of the perk
			targetNPC.RemovePerk(WhichSkill(SkillGroup, SkillChoice))
		Else
        ; Add the appropriate number of ranks to the perk
        Int SkillCounter = 1
        While SkillCounter <= SkillLevel - 1
            targetNPC.AddPerk(WhichSkill(SkillGroup, SkillChoice))
            SkillCounter += 1
        EndWhile
    EndIf				
	ElseIf GunChoice == 3
		targetNPC.UnequipAll()
	ElseIf GunChoice == 4
		targetNpc.OpenInventory(true)
	ElseIf GunChoice == 0
	debug.MessageBox("Have an awesome day!")
	EndIf	
EndEvent

Int Function WhichChoice(Int SkillGroup)
	If (SkillGroup == 1)
		Int SkillChoice = NEG_MessageBoxPhysical.Show()
		Return SkillChoice
	ElseIf (SkillGroup == 2)
		Int SkillChoice = NEG_MessageBoxSocial.Show()
		Return SkillChoice
	ElseIf (SkillGroup == 3)
		Int SkillChoice = NEG_MessageBoxCmbCert.Show()
		Return SkillChoice
	ElseIf (SkillGroup == 4)
		Int SkillChoice = NEG_MessageBoxCmbSpec.Show()
		Return SkillChoice
	ElseIf (SkillGroup == 5)
		Int SkillChoice = NEG_MessageBoxScience.Show()
		Return SkillChoice
	ElseIf (SkillGroup == 6)
		Int SkillChoice = NEG_MessageBoxTechWpnSys.Show()
		Return SkillChoice
	ElseIf (SkillGroup == 7)
		Int SkillChoice = NEG_MessageBoxTechOther.Show()
		Return SkillChoice	
	Else
		Return 0			
	EndIf
EndFunction	

Function WhichLevel()
	; stuff
EndFunction

Perk Function WhichSkill(int SkillGroup, int SkillChoice)
; Physical Skills
    If (SkillGroup == 1 && SkillChoice == 1)
        Return Crew_Stealth 
    ElseIf (SkillGroup == 1 && SkillChoice == 2)
		Return Crew_WeightLifting
    ElseIf (SkillGroup == 1 && SkillChoice == 3)
		Return Crew_Wellness
	ElseIf (SkillGroup == 1 && SkillChoice == 4)
		Return Crew_EnergyWeaponDissipation
	ElseIf (SkillGroup == 1 && SkillChoice == 5)
		Return Crew_PainTolerance
	ElseIf (SkillGroup == 1 && SkillChoice == 6)
		Return Crew_Concealment
; Social Skills
    ElseIf (SkillGroup == 2 && SkillChoice == 1)
		Return Crew_Gastronomy
    ElseIf (SkillGroup == 2 && SkillChoice == 2)
		Return Crew_Scavenging
	ElseIf (SkillGroup == 2 && SkillChoice == 3)
		Return Crew_Theft
	ElseIf (SkillGroup == 2 && SkillChoice == 4)
		Return Crew_Leadership
	ElseIf (SkillGroup == 2 && SkillChoice == 5)
		Return Crew_Outpost_Management
	ElseIf (SkillGroup == 2 && SkillChoice == 6)
		Return Crew_Xenosociology
; Combat Certifications
	ElseIf (SkillGroup == 3 && SkillChoice == 1)
		Return Crew_PistolCertification
	ElseIf (SkillGroup == 3 && SkillChoice == 2)
		Return Crew_ShotgunCertification
	ElseIf (SkillGroup == 3 && SkillChoice == 3)
		Return Crew_RifleCertification
	ElseIf (SkillGroup == 3 && SkillChoice == 4)
		Return Crew_SniperCertification
	ElseIf (SkillGroup == 3 && SkillChoice == 5)
		Return Crew_Demolitions
; Combat Specializations
	ElseIf (SkillGroup == 4 && SkillChoice == 1)
		Return Crew_Lasers
	ElseIf (SkillGroup == 4 && SkillChoice == 2)
		Return Crew_Ballistics
	ElseIf (SkillGroup == 4 && SkillChoice == 3)
		Return Crew_ParticleBeams
	ElseIf (SkillGroup == 4 && SkillChoice == 4)
		Return Crew_Marksmanship
	ElseIf (SkillGroup == 4 && SkillChoice == 5)
		Return Crew_Sharpshooting
	ElseIf (SkillGroup == 4 && SkillChoice == 6)
		Return Crew_Incapacitation
; Science
	ElseIf (SkillGroup == 5 && SkillChoice == 1)
		Return Crew_Ship_Astrodynamics
	ElseIf (SkillGroup == 5 && SkillChoice == 2)
		Return Crew_Botany
	ElseIf (SkillGroup == 5 && SkillChoice == 3)
		Return Crew_Chemistry
	ElseIf (SkillGroup == 5 && SkillChoice == 4)
		Return Crew_Geology
	ElseIf (SkillGroup == 5 && SkillChoice == 5)
		Return Crew_Medicine
	ElseIf (SkillGroup == 5 && SkillChoice == 6)
		Return Crew_Outpost_Engineering
	ElseIf (SkillGroup == 5 && SkillChoice == 7)															
		Return Crew_AneutronicFusion
; Tech Weapon Systems
    ElseIf (SkillGroup == 6 && SkillChoice == 1)
		Return Crew_Ship_Weapons_Ballistic
    ElseIf (SkillGroup == 6 && SkillChoice == 2)
		Return Crew_Ship_Weapons_Energy
    ElseIf (SkillGroup == 6 && SkillChoice == 3)
		Return Crew_Ship_Weapons_Missile
    ElseIf (SkillGroup == 6 && SkillChoice == 4)
		Return Crew_Ship_Weapons_ParticleBeam
    ElseIf (SkillGroup == 6 && SkillChoice == 5)
		Return Crew_Ship_Weapons_EM
; Tech Other
	ElseIf (SkillGroup == 7 && SkillChoice == 1)
		Return Crew_Ship_Piloting 
	ElseIf (SkillGroup == 7 && SkillChoice == 2)
		Return Crew_Ship_Payloads 
	ElseIf (SkillGroup == 7 && SkillChoice == 3)
		Return Crew_Ship_Shields 
	ElseIf (SkillGroup == 7 && SkillChoice == 4)
		Return Crew_Ship_StarshipEngineering
	ElseIf (SkillGroup == 7 && SkillChoice == 5)
		Return Crew_Robotics 
	EndIf
	Return None ; Default return value when condition isn't met	
EndFunction