ScriptName COL:QuestScript Extends Quest

    LocationAlias property PlayerOutpostLocation auto const mandatory
    { filled when player fails to pay registration fee }
    ReferenceAlias property PlayerOutpostBeacon auto const mandatory
    { filled when player fails to pay registration fee }
    LocationAlias Property OutpostPlanetLocation Mandatory Const Auto
    { Might be needed }
    ReferenceAlias Property CurrentOutpost Mandatory Const Auto
    { This should be filled anytime we enter workshop mode... somehow }
    WwiseEvent Property ITM_Credits_Down_WEF Mandatory Const Auto
	MiscObject Property Credits Auto Const
    ;Actor Property PlayerRef Mandatory Const Auto

Group COLKeywords
    Keyword Property LocTypeSettledPlanet Mandatory Const Auto
    Keyword Property LocTypeSettledSystem Mandatory Const Auto
    Keyword Property LocTypePlayerHouse Mandatory Const Auto
    Keyword Property LocTypeMajorOrbital Mandatory Const Auto
    Keyword Property LocTypeOutpost Mandatory Const Auto
    Keyword Property LocTypeStarSystem Mandatory Const Auto
    Keyword Property LocSystemFactionFreestarCollective Mandatory Const Auto
    Keyword Property LocSystemFactionUnitedColonies Mandatory Const Auto
    Keyword Property LocSystemFactionHouseVaruun Mandatory Const Auto
    ;Generic mod compatibility
    Keyword Property _col_PlayerHouseKey Mandatory Const Auto
EndGroup

Group COLKeys
    ;Detect Ownership
    Key Property CityNewAtlantisWellApartmentKey Mandatory Const Auto
    Key Property CityNewAtlantisPenthouseKey Mandatory Const Auto
    Key Property FCNeon_SleepCratePlayerHomeKey Mandatory Const Auto
    Key Property FCNeon_TradeTowerPlayerHomeKey Mandatory Const Auto
    Key Property CityAkilaCityMidtownHouseKey Mandatory Const Auto
    Key Property CityAkilaCityCoreHouseKey Mandatory Const Auto
EndGroup

Group COLGlobals
    ;System
    GlobalVariable Property _col_enabled Mandatory Const Auto
    ;Outposts
    GlobalVariable Property _colPenaltyfee Mandatory Const Auto
    GlobalVariable Property _coltaxinterest Mandatory Const Auto
    GlobalVariable Property _colHVSystemTax Mandatory Const Auto
    GlobalVariable Property _colGenericPlanetTax Mandatory Const Auto
    ;Homes
    GlobalVariable Property _colNAwellowned Mandatory Const Auto
    GlobalVariable Property _colNApentowned Mandatory Const Auto
    GlobalVariable Property _colACmidowned Mandatory Const Auto
    GlobalVariable Property _colACcoreowned Mandatory Const Auto
    GlobalVariable Property _colNEcrateowned Mandatory Const Auto
    GlobalVariable Property _colNEtradeowned Mandatory Const Auto
    ;Counters
    GlobalVariable Property _colDaysToPay Mandatory Const Auto
    GlobalVariable Property _colLastWeek Mandatory Const Auto
    ;Reg Values
    GlobalVariable Property _colUCSystemTax Mandatory Const Auto
    GlobalVariable Property _colFCSystemTax Mandatory Const Auto
    GlobalVariable Property _colUCPlanetTax Mandatory Const Auto
    GlobalVariable Property _colFCPlanetTax Mandatory Const Auto
    ;Tax Values
    GlobalVariable Property _colapartmenttax Mandatory Const Auto
    GlobalVariable Property _colhousetax Mandatory Const Auto
EndGroup

Group COLLocations
    Location Property SCheyenne_PAkila Mandatory Const Auto
    Location Property SCheyenne_PAkila_MAntharum Mandatory Const Auto
    Location Property SCheyenne_PAkila_MBindi Mandatory Const Auto
    Location Property SCheyenne_PAkila_MCodos Mandatory Const Auto
    Location Property SSol_PMars Mandatory Const Auto
    Location Property SSol_PMars_MPhobos Mandatory Const Auto
    Location Property SAlphaCentauri_PJemison Mandatory Const Auto
    Location Property SAlphaCentauri_PJemison_MKurtz Mandatory Const Auto
EndGroup

Group COLFActions
    Faction Property CrimeFactionUC Mandatory Const Auto
    Faction Property CrimeFactionFreestar Mandatory Const Auto
    Faction Property CrimeFactionVaruun Mandatory Const Auto
EndGroup

Group COLMessages
    ;System Messages for Outposts
    Message Property _col_RegSystemClaimMSG Mandatory Const Auto
    Message Property _col_RegWorldClaimMSG Mandatory Const Auto
    Message Property _colRegFailed Mandatory Const Auto
    Message Property _colCancelReg Mandatory Const Auto
    Message Property _colCongrats Mandatory Const Auto
    ;System messages for Penalties
    Message Property _col_BeaconUpMsg Mandatory Const Auto
    Message Property _col_OutpostBountyMsg Mandatory Const Auto
    ;System Messages for Taxes
    Message Property _col_TaxWarnMsg Mandatory Const Auto
    Message Property _col_TaxSuccessMsg Mandatory Const Auto
    ;registration messages
    ;Message Property _colNAwellownermsg Mandatory Const Auto
    ;Message Property _colNApentownermsg Mandatory Const Auto
    ;Message Property _colACmidownermsg Mandatory Const Auto
    ;Message Property _colACcoreownermsg Mandatory Const Auto
    ;Message Property _colNEcrateownermsg Mandatory Const Auto
    ;Message Property _colNEtradeownermsg Mandatory Const Auto
EndGroup

Group COLNotes
    Book Property _col_Ticket Mandatory Const Auto
EndGroup

Group COLPerks
    Perk Property Skill_Commerce Mandatory Const Auto
    Perk Property Skill_OutpostEngineering Mandatory Const Auto
    Perk Property Skill_OutpostManagement Mandatory Const Auto
    Perk Property Skill_Deception Mandatory Const Auto
    Perk Property Skill_Concealment Mandatory Const Auto
    Perk Property Skill_Scanning Mandatory Const Auto
EndGroup

Group COLQuests
    Quest Property UC02 Mandatory Const Auto
    Quest Property UC05 Mandatory Const Auto
    Quest Property FC02 Mandatory Const Auto
EndGroup



Actor PlayerRef

Function Jingle()
    PlayerRef = Game.GetPlayer()
    ITM_Credits_Down_WEF.PlayAndWait(Playerref, None, None)
EndFunction

;Check home ownership via keys
Function DetectOwnershipVanilla()
    PlayerRef = Game.GetPlayer()
    ;int outposts = BorrowedOutpostCounter()
    If Playerref.GetItemCount(CityNewAtlantisPenthouseKey) > 0
    _colNApentowned.SetValue(1)
    EndIf
    If Playerref.GetItemCount(CityNewAtlantisWellApartmentKey) > 0
    _colNAwellowned.SetValue(1)
    EndIf
    If Playerref.GetItemCount(CityAkilaCityCoreHouseKey) > 0
    _colACcoreowned.SetValue(1)
    EndIf
    If Playerref.GetItemCount(CityAkilaCityMidtownHouseKey) > 0
    _colACmidowned.SetValue(1)
    EndIf
    If Playerref.GetItemCount(FCNeon_SleepCratePlayerHomeKey) > 0
    _colNEcrateowned.SetValue(1)
    EndIf
    If Playerref.GetItemCount(FCNeon_TradeTowerPlayerHomeKey) > 0
    _colNEtradeowned.SetValue(1)
    EndIf
    ;If outposts >= 1
    ;Debug.Notification(outposts as int + " Outposts detected.")
    ;EndIf
EndFunction

;Trigger if Current Day - Last Tax > Payment Interval
;Currently only for player homes. This will also hold cargo linked outpost taxes later
Function Taxation()
    int taxfee = 0
    int mortgage = (Utility.GetCurrentGameTime() as int + 1) - _colLastWeek.GetValue() as int
    if mortgage > _colDaysToPay.GetValue()

        If taxfee > 0
            If Playerref.GetItemCount(Credits) > taxfee
                Utility.Wait(4)
                Playerref.RemoveItem(Credits, taxfee, true)
                _col_TaxSuccessMsg.Show(taxfee)
                Jingle()
                ;No interest even if there was previously
                _coltaxinterest.SetValue(0)
            Else
                ;Player didn't have enough credits, add interest and chastise them
                _coltaxinterest.SetValue(Math.Round(taxfee * 1.2))
                Utility.Wait(3)
                _col_TaxWarnMsg.Show(rich + poor, taxfee, _colDaysToPay.GetValue())
            EndIf
            ;Reset the counter from yesterday (lol)
            _colLastWeek.SetValue((Utility.GetCurrentGameTime() - 1))
        EndIf
    EndIf
EndFunction

Function HomeTaxes()
    PlayerRef = Game.GetPlayer()
    DetectOwnershipVanilla()
    int taxfee = 0
    int mod = Playerref.GetItemCount(_col_PlayerHouseKey)
    int rich = _colACcoreowned.GetValue() as int + _colNEtradeowned.GetValue() as int  + _colNApentowned.GetValue() as int 
    int poor = _colNAwellowned.GetValue() as int + _colACmidowned.GetValue() as int  + _colNEcrateowned.GetValue() as int + mod
    If mod + rich + poor > 1
        ;Debug.Trace("_COL detected " + rich as string + " homes & " + poor as string + " apts, " + mod as string + "mods")
        ;Debug.Trace("_COL detected it has been " + mortgage + " days")
        taxfee = Math.Floor((poor * _colapartmenttax.GetValue()) + (rich * _colhousetax.GetValue())) + _coltaxinterest.GetValue() as int
    EndIF
    (_COL_TaxGlobals[0] as GlobalVariable).SetValue(taxfee)
EndFunction

;Withdraw registration fees upon outpost establishment
;aiFaction: 2=UC, 3=FC, 4=HV. 1 is invalid
;afWorldMult: 1 = unsettled
;WorldMult determined by planet's habitation status
bool Function PayOutpostRegCost(int aiFaction, float afWorldMult)
    PlayerRef = Game.GetPlayer()
    float skillcheck = 1.0
    int creditfee = 0
    int systemfee = 0
    int planetfee = 0
    int ButtonPressed = 2
    float UCrepmult = 1.0
    float FCrepmult = 1.0
    ;Player skill checks
    If Playerref.HasPerk(Skill_OutpostManagement)
        skillcheck = 0.6
    Elseif Playerref.HasPerk(Skill_OutpostEngineering) || Playerref.HasPerk(Skill_Commerce)
        skillcheck = 0.8
    EndIf
    ;Player rep checks
    If  UC02.GetStageDone(1000) && !UC05.GetStageDone(1000)
        UCrepmult = Utility.RandomFloat(0.7, 0.9)
    ElseIf UC05.GetStageDone(1000)
        UCrepmult = Utility.RandomFloat(0.3, 0.6)
    EndIf
    If FC02.GetStageDone(2000)
        FCrepmult = Utility.RandomFloat(0.6, 0.8)
    EndIf
    ;Check whose system and which planet we are colonizing
    If aiFaction == 2
        systemfee = Math.Round(_colFCSystemTax.GetValue() * Utility.RandomFloat(2.4, 3.6) * UCrepmult)
        planetfee = Math.Round(_colFCPlanetTax.GetValue() * afWorldMult * UCrepmult)
    ElseIf aiFaction == 3
        systemfee = Math.Round(_colUCSystemTax.GetValue() * Utility.RandomFloat(1.8, 2.6) * FCrepmult)
        planetfee = Math.Round(_colUCPlanetTax.GetValue() * afWorldMult * FCrepmult)
    ElseIf aiFaction == 4
        systemfee = Math.Round(_colHVSystemTax.GetValue() * Utility.RandomFloat(1.2, 1.6))
        planetfee = Math.Round(_colGenericPlanetTax.GetValue() * afWorldMult)
    EndIf
    ;Determine final roll and set penalty to 200%
    creditfee = Math.Round(((systemfee + planetfee * skillcheck)/ 100) * 100)
    _colPenaltyfee.SetValue(creditfee * 2)
    Utility.Wait(3)
    ;Now we want to request payment from the player. 
    if afworldmult == 1.0
    ButtonPressed = _col_RegSystemClaimMSG.Show(creditfee)
    elseif afworldmult > 1.0
    ButtonPressed = _col_RegWorldClaimMSG.Show(creditfee)
    EndIf
    ;Player agreed to pay
    If ButtonPressed == 0
        If Playerref.GetItemCount(Credits) > creditfee
            Playerref.RemoveItem(Credits, creditfee)
            return true
        Else
            Utility.Wait(3)
            _colRegFailed.Show()
            return false
        EndIf
    ;Player declined to pay
    ElseIf ButtonPressed == 1
        return false
    Else
        return false
    EndIf
EndFunction

;Returns 2 for FC, 3 for UC, 4 for HV
;1 = false so we can double dip
Int Function CheckSystemOwnership(Location akLocation)
    int sys = 1
    Location[] ClaimSystem = akLocation.GetParentLocations(LocTypeStarSystem)
        Debug.Trace("_COL detected system " + ClaimSystem)
        If ClaimSystem
            Location system = ClaimSystem[0]
            If system.HasKeyword(LocTypeSettledSystem)
                ;Fallback for compatibility, defaults to UC like COS
                sys = 2
                ;Debug.Trace("_COL detected settled system!")
                If system.HasKeyword(LocSystemFactionFreestarCollective)
                sys = 2
                ElseIf system.HasKeyword(LocSystemFactionUnitedColonies)
                sys = 3
                ElseIf system.HasKeyword(LocSystemFactionHouseVaruun)
                sys = 4
                EndIf
            EndIf
        EndIf
    return sys
EndFunction

;Generic cost reset function. Runs silently, no state changes
;abHome = true when mod disabled. abOutpost = true when beacon event ends
Function ClearTaxes(bool abHome = false, bool abOutpost = false)
    If  abHome == true
        _coltaxinterest.SetValue(0)
        _colLastWeek.SetValue(Utility.GetCurrentGameTime())
    EndIf
    If  abOutpost == true
        _colPenaltyfee.SetValue(0)
        PlayerOutpostBeacon.Clear()
        PlayerOutpostLocation.Clear()
    EndIf
EndFunction

;Check if the planet is settled
;Same hack : 1.0 = false
float Function CheckPlanetOwnership(Location akLocation)
    float settled = 1.0
    float pop = 1.0
    Location[] ClaimWorld = akLocation.GetParentLocations(LocTypeMajorOrbital)
    ;Debug.Trace("_COL array" + ClaimWorld)
    If ClaimWorld
        Location world = ClaimWorld[0]
        Debug.Trace("_COL detected world as " + world)
        If world.HasKeyword(LocTypeSettledPlanet)
            settled = 1.45
        EndIf
        ;Is it a recognized location?
        If world == SCheyenne_PAkila 
            pop = 2.75
        ElseIf world == SCheyenne_PAkila_MAntharum || world == SCheyenne_PAkila_MBindi || world == SCheyenne_PAkila_MCodos
            pop = 1.4
        ElseIf world == SAlphaCentauri_PJemison
            pop = 4.25
        ElseIf world == SAlphaCentauri_PJemison_MKurtz
            pop = 2.25
        ElseIf world == SSol_PMars 
            pop = 2.45
        ElseIf world == SSol_PMars_MPhobos
            pop = 1.95
        EndIf
    EndIf
    ;This will be 1.0 if the planet is not recognized *or* settled
    return settled * pop
EndFunction

;Handler for mod startup
Function HandleModStartup()
    DetectOwnership()
    _colLastWeek.SetValue((Utility.GetCurrentGameTime() as int + 2))
    Debug.Notification("Cost of Living initialized.")
    GoToState("Running")
EndFunction

Event OnQuestInit()
	StartTimer(5)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
        PlayerRef = Game.GetPlayer()
        Self.RegisterForRemoteEvent(PlayerRef, "OnLocationChange")
        Self.RegisterForRemoteEvent(PlayerRef, "OnOutpostPlaced")
        Self.RegisterForRemoteEvent(CurrentOutpost, "OnWorkshopObjectPlaced")
        Self.RegisterForRemoteEvent(CurrentOutpost, "OnWorkshopMode")
        HandleModStartup()
        GotoState("Running")
    EndEvent
EndState
;Empty

Event Actor.OnOutpostPlaced(Actor akSource, ObjectReference akOutpostBeacon)
    ;Do nothing
    RegisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectPlaced")
EndEvent

Event ReferenceAlias.OnWorkshopObjectRemoved(ReferenceAlias akSource, ObjectReference akReference)
    ;Do nothing
EndEvent

Event ReferenceAlias.OnWorkshopObjectPlaced(ReferenceAlias akSender, ObjectReference akReference)
    Debug.Trace("COL detected placement with aksender " + akSender + "and akReference " + akReference)
    Keyword[] KWTestArray = CassiopeiaPapyrusExtender.GetKeywords(akReference)
    int i = 0
    While i < KWTestArray.Length
        Debug.Trace("COL keyword sweep found " + KWTestArray[i] )
        i += 1
    EndWhile
EndEvent

Event ReferenceAlias.OnWorkshopMode(ReferenceAlias akSender, bool aStart)
    if aStart
        Debug.Trace("COL detected OnWorkshopMode start " + aStart + " from " + CurrentOutpost)
    Else
        Debug.Trace("COL detected OnWorkshopMode start " + aStart + " from " + CurrentOutpost)
    EndIf
EndEvent

;Watch for mod re-enabled just in case
Event Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
    If  _col_enabled.GetValue() == 1
        _colLastWeek.SetValue((Utility.GetCurrentGameTime() as int + 2))
        ;Debug.Notification("Cost of Living restarted.")
        ;Debug.Trace("COL updated from 0.5")
        GotoState("Running")
    EndIf
EndEvent

;Running normally
State Running
    ;Charge for initialization of outposts in settled systems
    Event Actor.OnOutpostPlaced(Actor akSender, ObjectReference akOutpostBeacon)
        CurrentOutpost.RefillAlias()
        Debug.Trace("COL found CurrentOutpost of " + CurrentOutpost)
        PlayerRef = Game.GetPlayer()
        int systemis = 1
        float planetis = 1.0
        Location BeaconIsIn = akOutpostBeacon.GetCurrentLocation()
        ;First check if the system is settled at all before triggering logic
        systemis = CheckSystemOwnership(BeaconIsIn)
        ;CheckSystemOwnership 
        if systemis > 1
            ;System is settled, What planet are we on?
            planetis = CheckPlanetOwnership(BeaconIsIn)
            ;Bring up payment flow
            bool AllowReg = PayOutpostRegCost(systemis, planetis)
            ;Player forked over the starbux. Congratulations!
            If AllowReg == true
                Utility.Wait(6)
                _colCongrats.Show()
                _colPenaltyfee.SetValue(0)
            ;Player cancelled or was unable to pay
            ElseIf AllowReg == false
                ;Add a bit of luck and skill to evade penalty
                float penaltyroll = Utility.RandomFloat(0 , 13.0)
                If Playerref.HasPerk(Skill_Deception) || Playerref.HasPerk(Skill_Scanning)
                    penaltyroll *= 1.2
                ElseIf Playerref.HasPerk(Skill_Concealment)
                    penaltyroll *= 1.4
                EndIf
                ;min is 8.4 with skill check
                If penaltyroll >= 11
                    Debug.Notification("You have managed to shield the outgoing beacon signal from local authorities.")
                    _colPenaltyfee.SetValue(0)
                Else
                    Utility.Wait(4)
                    ;Warn the player to remove the outpost before leaving
                    _colCancelReg.Show()
                    ;Fill aliases so that we can watch for player removing the beacon
                    ;delinquentbeacon toggle means OnLocationChange will catch evaders
                    PlayerOutpostLocation.ForceLocationTo(Playerref.GetCurrentLocation())
                    OutpostPlanetLocation.ForceLocationTo(PlayerOutpostLocation.GetLocation())
                    PlayerOutpostLocation.RefillDependentAliases()
                    RegisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
                    GotoState("Delinquent")
                EndIf
            EndIf
        EndIf
    EndEvent
    ;This handles both taxation and registration delinquency
    ;Due to how often it runs, it must be lightweight 
    Event Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
        If _col_enabled.GetValue() == 0
            ClearTaxes(true, true)
            Debug.Trace("COL disabled from state" + GetState())
            GotoState("Standby")
        EndIf
        Taxation()
        IF akNewLoc.HasKeyword(LocTypeOutpost)
            CurrentOutpost.RefillAlias()
            Debug.Trace("COL found CurrentOutpost of " + CurrentOutpost)
        Else
            If CurrentOutpost
                CurrentOutpost.Clear()
                Debug.Trace("COL cleared CurrentOutpost Alias")
            Else
                Debug.Trace("COL did not find CurrentOutpost Alias to clear")
            EndIf
        EndIf
    EndEvent
EndState

State Delinquent
    ;Player has been warned to remove the outpost, system is now watching for beacon removal
    ;If they remove it, we congratulate them and clear the penalty. Otherwise, bounty is triggered when they leave the location.
    Event ReferenceAlias.OnWorkshopObjectRemoved(ReferenceAlias akSource, ObjectReference akReference)
        ;Debug.Trace("COL removed object is " + akReference as string + ", COL removed source is " + akSource as string)
        ;Player removed the beacon, congratulate them
        If akReference == PlayerOutpostBeacon.GetReference()
            Utility.Wait(4)
            _col_BeaconUpMsg.Show()
            ;This has to be first or the alias is already cleared - D'oh!
            UnregisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
            ;Clear penalty
            ClearTaxes(false, true)
            ;Resume normal operations, placing another outpost should be fine now
            GotoState("Running")
        Endif
    EndEvent
    ;Player left location without triggering the above, they will incur a bounty
    ;If they disable the mod before leaving, nothing should happen
     Event Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
        If _col_enabled.GetValue() == 0
            ClearTaxes(true, true)
            UnregisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
            GotoState("Standby")
        Else
            Location BeaconIsIn = PlayerOutpostLocation.GetLocation()
            ;Who is issuing the bounty?
            int fac = CheckSystemOwnership(BeaconIsIn)
            ;What was the original fee?
            int pen = _colPenaltyfee.GetValue() as int
            if fac > 1
                if fac == 2
                CrimeFactionFreestar.ModCrimeGold(pen)
                elseif fac == 3
                CrimeFactionUC.ModCrimeGold(pen)
                Elseif fac == 4
                CrimeFactionVaruun.ModCrimeGold(pen)
                Else
                CrimeFactionUC.ModCrimeGold(pen)
                endif
            EndIf
            Utility.Wait(6)
            _col_OutpostBountyMsg.Show(pen)
            ;Debug.MessageBox("stop right there citizen!")
            ClearTaxes(false, true)
            ;Resume normal operations
            GoToState("Running")
        EndIf
    EndEvent
EndState

State Standby
    ;We are only watching for the mod to toggle back on
    Event Actor.OnLocationChange(actor akSender, Location akOldLoc, Location akNewLoc)
        If  _col_enabled.GetValue() == 1
            _colLastWeek.SetValue((Utility.GetCurrentGameTime() as int + 2))
            Self.RegisterForRemoteEvent(PlayerRef, "OnOutpostPlaced")
            Debug.Notification("Cost of Living restarted.")
            GotoState("Running")
        EndIf
    EndEvent
EndState