Scriptname COL:OutpostHandlerQuest Extends Quest

Group Messages
    ;System Messages for Outposts
    Message Property _COL_SystemSettledPaymentPrompt Mandatory Const Auto
    Message Property _COL_WorldSettledPaymentPrompt Mandatory Const Auto
    Message Property _colRegFailed Mandatory Const Auto
    Message Property _colCancelReg Mandatory Const Auto
    Message Property _colCongrats Mandatory Const Auto
    Message Property _col_TutorialBox_Evasion Mandatory Const Auto
    Message Property _col_TutorialBox_OutpostRegistration Mandatory Const Auto
    Message Property _col_Toast_OutpostRegistration Mandatory Const Auto
    Message Property _col_Toast_Evasion Mandatory Const Auto
    ;System messages for Penalties
    Message Property _col_BeaconUpMsg Mandatory Const Auto
    Message Property _col_OutpostBountyMsg Mandatory Const Auto
    WwiseEvent Property ITM_Credits_Down_WEF Mandatory Const Auto
EndGroup

Group Checks
    ;Crime factions for Outpost Checks
    Faction Property CrimeFactionUC Mandatory Const Auto
    Faction Property CrimeFactionFreestar Mandatory Const Auto
    Faction Property CrimeFactionVaruun Mandatory Const Auto
    ;Location checks
    Location[] Property HighOccupancyPlanets Mandatory Const Auto
    { These are the planets with major civilizations }
    Location[] Property OutlyingPlanets Mandatory Const Auto
    { Moons of High-Occupancy planets }
    Location[] Property SpecialPlanets Mandatory Const Auto
    { These are planets like Paradiso with specific local laws }
    Book[] Property OutpostRegistrationForms Mandatory Const Auto
    { This is given to the player in lieu of a pop-up with 1:SETTLEDSYSTEM 2:SETTLEDPLANET 3:OUTLYING 4:OCCUPIED 5+:SPECIAL }
    ;Cost multipliers
    Perk Property Skill_Commerce Mandatory Const Auto
    Perk Property Skill_OutpostEngineering Mandatory Const Auto
    Perk Property Skill_OutpostManagement Mandatory Const Auto
    Perk Property Trait_UnitedColoniesNative Mandatory Const Auto
    Perk Property Trait_FreestarCollectiveSettler Mandatory Const Auto
    Perk Property Trait_SerpentsEmbrace Mandatory Const Auto
    Perk Property Trait_NeonStreetRat Mandatory Const Auto
    Quest Property UC02 Mandatory Const Auto
    Quest Property UC05 Mandatory Const Auto
    Quest Property FC02 Mandatory Const Auto
    ;determine scan evasion chance
    Perk Property Skill_Deception Mandatory Const Auto
    Perk Property Skill_Concealment Mandatory Const Auto
    Perk Property Skill_Scanning Mandatory Const Auto
    ;sanity checks before arrays
    Keyword Property LocTypeSettledPlanet Mandatory Const Auto
    Keyword Property LocTypeSettledSystem Mandatory Const Auto
    Keyword Property LocTypePlayerHouse Mandatory Const Auto
    Keyword Property LocTypeMajorOrbital Mandatory Const Auto
    Keyword Property LocTypeOutpost Mandatory Const Auto
    Keyword Property LocTypeStarSystem Mandatory Const Auto
    Keyword Property LoctypePlanet Mandatory Const Auto
    Keyword Property LocSystemFactionFreestarCollective Mandatory Const Auto
    Keyword Property LocSystemFactionUnitedColonies Mandatory Const Auto
    Keyword Property LocSystemFactionHouseVaruun Mandatory Const Auto
    FormList Property _COL_Moons Mandatory Const Auto
EndGroup

Group System
    GlobalVariable Property _col_enabled Auto Mandatory Const
    GlobalVariable Property _col_RegSys_Penalty Auto Mandatory Const
    { Filled on outpost placement, cleared on payment or used as bounty }
    GlobalVariable Property _col_RegCost_Base Auto Mandatory Const
    GlobalVariable Property _col_RegCost_UC_PlanetSettled Auto Mandatory Const
    GlobalVariable Property _col_RegCost_UC_SystemSettled Auto Mandatory Const
    GlobalVariable Property _col_RegCost_FC_PlanetSettled Auto Mandatory Const
    GlobalVariable Property _col_RegCost_FC_SystemSettled Auto Mandatory Const
EndGroup

    ;Detection is now stored in OutpostBeaconScript attached to POB
    LocationAlias property PlayerOutpostLocation auto const mandatory
    { filled when player fails to pay registration fee }
    ReferenceAlias property PlayerOutpostBeacon auto const mandatory
    { filled when player fails to pay registration fee }
    ReferenceAlias Property RegBookPlanetType0 Mandatory Const Auto
    LocationAlias Property PlayerOutpostPlanet Mandatory Const Auto

    ;Script Properties
    Int PlanetType = 0 ; 1:SETTLEDSYSTEM 2:SETTLEDPLANET 3:OUTLYING 4:OCCUPIED 5:SPECIAL
    int Estimate = 0
    int OutpostCost = 0 ; set in GetRealCosts
    String SystemOwner
    MiscObject Credits
    Actor PlayerRef

    Faction TheFaction

    ;Skills
    int OPM = 0
    int OPE = 0
    int COM = 0
    int DCP = 0
    int CON = 0
    int SCN = 0
    int BGUC = 0
    int BGFC = 0
    int BGNN = 0
    int BGVR = 0

    float UCREP = 1.0
    float FCREP = 1.0

    Bool DEBUGON = true
    Bool DEBUGVERBOSE = false
    bool DEBUGEVASION = false ; forces WonTheRoll outcome to match with DEBUGON

    bool EvasionTutorialShowed = false
    bool OutpostTutorialShowed = false

    bool IsPlayerDelinquent = false

    Location[] Moons ; I just don't want to put these in the CK

;Generic debug function that can be disabled for prod
Function CDBG(String asTextToPrint = "Debug Error!")
    If DEBUGON
        Debug.Trace("COL_DEBUG: " + asTextToPrint)
        IF DEBUGVERBOSE ; Can log in realtime to avoid alt-tabbing constantly
            Debug.Notification("COL: " + asTextToPrint)
        EndIF
    EndIF
EndFunction

Function Jingle()
    PlayerRef = Game.GetPlayer()
    ITM_Credits_Down_WEF.PlayAndWait(PlayerRef, None, None)
EndFunction


Function CheckPerks()
    PlayerRef = Game.GetPlayer()
    OPM = PlayerRef.HasPerk(Skill_OutpostManagement) as int
    OPE = PlayerRef.HasPerk(Skill_OutpostEngineering) as int
    COM = PlayerRef.HasPerk(Skill_Commerce) as int
    DCP = PlayerRef.HasPerk(Skill_Deception) as int
    CON = PlayerRef.HasPerk(Skill_Concealment) as int
    SCN = PlayerRef.HasPerk(Skill_Scanning) as int
    BGUC = PlayerRef.HasPerk(Trait_UnitedColoniesNative) as int
    BGFC = PlayerRef.HasPerk(Trait_FreestarCollectiveSettler) as int
    BGNN = PlayerRef.HasPerk(Trait_NeonStreetRat) as int
    BGVR = PlayerRef.HasPerk(Trait_SerpentsEmbrace) as int
EndFunction

;Can be called from other quests to get the reduction value
float Function CheckQuests(bool abReturnUC = true)
    float Repmult = 1.0
    ;Player is vanguard but not yet a citizen
    If  UC02.GetStageDone(1000) && !UC05.GetStageDone(1000)
        UCREP = Utility.RandomFloat(0.7, 0.9)
    ;Player is a citizen
    ElseIf UC05.GetStageDone(1000)
        UCREP = Utility.RandomFloat(0.3, 0.6)
    EndIf
    ;Player is a Ranger - no further reductions
    If FC02.GetStageDone(2000)
        FCREP = Utility.RandomFloat(0.6, 0.8)
    EndIf
    IF abReturnUC
        Repmult = UCREP
    Else
        Repmult = FCREP
    EndIF
    Return Repmult
EndFunction

Function ClearOutpostAliases()
    PlayerOutpostPlanet.Clear() ; Have to check if this retroactively breaks the registration - if so silently remove it
    PlayerOutpostBeacon.Clear()
    PlayerOutpostLocation.Clear()
    TheFaction = None
    int i = 0
    While i < OutpostRegistrationForms.Length
        Form TheBook = OutpostRegistrationForms[i]
        If PlayerRef.GetItemCount(TheBook) > 0
            PlayerRef.RemoveItem(TheBook, 999, true)
            CDBG("Removed " + TheBook)
        EndIF
        i += 1
    EndWhile
EndFunction

Function ClearOutpostValues()
    PlanetType = 0
    Estimate = 0
    SystemOwner = None
    IsPlayerDelinquent = False
    _col_RegSys_Penalty.SetValue(0)
EndFunction

Function HandleRegistrationBook()
    If IsPlayerDelinquent
        Bool RegistrationComplete = PayOutpostRegCost()
        If RegistrationComplete
            ClearOutpostAliases()
            ClearOutpostValues()
            IsPlayerDelinquent = False
        ; No Else needed as notifs are handled in PayORC
        EndIF
    Else
        CDBG("Skipping logic as the matter is settled")
    EndIF
EndFunction

;This gets our total System cost. Planet costs are handled separately
int Function GetOutpostSystemCost(string asFaction)
    int PlanetBaseCost = _col_RegCost_Base.GetValue() as int
    CDBG("GORC running with " + PlanetBaseCost + " and Faction " + asFaction )
    int creditfee = 0
    float skillmult = 1.0
    float traitmult = 1.0
    float repmult = 1.0 ; This will use an array
    int Skills = OPM + OPE + COM
    skillmult = 1 - ( Skills / 6 ) ; All three skills will reduce cost by 1/2
    If asFaction
        If asFaction == "UC"
            repmult = UCREP
            traitmult = 1 - ( BGUC / 4 )
            PlanetBaseCost = _col_RegCost_UC_SystemSettled.GetValue() as int
        ElseIf asFaction == "FC"
            repmult = FCREP
            int BG = BGFC + BGNN ; You can't have both so this will be 1 or 0
            traitmult = 1 - ( BG / 4 )
            PlanetBaseCost = _col_RegCost_FC_SystemSettled.GetValue() as int
        ElseIF asFaction == "VR"
            traitmult = 1 - ( BGVR / 2 ) ; Halves cost for serpents embrace
        EndIF
    EndIf
    creditfee = ( PlanetBaseCost * repmult * skillmult * traitmult ) as int
    creditfee += (100 - ( creditfee % 100 ) ) ; Round to nearest 100
    CDBG("GORC got total:" + creditfee + " from rep:" + repmult + " skill:" + skillmult + " trait:" + traitmult)
    Return creditfee
EndFunction

int Function GetOutpostPlanetCost()
    float PlanetTypeMult = 1.0
    int creditfee = 0
    PlanetTypeMult = ( PlanetType / 2 ) + 1 ; This should range from 1.7 > 3.4
    float PlanetCost = 1.0
    If SystemOwner == "FC"
        PlanetCost = _col_RegCost_FC_PlanetSettled.GetValue()
    ElseIf SystemOwner == "UC"
        PlanetCost = _col_RegCost_UC_PlanetSettled.GetValue()
    Else
        PlanetCost = _col_RegCost_Base.GetValue()
    EndIF
    creditfee = PlanetCost as int
    creditfee += (100 - ( creditfee % 100 ) ) ; Round to nearest 100
    CDBG("GOPC got " + creditfee + " with mult " + PlanetTypeMult + " from fac " + SystemOwner)
    Return creditfee
EndFunction

bool Function PayOutpostRegCost()
    bool Paid = false
    PlayerRef = Game.GetPlayer()
    int systemcost = GetOutpostSystemCost(SystemOwner)
    int planetcost = GetOutpostPlanetCost()
    int creditfee = ( systemcost + planetcost )
    _col_RegSys_Penalty.SetValue(creditfee * 2)
    Int ButtonPressed = 2
    ;Now we want to request payment from the player. 
    Message ToShow
    If PlanetType > 1
        ToShow = _COL_WorldSettledPaymentPrompt
    Else
        ToShow = _COL_SystemSettledPaymentPrompt
    EndIf
    ButtonPressed = ToShow.Show(creditfee)
    ;Player agreed to pay
    If ButtonPressed == 0
        If Playerref.GetItemCount(Credits) > creditfee
            Playerref.RemoveItem(Credits, creditfee)
            Paid = true
        Else
            Utility.Wait(3)
            _colRegFailed.Show()
            Paid = false
        EndIf
    ;Player declined to pay or backed out
    Else
        Paid = false
    EndIf
    Return Paid
EndFunction

bool Function HandleDeception()
    bool WonTheRoll = false
    If !DEBUGEVASION
        float RollToBeat = Utility.RandomFloat(4.0, 20.0)
        float SaveRoll = ( DCP + SCN + CON ) * Utility.RandomFloat(2.0, 6.0)
        If SaveRoll > RollToBeat
            WonTheRoll = True
        EndIf
    Else
        WonTheRoll = true
    EndIF
    Return WonTheRoll
EndFunction

;This function should: Check our stats, see if the system is settled, show tutorials, add appropriate reg book.
Function HandleOutpostPlacement(Actor akSender, ObjectReference akOutpostBeacon)
    CheckPerks()
    CheckQuests()
    PlayerRef = Game.GetPlayer()
    Location BeaconIsIn = akOutpostBeacon.GetCurrentLocation()
    SystemOwner = CheckSystemOwnership(BeaconIsIn) ;First check if the system is settled at all before triggering logic
    Bool EvadedScan = HandleDeception()
    PlayerOutpostPlanet.ForceLocationTo(GetThisPlanet(BeaconIsIn))
    if SystemOwner
        PlanetType = GetPlanetType(BeaconIsIn)
        Estimate = GetOutpostSystemCost(SystemOwner) + GetOutpostPlanetCost()
        If !EvadedScan
            IF !OutpostTutorialShowed
                _col_TutorialBox_OutpostRegistration.Show()
                OutpostTutorialShowed = true
            Else
                _col_Toast_OutpostRegistration.Show(Estimate)
            EndIF
            ;Fill aliases so that we can watch for player removing the beacon
            PlayerOutpostLocation.ForceLocationTo(Playerref.GetCurrentLocation())
            PlayerOutpostBeacon.ForceRefTo(akOutpostBeacon)
            CDBG("Registering PlayerOutpostLocation as " + PlayerOutpostLocation.GetLocation() + " and PlayerOutpostBeacon as " + PlayerOutpostBeacon.GetRef() ) 
            PlayerRef.AddAliasedItem(OutpostRegistrationForms[PlanetType], RegBookPlanetType0, absilent = false)
            _col_RegSys_Penalty.SetValue(Estimate * 2)
            RegisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
            IsPlayerDelinquent = True
        Else
            IF !EvasionTutorialShowed
                _col_TutorialBox_Evasion.Show()
                EvasionTutorialShowed = true
            Else
                _col_Toast_Evasion.Show()
            EndIF
        EndIf
    EndIf
EndFunction

Location Function GetThisPlanet(Location akLocation)
    Location[] Planets = akLocation.GetParentLocations(LocTypeMajorOrbital)
    Location WeAreOn = Planets[0]
    CDBG("GetThisPlanet returned MajorOrbital: " + WeAreOn)
    Return WeAreOn
EndFunction

; Return values are fed directly to PlanetType with values:
; 1:SETTLED SYSTEM 2:SETTLED PLANET 3:OUTLYING 4:OCCUPIED 5:SPECIAL
; where 1 is a fallback
int Function GetPlanetType(Location akLocation)
    int Type = 1 ; Indicates only a settled system - fallback 
    Location[] ClaimWorld = akLocation.GetParentLocations(LocTypeMajorOrbital)
    CDBG(" Checking Type of " + ClaimWorld[0] )
    If ClaimWorld
        Location world = ClaimWorld[0]
        CDBG(" Checking keywords and arrays against " + world )
        ; These go from most to least expensive and we will pass Type in to a linear eq
        If world.HasKeyword(LocTypeSettledPlanet)
            Type = 5 ; Indicates generic settled planet
        EndIf
        If HighOccupancyPlanets.Find(world) >= 0
            Type = 4
        ElseIf Moons.Find(world) >= 0
            Type = 3
        ElseIf SpecialPlanets.Find(world) >= 0
            Type = 2
        EndIF
    EndIF
    CDBG("GetPlanetType returned " + Type)
    Return Type
EndFunction

;Returns FC, UC, or VR
String Function CheckSystemOwnership(Location akLocation)
    String sys
    Location[] ClaimSystem = akLocation.GetParentLocations(LocTypeStarSystem)
        CDBG("running CheckSystemOwnership in " + ClaimSystem)
        If ClaimSystem
            Location system = ClaimSystem[0]
            If system.HasKeyword(LocTypeSettledSystem)
                CDBG("got LocTypeSettledSystem in " + ClaimSystem[0])
                If system.HasKeyword(LocSystemFactionFreestarCollective)
                    sys = "FC"
                    TheFaction = CrimeFactionFreestar
                ElseIf system.HasKeyword(LocSystemFactionHouseVaruun)
                    sys = "VR"
                    TheFaction = CrimeFactionVaruun
                Else
                    sys = "UC"
                    TheFaction = CrimeFactionUC
                EndIf
            EndIf
        EndIf
    CDBG("CheckSystemOwnership returned Owner: " + sys)
    return sys
EndFunction

Event OnQuestInit()
	StartTimer(5)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
        PlayerRef = Game.GetPlayer()
        Credits = Game.GetCredits()
        RegisterForRemoteEvent(PlayerRef, "OnLocationChange")
        RegisterForRemoteEvent(PlayerRef, "OnOutpostPlaced")
        Moons = ImportFormlist(_COL_Moons)
    EndEvent
EndState

Location[] Function ImportFormlist(FormList MyFormList)
    Int listSize = MyFormList.GetSize()
    Location[] MyArray = new Location[listSize]
    Int i = 0
    While i < listSize
        MyArray[i] = MyFormList.GetAt(i) as Location
        ;CDBG("ImportFormList added " + MyArray[i] + " at " + i)
        i += 1
    EndWhile
    return MyArray
EndFunction 

; This clears out all of our payments due etc
Function HandleObjectRemoval(ObjectReference akReference)
    CDBG("HandleRemoval firing on Reference " + akReference + " vs Outpost " + PlayerOutpostBeacon)
    If akReference == PlayerOutpostBeacon.GetReference()
        Utility.Wait(0.7)
        ClearOutpostAliases()
        ClearOutpostValues()
        _col_BeaconUpMsg.Show()
        IsPlayerDelinquent = False
    Endif
EndFunction

;Charge for initialization of outposts in settled systems
Event Actor.OnOutpostPlaced(Actor akSender, ObjectReference akOutpostBeacon)
    HandleOutpostPlacement(akSender, akOutpostBeacon)
EndEvent

Event Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
    If IsPlayerDelinquent
        float Penalty = _col_RegSys_Penalty.GetValue()
        _col_OutpostBountyMsg.Show(Penalty)
        TheFaction.ModCrimeGold(Penalty as int)
        ClearOutpostAliases()
        ClearOutpostValues()
        UnregisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
    EndIF
EndEvent

Event ReferenceAlias.OnWorkshopObjectRemoved(ReferenceAlias akSource, ObjectReference akReference)
    CDBG("OnRemoved fired with delinquent " + IsPlayerDelinquent)
    If IsPlayerDelinquent
        HandleObjectRemoval(akReference)
        UnregisterForRemoteEvent(PlayerOutpostBeacon, "OnWorkshopObjectRemoved")
    EndIf
EndEvent