Scriptname COL:TaxationHandlerQuest Extends Quest

    WwiseEvent Property ITM_Credits_Down_WEF Mandatory Const Auto
    GlobalVariable Property _col_Owner_NeonTradeTowerHome Auto Mandatory Const
    GlobalVariable Property _col_Owner_NeonSleepCrate Auto Mandatory Const
    GlobalVariable Property _col_Owner_ACMidTown Auto Mandatory Const
    GlobalVariable Property _col_Owner_NAWellApartment Auto Mandatory Const
    GlobalVariable Property _col_Owner_ACCore Auto Mandatory Const
    GlobalVariable Property _col_Owner_NAPentHouse Auto Mandatory Const
    GlobalVariable Property _col_TaxSys_AccruedInterest Auto Mandatory Const
    GlobalVariable Property _col_TaxSys_Interval Auto Mandatory Const
    GlobalVariable Property _col_TaxSys_LastTaxDay Auto Mandatory Const
    GlobalVariable Property _col_TaxBase_Home Auto Mandatory Const
    GlobalVariable Property _col_TaxBase_Apartment Auto Mandatory Const

    GlobalVariable Property _col_enabled Mandatory Const Auto
    Message Property _col_TaxWarnMsg Mandatory Const Auto
    Message Property _col_TaxSuccessMsg Mandatory Const Auto
    Message Property _col_TaxPaymentPromptMessage Mandatory Const Auto

    Keyword Property LocTypePlayerHouse Mandatory Const Auto
    Keyword Property LocTypeMajorOrbital Mandatory Const Auto
    Keyword Property LocTypeOutpost Mandatory Const Auto
    Keyword Property _col_PlayerHouseKey Mandatory Const Auto

    Message Property _col_init Mandatory Const Auto


    Book Property _COL_TaxCitation Auto Mandatory Const
    { This calls our late payment flow }

    ;Cost multipliers
    Perk Property Skill_Commerce Mandatory Const Auto
    Perk Property Trait_UnitedColoniesNative Mandatory Const Auto
    Perk Property Trait_FreestarCollectiveSettler Mandatory Const Auto
    Perk Property Trait_SerpentsEmbrace Mandatory Const Auto
    Perk Property Trait_NeonStreetRat Mandatory Const Auto
    Quest Property UC02 Mandatory Const Auto
    Quest Property UC05 Mandatory Const Auto
    Quest Property FC02 Mandatory Const Auto

    GlobalVariable[] Property VanillaHomeOwnership Auto Mandatory Const
    { 0:AC_CORE 1:AC_MID 2:NA_PENT 3:NA_WELL 4:NE_CRATE 5: NE_TRADE}
    Key[] Property VanillaHomeKeys Auto Mandatory Const
    { 0:AC_CORE 1:AC_MID 2:NA_PENT 3:NA_WELL 4:NE_CRATE 5: NE_TRADE}
    float[] Property VanillaHomeTaxMults Auto
    { 0=0.75  1=0.65 2=1.4 3=0.7 4=0.3 5=4.2}

Group Formlists
    Formlist Property _COL_TaxGlobals Mandatory Const Auto
    { 0:HOME 1:OUTPOST }
    ;Formlist Property _COL_TaxMessages Mandatory Const Auto
EndGroup

    float COMM = 1.0
    float BGUC = 1.0
    float BGFC = 1.0
    float BGNN = 1.0
    float BGVR = 1.0
 
    float UCREP = 1.0
    float FCREP = 1.0

    Actor PlayerRef
    MiscObject Credits

    Bool DEBUGON = true
    Bool DEBUGVERBOSE = false
    Bool DEBUGCHARGE = false ; If this is true we will always get charged taxes onlocationchange

    bool IsPlayerDelinquent = false

;Generic debug function that can be disabled for prod
Function CDBG(String asTextToPrint = "Debug Error!")
    If DEBUGON
        Debug.Trace("COL_DEBUG: " + asTextToPrint)
        IF DEBUGVERBOSE ; Can log in realtime to avoid alt-tabbing constantly
            Debug.Notification("COL: " + asTextToPrint)
        EndIF
    EndIF
EndFunction

Function Jingle()
    PlayerRef = Game.GetPlayer()
    ITM_Credits_Down_WEF.PlayAndWait(Playerref, None, None)
EndFunction

Function IntervalTimer(bool abReset)
    CDBG( "COL: Checking " + Utility.GetCurrentGameTime() + " vs " + _col_TaxSys_LastTaxDay.GetValue() )
    If abReset
        _col_TaxSys_LastTaxDay.SetValue(Utility.GetCurrentGameTime())
        CDBG("Tax Period reset to " + _col_TaxSys_LastTaxDay.GetValue())
    Else
        float CurrentDay = Utility.GetCurrentGameTime()
        float LastPeriod = _col_TaxSys_LastTaxDay.GetValue()
        float Interval = _col_TaxSys_Interval.GetValue() * 2
        If ( CurrentDay - LastPeriod ) > Interval
            CDBG("IntervalTimer running with " + CurrentDay + " - " + LastPeriod + " > " + Interval)
            _col_TaxSys_LastTaxDay.SetValue(Utility.GetCurrentGameTime())
            DoHomeTaxes()
            Taxation(true)
        EndIf
    EndIF
EndFunction

Function CheckPerks()
    PlayerRef = Game.GetPlayer()
    COMM = 1 - ( PlayerRef.HasPerk(Skill_Commerce) as int / 4) 
    BGUC = 1 - ( PlayerRef.HasPerk(Trait_UnitedColoniesNative) as int / 6) 
    BGFC = 1 - ( PlayerRef.HasPerk(Trait_FreestarCollectiveSettler) as int / 6) 
    BGNN = 1 - ( PlayerRef.HasPerk(Trait_NeonStreetRat) as int / 4) 
    BGVR = 1 - ( PlayerRef.HasPerk(Trait_SerpentsEmbrace) as int / 2) 
EndFunction

float Function CheckQuests(bool abReturnUC = true)
    float Repmult = 1.0
    ;Player is a Citizen (this is probably always true in vanilla)
    If UC05.GetStageDone(1000)
        UCREP = Utility.RandomFloat(0.5, 0.8)
    EndIf
    ;Player is a Ranger
    If FC02.GetStageDone(2000)
        FCREP = Utility.RandomFloat(0.6, 0.8)
    EndIf
    IF abReturnUC
        Repmult = UCREP
    Else
        Repmult = FCREP
    EndIF
    Return Repmult
EndFunction

Function Taxation(bool abOnTime)
    Utility.Wait(2)
    int taxfee = 0
    int Interest = 0
    ;This logic flow should avoid incrementing tax value 
    If abOnTime
        taxfee = GetSummedTaxes()
        Interest = ( taxfee * 1.4 ) as int
    Else
        taxfee = _col_TaxSys_AccruedInterest.GetValue() as int
    EndIf
    _col_TaxSys_AccruedInterest.SetValue(Interest)
    If taxfee != 0
        taxfee += 20 - ( taxfee % 20 )
        If Playerref.GetItemCount(Credits) > taxfee
            Utility.Wait(4)
            Playerref.RemoveItem(Credits, taxfee, true)
            _col_TaxSuccessMsg.Show(taxfee)
            Jingle()
            ;No interest even if there was previously
            _col_TaxSys_AccruedInterest.SetValue(0)
            PlayerRef.RemoveItem(_COL_TaxCitation, 9, true)
        Else
            _col_TaxWarnMsg.Show(Interest)
            PlayerRef.AddItem(_COL_TaxCitation, 1)
        EndIF
    Else
        CDBG("Taxation ran empty with 0 accumulated taxes")
    EndIF
EndFunction

int Function GetSummedTaxes()
    int taxtotalint = 0
    float taxfee = 0
    float backtax = _col_TaxSys_AccruedInterest.GetValue()
    int i = 0
    While i < _COL_TaxGlobals.GetSize()
        GlobalVariable ToPay = _COL_TaxGlobals.GetAt(i) as GlobalVariable
        float ThisTax = ToPay.GetValue()
        taxfee += ThisTax
        CDBG("GetSummedTaxes summing " + ToPay + " at index " + i + " with value " + ThisTax + " for total " + taxfee )
        i += 1
    EndWhile
    int taxtotal = ( taxfee + backtax ) as  int
    taxtotalint = taxtotal as int
    CDBG("GetSummedTaxes returned rounded value " + taxtotalint + " from float " + taxfee)
    return taxtotalint
EndFunction



Function HandleTaxBook()
    int ButtonPressed = 2
    _col_TaxPaymentPromptMessage.Show(_col_TaxSys_AccruedInterest.GetValue())
    If ButtonPressed == 0
        Taxation(false)
    Else
        ;Do nothing
    EndIf
EndFunction

Function DoHomeTaxes()
    GlobalVariable HomeTaxes = _COL_TaxGlobals.GetAt(0) as GlobalVariable
    CDBG("DoHomeTaxes started with HomeTaxes Global as " + HomeTaxes)
    CheckPerks()
    float taxfee = 0
    int taxmod = 0
    float repmult = 1.0
    float traitmult = 1.0
    float skillmult = COMM
    PlayerRef = Game.GetPlayer()
    DetectOwnershipVanilla()
    int ModHomes = DetectOwnershipModded()
    int i = 0
    int o = 0
    While i < VanillaHomeOwnership.Length
        If VanillaHomeOwnership[i].GetValue() == 1
            CDBG("DoHomeTaxes calculating taxes on index " + i )
            If i < 3
                repmult = FCREP
                traitmult = BGFC
            Elseif i >= 3 && i < 5
                repmult = UCREP
                traitmult = BGUC
            Else
                repmult = FCREP
                traitmult = BGNN
            EndIf
            taxfee += ( _col_TaxBase_Home.GetValue() * VanillaHomeTaxMults[i] * repmult * traitmult ) ; We store all diversity in these floats and use apartment tax for mod homes
            o += 1
        EndIf
        i += 1
    EndWhile
    taxmod = ( _col_TaxBase_Apartment.GetValue() * ModHomes ) as int
    CDBG("DoHomeTaxes got Homes: " + o + " Tax: " + taxfee + " Mod Homes: " + ModHomes + " Mod Taxes: " + taxmod )
    int taxfeefinal = Math.Round( ( taxmod + taxfee ) * skillmult )
    CDBG("DoHomeTaxes rounded to " + taxfeefinal + " with SkillMult: " + skillmult)
    HomeTaxes.SetValue(taxfeefinal)
EndFunction

Function AddTaxCostGlobal(GlobalVariable asGlobalToAdd)
    If asGlobalToAdd
        _COL_TaxGlobals.AddForm(asGlobalToAdd)
        int Index = _COL_TaxGlobals.Find(asGlobalToAdd)
        If Index >= 0
            CDBG( "Added " + asGlobalToAdd + " to " + _COL_TaxGlobals + " at position " + Index )
        Else
            CDBG( "EXCEPTION: Added global not found in _COL_TaxGlobals after insertion " ) 
        EndIF
    Else
        CDBG( "EXCEPTION: No global found" )
    EndIF
    int i = 0
    While i < _COL_TaxGlobals.GetSize()
        GlobalVariable TheTax = _COL_TaxGlobals.GetAt(i) as GlobalVariable
        CDBG( "AddTaxCost found Tax Global " + TheTax + " at " + i )
        i += 1
    EndWhile
EndFunction

Function DetectOwnershipVanilla()
    int i = 0
    While i < VanillaHomeKeys.Length
        If PlayerRef.GetItemCount(VanillaHomeKeys[i]) >= 1
            VanillaHomeOwnership[i].SetValue(1)
            CDBG("Ownership detected on index " + i)
        EndIf
        i += 1
    EndWhile
EndFunction

int Function DetectOwnershipModded()
    int Owned = 0
    Owned = PlayerRef.GetItemCount(_col_PlayerHouseKey)
    Return Owned
EndFunction

;Handler for mod startup
Function HandleModStartup()
    DetectOwnershipVanilla()
    IntervalTimer(true)
    _col_init.Show()
    GoToState("Running")
EndFunction

Event OnQuestInit()
	StartTimer(5)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
        PlayerRef = Game.GetPlayer()
        Credits = Game.GetCredits()
        RegisterForRemoteEvent(PlayerRef, "OnLocationChange")
        HandleModStartup()
        GotoState("Running")
    EndEvent
EndState

Event Actor.OnLocationChange(Actor akSender, Location akOldLoc, Location akNewLoc)
    If _col_enabled.GetValue() == 1
        IntervalTimer(false)
    EndIf
EndEvent