﻿//=============================================================================

public class Light 
{
	public static TkSceneNodeData Create( string NAME = "NewLight", double tx = 0, double ty = 0, double tz = 0, double i = 30000, double r = 1, double g = 1, double b = 1 )
    {
        TkSceneNodeData NewLight = new TkSceneNodeData {
            Name = NAME,
            NameHash = NAME.JenkinsHash(),
            Type = "LIGHT",
            Children = new(),
            Transform = new TkTransformData {
                TransX = (float) tx,
                TransY = (float) ty,
                TransZ = (float) tz,
                RotX = 0,
                RotY = 0,
                RotZ = 0,
                ScaleX = 1,
                ScaleY = 1,
                ScaleZ = 1,
            },
            Attributes = new List<TkSceneNodeAttributeData> {
                new() {
                    Name = "FOV",
                    Value = "360.0",
                },
                new() {
                    Name = "FALLOFF",
                    Value = "quadratic",
                },
                new() {
                    Name = "FALLOFF_RATE",
                    Value = "2.0",
                },
                new() {
                    Name = "INTENSITY",
                    Value = i.ToString("0.0"),
                },
                new() {
                    Name = "COL_R",
                    Value = r.ToString("0.0000"),
                },
                new() {
                    Name = "COL_G",
                    Value = g.ToString("0.0000"),
                },
                new() {
                    Name = "COL_B",
                    Value = b.ToString("0.0000"),
                },
                new() {
                    Name = "COOKIE_IDX",
                    Value = "-1",
                },
                new() {
                    Name = "VOLUMETRIC",
                    Value = "0.0",
                },
                new() {
                    Name = "MATERIAL",
                    Value = "MATERIALS/LIGHT.MATERIAL.MBIN",
                },
            },
        };
        return NewLight;
    }
	
	//...........................................................

	public static void linear(TkSceneNodeData LIGHT)
	{
		LIGHT.Attributes.Find(NAME => NAME.Name == "FALLOFF").Value = "linear";
	}
	
	//...........................................................

	public static void Fov(TkSceneNodeData LIGHT, double FOV)
	{
		LIGHT.Attributes.Find(NAME => NAME.Name == "FOV").Value = FOV.ToString("0.0");
	}
}


//=============================================================================

public static partial class _x_  // any extension methods
{
	//...........................................................
}

//=============================================================================
