﻿//=============================================================================
// Greatly increase scanning capabilities of most exocraft
//=============================================================================

public class bExocraftScanner : cmk.NMS.Script.ModClass
{
	protected override void Execute()
	{
		ImproveShipScanRange();
		AddExoCraftScanEvents();
		PopulateScanTable();
		AddUpgradesToMech();
	}

	//...........................................................

	private readonly List<_EventAdds> EventAdds = new()
	{//      NAME,      INTERACTIONTYPE,            BUILDINGLOCATION,             BUILDINGTYPE,                       BUILDINGCLASS,                            FORCEWIDERANDOM, ALLOWOVERRIDDENBUILDINGS, OSDMESSAGE,                    TOOLTIP,                         MARKERLABEL
		new ("VS_PORT", InteractionTypeEnum.Portal, BuildingLocationEnum.Nearest, BuildingTypeEnum.BuildingClass,     BuildingClassEnum.Portal,                 false,           true ,                    "SIGNAL_PORTAL",               "TIP_PORTAL",                    ""                         ),
		new ("VS_DRHV", InteractionTypeEnum.None,   BuildingLocationEnum.Nearest, BuildingTypeEnum.BuildingClass,     BuildingClassEnum.DroneHive,              false,           false,                    "UI_DRONEHIVE_LOCATED_OSD",    "UI_DRONEHIVE_LOCATED",          ""                         ),
		new ("VS_GRV" , InteractionTypeEnum.None,   BuildingLocationEnum.Nearest, BuildingTypeEnum.BuildingClass,     BuildingClassEnum.GraveInCave,            false,           false,                    "UI_MP_PLANTKILL_GRAVE_OSD",   "UI_TITLE_OWNED_LORE1",          "SCAN_GRAVE"               ),
		new ("VS_BASE", InteractionTypeEnum.None,   BuildingLocationEnum.Nearest, BuildingTypeEnum.BuildingClass,     BuildingClassEnum.Base,                   false,           false,                    "SIGNAL_BASE",                 "TIP_BASE",                      ""                         ),
		new ("VS_GLCH", InteractionTypeEnum.None,   BuildingLocationEnum.Nearest, BuildingTypeEnum.BuildingClass,     BuildingClassEnum.StoryGlitch,            false,           false,                    "NPC_COMM_WEEK_04_GLITCH_OSD", "NPC_COMM_WEEK_04_GLITCH_RES_A", "BUILDING_GLITCHYSTORYBOX" ),
		new ("VS_RBCP", InteractionTypeEnum.None,   BuildingLocationEnum.Nearest, BuildingTypeEnum.BuildingClass,     BuildingClassEnum.AbandonedRobotCamp,     false,           false,                    "UI_CAMP_REVEAL_OSD",          "UI_CAMP_REVEAL_MSG",            "UI_CAMP_REVEAL_MARKER"    ),
		new ("VS_DRCS", InteractionTypeEnum.None,   BuildingLocationEnum.Nearest, BuildingTypeEnum.BuildingClass,     BuildingClassEnum.SentinelDistressSignal, false,           false,                    "UI_CRASH_REVEAL_OSD",         "UI_CRASH_REVEAL_MSG",           "UI_CRASH_REVEAL_MARKER"   ),
		new ("VS_SETL", InteractionTypeEnum.None,   BuildingLocationEnum.Random,  BuildingTypeEnum.UnownedSettlement, BuildingClassEnum.None,                   true ,           true ,                    "UI_SETTLEMENT_LOCATED_OSD",   "UI_SETTLEMENT_LOCATED",         ""                         )
	};
	
	//...........................................................

	protected void ImproveShipScanRange()
	{
		var Mbin = ExtractMbin<GcBuildingGlobals>("GCBUILDINGGLOBALS.GLOBAL.MBIN");
		Mbin.UnknownBuildingRange = 10000;  //  600
		Mbin.MaxIconRange         = 10000;  // 1200
		Mbin.MinShipScanBuildings = 1;      //    0
		Mbin.MaxShipScanBuildings = 5;      //    2
	}

	//...........................................................

	protected void AddExoCraftScanEvents()
	{
		var ExocraftScanEventsData = new ( string ScanList, string Name, string Tech, string Icon ) [] {
			new ("DISTRESS",            "BUILDING_DISTRESSSIGNAL_L",      "VEHICLE_SCAN2", "TEXTURES/UI/FRONTEND/ICONS/QUICKMENU/BUILDINGS.STARSHIPS.DDS" ),
			new ("CRASHED_FREIGHTER",   "UI_CORE_ACT2_STEP8_MARKER",      "VEHICLE_SCAN",  "TEXTURES/UI/FRONTEND/ICONS/QUICKMENU/BUILDINGS.CRASHEDFREIGHTER.DDS" ),
			new ("DISTRESS_NPC",        "UI_PULSE_ENCOUNTER_NAME_REPAIR", "VEHICLE_SCAN1", "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.REPAIR.DDS" ),
			new ("FACTORY",             "BUILDING_FACTORY_L",             "VEHICLE_SCAN2", "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.COLLECT.DDS" ),
			new ("HARVESTER",           "BUILDING_HARVESTER_L",           "VEHICLE_SCAN1", "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.WHEAT.DDS" ),
			new ("OBSERVATORY",         "BUILDING_OBSERVATORY_L",         "VEHICLE_SCAN1", "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.PLANET.DDS" ),
			new ("RADIOTOWER",          "BUILDING_RADIOTOWER_L",          "VEHICLE_SCAN1", "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.SCAN.DDS" ),
			new ("SHOP",                "BUILDING_SHOP_L",                "VEHICLE_SCAN",  "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.DEPOTRAID.DDS"),
  		    new ("VS_BASE",             "UI_BASE_ANYWHERE_OPT_A",         "VEHICLE_SCAN",  "TEXTURES/UI/HUD/ICONS/MISSIONS/BASECOMPUTERMISSION.DDS"),
 		    new ("VS_DRHV",             "UI_SENTINEL_HIVE_NAME",          "VEHICLE_SCAN2", "TEXTURES/UI/HUD/ICONS/BUILDINGS/BUILDING.DRONEHIVE.DDS"),
      		new ("VS_GRV",              "SCAN_GRAVE",                     "VEHICLE_SCAN1", "TEXTURES/UI/HUD/ICONS/SCANNING/PICKUP.GRAVE.DDS"),
      		new ("VS_SETL",             "UI_SETTLEMENT_LABEL",            "VEHICLE_SCAN2", "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.SETTLEMENT.DDS"),
		    new ("VS_PORT",             "UI_PORTAL_OPT",                  "VEHICLE_SCAN1", "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.PORTAL.DDS"),
		    new ("VS_GLCH",             "BUILDING_GLITCHYSTORYBOX",       "VEHICLE_SCAN1", "TEXTURES/UI/HUD/ICONS/SCANNING/PICKUP.GLITCH.DDS"),
		    new ("VS_DRCS",             "UI_CRASH_REVEAL_MARKER",         "VEHICLE_SCAN2", "TEXTURES/UI/HUD/ICONS/MISSIONS/MISSION.SENTINELCRASH.DDS"),
        };


		var Mbin = ExtractMbin<GcVehicleScanTable>("METADATA/SIMULATION/SCANNING/VEHICLESCANTABLE.MBIN");

		foreach( var Data in ExocraftScanEventsData ) {
			AddScanEvent(Data, Mbin.VehicleScanTable);
		}
	}
	
	//...........................................................
	
		protected void PopulateScanTable()
	{
		var mbin = ExtractMbin<GcScanEventTable>(
			"METADATA/SIMULATION/SCANNING/SCANEVENTTABLEVEHICLE.MBIN"
		);
		//var index = 0;

		foreach (var scan in EventAdds)
		{
			var target = mbin.Events.Find(EVENT => EVENT.Name == scan.Name);
			if (target != null) continue;  // no error, already exists

			var source = mbin.Events.Find(EVENT => EVENT.Name == "HARVESTER");
			target = CloneMbin(source);

			target.Name = scan.Name;
			target.ForceInteractionType.InteractionType = scan.InteractionType;
			target.BuildingLocation = scan.BuildingLocation;
			target.BuildingType = scan.BuildingType;
			target.BuildingClass.BuildingClass = scan.BuildingClass;
			target.OSDMessage = scan.OSDMessage;
			target.MarkerLabel = scan.MarkerLabel;
			target.TooltipMessage = scan.ToolTip;

			target.ForceWideRandom = scan.ForceWideRandom;
			target.AllowOverriddenBuildings = scan.AllowOverriddenBuildings;
			target.ReplaceEventIfAlreadyActive = true;
			target.TriggerActions.Range = 0;

			mbin.Events.Add(target);
		};

	}

	//...........................................................

	protected void AddUpgradesToMech()
	{
		var mbin = ExtractMbin<GcTechnologyTable>(
			"METADATA/REALITY/TABLES/NMS_REALITY_GCTECHNOLOGYTABLE.MBIN"
		);
		string [] Scanners = { "VEHICLE_SCAN1", "VEHICLE_SCAN2" };
		
		foreach( var scanner in Scanners) {
			var entry = mbin.Table.Find(NAME => NAME.ID == scanner);
			entry.Category.TechnologyCategory = TechnologyCategoryEnum.AllVehicles;
		}
	}
	
	//...........................................................

	protected void AddScanEvent( (string ScanList, string Name, string Tech, string Icon) ITEM, List<GcVehicleScanTableEntry> LIST )
	{
		var entry = new GcVehicleScanTableEntry() {
			ScanList     = new() { ITEM.ScanList },
			Name         = ITEM.Name,
			RequiredTech = ITEM.Tech,  
			Icon         = new() { Filename = ITEM.Icon },
		};
		LIST.Add(entry);
	}
	
	//...........................................................

	protected class _EventAdds
	{
		public string Name { get; set; }
		public InteractionTypeEnum InteractionType { get; set; }
		public BuildingLocationEnum BuildingLocation { get; set; }
		public BuildingTypeEnum BuildingType { get; set; }
		public BuildingClassEnum BuildingClass { get; set; }
		public bool ForceWideRandom { get; set; }
		public bool AllowOverriddenBuildings { get; set; }
		public string OSDMessage { get; set; }
		public string ToolTip { get; set; }
		public string MarkerLabel { get; set; }

		public _EventAdds(string NAME, InteractionTypeEnum INTERACTION, BuildingLocationEnum LOCATION,
							BuildingTypeEnum TYPE, BuildingClassEnum CLASS, bool FORCE, bool ALLOWOVERRIDE,
							string OSD, string TIP, string MARKER)
		{
			Name = NAME;
			InteractionType = INTERACTION;
			BuildingLocation = LOCATION;
			BuildingType = TYPE;
			BuildingClass = CLASS;
			ForceWideRandom = FORCE;
			AllowOverriddenBuildings = ALLOWOVERRIDE;
			OSDMessage = OSD;
			ToolTip = TIP;
			MarkerLabel = MARKER;
		}
	}

	//...........................................................
		
}