local M = {}

-- Define sound IDs
local SOUND_DOWN = "rearwindow"
local SOUND_UP = "rearwindowup"

-- State tracking (needs to be module-level for BeamNG)
local soundPlayedDown = false
local soundPlayedUp = false
local isResetting = false  -- Flag to prevent sounds during reset

local function playSoundDown()
    obj:playSFXOnce(SOUND_DOWN, 282, 1, 1)
end

local function playSoundUp()
    obj:playSFXOnce(SOUND_UP, 282, 1, 1)
end

local function onInit(jbeamData)
    -- Initialize sound sources with BeamNG-specific parameters
    obj:createSFXSource("/vehicles/RLA_DelSol/sounds/rearwindow.mp3", "AudioClosest3D", SOUND_DOWN, -1)
    obj:createSFXSource("/vehicles/RLA_DelSol/sounds/rearwindowup.mp3", "AudioClosest3D", SOUND_UP, -1)
    electrics.values.RLA_DelSol_rearwindow = 0  -- Set window to up state on init
end

local function updateGFX(dt)
    if isResetting then
        isResetting = false
        return
    end
    
    local windowState = electrics.values.RLA_DelSol_rearwindow
    
    -- Handle window down sound
    if windowState == 1 then
        if not soundPlayedDown then
            playSoundDown()
            soundPlayedDown = true
            soundPlayedUp = false
        end
    -- Handle window up sound
    elseif windowState == 0 then
        if not soundPlayedUp then
            playSoundUp()
            soundPlayedUp = true
            soundPlayedDown = false
        end
    end
end

local function onReset()
    isResetting = true  -- Set resetting flag to prevent sounds
    electrics.values.RLA_DelSol_rearwindow = 0  -- Set window to up state
    soundPlayedDown = false
    soundPlayedUp = true  -- Set to true since window is now up
end

M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M