local M = {}

function M.init(id)
    print("Clock initialized!")
end

function M.updateGFX(dt)
    -- Check ignition
    if electrics.values.ignitionLevel == 0 then
        -- Turn off all segments if ignition is off
        for i = 1, 4 do
            for _, seg in ipairs({'A','B','C','D','E','F','G'}) do
                electrics.values["RLA_DelSol_d" .. i .. "_seg" .. seg] = 0
            end
        end
        return
    end
    
    -- Get current system time
    local timeTable = os.date("*t")
    local hours = timeTable.hour
    local minutes = timeTable.min
    
    -- Convert to 12 hour format
    if hours > 12 then
        hours = hours - 12
    elseif hours == 0 then
        hours = 12
    end
    
    -- Split into digits, handle single digit hours
    local hourTens = 0
    local hourOnes = hours
    
    -- If hours is 10 or greater, split it properly
    if hours >= 10 then
        hourTens = math.floor(hours / 10)
        hourOnes = hours % 10
    end
    
    local minuteTens = math.floor(minutes / 10)
    local minuteOnes = minutes % 10

    -- Define digit patterns
    local digitPatterns = {
        [0] = {1,1,1,1,1,1,0},  -- 0
        [1] = {0,1,1,0,0,0,0},  -- 1
        [2] = {1,1,0,1,1,0,1},  -- 2
        [3] = {1,1,1,1,0,0,1},  -- 3
        [4] = {0,1,1,0,0,1,1},  -- 4
        [5] = {1,0,1,1,0,1,1},  -- 5
        [6] = {1,0,1,1,1,1,1},  -- 6
        [7] = {1,1,1,0,0,0,0},  -- 7
        [8] = {1,1,1,1,1,1,1},  -- 8
        [9] = {1,1,1,1,0,1,1}   -- 9
    }

    -- Function to set digit segments
    local function setDigit(digitNum, value, visible)
        -- If not visible, turn off all segments
        if not visible then
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segA"] = 0
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segB"] = 0
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segC"] = 0
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segD"] = 0
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segE"] = 0
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segF"] = 0
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segG"] = 0
            return
        end

        local pattern = digitPatterns[value]
        if pattern then
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segA"] = pattern[1]
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segB"] = pattern[2]
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segC"] = pattern[3]
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segD"] = pattern[4]
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segE"] = pattern[5]
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segF"] = pattern[6]
            electrics.values["RLA_DelSol_d" .. digitNum .. "_segG"] = pattern[7]
        end
    end

    -- Set all digits, hide first digit if hours < 10
    setDigit(1, hourTens, hours >= 10)  -- Only show if hours is 10 or greater
    setDigit(2, hourOnes, true)         -- Always show
    setDigit(3, minuteTens, true)       -- Always show
    setDigit(4, minuteOnes, true)       -- Always show
end

return M