Scriptname GSN:Objects:LinkWorkbenches extends ObjectReference

Keyword Property LinkedWorkbenchContainerKeyword Auto Const Mandatory
Keyword Property WorkbenchGeneralKeyword Auto Const Mandatory
Keyword Property WorkbenchResearchKeyword Auto Const Mandatory

LocationAlias Property LocationAliasFilter Auto Const

ObjectReference[] Workbenches
ObjectReference Workshop
Int Radius = 750
Bool FirstLoad = true

Event OnLoad() 
    Workshop = GetWorkshop()
    If FirstLoad && Workshop ; Only call the first time this object is placed by player
        HandleLoad()
        FirstLoad = false
    EndIf
EndEvent

Event OnCellLoad() ; Ensures all workbenches in the outpost are loaded
    HandleLoad()
EndEvent

Function HandleLoad()
    If IsEnabled()
        Workshop = GetWorkshop()
        If Workshop
            RegisterWorkshop(true)
        EndIf
        Workbenches = GetWorkbenches(Self)
        LinkWorkbenches(Self, Workbenches)
    EndIf
EndFunction

Event OnUnload()
    UnlinkWorkbenches(Workbenches)
    If Workshop
        RegisterWorkshop(false)
    EndIf
    Workbenches = new ObjectReference[0]
EndEvent

ObjectReference[] Function GetWorkbenches(ObjectReference NearTo)
    ObjectReference[] GenBenches = GetAndFilterObjectsByKeyword(NearTo, WorkbenchGeneralKeyword)
    ObjectReference[] ResBenches = GetAndFilterObjectsByKeyword(NearTo, WorkbenchResearchKeyword)

    ; Not all research benches have "WorkbenchGeneralKeyword". Sigh. 
    Int i = 0
    While i < ResBenches.Length
        If GenBenches.find(ResBenches[i]) < 0
            GenBenches = AddArrayElement(GenBenches as Form[], ResBenches[i] as Form) as ObjectReference[]
        EndIf
        i += 1
    EndWhile
    ; Debug.Notification(GenBenches.length + " workbenches found")
    return GenBenches
EndFunction

ObjectReference[] Function GetAndFilterObjectsByKeyword(objectReference NearTo, Keyword TheKeyword)
    ObjectReference[] ByKeyword = NearTo.FindAllReferencesWithKeyword(TheKeyword, Radius)
    ObjectReference[] Filtered = New ObjectReference[0]

    Int i = 0
    While i < ByKeyword.length
        If ByKeyword[i].IsEnabled()
            If !LocationAliasFilter || ByKeyword[i].GetCurrentLocation() == LocationAliasFilter.GetLocation()
                Filtered = AddArrayElement(Filtered as Form[], ByKeyword[i] as Form) as ObjectReference[]
            EndIf
        EndIf
        i += 1
    EndWhile

    return Filtered
EndFunction

Function LinkWorkbenches(ObjectReference LinkTo, ObjectReference[] WorkbenchList)
    int i = 0
    While i < WorkbenchList.Length
        ObjectReference TheWorkbench = WorkbenchList[i]
        LinkWorkbench(LinkTo, Workbenchlist[i])
        i += 1
    EndWhile
EndFunction

Bool Function LinkWorkbench(ObjectReference LinkTo, ObjectReference akRef)
    If !akRef.GetLinkedRef(LinkedWorkbenchContainerKeyword) && akRef.IsEnabled()
        akRef.SetLinkedRef(LinkTo, LinkedWorkbenchContainerKeyword)
        Return true
    EndIf
EndFunction

Function UnlinkWorkbenches(ObjectReference[] WorkbenchList)
    int i = 0
    While i < WorkbenchList.length
        ObjectReference TheWorkbench = WorkbenchList[i]
        TheWorkbench.SetLinkedRef(None, LinkedWorkbenchContainerKeyword)
        i += 1
    EndWhile
EndFunction

Function RegisterWorkshop(Bool bRegister)
    If bRegister
        RegisterForRemoteEvent(Workshop, "OnWorkshopObjectPlaced")
        RegisterForRemoteEvent(Workshop, "OnWorkshopObjectRemoved")
    Else
        UnregisterForRemoteEvent(Workshop, "OnWorkshopObjectPlaced")
        UnregisterForRemoteEvent(Workshop, "OnWorkshopObjectRemoved")
    Endif
EndFunction

Event ObjectReference.OnWorkshopObjectPlaced(ObjectReference TheWorkshop, ObjectReference akRef)
    If akRef.HasKeyword(WorkbenchGeneralKeyword) || akRef.HasKeyword(WorkbenchResearchKeyword)
        LinkWorkbench(Self, akRef)
        Workbenches = AddArrayElement(Workbenches as Form[], akRef) as ObjectReference[]
        ; Debug.Notification("Workbenches: "+ Workbenches.length)
    EndIf
EndEvent

Event ObjectReference.OnWorkshopObjectRemoved(ObjectReference TheWorkshop, ObjectReference akRef)
    If akRef.HasKeyword(WorkbenchGeneralKeyword) || akRef.HasKeyword(WorkbenchResearchKeyword)
        akRef.SetLinkedRef(None, LinkedWorkbenchContainerKeyword)
        Workbenches = RemoveArrayElement(Workbenches as Form[], akRef) as ObjectReference[]
        ; Debug.Notification("Workbenches: "+ Workbenches.length)
    EndIf

    If akRef == Self
        ; Debug.Notification("unlink workbenches: " + Workbenches.length)
        UnlinkWorkbenches(Workbenches)
        RegisterWorkshop(false)
    EndIf
EndEvent

Form[] Function AddArrayElement(Form[] TheArray, Form ElementToAdd)
    int NewSize = TheArray.Length + 1
    Form[] NewArray = New Form[NewSize]
    Int i = 0
    While i < TheArray.length
        NewArray[i] = TheArray[i]
        i += 1
    EndWhile
    NewArray[NewArray.length - 1] = ElementToAdd
    Return NewArray
EndFunction

Form[] Function RemoveArrayElement(Form[] TheArray, Form ElementToRemove)
    int NewSize = TheArray.Length - 1
    If NewSize < 0
        Return New Form[0]  ; Return empty array if there's nothing left
    EndIf
    Form[] NewArray = New Form[NewSize]
    Int i = 0
    Int j = 0
    While i < TheArray.length
        If TheArray[i] != ElementToRemove
            If j < NewSize  ; Prevent index out of bounds
                NewArray[j] = TheArray[i]
                j += 1
            EndIf
        EndIf
        i += 1
    EndWhile
    Return NewArray
EndFunction
