Scriptname GSN:VendorManager extends Quest
Actor Player
Key TheKey
bool ModRunning = false

Group Scripts
    GSN:StorageManager Property GSN_StorageManager Auto Const
EndGroup

Group Globals
    GlobalVariable Property GSN_Global_KeyCost Auto Const
    GlobalVariable Property GSN_Global_StorageCost Auto Const
    GlobalVariable Property GSN_Global_StorageCapacity Auto Const
    GlobalVariable Property GSN_Global_VendorCooldownDay Auto Const
    GlobalVariable Property GameDaysPassed Auto Const
EndGroup

Group Keywords
    Keyword Property GSN_KW_Cost_Discount Mandatory Auto
    Keyword Property GSN_KW_Cost_DiscountXL Mandatory Auto
    Keyword Property GSN_KW_Cost_Premium Mandatory Auto
    Keyword Property GSN_KW_Cost_PremiumXL Mandatory Auto
EndGroup

Group PerkConditions
    ConditionForm Property GSN_HasPerkCommerce_Rank1 Mandatory Auto
    ConditionForm Property GSN_HasPerkCommerce_Rank2 Mandatory Auto
    ConditionForm Property GSN_HasPerkCommerce_Rank3 Mandatory Auto
    ConditionForm Property GSN_HasPerkCommerce_Rank4 Mandatory Auto
EndGroup

Int BaseStorageCost = 30000 Const

float Cost_Discount = 0.75 Const
float Cost_DiscountXL = 0.5 Const
float Cost_Premium = 1.5 Const
float Cost_PremiumXL = 2.0 Const

float PerkMultCommerceRank1 = 0.95 Const
float PerkMultCommerceRank2 = 0.9 Const
float PerkMultCommerceRank3 = 0.85 Const
float PerkMultCommerceRank4 = 0.8 Const

float CooldownDays = 2.0 Const

Function InitMod()
    Player = Game.GetPlayer()
EndFunction

Function StartMod()
    ModRunning = true
EndFunction

Function StopMod()
    ResetVendor()
    GSN_Global_VendorCooldownDay.SetValue(0)
    UpdateGlobals()
    ModRunning = false
EndFunction

Function SetupVendor(ObjectReference TheContainer)
    If ModRunning
        TheKey = TheContainer.GetKey()
        bool HasKey = Player.GetItemCount(TheKey) as bool
        If !HasKey 
            ; Makes any nearby shiptech offer the key for sale
            GSN_Global_KeyCost.SetValue(CalcKeyCost(TheContainer))
        Else 
            ; Makes any nearby shiptech offer a storage upgrade
            GSN_Global_StorageCost.SetValue(CalcStorageCost())
        EndIf
        UpdateGlobals()
        ; Debug.Notification("Game Day: " + GameDaysPassed.GetValue() +"\nCooldown day: " + GSN_Global_VendorCooldownDay.GetValue())
    EndIf
EndFunction

Function UpdateGlobals()
    UpdateCurrentInstanceGlobal(GSN_Global_KeyCost)
    UpdateCurrentInstanceGlobal(GSN_Global_StorageCost)
    UpdateCurrentInstanceGlobal(GSN_Global_StorageCapacity)
    UpdateCurrentInstanceGlobal(GSN_Global_VendorCooldownDay)
    UpdateCurrentInstanceGlobal(GameDaysPassed)
EndFunction

Function ResetVendor()
    TheKey = None
    GSN_Global_KeyCost.SetValue(0)
    GSN_Global_StorageCost.SetValue(0)
    UpdateGlobals()
EndFunction 

Int Function CalcKeyCost(ObjectReference TheContainer)
    float TheCost = CalcStorageCost()

    ; Add a discount/premium (if any) for this container's location
    If TheContainer.HasKeyword(GSN_KW_Cost_Discount)
        TheCost = TheCost * Cost_Discount
    ElseIf TheContainer.HasKeyword(GSN_KW_Cost_DiscountXL)
        TheCost = TheCost * Cost_DiscountXL
    ElseIf TheContainer.HasKeyword(GSN_KW_Cost_Premium)
        TheCost = TheCost * Cost_Premium
    ElseIf TheContainer.HasKeyword(GSN_KW_Cost_PremiumXL)
        TheCost = TheCost * Cost_PremiumXL
    EndIf

    Int TheCostInt = Math.Round(TheCost)
    ; Debug.Notification("Cost: " + TheCostInt)
    return TheCostInt
EndFunction

Int Function CalcStorageCost()
    Float TheCost = BaseStorageCost

    float PerkMultiplier = 1
    If GSN_HasPerkCommerce_Rank1.IsTrue()
        PerkMultiplier = 0.95
    ElseIf GSN_HasPerkCommerce_Rank2.IsTrue()
        PerkMultiplier = 0.9
    ElseIf GSN_HasPerkCommerce_Rank3.IsTrue()
        PerkMultiplier = 0.85
    ElseIf GSN_HasPerkCommerce_Rank4.IsTrue()
        PerkMultiplier = 0.8
    EndIf

    TheCost = TheCost * PerkMultiplier
    Int TheCostInt = Math.Round(TheCost)

    Return TheCostInt
EndFunction

Function PurchaseKey()
    Player.RemoveItem(Game.GetCredits(), GSN_Global_KeyCost.GetValue() as Int)
    Player.AddItem(TheKey)
    StartCooldown()
    ResetVendor()
EndFunction

Function PurchaseStorage()
    Player.RemoveItem(Game.GetCredits(), GSN_Global_StorageCost.GetValue() as Int)
    GSN_StorageManager.AddStorage()
    StartCooldown()
    ResetVendor()
EndFunction

Function StartCooldown()
    float CurrentDays =  GameDaysPassed.GetValue()
    float CooldownDay = CurrentDays + CooldownDays
    GSN_Global_VendorCooldownDay.SetValue(CooldownDay)
    UpdateGlobals()
    ; Debug.Notification("Game Day: "+  GameDaysPassed.GetValue())
    ; Debug.Notification("Cooldown Day: "+  GSN_Global_VendorCooldownDay.GetValue())
EndFunction
