Scriptname GSN:Main extends Quest

Group Quests
    GSN:StorageManager Property GSN_StorageManager Auto Const Mandatory
    GSN:VendorManager Property GSN_VendorManager Auto Const Mandatory
EndGroup

Group ModConfiguration
    GameplayOption Property GSN_GPO_MODE Auto Const Mandatory
EndGroup

Group Messages
    Message Property GSN_Message_ModEnabled Auto Const Mandatory
    Message Property GSN_Message_ModDisabled Auto Const Mandatory
EndGroup

Perk Property GSN_ActivatorPerk_OutpostContainer Auto Const Mandatory
Perk Property GSN_ActivatorPerk_ShipContainer Auto Const Mandatory

CustomEvent DisableMod
CustomEvent EnableMod

Actor Player
Bool ModRunning = false
Bool FirstStart = true

Bool Function MODE_ENABLED()
    If GSN_GPO_MODE.GetValue() > 0
        Return true
    EndIf
    Return false
EndFunction

Bool Function GSN_OPTION_CHANGED(GameplayOption[] aChangedOptions)
    If(aChangedOptions.find(GSN_GPO_MODE) >= 0)
        Return true
    EndIf
    Return false
EndFunction

Bool Function IsModRunning()
    return ModRunning
EndFunction

Event OnInit()
    Utility.Wait(1)
    RegisterForGameplayOptionChangedEvent()
    Player = Game.GetPlayer()
    InitMod()
    StartMod()
Endevent

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
    If GSN_OPTION_CHANGED(aChangedOptions)
        If MODE_ENABLED()
            StartMod()
            SendCustomEvent("EnableMod")
        Else
            StopMod()
            SendCustomEvent("DisableMod")
        EndIf
    EndIf
EndEvent

Function InitMod()
    GSN_StorageManager.InitMod()
    GSN_VendorManager.InitMod()
EndFunction

Function StartMod()
    RegisterForRemoteEvent(Game.GetPlayer(), "OnPlayerLoadGame")
    GSN_VendorManager.StartMod()
    GSN_StorageManager.OnPlayerLoadGame()
    AddPerks(true)
    ModRunning = true
    GSN_Message_ModEnabled.show()
EndFunction

Function StopMod()
    UnregisterForRemoteEvent(Player, "OnPlayerLoadGame")
    GSN_VendorManager.StopMod()
    AddPerks(false)
    ModRunning = false
    GSN_Message_ModDisabled.show()
EndFunction

Function AddPerks(bool bAdd)
    If bAdd
        If !Player.HasPerk(GSN_ActivatorPerk_OutpostContainer)
            Player.AddPerk(GSN_ActivatorPerk_OutpostContainer)
        EndIf

        If !Player.HasPerk(GSN_ActivatorPerk_ShipContainer)
            Player.AddPerk(GSN_ActivatorPerk_ShipContainer)
        EndIf
    Else
         If Player.HasPerk(GSN_ActivatorPerk_OutpostContainer)
            Player.RemovePerk(GSN_ActivatorPerk_OutpostContainer)
        EndIf

        If Player.HasPerk(GSN_ActivatorPerk_ShipContainer)
            Player.RemovePerk(GSN_ActivatorPerk_ShipContainer)
        EndIf
    EndIf
EndFunction

Event Actor.OnPlayerLoadGame(Actor akSender)
    GSN_StorageManager.OnPlayerLoadGame()
EndEvent



